/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.DB2UDB;
import com.kingdee.shr.dydeploy.web.executeSql.DB2VO;
import com.kingdee.shr.dydeploy.web.executeSql.DB400;
import com.kingdee.shr.dydeploy.web.executeSql.DB400VO;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.IDatabase;
import com.kingdee.shr.dydeploy.web.executeSql.InAndOutBean;
import com.kingdee.shr.dydeploy.web.executeSql.KINGBASE;
import com.kingdee.shr.dydeploy.web.executeSql.KINGBASEVO;
import com.kingdee.shr.dydeploy.web.executeSql.MySQL;
import com.kingdee.shr.dydeploy.web.executeSql.MySQLVO;
import com.kingdee.shr.dydeploy.web.executeSql.Oracle;
import com.kingdee.shr.dydeploy.web.executeSql.OracleVO;
import com.kingdee.shr.dydeploy.web.executeSql.Postgresql;
import com.kingdee.shr.dydeploy.web.executeSql.PostgresqlVO;
import com.kingdee.shr.dydeploy.web.executeSql.PropertiesUtils;
import com.kingdee.shr.dydeploy.web.executeSql.SqlServer;
import com.kingdee.shr.dydeploy.web.executeSql.SqlServerVO;
import com.kingdee.shr.dydeploy.web.executeSql.SyBase;
import com.kingdee.shr.dydeploy.web.executeSql.SyBaseVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public final class DatabaseManager {
    private static Map<String, IDatabase> cachedDBEnginesRunSQLScript = new HashMap<String, IDatabase>(20);
    private static Map<String, IDatabase> cachedDBEnginesQueryAnalyer = new HashMap<String, IDatabase>(20);
    private static Map<String, Long> latestVisitTimeQueryAnalyer = new HashMap<String, Long>(20);
    private static Timer timer;
    private static int runInScheduleTime;
    private static int timeOutToRollback;
    private static final Logger logger;

    public static synchronized IDatabase getDBEngine(DatabaseVO dbvo) {
        return DatabaseManager.getDBEngine(dbvo, false, null);
    }

    public static synchronized IDatabase getDBEngine(DatabaseVO dbvo, boolean isForSQLAnalyer, InAndOutBean inAndOutBean) {
        Map<String, IDatabase> cacheEngine = cachedDBEnginesRunSQLScript;
        if (isForSQLAnalyer) {
            Long latestVisitTimeMillis = new Long(System.currentTimeMillis());
            latestVisitTimeQueryAnalyer.put(dbvo.getID(), latestVisitTimeMillis);
            DatabaseManager.exeTimeOutToRollback();
            cacheEngine = cachedDBEnginesQueryAnalyer;
        }
        IDatabase engine = null;
        if (cacheEngine.containsKey(dbvo.getID())) {
            engine = cacheEngine.get(dbvo.getID());
            engine.setInAndOutBean(inAndOutBean);
            return engine;
        }
        logger.info((Object)("====Create new database engine for [" + dbvo.getIDForOutput() + "]...isForSQLAnalyer[" + isForSQLAnalyer + "]"));
        if ("Oracle".equals(dbvo.getDBType())) {
            engine = new Oracle((OracleVO)dbvo);
        } else if ("MS SqlServer".equals(dbvo.getDBType())) {
            engine = new SqlServer((SqlServerVO)dbvo);
        } else if ("DB2".equals(dbvo.getDBType())) {
            engine = new DB2UDB((DB2VO)dbvo);
        } else if ("DB2/400".equals(dbvo.getDBType())) {
            engine = new DB400((DB400VO)dbvo);
        } else if ("Sybase".equalsIgnoreCase(dbvo.getDBType())) {
            engine = new SyBase((SyBaseVO)dbvo);
        } else if ("MySQL".equalsIgnoreCase(dbvo.getDBType())) {
            engine = new MySQL((MySQLVO)dbvo);
        } else if ("PostgreSql".equalsIgnoreCase(dbvo.getDBType())) {
            engine = new Postgresql((PostgresqlVO)dbvo);
        } else if (!"DM".equalsIgnoreCase(dbvo.getDBType())) {
            if ("Kingbase".equalsIgnoreCase(dbvo.getDBType())) {
                engine = new KINGBASE((KINGBASEVO)dbvo);
            } else {
                throw new DBException("DBType[" + dbvo.getDBType() + "] is not supported!");
            }
        }
        cacheEngine.put(dbvo.getID(), engine);
        engine.setInAndOutBean(inAndOutBean);
        return engine;
    }

    public static String[] getSupportedDBTypes() {
        return DatabaseVO.getSupportedDBTypes();
    }

    public static int getTimeOutToRollback() {
        return timeOutToRollback;
    }

    public static void setTimeOutToRollback(int timeOutSecs) {
        timeOutToRollback = timeOutSecs;
        logger.info((Object)("TimeOutToRollback have been set,value=[" + timeOutToRollback + "s]"));
    }

    private static void exeTimeOutToRollback() {
        if (timer == null) {
            logger.info((Object)("====Schedule a timer:Task [RollbackTimerTask] delay[20s],period[20s];SQLQueryAnalyerTimeOutToRollback[" + timeOutToRollback + "s]"));
            timer = new Timer(true);
            TimerTask rollbackTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (timeOutToRollback < 100) {
                        DatabaseManager.setTimeOutToRollback(600);
                    }
                    for (String dbvoID : cachedDBEnginesQueryAnalyer.keySet()) {
                        IDatabase dbEngine;
                        Long latestVisitTimeMillis = (Long)latestVisitTimeQueryAnalyer.get(dbvoID);
                        long latestVisitTime = latestVisitTimeMillis;
                        long currentSysTime = System.currentTimeMillis();
                        if (currentSysTime - latestVisitTime < (long)(timeOutToRollback * 1000) || (dbEngine = (IDatabase)cachedDBEnginesQueryAnalyer.get(dbvoID)).getAutoCommit()) continue;
                        dbEngine.rollbackTransaction();
                        Long rollbackTimeMillis = new Long(System.currentTimeMillis());
                        latestVisitTimeQueryAnalyer.put(dbvoID, rollbackTimeMillis);
                    }
                }
            };
            timer.scheduleAtFixedRate(rollbackTimerTask, runInScheduleTime * 1000, (long)(runInScheduleTime * 1000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTimeOutToRollbackFromConfigFile() {
        Properties prop = new Properties();
        FileInputStream inStream = null;
        int timeOutFromFile = 600;
        try {
            File file = new File("./config/timeouttorollback.properties");
            if (file.exists()) {
                inStream = new FileInputStream(file);
                PropertiesUtils.load(prop, inStream);
            }
            timeOutFromFile = Integer.valueOf(prop.getProperty("timeoutvalue"));
        }
        catch (Exception e) {
            logger.error((Object)"Get timeout value to rollback from config file error,set default value[600s] !", (Throwable)e);
            timeOutFromFile = 600;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return timeOutFromFile;
    }

    public static void saveTimeOutToConfigFile(int number) {
        OutputStreamWriter writer = null;
        try {
            Properties props = new Properties();
            props.setProperty("timeoutvalue", String.valueOf(number));
            writer = new FileWriter("./config/timeouttorollback.properties");
            PropertiesUtils.store(props, writer, "Query Analyer TimeOut To Rollback,unit(second),eg. 600");
        }
        catch (Exception e) {
            logger.error((Object)"Save timeout value to rollback to config file error !", (Throwable)e);
            throw new AdminException("Save timeout value to rollback to config file error !", e);
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"resource not closed", (Throwable)e);
                }
            }
        }
    }

    static {
        runInScheduleTime = 20;
        timeOutToRollback = 600;
        logger = Logger.getLogger(DatabaseManager.class);
    }
}

