/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.FileAccess;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DirFileAccess
implements FileAccess {
    private Logger logger = Logger.getLogger(DirFileAccess.class);
    private String basePath;

    public DirFileAccess(String filepath) {
        this.basePath = filepath;
    }

    @Override
    public boolean isFileExist(String filename) {
        File file = new File(this.getFilePath(filename));
        return file.exists();
    }

    private String getFilePath(String filename) {
        String f = this.basePath + File.separator + filename;
        return StringUtils.cleanPath(f);
    }

    @Override
    public InputStream getFileInputStream(String filename) {
        String path = this.getFilePath(filename);
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"Get fileinputstream error!", (Throwable)e);
            throw new AdminException("File[" + path + "] not found!", e);
        }
    }

    @Override
    public String[] getFileNames(String filename) throws IOException {
        if (filename.indexOf("*") >= 0) {
            String path = this.getFilePath(filename);
            String fName = path.substring(path.lastIndexOf("/") + 1);
            fName = StringUtils.replace(fName, "*", "\\S*");
            fName = StringUtils.replace(fName, ".", "\\.");
            final Pattern p = Pattern.compile(fName);
            File fPath = new File(path = path.substring(0, path.lastIndexOf("/")));
            File[] files = fPath.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return p.matcher(name).matches();
                }
            });
            if (files != null) {
                Object[] res = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    res[i] = files[i].getCanonicalPath().substring(this.basePath.length());
                }
                Arrays.sort(res);
                this.logger.debug((Object)("Find files " + Arrays.asList(res) + " matches [" + fName + "] was found in [" + fPath.getAbsolutePath() + "]!"));
                return res;
            }
            this.logger.warn((Object)("No files matches [" + fName + "] was found in [" + fPath.getAbsolutePath() + "]!"));
            return new String[0];
        }
        return new String[]{filename};
    }

    @Override
    public String getBaseFile() {
        return this.basePath;
    }
}

