/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AdditionalLog;
import com.kingdee.shr.dydeploy.web.executeSql.DB2DecimalConvertUtils;
import com.kingdee.shr.dydeploy.web.executeSql.DBSQLException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseManager;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSqlInputStreamExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.IDatabase;
import com.kingdee.shr.dydeploy.web.executeSql.KSQLProvider;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class KSQLInputStreamExecutor
extends DefaultSqlInputStreamExecutor {
    private static final Logger logger = Logger.getLogger(KSQLInputStreamExecutor.class);
    private int targetDBType;
    private DatabaseVO db;
    private KSQLProvider ksqlProvider;
    private transient String curOrgSQL = "";
    private String indexTableSpace = "";

    public KSQLInputStreamExecutor(String name, InputStream input, String splitStr, DatabaseVO dbvo, String charSet, KSQLProvider provider) {
        super(name, input, splitStr, charSet);
        this.ksqlProvider = provider;
        this.db = dbvo;
        if ("Oracle".equalsIgnoreCase(this.db.getDBType())) {
            // empty if block
        }
    }

    @Override
    public String[] preprocessSQL(String sqlText) {
        this.curOrgSQL = sqlText;
        ArrayList<String> resultSQL = new ArrayList<String>();
        if (sqlText.length() == 0 || sqlText.equals("\n") || sqlText.equals("\r\n")) {
            return new String[]{""};
        }
        if (sqlText.endsWith("\n")) {
            sqlText = sqlText.substring(0, sqlText.length() - 1);
        }
        try {
            if ("DB2/400".equals(this.db.getDBType()) || "DB2".equals(this.db.getDBType()) || "MySQL".equals(this.db.getDBType())) {
                sqlText = DB2DecimalConvertUtils.convertDB2Decimal(sqlText);
                logger.debug((Object)("before translate:" + sqlText));
                sqlText = this.isIstransTostoreProc() ? this.ksqlProvider.translateSQL(sqlText, this.db, true) : this.ksqlProvider.translateSQL(sqlText, this.db, false);
                logger.debug((Object)("after translate:" + sqlText));
                int start = 0;
                int begin = -1;
                String tempSQL = null;
                ArrayList<String> sqlList = new ArrayList<String>();
                while ((begin = sqlText.indexOf("\r\n", start + 2)) != -1) {
                    tempSQL = sqlText.substring(start, begin);
                    tempSQL = this.dealString(tempSQL, this.split);
                    if (null != (tempSQL = this.dealString(tempSQL, ";")) && !tempSQL.equals("\n")) {
                        sqlList.add(tempSQL);
                    }
                    start = begin;
                }
                tempSQL = sqlText.substring(start);
                tempSQL = this.dealString(tempSQL, this.split);
                if (StringUtils.hasLength(tempSQL = this.dealString(tempSQL, ";")) && null != tempSQL && !tempSQL.equals("\n")) {
                    sqlList.add(tempSQL);
                }
                String[] sqlStr = sqlList.toArray(new String[sqlList.size()]);
                for (int i = 0; i < sqlStr.length; ++i) {
                    resultSQL.add(sqlStr[i]);
                }
            } else {
                String sql = sqlText;
                resultSQL.add(sqlText);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Translate provider[ " + this.getProviderName() + "] failed! \nSource SQL: {" + sqlText + "} \nException:" + e.getMessage()), e);
            AdditionalLog.getErrLogger().error((Object)("Translate provider[ " + this.getProviderName() + "] failed! \nSource SQL: {" + sqlText + "} \nException:" + e.getMessage()), e);
            throw new DBSQLException("Translate provider[ " + this.getProviderName() + "] failed! \nSource SQL: {" + sqlText + "} \nException:" + e.getMessage(), this.db.getDBType());
        }
        return resultSQL.toArray(new String[0]);
    }

    private String getIndexTableSpace() {
        String indexTableSpaceName = "";
        String sql = "select ffilename from t_sys_tablespaceinfo where FTYPE = 'index' and rownum = 1";
        final ArrayList infoList = new ArrayList();
        if (this.db != null && "Oracle".equalsIgnoreCase(this.db.getDBType())) {
            try {
                IDatabase dbEngine = DatabaseManager.getDBEngine(this.db);
                dbEngine.execute(new DefaultSQLQueryProviderExecutor(sql){

                    @Override
                    public void processRow(ResultSet rs) throws SQLException {
                        infoList.add(rs.getString("ffilename"));
                    }
                });
                if (infoList.size() > 0) {
                    indexTableSpaceName = (String)infoList.get(0);
                }
            }
            catch (Throwable e) {
                logger.error((Object)("Translate provider[ " + this.getProviderName() + "] failed! \nGet index table space failed: \nException:" + e.getMessage()), e);
            }
        }
        return indexTableSpaceName;
    }

    private String dealString(String s, String split) {
        String sql = null;
        s = s.trim();
        StringBuffer sqlBuffer = new StringBuffer();
        if (s.length() > 0 && Character.getType(s.charAt(0)) == 16) {
            logger.warn((Object)("========== Find format character in {" + s + "}, skip it!"));
            s = s.substring(1);
        }
        s = s + "\n";
        sqlBuffer.append(s);
        if (s.endsWith(split + "\n")) {
            for (int i = 0; i < split.length(); ++i) {
                sqlBuffer.deleteCharAt(sqlBuffer.length() - 2);
            }
            sql = sqlBuffer.toString();
            if (sql.equals("\n")) {
                sqlBuffer.delete(0, sqlBuffer.length());
            }
            sqlBuffer.delete(0, sqlBuffer.length());
        } else if (s.endsWith("\n")) {
            sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
            sql = sqlBuffer.toString();
            sqlBuffer.delete(0, sqlBuffer.length());
        }
        return sql;
    }

    @Override
    protected boolean handExceptionInternal(String curSQL, DBSQLException sqle) {
        logger.error((Object)("Source SQL {" + this.curOrgSQL + "}, Current SQL {" + curSQL + "}"));
        AdditionalLog.getErrLogger().error((Object)("Source SQL {" + this.curOrgSQL + "}, Current SQL {" + curSQL + "}"));
        return true;
    }
}

