/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesUtils {
    public static void load(Properties props, InputStream is) throws IOException {
        PropertiesUtils.load(props, new InputStreamReader(is));
    }

    public static void load(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (PropertiesUtils.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value = StringUtils.trimLeadingWhitespace(value);
            props.put(PropertiesUtils.unescape(key), PropertiesUtils.unescape(value));
        }
        return;
    }

    protected static boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    protected static String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            char c;
            if ((c = str.charAt(index++)) == '\\') {
                outBuffer.append("\\\\");
                continue;
            }
            outBuffer.append(c);
        }
        return outBuffer.toString();
    }

    public static void store(Properties props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(PropertiesUtils.escape(key, true) + "=" + PropertiesUtils.escape(val, false));
            out.newLine();
        }
        out.flush();
        out.close();
    }

    protected static String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        for (int index = 0; index < len; ++index) {
            char c = str.charAt(index);
            if (c == '\\' && index != len - 1 && str.charAt(index + 1) == '\\') continue;
            outBuffer.append(c);
        }
        return outBuffer.toString();
    }

    public static String getProperty(Properties prop, String propName, String defaultValue) {
        String value = defaultValue;
        if (prop != null) {
            value = prop.getProperty(propName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

