/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.executeSql.DB2VO;
import com.kingdee.shr.dydeploy.web.executeSql.DB400VO;
import com.kingdee.shr.dydeploy.web.executeSql.DataCenterInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DataCenterServiceImpl;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.OracleVO;
import com.kingdee.shr.dydeploy.web.executeSql.ScriptInfo;
import com.kingdee.shr.dydeploy.web.executeSql.SqlServerVO;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import com.kingdee.shr.dydeploy.web.executeSql.SyBaseVO;
import com.kingdee.shr.dydeploy.web.util.Constants;
import com.kingdee.shr.dydeploy.web.util.LoggerUtil;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ScriptRunner {
    public static void run(String basePath, String appId, String component, int installType) throws Exception {
        Logger logger = LoggerUtil.getLoggerByAppId(appId);
        String appPath = Constants.getApps_webPath(basePath) + "/" + component + "/data";
        if (installType == 0) {
            appPath = appPath + "/uninstall";
        }
        if (StringUtils.hasText(appPath)) {
            File file1 = new File(SHRCheck.checkFilePath((String)appPath));
            ArrayList<String> list = new ArrayList<String>();
            if (file1.exists()) {
                File[] files = file1.listFiles();
                if (files.length <= 0) {
                    logger.info((Object)SHRCheck.vaildLog((String)(appPath + " no update.xml")));
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    list.add(files[i].getName());
                }
            }
            if (list.contains("update.xml")) {
                list.clear();
                appPath = appPath + "/update.xml";
            } else {
                logger.info((Object)(SHRCheck.vaildLog((String)appPath) + " no update.xml"));
                return;
            }
        }
        int dbType = 0;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"conn not found !");
            System.err.println("conn not found !");
        }
        try {
            DatabaseVO database = null;
            if (3 == dbType) {
                database = new SqlServerVO();
            } else if (1 == dbType) {
                database = new DB2VO();
            } else if (2 == dbType || 8 == dbType || 7 == dbType) {
                database = new OracleVO();
            } else if (4 == dbType) {
                database = new SyBaseVO();
            } else if (9 == dbType) {
                database = new DB400VO();
            }
            String scriptPath = appPath;
            DataCenterInfo dcInfo = new DataCenterInfo(database);
            DataCenterServiceImpl dcservice = new DataCenterServiceImpl();
            dcservice.executeSqlScriptFile(dcInfo, ScriptRunner.getScriptFile(appId, dcInfo.getDefaultDatabase(), scriptPath, dcservice));
            logger.info((Object)"RunScript Success!");
            System.out.println("RunScript Success!");
        }
        catch (Exception e1) {
            logger.error((Object)"RunScriptError:  ", (Throwable)e1);
            logger.error((Object)"RunScript Failed! ");
            System.out.println("RunScriptError" + e1);
            System.out.println("RunScript Failed!");
            throw e1;
        }
    }

    private static ArrayList getScriptFile(String appId, DatabaseVO database, String scriptPath, DataCenterServiceImpl dcservice) {
        Logger logger = LoggerUtil.getLoggerByAppId(appId);
        ArrayList<ScriptInfo> scriptList = new ArrayList<ScriptInfo>();
        logger.info((Object)("scriptPath " + SHRCheck.vaildLog((String)scriptPath)));
        scriptPath = scriptPath.replaceAll("\\\\", "/");
        if (StringUtils.hasText(scriptPath)) {
            String lowerPath = scriptPath.toLowerCase(Locale.ENGLISH);
            if (lowerPath.endsWith(".xml")) {
                ScriptInfo[] scriptInfos = dcservice.getScriptInfoFromFile(database, scriptPath);
                if (scriptInfos != null && scriptInfos.length > 0) {
                    for (int i = 0; i < scriptInfos.length; ++i) {
                        ScriptInfo scriptInfo = scriptInfos[i];
                        scriptInfo.scriptFilePath = scriptInfo.scriptFilePath.replaceAll("\\\\", "/");
                        scriptList.add(scriptInfo);
                        logger.info((Object)("scriptInfo.scriptFilePath " + SHRCheck.vaildLog((String)scriptInfo.scriptFilePath)));
                    }
                }
            } else if (lowerPath.endsWith("sql") || lowerPath.endsWith("ksql")) {
                ScriptInfo scriptInfo = new ScriptInfo();
                scriptInfo.charset = "UTF-8";
                scriptInfo.dialect = Boolean.FALSE;
                scriptInfo.scriptFilePath = scriptPath;
                scriptInfo.scriptSplit = ";";
                scriptInfo.scriptType = ScriptInfo.SCRIPT_TYPE_ALL;
                scriptList.add(scriptInfo);
            }
        } else {
            logger.info((Object)(SHRCheck.vaildLog((String)scriptPath) + " no script!"));
        }
        return scriptList;
    }
}

