/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.util;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AppUtil {
    private static Logger logger = Logger.getLogger(AppUtil.class);

    public static String getLocalAppCode(String appCode) {
        if (StringUtils.isEmpty((String)appCode)) {
            return "";
        }
        String[] str = appCode.split("-");
        if (str.length == 3) {
            appCode = str[0] + str[2];
        }
        return appCode;
    }

    public static String getCloudAppCode(String appCode, String appVersion) {
        if (StringUtils.isEmpty((String)appCode)) {
            return "";
        }
        if (!StringUtils.isEmpty((String)appVersion) && appCode.startsWith("APP") && appCode.split("-").length != 3) {
            appCode = "APP-" + appVersion + "-" + appCode.substring(3);
        }
        return appCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
            }
            if (outBuff != null) {
                outBuff.close();
            }
        }
    }

    public static void del(String filepath) throws IOException {
        File f = new File(filepath);
        if (f.exists() && f.isDirectory()) {
            if (f.listFiles().length == 0) {
                f.delete();
            } else {
                File[] delFile = f.listFiles();
                int i = f.listFiles().length;
                for (int j = 0; j < i; ++j) {
                    if (delFile[j].isDirectory()) {
                        AppUtil.del(delFile[j].getAbsolutePath());
                    }
                    delFile[j].delete();
                }
            }
        }
    }

    public static void delFile(String filePath) {
        File f = new File(SHRCheck.checkFilePath((String)filePath));
        if (f.exists()) {
            f.delete();
        }
    }

    public static void delDir(String dirPath) {
        File[] files;
        File dir = new File(SHRCheck.checkFilePath((String)dirPath));
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                AppUtil.delDir(f.getAbsolutePath());
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileAddr) throws IOException {
        File file = new File(SHRCheck.checkFilePath((String)fileAddr));
        if (!file.exists()) {
            return "";
        }
        StringBuffer datas = new StringBuffer();
        try (BufferedReader fr = null;){
            String line;
            fr = new BufferedReader(new FileReader(SHRCheck.checkFilePath((String)fileAddr)));
            while ((line = fr.readLine()) != null) {
                datas.append(line + "\n");
            }
        }
        return datas.toString();
    }
}

