/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.util;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.util.Constants;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DerbyDbUtil {
    public static final String DERBY_PATH = Constants.BASEPATH + "/deploy/easweb.ear/eas_web.war/webviews/shr/dydeploy/db-app";
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";

    public static void main(String[] args) throws Exception {
    }

    public static Connection openConnection() throws Exception {
        File f = new File(SHRCheck.checkFilePath((String)DERBY_PATH));
        if (!f.exists()) {
            return null;
        }
        Class.forName(DERBY_DRIVER).newInstance();
        String dbUrl = "jdbc:derby:" + DERBY_PATH;
        Connection conn = DriverManager.getConnection(dbUrl);
        return conn;
    }

    public static void closeConnection(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    public static void closeDerby() throws SQLException {
        DriverManager.getConnection("jdbc:derby:;shutdown=true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAppInfo(Map<String, String> appInfo, boolean isLocal) throws Exception {
        if (appInfo == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + (isLocal ? "t_app_local" : "t_app_deploy"));
        sql.append("(appId,name,version,alias,remark,author,authorId) values(");
        sql.append("'" + appInfo.get("appId") + "',");
        sql.append("'" + appInfo.get("name") + "',");
        sql.append("'" + appInfo.get("version") + "',");
        sql.append("'" + appInfo.get("alias") + "',");
        sql.append("'" + appInfo.get("remark") + "',");
        sql.append("'" + appInfo.get("author") + "',");
        sql.append("'" + appInfo.get("authorId") + "')");
        Connection conn = null;
        Statement s = null;
        try {
            conn = DerbyDbUtil.openConnection();
            if (conn != null) {
                s = conn.createStatement();
                s.execute(sql.toString());
            }
        }
        finally {
            if (null != s) {
                s.close();
            }
            DerbyDbUtil.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppsInfo() throws Exception {
        JSONObject info = new JSONObject();
        Connection conn = null;
        try {
            conn = DerbyDbUtil.openConnection();
            JSONArray local = new JSONArray();
            String sql = "select appId,name,version,alias,remark,author,authorId from t_app_local";
            List list = DerbyDbUtil.getAllBySql(conn, sql);
            JSONObject app = null;
            for (Object[] o : list) {
                app = new JSONObject();
                app.put("appId", o[0]);
                app.put("name", o[1]);
                app.put("version", o[2]);
                app.put("alias", o[3]);
                app.put("remark", o[4]);
                app.put("author", o[5]);
                app.put("authorId", o[6]);
                local.put((Object)app);
            }
            info.put("listLocal", (Object)local);
            JSONArray deploy = new JSONArray();
            sql = "select appId,name,version,alias,remark,author,authorId from t_app_deploy";
            list = DerbyDbUtil.getAllBySql(conn, sql);
            for (Object[] o : list) {
                app = new JSONObject();
                app.put("appId", o[0]);
                app.put("name", o[1]);
                app.put("version", o[2]);
                app.put("alias", o[3]);
                app.put("remark", o[4]);
                app.put("author", o[5]);
                app.put("authorId", o[6]);
                deploy.put((Object)app);
            }
            info.put("listDeploy", (Object)deploy);
        }
        finally {
            DerbyDbUtil.closeConnection(conn);
        }
        return info.toString();
    }

    public static List getAllBySql(Connection conn, String sql) throws SQLException {
        if (conn == null) {
            return new ArrayList();
        }
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery(sql);
        ResultSetMetaData meta = rs.getMetaData();
        int colSize = meta.getColumnCount();
        ArrayList<Object> list = new ArrayList<Object>();
        while (rs.next()) {
            if (colSize == 1) {
                list.add(rs.getObject(0));
                continue;
            }
            Object[] cols = new Object[colSize];
            for (int i = 0; i < colSize; ++i) {
                cols[i] = rs.getObject(i + 1);
            }
            list.add(cols);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeApp(String appId, boolean isLocal) throws Exception {
        if (Constants.isNullOrEmpty(appId)) {
            return;
        }
        String sql = "delete from " + (isLocal ? "t_app_local" : "t_app_deploy");
        sql = sql + " where appId = '" + appId + "'";
        Connection conn = null;
        Statement s = null;
        try {
            conn = DerbyDbUtil.openConnection();
            if (conn != null) {
                s = conn.createStatement();
                s.execute(sql.toString());
            }
        }
        finally {
            if (null != s) {
                s.close();
            }
            DerbyDbUtil.closeConnection(conn);
        }
    }
}

