/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec.config;

import com.kingdee.eas.mobileaccess.hr.sHR.util.ConfigUtils;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class EcConfigBean {
    private static EcConfigBean instance;
    private Configuration cfg;
    private static final Object metx;

    private EcConfigBean(Configuration cfg) {
        this.cfg = cfg;
    }

    public String getString(String key) {
        return this.cfg.getString(key);
    }

    public String[] getStringArray(String key) {
        return this.cfg.getStringArray(key);
    }

    public boolean showOrganLongName() {
        return this.cfg.getBoolean("ec.organ.showOrganLongName", true);
    }

    public boolean showNoPersonOrg() {
        return this.cfg.getBoolean("ec.organ.noPerson.display", false);
    }

    public String getRootOrgId() {
        return this.cfg.getString("ec.organ.rootOrgId");
    }

    public int getSearchPersonMaxSize() {
        String string = this.getString("ec.person.searchListMaxSize");
        if (string != null && string.length() > 0) {
            int parseInt = Integer.parseInt(string);
            if (parseInt >= 50) {
                return 50;
            }
            return parseInt;
        }
        return 20;
    }

    public int getSearchOrgMaxSize() {
        String string = this.getString("ec.organ.searchListMaxSize");
        if (string != null && string.length() > 0) {
            int parseInt = Integer.parseInt(string);
            if (parseInt >= 50) {
                return 50;
            }
            return parseInt;
        }
        return 20;
    }

    public List<String> getWordForFilterOrgan() {
        String[] words = this.getStringArray("ec.organ.wordForFilterOrgan");
        if (words == null || words.length == 0) {
            return Collections.emptyList();
        }
        if (words.length == 0 && StringUtils.isEmpty((String)words[0])) {
            return Collections.emptyList();
        }
        return Arrays.asList(words);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EcConfigBean getInstance() {
        Object object = metx;
        synchronized (object) {
            if (instance == null) {
                String fileName = ConfigUtils.getConfigRoot() + "/mobile_hr_ec.properties";
                try {
                    PropertiesConfiguration cfg = new PropertiesConfiguration(fileName);
                    cfg.setEncoding("UTF-8");
                    cfg.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
                    instance = new EcConfigBean((Configuration)cfg);
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                    throw new RuntimeException(String.format("Failed to parse profile: [% s]", fileName));
                }
            }
        }
        return instance;
    }

    public String getLocationValidLatitude() {
        return this.cfg.getString("hr.location.validLatitude");
    }

    public String getLocationValidLongitude() {
        return this.cfg.getString("hr.location.validLongitude");
    }

    public String getLocationAddress() {
        return this.cfg.getString("hr.location.address");
    }

    public String getLocationRange() {
        return this.cfg.getString("hr.location.range");
    }

    public String getHrPlatform() {
        return this.cfg.getString("hr.platform");
    }

    public String getHrVersion() {
        return this.cfg.getString("hr.version");
    }

    static {
        metx = new Object();
    }
}

