/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.sHR.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobileaccess.hr.sHR.action.BaseMobileAction;
import com.kingdee.eas.mobileaccess.hr.sHR.service.CallServiceUtil;
import com.kingdee.eas.mobileaccess.hr.sHR.util.SessionUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PersonTagAction
extends BaseMobileAction {
    private static final Logger logger = Logger.getLogger(PersonTagAction.class);
    private String personId;
    private String tagId;
    private String word;
    private String tagTypeId;
    private String tagIds;
    private String custTagName;
    private String custTagType;
    private String pageNum;
    private String pageSize;

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void setTagTypeId(String tagTypeId) {
        this.tagTypeId = tagTypeId;
    }

    public void setTagIds(String tagIds) {
        this.tagIds = tagIds;
    }

    public void setCustTagName(String custTagName) {
        this.custTagName = custTagName;
    }

    public void setCustTagType(String custTagType) {
        this.custTagType = custTagType;
    }

    public void setPageNum(String pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String queryTag() throws BOSException {
        if (this.personId == null || this.personId.length() == 0) {
            this.ok(Collections.emptyList());
            return "json";
        }
        try {
            Object list = CallServiceUtil.callRemoteService("GetAllTagAndPersonSelectedService", new String[]{"objectId", this.personId});
            this.ok(list);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String queryPersonTag() throws BOSException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("personId", this.personId);
            Object list = MSFServiceFacadeFactory.getRemoteInstance().processService("queryPersonTag", params);
            this.ok(list);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String queryPersonByTag() throws BOSException, ParseException {
        int NO_PERMISSION_COUNT = 3;
        if (this.tagId == null || this.tagId.length() == 0) {
            this.ok(Collections.emptyList());
            return "json";
        }
        try {
            Context ctx = SessionUtils.getCtx();
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            List collection = (List)CallServiceUtil.callRemoteService("GetTagListByObjIdService", new String[]{"objectId", personId});
            boolean isHavePermission = collection != null && collection.size() > 0;
            List list = (List)CallServiceUtil.callRemoteService("GetPersonListByTagIdService", new String[]{"tagId", this.tagId});
            List retList = !isHavePermission && list.size() > 3 ? list.subList(0, 3) : list;
            HashMap<String, Object> retMap = new HashMap<String, Object>();
            retMap.put("isHavePermission", isHavePermission);
            retMap.put("count", list.size());
            retMap.put("personList", retList);
            this.ok(retMap);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String queryTagList() throws BOSException {
        try {
            Object list = CallServiceUtil.callRemoteService("GetPersonTagInfoByTagTypeIdService", new String[]{"tagTypeId", this.tagTypeId});
            this.ok(list);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String queryTagListByName() throws BOSException {
        try {
            Object list = CallServiceUtil.callRemoteService("GetPersonTagInfoByTagNameService", new String[]{"word", this.word});
            this.ok(list);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String queryTagCount() throws BOSException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tagTypeId", this.tagTypeId);
            Object retValue = MSFServiceFacadeFactory.getRemoteInstance().processService("queryTagCount", params);
            this.ok(retValue);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String editPersonTag() {
        try {
            CallServiceUtil.callRemoteService("UpdatePersonTagService", new String[]{"objectId", this.personId, "tagIds", this.tagIds});
            this.ok(Collections.emptyList());
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            this.fail(e.getMessage());
        }
        return "json";
    }

    public String queryTagType() throws BOSException, EASBizException {
        Object list = CallServiceUtil.callRemoteService("GetTagTypeInfoService", new String[0]);
        this.ok(list);
        return "json";
    }
}

