/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.sHR.dao.page;

import com.kingdee.eas.mobileaccess.hr.sHR.config.EASConfig;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.CommonDao;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.page.DB2Page;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.page.IPage;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.page.OraclePage;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.page.SQLServer2005Page;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.page.SQLServerPage;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PageFactory {
    private static Logger logger = Logger.getLogger(PageFactory.class);
    private static int DBTYPE;
    private static IPage instance;

    public static IPage getPage(CommonDao dao) {
        return PageFactory.getInstance(dao);
    }

    private static IPage getInstance(CommonDao dao) {
        if (instance != null) {
            return instance;
        }
        switch (DBTYPE) {
            case 0: {
                String version = PageFactory.getSQLServerVersion(dao);
                if (!StringUtils.isBlank((String)version) && version.startsWith("8")) {
                    instance = new SQLServerPage();
                }
                instance = new SQLServer2005Page();
                break;
            }
            case 1: {
                instance = new DB2Page();
                break;
            }
            case 2: {
                instance = new OraclePage();
            }
        }
        return instance;
    }

    public static String getSQLServerVersion(CommonDao dao) {
        try {
            List<Map<String, Object>> data = dao.query("/*dialect*/SELECT SERVERPROPERTY('productversion') as VERSIOIN");
            Map<String, Object> o = data.get(0);
            return String.valueOf(o.get("VERSIOIN"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            DBTYPE = EASConfig.getInstance().getDbType();
        }
        catch (Exception e) {
            logger.error((Object)"can not load eas_config!", (Throwable)e);
        }
    }
}

