/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.sHR.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.mobileaccess.hr.sHR.config.EASConfig;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.CommonDao;
import com.kingdee.eas.mobileaccess.hr.sHR.util.SessionUtils;
import common.Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ContextUtils {
    private static Logger logger = Logger.getLogger(ContextUtils.class);
    private static Map<String, String> appId2Desc;

    public static Map<String, String> getAppId2Desc() {
        if (appId2Desc == null) {
            appId2Desc = new HashMap<String, String>();
            CommonDao commonDao = new CommonDao();
            try {
                List<Map<String, Object>> versions = commonDao.query("select * from T_3G_AppInfo", new String[]{"FID", "FName"});
                for (Map<String, Object> o : versions) {
                    appId2Desc.put(String.valueOf(o.get("FID")), String.valueOf(o.get("FName")));
                }
            }
            catch (Exception e) {
                logger.error((Object)"can not load appid data from table!", (Throwable)e);
            }
        }
        return appId2Desc;
    }

    public static void delUserInMonitorPanel(UMRegistryInfo monitoredUser) {
        try {
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            logger.info((Object)("deleting user[" + monitoredUser.getUserName() + "] from monitor! monitor users number[" + iUserMonitor.getCollection().size() + "]."));
            Context ctx = SessionUtils.getCtx();
            String sessionId = ctx.getContextID();
            iUserMonitor.deleteSessionAndUserMonitorInfo(sessionId, null);
            logger.info((Object)("User[" + monitoredUser.getUserName() + "]deleted from monitor! monitor users number[" + iUserMonitor.getCollection().size() + "]."));
        }
        catch (Exception e) {
            logger.error((Object)"can not delete monitored user in monitor panel!", (Throwable)e);
        }
    }

    public static void delUserInMonitorPanel() {
        try {
            UMRegistryInfo monitoredUser = ContextUtils.getUserInMonitorPanel();
            if (monitoredUser == null) {
                return;
            }
            ContextUtils.delUserInMonitorPanel(monitoredUser);
        }
        catch (Exception e) {
            logger.warn((Object)"can not delete monitored user in monitor panel!", (Throwable)e);
        }
    }

    public static boolean isUserExsitInMonitorPanel() throws Exception {
        return ContextUtils.getUserInMonitorPanel() != null;
    }

    public static void updateAppInfoOfMonitoredUser(String appClientId) {
        try {
            UMRegistryInfo monitoredUser = ContextUtils.getUserInMonitorPanel();
            if (monitoredUser == null) {
                return;
            }
            monitoredUser.setOpenWindowTitle(ContextUtils.getOpenWindowTitle(appClientId));
            ContextUtils.updateUserInMonitorPanel(monitoredUser);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to update window information for monitoring user", (Throwable)e);
        }
    }

    public static UMRegistryInfo getUserInMonitorPanel(Context ctx) throws Exception {
        if (ctx == null) {
            return null;
        }
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        List monitorUsers = iUserMonitor.findUsers(EASConfig.getInstance().getDcCode(), ctx.getUserName());
        for (Object o : monitorUsers) {
            UMRegistryInfo info = (UMRegistryInfo)o;
            if (!info.getId().equals(ctx.getContextID())) continue;
            return info;
        }
        return null;
    }

    public static UMRegistryInfo getUserInMonitorPanel() throws Exception {
        Context ctx = SessionUtils.getCtx();
        return ContextUtils.getUserInMonitorPanel(ctx);
    }

    public static void updateUserInMonitorPanel(UMRegistryInfo monitoredUser) throws Exception {
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        iUserMonitor.updateLastOperate(monitoredUser);
    }

    private static String getOpenWindowTitle(String appClientId) {
        if (StringUtils.isBlank((String)appClientId)) {
            return "3G";
        }
        String desc = ContextUtils.getAppId2Desc().get(appClientId);
        desc = !StringUtils.isBlank((String)desc) ? (desc = ":" + desc) : "";
        return "3G" + desc;
    }

    public static void addUserToMonitorPanel(String appid) throws Exception {
        Context ctx = SessionUtils.getCtx();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String userId = userInfo.getId().toString();
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        UMRegistryInfo info = new UMRegistryInfo();
        String id = ctx.getContextID();
        info.setId(id);
        info.setUserId(userId);
        info.setGUIUserId(id);
        info.setUserCUName(userInfo.getCU().getName());
        info.setDataCenterName(EASConfig.getInstance().getDcCode());
        info.setCurrentMainBizUnitName("");
        info.setFinished(true);
        info.setUserName(ctx.getUserName());
        info.setClientIPAddress(ctx.getClientHostIP());
        info.setUserRealName(userInfo.getName());
        info.setOpenWindowTitle(ContextUtils.getOpenWindowTitle(appid));
        info.setUserType(userInfo.getType().getValue());
        info.setCurrentCtrlUnitId(userInfo.getCU().getId().toString());
        info.setLastOperateTime(new Date());
        iUserMonitor.addnew(info);
    }

    public static Context getContext() throws Exception {
        String currentSolutionName = EASConfig.getInstance().getSlnName();
        String currentDatabaseCenter = EASConfig.getInstance().getDcCode();
        return ContextUtils.getContext(currentSolutionName, currentDatabaseCenter);
    }

    public static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        return new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
    }
}

