/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.IIntermilNO;
import com.kingdee.eas.base.codingrule.IntermilNOFactory;
import com.kingdee.eas.base.codingrule.client.AbstractIntermilNOEditUI;
import com.kingdee.eas.base.codingrule.client.IntermilNOListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class IntermilNOEditUI
extends AbstractIntermilNOEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IntermilNOListUI.class);
    private boolean canceled = false;
    private String codingruleid;
    private IObjectValue eo = null;
    private String value;
    private String sortItemValue;
    private CodingRuleInfo codingRuleInfo;

    public void onLoad() throws EASBizException, BOSException {
        if (this.getUIContext().get("EntityObjectInfo") != null) {
            this.eo = (IObjectValue)this.getUIContext().get("EntityObjectInfo");
        }
        if (this.getUIContext().get("codingruleid") != null) {
            this.codingruleid = this.getUIContext().get("codingruleid").toString();
        }
    }

    public IntermilNOEditUI() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Title_IntermilNOF7_ADD"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void bt_OK_mouseClicked(MouseEvent e) throws Exception {
        long number;
        super.bt_OK_mouseClicked(e);
        if (this.kDTextField1.getText() == null || this.kDTextField1.getText().equals("")) {
            return;
        }
        String aaa = this.kDTextField1.getText();
        IIntermilNO iIntermilNO = IntermilNOFactory.getRemoteInstance();
        try {
            number = new Long(aaa);
        }
        catch (Exception error) {
            throw new CodingRuleException(CodingRuleException.ERROR_CHECKINTERMILNO);
        }
        boolean ok = iIntermilNO.addDuanHao(this.eo, this.codingruleid, number);
        if (!ok) {
            throw new CodingRuleException(CodingRuleException.ERROR_CHECKINTERMILNO_MAX);
        }
        this.setValue(aaa);
        ICodingRule iCodingRule = CodingRuleFactory.getRemoteInstance();
        this.codingRuleInfo = iCodingRule.getCodingRuleInfo((IObjectPK)new ObjectUuidPK(this.codingruleid));
        String sortItemValue = iCodingRule.getSortItemValue(this.eo, (IObjectValue)this.codingRuleInfo);
        this.setSortItemValue(sortItemValue);
        this.canceled = false;
        this.getUIWindow().close();
    }

    @Override
    protected void bt_Cancel_mouseClicked(MouseEvent e) throws Exception {
        logger.debug((Object)"bt_Cancel_mouseClicked Event!");
        super.bt_Cancel_mouseClicked(e);
        this.canceled = true;
        this.getUIWindow().close();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSortItemValue() {
        return this.sortItemValue;
    }

    public void setSortItemValue(String sortItemValue) {
        this.sortItemValue = sortItemValue;
    }
}

