/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.codingrule.CodingRuleEntryFactory;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.ISeqSegmentEntry;
import com.kingdee.eas.base.codingrule.MaxSerialCollection;
import com.kingdee.eas.base.codingrule.MaxSerialFactory;
import com.kingdee.eas.base.codingrule.MaxSerialInfo;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryCollection;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryFactory;
import com.kingdee.eas.base.codingrule.client.AbstractSeqInitialValueListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SeqInitialValueListUI
extends AbstractSeqInitialValueListUI {
    private static final Logger logger = CoreUIObject.getLogger(SeqInitialValueListUI.class);
    private ArrayList sortItems = null;
    private Color[] color = new Color[]{Color.WHITE, new Color(217, 217, 208)};
    private HashMap maxSerialMap = new HashMap();
    private HashMap modifiedMaxs = new HashMap();
    private static final String splitSign = "_split_";
    private MaxSerialCollection maxCollection = null;
    private Map maxserialMap = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.initTable();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("seqInfo", this.getUIContext().get("seqInfo"));
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected void loadData() throws Exception {
        this.setOprtState("ADDNEW");
        super.loadData();
    }

    @Override
    public void loadFields() {
        this.dataBinder.loadHeader();
        this.loadDetailData();
    }

    private void loadDetailData() {
    }

    private void initContext() {
        if (this.getUIContext().get("sortItems") != null) {
            this.sortItems = (ArrayList)this.getUIContext().get("sortItems");
        }
    }

    private KDFormattedTextField createIntFieldForNum() {
        KDFormattedTextField numField = new KDFormattedTextField(0);
        numField.setDataVerifierType(12);
        numField.setDataType(0);
        numField.setMaximumValue((Comparable)new Long(999999999L));
        numField.setMinimumValue((Comparable)new Long(0L));
        numField.setSupportedEmpty(true);
        return numField;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void initTableHead() throws EASBizException, BOSException, Exception {
        IColumn col;
        while (this.kdtMaxSerials.getRowCount() > 0) {
            this.kdtMaxSerials.removeRow(0);
        }
        this.kdtMaxSerials.removeHeadRows();
        this.kdtMaxSerials.removeColumns();
        this.kdtMaxSerials.setFormatXml("");
        IRow headRow = this.kdtMaxSerials.addHeadRow();
        int index = 0;
        int segIndex = 0;
        if (this.editData.getId() != null && this.getMaxSerials().size() == 0) {
            this.editData = (CodingRuleEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        }
        if (this.getMaxSerials().get(0) != null && this.getMaxSerials().get(0).getSegmentAttrValue() != null && this.getMaxSerials().get(0).getSegmentAttrValue().trim().length() > 0) {
            col = this.kdtMaxSerials.addColumn();
            col.setKey("segment");
            headRow.getCell(index).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.info_Segment"));
            segIndex = 1;
        }
        while (index < this.sortItems.size()) {
            col = this.kdtMaxSerials.addColumn();
            col.setKey("attr" + index);
            headRow.getCell(index + segIndex).setValue((Object)this.sortItems.get(index).toString());
            ++index;
        }
        IColumn pNumCol = this.kdtMaxSerials.addColumn();
        pNumCol.setKey("preInitNum");
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.info_InitNum"));
        IColumn uNumCol = this.kdtMaxSerials.addColumn();
        uNumCol.setKey("usedNum");
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.info_usedNum"));
        IColumn iNumCol = this.kdtMaxSerials.addColumn();
        iNumCol.setKey("initNum");
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.info_AdjustNum"));
    }

    private MaxSerialCollection getMaxSerialCollection() {
        if (this.maxCollection != null) {
            return this.maxCollection;
        }
        MaxSerialCollection retColl = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterTemp = new FilterInfo();
        filterTemp.getFilterItems().add(new FilterItemInfo("codingRuleEntry", (Object)this.editData.getId()));
        ev.setFilter(filterTemp);
        try {
            retColl = MaxSerialFactory.getRemoteInstance().getMaxSerialCollection(ev);
        }
        catch (BOSException e) {
            retColl = this.editData.getMaxSerials();
        }
        this.maxCollection = retColl;
        return retColl;
    }

    private void initMasSerialCollection() {
        Iterator it = null;
        MaxSerialCollection mxc = this.getMaxSerialCollection();
        it = mxc.iterator();
        while (it.hasNext()) {
            MaxSerialInfo inInfo = (MaxSerialInfo)it.next();
            String sortItem = inInfo.getSortItemValue();
            if (sortItem == null) continue;
            if (inInfo.getSegmentAttrValue() != null && inInfo.getSegmentAttrValue().trim().length() > 0) {
                sortItem = sortItem + splitSign + inInfo.getSegmentAttrValue();
            }
            this.maxserialMap.put(sortItem, inInfo);
        }
    }

    private long getMaxSerialNumber(String key) {
        MaxSerialInfo mInfo = (MaxSerialInfo)this.maxserialMap.get(key);
        long maxSerial = mInfo.getSerialNumber();
        return maxSerial;
    }

    private void initTableData() {
        this.initMasSerialCollection();
        Map ms = this.maxserialMap;
        Object[] keySet = this.maxserialMap.keySet().toArray();
        Arrays.sort(keySet, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        int keyIndex = 0;
        while (keyIndex < keySet.length) {
            String sortItem = (String)keySet[keyIndex++];
            String[] strSortItems2 = sortItem.split(splitSign);
            MaxSerialInfo msInfo = (MaxSerialInfo)ms.get(sortItem);
            if (strSortItems2 == null || strSortItems2.length != this.sortItems.size()) continue;
            long maxSerialNumber = this.getMaxSerialNumber(sortItem);
            String segAttr = msInfo.getSegmentAttrValue();
            String[] strSortItems = msInfo.getSortItemValue().split(splitSign);
            if (strSortItems == null || strSortItems.length != this.sortItems.size()) continue;
            String key = msInfo.getSortItemValue();
            IRow row = this.kdtMaxSerials.addRow();
            if (segAttr != null && segAttr.trim().length() > 0) {
                try {
                    ISeqSegmentEntry ssEntry = SeqSegmentEntryFactory.getRemoteInstance();
                    EntityViewInfo eviTemp = new EntityViewInfo();
                    FilterInfo filterTemp = new FilterInfo();
                    filterTemp.getFilterItems().add(new FilterItemInfo("linkID", (Object)segAttr));
                    eviTemp.setFilter(filterTemp);
                    SeqSegmentEntryCollection ssCol = ssEntry.getSeqSegmentEntryCollection(eviTemp);
                    if (ssCol.get(0) != null) {
                        segAttr = ssCol.get(0).getAttrValue();
                    }
                }
                catch (BOSException ssEntry) {
                    // empty catch block
                }
                row.getCell("segment").setValue((Object)segAttr);
                row.getCell("segment").getStyleAttributes().setBackground(this.color[1]);
                row.getCell("segment").getStyleAttributes().setLocked(true);
            }
            if (segAttr != null) {
                key = segAttr + splitSign + key;
            }
            this.maxSerialMap.put(key, msInfo);
            for (int iItem = 0; iItem < strSortItems.length; ++iItem) {
                if (iItem == 0 && strSortItems[iItem].equalsIgnoreCase("codingrule_maxserial")) {
                    row.getCell("attr" + iItem).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AllItems"));
                } else {
                    row.getCell("attr" + iItem).setValue((Object)strSortItems[iItem]);
                }
                row.getCell("attr" + iItem).getStyleAttributes().setLocked(true);
                row.getCell("attr" + iItem).getStyleAttributes().setBackground(this.color[1]);
            }
            long lInitNum = msInfo.getInitValue();
            long lUsedNum = msInfo.getSerialNumber();
            if (lInitNum == 0L) {
                lInitNum = this.editData.getInitial();
            }
            if (lUsedNum <= 0L) {
                lUsedNum = this.editData.getInitial();
            }
            row.getCell("preInitNum").setValue((Object)("" + lInitNum));
            row.getCell("preInitNum").getStyleAttributes().setLocked(true);
            row.getCell("preInitNum").getStyleAttributes().setBackground(this.color[1]);
            row.getCell("usedNum").setValue((Object)("" + lUsedNum));
            row.getCell("usedNum").getStyleAttributes().setLocked(true);
            row.getCell("usedNum").getStyleAttributes().setBackground(this.color[1]);
            row.getCell("initNum").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.createIntFieldForNum()));
        }
        int rowCount = 0;
        for (rowCount = 13 - ms.size(); rowCount > 0; --rowCount) {
            IRow row = this.kdtMaxSerials.addRow();
            row.getStyleAttributes().setLocked(true);
        }
    }

    private MaxSerialCollection getMaxSerials() {
        return this.editData.getMaxSerials();
    }

    private void initTable() throws EASBizException, BOSException, Exception {
        if (this.sortItems == null) {
            return;
        }
        this.initTableHead();
        this.initTableData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CodingRuleEntryFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        CodingRuleEntryInfo info = (CodingRuleEntryInfo)this.getUIContext().get("seqInfo");
        if (info.getMaxSerials() == null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo finfo = new FilterInfo();
            finfo.getFilterItems().add(new FilterItemInfo("codingRuleEntry", (Object)info.getId()));
            evi.setFilter(finfo);
            MaxSerialCollection maxCol = null;
            try {
                maxCol = MaxSerialFactory.getRemoteInstance().getMaxSerialCollection(evi);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                maxCol = info.getMaxSerials();
            }
            info.getMaxSerials().clear();
            info.getMaxSerials().addCollection(maxCol);
        }
        return info;
    }

    public void saveMaxSerial() throws EASBizException, BOSException, Exception {
        if (this.modifiedMaxs.isEmpty()) {
            return;
        }
        Set keySet = this.modifiedMaxs.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            MaxSerialInfo msInfo = (MaxSerialInfo)this.maxSerialMap.get(key);
            msInfo.setInitValue(Long.parseLong(this.modifiedMaxs.get(key).toString()));
            MaxSerialFactory.getRemoteInstance().submit(msInfo);
        }
        this.modifiedMaxs.clear();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.saveMaxSerial();
        this.initTable();
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTable();
    }

    @Override
    protected void kdtMaxSerials_editStopping(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        IRow row = table.getRow(e.getRowIndex());
        int colIndex = 0;
        StringBuffer key = new StringBuffer();
        if (table.getColumn(0).getKey().equalsIgnoreCase("segment")) {
            key.append(row.getCell("segment").getValue().toString());
            colIndex = 1;
        }
        while (colIndex < table.getColumnCount() - 3) {
            if (key.length() > 0) {
                key.append(splitSign);
            }
            if (row.getCell(colIndex).getValue() != null && row.getCell(colIndex).getValue().toString().equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AllItems"))) {
                key.append("codingrule_maxserial");
            } else {
                key.append(row.getCell(colIndex).getValue().toString().trim());
            }
            ++colIndex;
        }
        if (e.getValue() == null || e.getValue().toString().length() == 0 || e.getValue() != null && e.getValue().equals(e.getOldValue())) {
            this.modifiedMaxs.remove(key.toString());
            return;
        }
        long initNum = Long.parseLong(e.getValue().toString());
        long usedNum = Long.parseLong(row.getCell("usedNum").getValue().toString());
        if (this.editData.getStep() > 0 && initNum <= usedNum) {
            row.getCell("initNum").setValue(e.getValue());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_PstInitNumInvalid"));
            this.kdtMaxSerials.requestFocusInWindow();
            return;
        }
        if (this.editData.getStep() < 0 && initNum >= usedNum) {
            row.getCell("initNum").setValue(e.getValue());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_NegInitNumInvalid"));
            this.kdtMaxSerials.requestFocusInWindow();
            return;
        }
        if (this.maxSerialMap.get(key.toString()) == null) {
            logger.error((Object)("\u6700\u5927\u503c\u4fdd\u5b58\u51fa\u9519,\u5206\u7c7b\u6392\u5e8f\u503c\u4e3a\uff1a" + key.toString()));
            return;
        }
        this.modifiedMaxs.put(key.toString(), initNum + "");
    }

    public boolean isModify() {
        return !this.modifiedMaxs.isEmpty();
    }
}

