/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.VarEnum;
import com.kingdee.eas.base.commonquery.client.CommonConstant;
import com.kingdee.eas.base.commonquery.client.CommonEntityPanel;
import com.kingdee.eas.base.commonquery.client.CommonEntityProcessor;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CommonEntityFilterPanel
extends KDPanel
implements IFilterPanel {
    private static Logger logger = Logger.getLogger(CommonEntityFilterPanel.class);
    private KDTable kdtTable;
    private KDPanel filterButtonPanel;
    private KDWorkButton addRowButton;
    private KDWorkButton insRowButton;
    private KDWorkButton delRowButton;
    private KDWorkButton clearButton;
    private KDWorkButton moveUpButton;
    private KDWorkButton moveDownButton;
    private FilterInfo filterInfo;
    private EntityObjectInfo entity;
    private String[] filterProperties;
    private IProcessor processor;
    private IPromptBoxFactory promptBoxFactory;
    private int width;
    private int height;
    private int defaultRows;
    private boolean extendCondition;
    private String panelName;
    private static final int MAX_COMPARE_VALUE_LENGTH = 1000;
    private boolean isShowEntry = false;
    private final String BIGDECIMAL_NUMBER_FORMAT = "0.0000000000";
    private String DEFAULT_NUMBER_FORMAT = "";
    private boolean isUseDateFunc = false;
    private boolean isUseTodayEnum = false;
    private boolean showFieldCompare = false;
    private final String USER_BOS_TYPE = "13B7DE7F";
    private final String PERSON_BOS_TYPE = "80EF7DED";
    private final String ORG_UNIT_BOS_TYPE = "9127AC92";
    private int[] FILTER_COLUMN_WIDTHs;
    private static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private static final String EXTEND_CONDITION_SIGN = "%";
    private static int defaultFieldMaxLenth = 80;

    public void setUseDateFunc(boolean aIsUseDateFunc) {
        this.isUseDateFunc = aIsUseDateFunc;
    }

    public boolean isUseDateFunc() {
        return this.isUseDateFunc;
    }

    public void setShowEntry(boolean isShowEntry) {
        this.isShowEntry = isShowEntry;
    }

    public boolean isShowEntry() {
        return this.isShowEntry;
    }

    public void setUseTodayEnum(boolean aIsUseTodayEnum) {
        this.isUseTodayEnum = aIsUseTodayEnum;
    }

    public boolean isUseTodayEnum() {
        return this.isUseTodayEnum;
    }

    public boolean isShowFieldCompare() {
        return this.showFieldCompare;
    }

    public void setShowFieldCompare(boolean showFieldCompare) {
        this.showFieldCompare = showFieldCompare;
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows, boolean extendCondition, boolean isShowEntry, boolean isUseDateFunc, boolean isUseTodayEnum, boolean isShowFieldCompare) throws BaseCommonQueryClientException {
        this.entity = Util.getEntity(entityPK);
        this.entity.setDefaultLocale(SysContext.getSysContext().getOriginLocale());
        this.filterInfo = filterInfo == null ? null : (FilterInfo)filterInfo.clone();
        this.filterProperties = filterProperties;
        this.processor = processor;
        this.promptBoxFactory = promptBoxFactory;
        this.width = width;
        this.height = height;
        this.defaultRows = defaultRows;
        this.extendCondition = extendCondition;
        this.FILTER_COLUMN_WIDTHs = this.calculateWidths();
        this.setShowEntry(isShowEntry);
        this.setUseDateFunc(isUseDateFunc);
        this.setUseTodayEnum(isUseTodayEnum);
        this.setShowFieldCompare(isShowFieldCompare);
        if (processor != null) {
            processor.set("COMMON_ENTITY_FILTER_PANEL", this);
        }
        this.jbInit();
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows, boolean extendCondition, boolean isShowEntry, boolean isUseDateFunc) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, defaultRows, extendCondition, isShowEntry, isUseDateFunc, false, false);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows, boolean extendCondition, boolean isShowEntry) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, defaultRows, extendCondition, isShowEntry, false);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows, boolean extendCondition) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, defaultRows, extendCondition, false);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height, int defaultRows) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, 10, false);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IProcessor processor, IPromptBoxFactory promptBoxFactory, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, processor, promptBoxFactory, width, height, 10);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, null, promptBoxFactory, width, height);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, IProcessor processor) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, processor, null, 540, 400);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, IProcessor processor, int defaultRows) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, processor, null, 540, 400, defaultRows);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, IProcessor processor, int defaultRows, boolean extendCondition) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, processor, null, 540, 400, defaultRows, extendCondition);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, promptBoxFactory, 540, 400);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory, boolean isUseDateFunc, boolean isUseTodayEnum) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, promptBoxFactory, isUseDateFunc, isUseTodayEnum, false);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, String[] filterProperties, IPromptBoxFactory promptBoxFactory, boolean isUseDateFunc, boolean isUseTodayEnum, boolean isShowFieldCompare) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, filterProperties, null, promptBoxFactory, 540, 400, 10, false, false, isUseDateFunc, isUseTodayEnum, isShowFieldCompare);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, null, 540, 400);
    }

    public CommonEntityFilterPanel(IMetaDataPK entityPK, FilterInfo filterInfo, int width, int height) throws BaseCommonQueryClientException {
        this(entityPK, filterInfo, null, null, width, height);
    }

    private int[] calculateWidths() {
        int unit = (this.width - 8 - 8) / 5;
        return new int[]{unit / 2, unit, unit, unit, unit / 2, unit - 45};
    }

    private void jbInit() throws BaseCommonQueryClientException {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"addRow"));
        this.addRowButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityFilterPanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.addRowButton);
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"removeRow"));
        this.delRowButton.setBounds(this.width - 8 - 22 - 3 - 22, 3, 22, 19);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityFilterPanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"clear"));
        this.clearButton.setBounds(this.width - 8 - 22, 3, 22, 19);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityFilterPanel.this.clearButton_actionPerformed(e);
            }
        });
        this.add((Component)this.clearButton);
        this.kdtTable = new KDTable();
        this.initTable();
        this.kdtTable.setBounds(8, 23, this.width - 8 - 8, this.height - 19 - 1 - 3);
        this.add((Component)this.kdtTable);
        this.insRowButton = new KDWorkButton();
        this.insRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.insRowButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"insertRow"));
        this.insRowButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.insRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityFilterPanel.this.insRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.insRowButton);
        this.moveUpButton = new KDWorkButton();
        this.moveUpButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.moveUpButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"moveUp"));
        this.moveUpButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityFilterPanel.this.moveUpButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveUpButton);
        this.moveDownButton = new KDWorkButton();
        this.moveDownButton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.moveDownButton.setToolTipText(EASResource.getString((String)commonEntityFilterRes, (String)"moveDown"));
        this.moveDownButton.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntityFilterPanel.this.moveDownButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveDownButton);
    }

    private void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    CommonEntityFilterPanel.this.kdtTable_editStarting(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    CommonEntityFilterPanel.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    CommonEntityFilterPanel.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void kdtTable_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(3);
                if (currentCell.getEditor() != null) {
                    Component editor = currentCell.getEditor().getComponent();
                    if (this.processor != null && !currentCell.getStyleAttributes().isLocked()) {
                        String condition = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
                        CommonEntityProcessor commonEntityProcessor = (CommonEntityProcessor)this.processor;
                        commonEntityProcessor.prepareEditor(this.entity, condition, editor);
                    }
                }
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void initTable() throws BaseCommonQueryClientException {
        int columnSize = CommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setWidth(this.FILTER_COLUMN_WIDTHs[i]);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)commonEntityFilterRes, (String)CommonConstant.FILTER_COLUMN_CODEs[i]));
        }
        this.fillFilterTableBody();
        this.setEditor();
        this.addTableListener();
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
        this.kdtTable.getActionMap().put("FocusChangeCol", (Action)new KDTFocusChangeAction(this.kdtTable, 0, false));
    }

    private void setEditor() {
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getEntityTreePromptBox());
        this.kdtTable.getColumn(1).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    private void fillLeftRows() {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.kdtTable.addRow();
            }
        }
    }

    private void fillFilterTableBody() throws BaseCommonQueryClientException {
        int filterSize;
        if (this.filterInfo != null && (filterSize = this.filterInfo.getFilterItems().size()) > 0) {
            if (!this.extendCondition) {
                this.checkFilters();
            }
            ArrayList rowInfos = Util.getRowInfos(this.filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                String compare;
                RowObject rowObject = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                this.kdtTable.addRow(i);
                rowObject.setLeftBracket(rowObject.getLeftBracket());
                rowObject.setCondition(filterItemInfo.getPropertyName());
                if (!filterItemInfo.isCompareValueIsProperty()) {
                    if (filterItemInfo.getCompareValue() != null) {
                        rowObject.setCompare(filterItemInfo.getCompareType().getName());
                        EntityObjectInfo targetEntity = Util.getEntity(this.entity, filterItemInfo.getPropertyName());
                        if (Util.isDate(targetEntity, Util.getPropertyName(filterItemInfo.getPropertyName()))) {
                            if (filterItemInfo.getCompareValue() instanceof Date) {
                                rowObject.setCompareValue(filterItemInfo.getCompareValue());
                            } else if (filterItemInfo.getCompareValue() != null && (CommonFilterUtil.isDateCompareSign(filterItemInfo.getCompareValue().toString()) || QueryUtils.isDateFunctionCompareSign(filterItemInfo.getCompareValue().toString()))) {
                                rowObject.setCompareValue(filterItemInfo.getCompareValue().toString());
                            } else {
                                try {
                                    rowObject.setCompareValue(DateTimeUtils.parseDate((String)filterItemInfo.getCompareValue().toString()));
                                }
                                catch (ParseException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                            }
                        } else if (filterItemInfo.getCompareValue() != null) {
                            Util.updateLikeRowObject(rowObject, filterItemInfo.getCompareValue(), filterItemInfo.getCompareType());
                        } else {
                            rowObject.setCompareValue(filterItemInfo.getCompareValue());
                        }
                    } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                        compare = filterItemInfo.getCompareType().getName();
                        if (compare.equalsIgnoreCase("=")) {
                            compare = "IS";
                        }
                        if (compare.equalsIgnoreCase("<>")) {
                            compare = "IS NOT";
                        }
                        rowObject.setCompare(compare);
                        rowObject.setCompareValue(null);
                    }
                } else {
                    compare = filterItemInfo.getCompareType().getName();
                    if (compare.equalsIgnoreCase("=")) {
                        compare = "FIELDEQUAL";
                    } else if (compare.equalsIgnoreCase("<>")) {
                        compare = "FIELDNOTEQUAL";
                    } else if (compare.equalsIgnoreCase(">")) {
                        compare = "FIELDLARGE";
                    } else if (compare.equalsIgnoreCase(">=")) {
                        compare = "FIELDLARGEEQUAL";
                    } else if (compare.equalsIgnoreCase("<")) {
                        compare = "FIELDLESS";
                    } else if (compare.equalsIgnoreCase("<=")) {
                        compare = "FIELDLESSEQUAL";
                    }
                    rowObject.setCompare(compare);
                    DataObject ob = Util.getCompareValueObject(this.entity, filterItemInfo.getCompareValue().toString());
                    rowObject.setCompareValue(ob);
                }
                rowObject.setRightBracket(rowObject.getRightBracket());
                rowObject.setLogic(rowObject.getLogic());
                this.loadFilter(i, rowObject);
            }
        }
    }

    private void checkFilters() {
        int filterSize = this.filterInfo.getFilterItems().size();
        if (this.filterProperties != null && this.filterProperties.length > 0) {
            for (int i = 0; i < filterSize; ++i) {
                int length = this.filterProperties.length;
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                boolean flag = true;
                for (int j = 0; j < length; ++j) {
                    if (!this.filterProperties[j].toLowerCase().equalsIgnoreCase(currentField.toLowerCase())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntityFilterRes, (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < filterSize; ++i) {
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                if (Util.getEntityPropertyAlias(this.entity, currentField) != null) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntityFilterRes, (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        }
    }

    private KDPromptBox getEntityTreePromptBox() {
        KDPromptBox entityTreePromptBox = new KDPromptBox();
        Window window = null;
        CommonEntityPanel commonEntityPanel = (CommonEntityPanel)((Object)Util.getComponent((Component)((Object)this), CommonEntityPanel.class.getName()));
        if (commonEntityPanel != null && commonEntityPanel.getParentUI() != null) {
            window = Util.getWindow(commonEntityPanel.getParentUI());
        }
        if (window == null) {
            window = Util.getWindow((Component)this.kdtTable);
        }
        EntityTreePromptDialog entityTreePromptDialog = null;
        entityTreePromptDialog = window instanceof Frame ? new EntityTreePromptDialog((Frame)window, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle") + " -- " + Util.getEntityAlias(this.entity), true, this.entity, this.filterProperties, false, this.isShowEntry()) : (window instanceof Dialog ? new EntityTreePromptDialog((Dialog)window, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle") + " -- " + Util.getEntityAlias(this.entity), true, this.entity, this.filterProperties, false, this.isShowEntry()) : new EntityTreePromptDialog((Frame)null, EASResource.getString((String)entityTreePromptDialogRes, (String)"dialogTitle") + " -- " + this.entity.getAlias(), true, this.entity, this.filterProperties, false, this.isShowEntry()));
        if (this.extendCondition) {
            entityTreePromptBox.setEditable(true);
        }
        entityTreePromptDialog.setShowEntry(this.isShowEntry());
        entityTreePromptBox.setSelector((KDPromptSelector)entityTreePromptDialog);
        entityTreePromptBox.setEditable(false);
        return entityTreePromptBox;
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 0, LeftBracketSignEnum.class.getName(), rowObject.getLeftBracket());
    }

    private void loadCondition(int rowIndex, RowObject rowObject) {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            if (strCondition.indexOf(EXTEND_CONDITION_SIGN) != -1) {
                this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)strCondition);
            } else {
                DataObject dataObject = new DataObject();
                dataObject.setName(Util.getEntityPropertyAlias(this.entity, rowObject.getCondition()));
                dataObject.setValue(strCondition);
                this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)dataObject);
            }
        }
    }

    private void removeFieldCompare(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignDateEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignDateEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignDateEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignDateEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignDateEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignDateEnum.FIELDNOTEQUAL);
    }

    private void loadCompareSign(int rowIndex, RowObject rowObject) throws BOSException {
        EntityObjectInfo targetEntity = Util.getEntity(this.entity, rowObject.getCondition());
        String targetProperty = Util.getPropertyName(rowObject.getCondition());
        DataObject dataInfo = Util.getRefMetaData(targetEntity, targetProperty);
        String compare = rowObject.getCompare();
        if (compare.equalsIgnoreCase(CompareType.LIKE.toString())) {
            if (rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && !rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "RIGHT LIKE";
            } else if (!rowObject.getCompareValue().toString().startsWith(EXTEND_CONDITION_SIGN) && rowObject.getCompareValue().toString().endsWith(EXTEND_CONDITION_SIGN)) {
                compare = "LEFT LIKE";
            }
        }
        boolean hasVar = false;
        if (rowObject.getCompareValue() != null && CommonFilterUtil.isVarValue(rowObject.getCompareValue().toString())) {
            if (compare.equalsIgnoreCase(CompareType.EQUALS.toString())) {
                compare = "VAREQUAL";
                hasVar = true;
            } else if (compare.equalsIgnoreCase(CompareType.NOTEQUALS.toString())) {
                compare = "VARNOTEQUAL";
                hasVar = true;
            }
        }
        if (dataInfo != null) {
            KDComboBox comboBox;
            if (CommonFilterUtil.isDateType(dataInfo.getName())) {
                if (rowObject.getCompareValue() != null && CommonFilterUtil.isDateCompareSign(rowObject.getCompareValue().toString())) {
                    comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompareValue().toString());
                } else if (rowObject.getCompareValue() != null && QueryUtils.isDateFunctionCompareSign(rowObject.getCompareValue().toString())) {
                    String compareValue = rowObject.getCompareValue().toString().split("\\$")[0];
                    comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), compareValue);
                } else {
                    comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompare());
                }
            } else {
                comboBox = Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnum.class.getName(), compare);
            }
            this.removeIncludeEnum(comboBox);
            this.removeDateEnum(comboBox);
            if (CommonFilterUtil.isDateType(dataInfo.getName())) {
                if (this.isUseTodayEnum()) {
                    this.removeTodayEnum(comboBox);
                    this.addTodayEnum(comboBox);
                }
                if (this.isUseDateFunc()) {
                    this.removeDateFuncEnum(comboBox);
                    this.addDateFuncEnum(comboBox);
                }
            }
            if (!targetEntity.equals((Object)this.entity) || !this.isShowFieldCompare()) {
                this.removeFieldCompare(comboBox);
            }
            if (hasVar) {
                this.removeVarEnum(comboBox);
                this.addVarEnum(comboBox);
            } else {
                this.removeVarEnum(comboBox);
            }
            if (!Util.isString(MetaDataPK.create((String)targetEntity.getFullName()), new String[]{targetProperty}, false)[0]) {
                comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
                comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
                comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
                comboBox.removeItem((Object)CompareSignEnum.NOTRIGHTLIKESIGN);
                comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
                comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
            }
        } else {
            logger.warn((Object)("------> Can not find ['" + targetProperty + "'] in entityObjectInfo(" + targetEntity + "),There may be something wrong"));
        }
    }

    private void loadCompareValue(int rowIndex, RowObject rowObject) throws BOSException {
        EntityObjectInfo targetEntity = Util.getEntity(this.entity, rowObject.getCondition());
        String targetProperty = Util.getPropertyName(rowObject.getCondition());
        DataObject dataInfo = Util.getRefMetaData(targetEntity, targetProperty);
        ICell compareValueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        ICell compareSignCell = this.kdtTable.getRow(rowIndex).getCell(2);
        ICell conditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        String compare = Util.getValue(compareSignCell.getValue()).toString();
        this.setNullSignLocked(rowIndex);
        if (CommonFilterUtil.isFieldJudge(compare)) {
            DataObject[] conditions = null;
            try {
                conditions = Util.getCompareValueList(this.entity, this.getProperty(this.kdtTable.getRow(rowIndex).getCell(1)).getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(conditions, null));
            DataObject value = null;
            if (conditions != null) {
                for (int i = 0; i < conditions.length; ++i) {
                    if (!(rowObject.getCompareValue() instanceof DataObject)) continue;
                    DataObject compareValue = (DataObject)rowObject.getCompareValue();
                    if (conditions[i] == null || !conditions[i].getValue().equals(compareValue.getValue())) continue;
                    value = conditions[i];
                }
            }
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(value);
            return;
        }
        if (dataInfo != null) {
            Object compareValue;
            if (CommonFilterUtil.isDateCompareSign(compare) || compare.equals("IS") || compare.equals("IS NOT")) {
                compareValueCell.setValue(null);
                compareValueCell.getStyleAttributes().setLocked(true);
            } else if (CommonFilterUtil.isEnumType(dataInfo.getName())) {
                Util.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), Util.getValue(rowObject.getCompareValue()).toString());
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                Util.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), Util.getValue(rowObject.getCompareValue()).toString());
            } else if (CommonFilterUtil.isDateType(dataInfo.getName())) {
                if (QueryUtils.isDateFunctionCompareSign(rowObject.getCompareValue().toString())) {
                    compareValue = rowObject.getCompareValue().toString();
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)((String)compareValue).split("\\$")[1]);
                } else {
                    Date dateValue = Util.getDate((Date)rowObject.getCompareValue(), dataInfo.getName());
                    Util.setDateCtrlField(this.kdtTable, rowIndex, 3, dateValue);
                    compareValueCell.setValue((Object)dateValue);
                    String format = Util.getTimeFormatForTable(dataInfo.getName());
                    compareValueCell.getStyleAttributes().setNumberFormat(format);
                }
            } else if (CommonFilterUtil.isF7Type(dataInfo.getName())) {
                KDBizPromptBox promptBox = (KDBizPromptBox)Util.getF7(targetProperty, MetaDataPK.create((String)targetEntity.getFullName()), false, null, this.promptBoxFactory);
                if (promptBox != null) {
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    Object f7Data = rowObject.getCompareValue();
                    promptBox.setData(f7Data);
                    compareValueCell.setRenderer((IBasicRender)avr);
                    compareValueCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    compareValueCell.setValue(f7Data);
                }
            } else if (CommonFilterUtil.isIntType(dataInfo.getName())) {
                if (dataInfo.getValue() != null) {
                    String value = ((DataObject)conditionCell.getValue()).getValue();
                    KDPromptBox f7 = Util.getF7(value, MetaDataPK.create((String)this.entity.getFullName()), false, null, this.promptBoxFactory);
                    if (f7 == null) {
                        this.setNumberCell(compareValueCell, dataInfo.getName(), rowObject.getCompareValue());
                    } else {
                        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                        Object f7Data = rowObject.getCompareValue();
                        f7.setData(f7Data);
                        compareValueCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                        compareValueCell.setRenderer(null);
                        compareValueCell.setValue(f7Data);
                    }
                } else {
                    this.setNumberCell(compareValueCell, dataInfo.getName(), rowObject.getCompareValue());
                }
            } else {
                compareValue = rowObject.getCompareValue();
                Object sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
                if (CompareSignEnum.LIKESIGN.equals(sign)) {
                    if (compareValue.toString().startsWith(EXTEND_CONDITION_SIGN) && compareValue.toString().endsWith(EXTEND_CONDITION_SIGN)) {
                        compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
                    }
                } else if (CompareSignEnum.LEFTLIKESIGN.equals(sign)) {
                    if (compareValue.toString().endsWith(EXTEND_CONDITION_SIGN)) {
                        compareValue = compareValue.toString().substring(0, compareValue.toString().length() - 1);
                    }
                } else if (CompareSignEnum.RIGHTLIKESIGN.equals(sign) && compareValue.toString().startsWith(EXTEND_CONDITION_SIGN)) {
                    compareValue = compareValue.toString().substring(1, compareValue.toString().length());
                }
                String propertyValue = ((DataObject)conditionCell.getValue()).getValue();
                this.setStringCell(compareValueCell, propertyValue, compareValue);
                compareValueCell.setValue(compareValue);
            }
        } else {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
        this.setCompareValueCellNumberFormat(conditionCell, compareSignCell, compareValueCell);
        if (this.isNullSign(rowObject.getCompare())) {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
        if (rowObject.getCompareValue() != null && CommonFilterUtil.isVarValue(rowObject.getCompareValue().toString())) {
            KDComboBox comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(VarEnum.getEnumList().toArray(), null));
            this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)VarEnum.getEnum(rowObject.getCompareValue().toString()));
        }
    }

    private void setNumberCell(ICell icell, String dataType, Object value) {
        KDFormattedTextField field = new KDFormattedTextField();
        if (DataType.SHORT.getName().equals(dataType)) {
            field.setDataType(2);
        } else if (DataType.INTEGER.getName().equals(dataType)) {
            field.setDataType(0);
        } else if (DataType.FLOAT.getName().equals(dataType)) {
            field.setDataType(4);
        } else if (DataType.DECIMAL.getName().equals(dataType)) {
            field.setDataType(1);
        } else if (DataType.DOUBLE.getName().equals(dataType)) {
            field.setDataType(5);
        }
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        icell.setEditor((ICellEditor)kdtDefaultCellEditor);
        icell.setValue(value);
    }

    private void setStringCell(ICell iCompareValueCell, String property, Object value) throws BOSException {
        KDPromptBox f7 = Util.getF7(property, MetaDataPK.create((String)this.entity.getFullName()), false, null, this.promptBoxFactory);
        KDTDefaultCellEditor kdtDefaultCellEditor = null;
        if (f7 == null) {
            KDTextField field = new KDTextField();
            field.setMaxLength(1000);
            if (value != null) {
                field.setText(value.toString());
            }
            kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        } else {
            this.resetCell(iCompareValueCell);
            f7.setData(value);
            kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
        }
        iCompareValueCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        iCompareValueCell.setValue(value);
    }

    private boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    private void loadRightBracket(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 4, RightBracketSignEnum.class.getName(), rowObject.getRightBracket());
    }

    private void loadLogicSign(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 5, LogicSignEnum.class.getName(), rowObject.getLogic());
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = CommonConstant.FILTER_COLUMN_CODEs.length;
        block12: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block12;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block12;
                }
                case 2: {
                    try {
                        this.loadCompareSign(rowIndex, rowObject);
                        continue block12;
                    }
                    catch (BOSException e) {
                        throw new BaseCommonQueryClientException(BaseCommonQueryClientException.QUERY_IS_NULL, e);
                    }
                }
                case 3: {
                    try {
                        this.loadCompareValue(rowIndex, rowObject);
                        continue block12;
                    }
                    catch (BOSException e) {
                        throw new BaseCommonQueryClientException(BaseCommonQueryClientException.QUERY_IS_NULL, e);
                    }
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block12;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block12;
                }
            }
        }
    }

    private void increaseRow(KDTEditEvent e) {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private boolean isBlankRow(int rowIndex) {
        int columnSize = CommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            if (Util.getValue(this.kdtTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
            if (object instanceof DataObject) {
                this.processCompareSignCell(e);
                this.processCompareValueCell(e);
            } else {
                this.kdtTable.getRow(rowIndex).getCell(3).setEditor(null);
            }
        }
        this.setCompareValueCellNumberFormat(this.kdtTable.getRow(rowIndex).getCell(1), this.kdtTable.getRow(rowIndex).getCell(2), this.kdtTable.getRow(rowIndex).getCell(3));
    }

    private void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        String targetProperty;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        String conditonValue = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        if (StringUtils.isEmpty((String)conditonValue)) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"blankRowWarning"));
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            return;
        }
        EntityObjectInfo targetEntity = Util.getEntity(this.entity, conditonValue);
        DataObject dataType = Util.getRefMetaData(targetEntity, targetProperty = Util.getPropertyName(conditonValue));
        if (dataType != null) {
            if (CommonFilterUtil.isEnumType(dataType.getName())) {
                return;
            }
            if (CommonFilterUtil.isDateType(dataType.getName()) && this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null && QueryUtils.isDateFunctionCompareSign(Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString())) {
                String numberValue = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(3).getValue()).toString();
                if (this.checkIsNumber(numberValue, DataType.INTEGER.getName())) {
                    MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"compareValueWarning"));
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                } else {
                    dataObject.setValue(numberValue);
                    dataObject.setName(numberValue);
                    this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)dataObject);
                }
            } else {
                if (CommonFilterUtil.isDateType(dataType.getName())) {
                    return;
                }
                if (CommonFilterUtil.isBooleanType(dataType.getName())) {
                    return;
                }
                if (CommonFilterUtil.isIntType(dataType.getName())) {
                    String numberValue = null;
                    ICellEditor editor = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
                    if (editor != null && editor.getComponent() instanceof KDBizPromptBox) {
                        KDBizPromptBox f7PromptBox = (KDBizPromptBox)editor.getComponent();
                        Object value = f7PromptBox.getData();
                        if (value == null) {
                            return;
                        }
                        if (value instanceof String) {
                            numberValue = (String)value;
                        } else if (value instanceof DataObject) {
                            numberValue = ((DataObject)value).getValue();
                        } else if (value instanceof IObjectValue) {
                            value = Util.getBizData((IObjectValue)value);
                            f7PromptBox.setData(value);
                            numberValue = f7PromptBox.getEditFormatter().valueToString(value);
                        } else if (value instanceof Float) {
                            numberValue = value.toString();
                        } else if (value instanceof Integer) {
                            numberValue = value.toString();
                        }
                        if (this.checkFilterData(numberValue, dataType.getName())) {
                            MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"compareValueWarning"));
                            this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                            return;
                        }
                        dataObject.setValue(numberValue);
                        dataObject.setName(numberValue);
                        this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)numberValue);
                    }
                } else {
                    ICellEditor editor = this.kdtTable.getRow(rowIndex).getCell(3).getEditor();
                    if (editor != null) {
                        KDComboBox box;
                        Object value;
                        Component valueObject = this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                        if (valueObject instanceof KDBizPromptBox) {
                            KDBizPromptBox promptBox = (KDBizPromptBox)valueObject;
                            Object objData = promptBox.getData();
                            if (objData == null) {
                                return;
                            }
                            if (objData instanceof String) {
                                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)((String)objData));
                                return;
                            }
                            if (objData instanceof DataObject) {
                                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                            } else if (objData instanceof IObjectValue) {
                                IObjectValue bizObject = (IObjectValue)objData;
                                bizObject = Util.getBizData(bizObject);
                                promptBox.setData((Object)bizObject);
                                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)promptBox.getEditFormatter().valueToString((Object)bizObject));
                                return;
                            }
                        } else if (valueObject instanceof KDComboBox && (value = (box = (KDComboBox)valueObject).getSelectedItem()) instanceof VarEnum) {
                            this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(value);
                        }
                    }
                }
            }
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 1) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(3));
            }
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            return;
        }
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.editedCompareSignCellAfter(e);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void setNullSignLocked(int rowIndex) {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null) {
            String filter_compare_sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue().toString();
            if (filter_compare_sign.equals(CompareSignDateEnum.NULLSIGN.toString()) || filter_compare_sign.equals(CompareSignDateEnum.NOTNULLSIGN.toString())) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else if (filter_compare_sign.equals(CompareSignEnum.VAREQUAL.toString()) || filter_compare_sign.equals(CompareSignEnum.VARNOTEQUAL.toString())) {
                Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(VarEnum.getEnumList().toArray(), null));
                iCell.getStyleAttributes().setLocked(false);
            } else {
                iCell.getStyleAttributes().setLocked(false);
            }
        }
    }

    private boolean checkFilterData(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Float(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void processCompareSignCell(KDTEditEvent e) throws Exception {
        KDComboBox comboBox;
        int rowIndex = e.getRowIndex();
        ICell conditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        DataObject dataObject = this.getProperty(conditionCell);
        String type = dataObject.getName();
        String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        if (!Util.isString(MetaDataPK.create((String)this.entity.getFullName()), new String[]{value}, false)[0]) {
            if (CommonFilterUtil.isDateType(type)) {
                comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignDateEnum.getEnumList().toArray(), null));
                this.removeIncludeEnum(comboBox);
                this.removeDateEnum(comboBox);
                if (this.isUseTodayEnum()) {
                    this.removeTodayEnum(comboBox);
                    this.addTodayEnum(comboBox);
                }
                if (this.isUseDateFunc()) {
                    this.removeDateFuncEnum(comboBox);
                    this.addDateFuncEnum(comboBox);
                }
                this.removeLikeEnum(comboBox);
            } else if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null) {
                comboBox = (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(2).getEditor().getComponent();
                if (Util.hasLikeCompare(comboBox)) {
                    this.removeDateEnum(comboBox);
                    this.removeLikeEnum(comboBox);
                    comboBox.setSelectedIndex(0);
                    this.kdtTable.getRow(rowIndex).getCell(2).setValue(null);
                }
            } else {
                comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
                this.removeIncludeEnum(comboBox);
                this.removeDateEnum(comboBox);
                this.removeLikeEnum(comboBox);
            }
            if (value.indexOf(".") >= 0 || !this.isShowFieldCompare()) {
                this.removeFieldCompare(comboBox);
            }
        } else if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null) {
            comboBox = this.getCompareSignBox(rowIndex);
            if (!Util.hasLikeCompare(comboBox)) {
                comboBox.addItem((Object)CompareSignEnum.LIKESIGN);
                comboBox.addItem((Object)CompareSignEnum.NOTLIKESIGN);
                comboBox.addItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
                comboBox.addItem((Object)CompareSignEnum.LEFTLIKESIGN);
                comboBox.addItem((Object)CompareSignEnum.RIGHTLIKESIGN);
            }
            if (value.indexOf(".") >= 0 || !this.isShowFieldCompare()) {
                this.removeFieldCompare(comboBox);
            }
        } else {
            comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, 2, Util.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
            this.removeIncludeEnum(comboBox);
            this.removeDateEnum(comboBox);
            if (value.indexOf(".") >= 0 || !this.isShowFieldCompare()) {
                this.removeFieldCompare(comboBox);
            }
        }
        if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null) {
            comboBox = this.getCompareSignBox(rowIndex);
            if (this.isSelectVar(rowIndex)) {
                this.removeVarEnum(comboBox);
                this.addVarEnum(comboBox);
            } else {
                this.removeVarEnum(comboBox);
            }
            if (!CommonFilterUtil.isDateType(type)) {
                this.removeDateEnum(comboBox);
            } else {
                if (this.isUseTodayEnum()) {
                    this.removeTodayEnum(comboBox);
                    this.addTodayEnum(comboBox);
                }
                if (this.isUseDateFunc()) {
                    this.removeDateFuncEnum(comboBox);
                    this.addDateFuncEnum(comboBox);
                }
            }
        }
        if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() == null || this.kdtTable.getRow(rowIndex).getCell(1).isChange()) {
            this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignDateEnum.EQUALSSIGN);
            this.processCompareValueCell(e);
        }
    }

    private KDComboBox getCompareSignBox(int rowIndex) {
        return (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(2).getEditor().getComponent();
    }

    private boolean isSelectVar(int rowIndex) {
        String targetProperty;
        Object o = this.kdtTable.getRow(rowIndex).getCell(1).getValue();
        if (!(o instanceof DataObject)) {
            return false;
        }
        String value = ((DataObject)o).getValue();
        EntityObjectInfo targetEntity = Util.getEntity(this.entity, value);
        return this.checkBOSTypeAndProperties("13B7DE7F", targetEntity, targetProperty = Util.getPropertyName(value), false) || this.checkBOSTypeAndProperties("80EF7DED", targetEntity, targetProperty, false) || this.checkBOSTypeAndProperties("9127AC92", targetEntity, targetProperty, true);
    }

    private boolean checkBOSTypeAndProperties(String boType, EntityObjectInfo targetEntity, String targetProperty, boolean isSubFrom) {
        boolean checkBOSTypeAndProperties = false;
        boolean checkBOSType = false;
        boolean checkProperties = false;
        checkBOSType = boType.equals(targetEntity.getType().toString());
        if (!checkBOSType && isSubFrom) {
            checkBOSType = targetEntity.isSubFrom((BusinessObjectInfo)Util.getEntity(BOSObjectType.create((String)boType)));
        }
        checkProperties = targetProperty.equalsIgnoreCase("id") || targetProperty.equalsIgnoreCase("number") || targetProperty.equalsIgnoreCase("name");
        checkBOSTypeAndProperties = checkBOSType && checkProperties;
        return checkBOSTypeAndProperties;
    }

    private void addVarEnum(KDComboBox comboBox) {
        comboBox.addItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.addItem((Object)CompareSignEnum.VARNOTEQUAL);
    }

    private void removeVarEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
    }

    private void removeLikeEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTRIGHTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
    }

    private void removeIncludeEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
    }

    private void removeTodayEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.TODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.AFTERTODAY);
    }

    private void addTodayEnum(KDComboBox comboBox) {
        comboBox.addItem((Object)CompareSignEnum.TODAY);
        comboBox.addItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.addItem((Object)CompareSignEnum.AFTERTODAY);
    }

    private void removeDateEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignDateEnum.TODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignDateEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignDateEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignDateEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignDateEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignDateEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignDateEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignDateEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignDateEnum.IN_X_DAYS_AFTER);
        comboBox.removeItem((Object)CompareSignDateEnum.IN_X_DAYS_BEFORE);
        comboBox.removeItem((Object)CompareSignDateEnum.IN_X_DAYS_EQUAL);
        comboBox.removeItem((Object)CompareSignDateEnum.X_DAYS_AGO_AFTER);
        comboBox.removeItem((Object)CompareSignDateEnum.X_DAYS_AGO_BEFORE);
        comboBox.removeItem((Object)CompareSignDateEnum.X_DAYS_AGO_EQUAL);
    }

    private void removeDateFuncEnum(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignDateEnum.IN_X_DAYS_AFTER);
        comboBox.removeItem((Object)CompareSignDateEnum.IN_X_DAYS_BEFORE);
        comboBox.removeItem((Object)CompareSignDateEnum.IN_X_DAYS_EQUAL);
        comboBox.removeItem((Object)CompareSignDateEnum.X_DAYS_AGO_AFTER);
        comboBox.removeItem((Object)CompareSignDateEnum.X_DAYS_AGO_BEFORE);
        comboBox.removeItem((Object)CompareSignDateEnum.X_DAYS_AGO_EQUAL);
    }

    private void addDateFuncEnum(KDComboBox comboBox) {
        comboBox.addItem((Object)CompareSignDateEnum.IN_X_DAYS_AFTER);
        comboBox.addItem((Object)CompareSignDateEnum.IN_X_DAYS_BEFORE);
        comboBox.addItem((Object)CompareSignDateEnum.IN_X_DAYS_EQUAL);
        comboBox.addItem((Object)CompareSignDateEnum.X_DAYS_AGO_AFTER);
        comboBox.addItem((Object)CompareSignDateEnum.X_DAYS_AGO_BEFORE);
        comboBox.addItem((Object)CompareSignDateEnum.X_DAYS_AGO_EQUAL);
    }

    private void processCompareValueCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        String filter_compare_sign = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        ICell compareValueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        ICell conditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        ICell compareSignCell = this.kdtTable.getRow(rowIndex).getCell(2);
        if (conditionCell.getValue() != null && !"".equals(conditionCell.getValue())) {
            if (e.getOldValue() != null) {
                String sEventCellOldValue = e.getOldValue().toString();
                if (compareSignCell.getValue() != null && !conditionCell.getValue().toString().equalsIgnoreCase(sEventCellOldValue)) {
                    if (CommonFilterUtil.isFieldJudge(compareSignCell.getValue().toString())) {
                        compareValueCell.getStyleAttributes().setLocked(false);
                        compareValueCell.setValue(null);
                        Object[] conditions = null;
                        Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(conditions, null));
                        return;
                    }
                    if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                        compareValueCell.getStyleAttributes().setLocked(true);
                        compareValueCell.setValue(null);
                    } else {
                        compareValueCell.getStyleAttributes().setLocked(false);
                    }
                    if (CommonFilterUtil.isFieldJudge(sEventCellOldValue)) {
                        compareValueCell.setValue(null);
                    }
                    DataObject dataObject = this.getProperty(conditionCell);
                    int colMaxLength = defaultFieldMaxLenth;
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, compareValueCell);
                    } else {
                        this.resetCell(compareValueCell, colMaxLength);
                    }
                } else if (CommonFilterUtil.isDateCompareSign(filter_compare_sign)) {
                    DataObject dataObject = this.getProperty(conditionCell);
                    int colMaxLength = defaultFieldMaxLenth;
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, compareValueCell);
                    } else {
                        this.resetCell(compareValueCell, colMaxLength);
                    }
                }
            } else if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null) {
                DataObject dataObject = this.getProperty(conditionCell);
                int colMaxLength = defaultFieldMaxLenth;
                if (dataObject != null) {
                    this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, compareValueCell);
                } else {
                    this.resetCell(compareValueCell, colMaxLength);
                }
            }
        }
    }

    private DataObject getProperty(ICell conditionCell) {
        String value = ((DataObject)conditionCell.getValue()).getValue();
        DataObject dataObject = null;
        if (value.indexOf(".") >= 0) {
            String value1 = value.substring(value.lastIndexOf(".") + 1);
            dataObject = Util.getRefMetaData(Util.getEntity(this.entity, value), value1);
        } else {
            dataObject = Util.getRefMetaData(this.entity, value);
        }
        return dataObject;
    }

    private void setDataObjectCompareValue(DataObject dataObject, int rowIndex, String filter_compare_sign, ICell iCell) throws BOSException {
        ICell conditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        String value = ((DataObject)conditionCell.getValue()).getValue();
        String type = dataObject.getName();
        if (CommonFilterUtil.isFieldJudge(filter_compare_sign)) {
            iCell.getStyleAttributes().setLocked(true);
            iCell.setValue(null);
            Object[] conditions = null;
            try {
                conditions = Util.getCompareValueList(this.entity, type);
            }
            catch (Exception e) {
                throw new BOSException("getCompareValueList error!", (Throwable)e);
            }
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(conditions, null));
            return;
        }
        if (CommonFilterUtil.isEnumType(type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = Util.getEnumList(enumClassName).toArray();
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(em, null));
        } else if (CommonFilterUtil.isBooleanType(type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = Util.getEnumList(enumClassName).toArray();
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(em, null));
            iCell.setValue(null);
        } else if (CommonFilterUtil.isDateType(type)) {
            if (CommonFilterUtil.isDateCompareSign(filter_compare_sign) || filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.setEditor(null);
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else if (QueryUtils.isDateFunctionCompareSign(filter_compare_sign)) {
                this.resetCell(iCell, dataObject.getColLength());
                iCell.setValue(null);
            } else {
                String format = Util.getTimeFormatForTable(type);
                Util.setDateCtrlField(this.kdtTable, rowIndex, 3, Util.getDate(new Date(), type, CompareSignDateEnum.getEnum(filter_compare_sign)));
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.getStyleAttributes().setLocked(false);
                iCell.setValue(null);
            }
        } else if (CommonFilterUtil.isF7Type(type)) {
            Object ob = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
            Component obj = null;
            if (this.kdtTable.getRow(rowIndex).getCell(3).getEditor() != null) {
                obj = this.kdtTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
            }
            Object f7 = null;
            f7 = obj instanceof KDBizPromptBox ? (KDBizPromptBox)obj : Util.getF7(value, MetaDataPK.create((String)this.entity.getFullName()), false, null, this.promptBoxFactory);
            f7.setEditable(true);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
            iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
            iCell.getStyleAttributes().setLocked(false);
            if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
            }
        } else if (CommonFilterUtil.isSimpleEntityType(type)) {
            Object[] simpleQueryResult = Util.getSimpleQueryResult(MetaDataPK.create((String)this.entity.getFullName()), dataObject.getValue(), value, false);
            Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(simpleQueryResult, null));
        } else if (CommonFilterUtil.isIntType(type)) {
            if (dataObject.getValue() != null) {
                KDPromptBox f7 = Util.getF7(value, MetaDataPK.create((String)this.entity.getFullName()), false, null, this.promptBoxFactory);
                if (f7 == null) {
                    this.setNumberCell(iCell, type, null);
                } else {
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.setRenderer(null);
                    iCell.setValue(null);
                }
            } else {
                this.resetCell(iCell, dataObject.getColLength());
            }
        } else if (DataType.STRING.getName().equals(type)) {
            if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null) {
                if (filter_compare_sign.equals(CompareSignDateEnum.NULLSIGN.getValue()) || filter_compare_sign.equals(CompareSignDateEnum.NOTNULLSIGN.getValue())) {
                    iCell.getStyleAttributes().setLocked(true);
                    iCell.setValue(null);
                } else if (filter_compare_sign.equals(CompareSignEnum.VAREQUAL.getValue()) || filter_compare_sign.equals(CompareSignEnum.VARNOTEQUAL.getValue())) {
                    EntityObjectInfo targetEntity = Util.getEntity(this.entity, value);
                    if ("13B7DE7F".equalsIgnoreCase(targetEntity.getType().toString())) {
                        Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(new Object[]{VarEnum.getEnum("$currentUser$")}, null));
                    } else if ("80EF7DED".equalsIgnoreCase(targetEntity.getType().toString())) {
                        Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(new Object[]{VarEnum.getEnum("$currentPerson$")}, null));
                    } else if ("9127AC92".equalsIgnoreCase(targetEntity.getType().toString())) {
                        Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(new Object[]{VarEnum.getEnum("$currentOrg$")}, null));
                    } else {
                        Util.setComboBoxField(this.kdtTable, rowIndex, 3, Util.addObjectToArray(VarEnum.getEnumList().toArray(), null));
                    }
                    iCell.getStyleAttributes().setLocked(false);
                } else {
                    this.setStringCell(iCell, value, null);
                }
            }
        } else {
            this.resetCell(iCell);
        }
    }

    private void setCompareValueCellNumberFormat(ICell aConditionCell, ICell aCompareSignCell, ICell aCompareValueCell) {
        String numberFormat = this.DEFAULT_NUMBER_FORMAT;
        DataObject object = this.getProperty(aConditionCell);
        if (object != null) {
            boolean isDateFuncCompareSign;
            if (DataType.DECIMAL.getName().equalsIgnoreCase(object.getName())) {
                numberFormat = "0.0000000000";
            } else if (CommonFilterUtil.isDateType(object.getName()) && !(isDateFuncCompareSign = QueryUtils.isDateFunctionCompareSign(Util.getValue(aCompareSignCell.getValue()).toString()))) {
                numberFormat = Util.getTimeFormatForTable(object.getName());
            }
        }
        aCompareValueCell.getStyleAttributes().setNumberFormat(numberFormat);
    }

    private void resetCell(ICell cell) {
        cell.setEditor(null);
        cell.setValue(null);
        if (cell.getStyleAttributes() != null) {
            cell.getStyleAttributes().setNumberFormat("");
        }
    }

    private void resetCell(ICell iCell, int maxLength) {
        if (maxLength <= 0) {
            maxLength = defaultFieldMaxLenth;
        }
        KDTextField field = new KDTextField();
        field.setMaxLength(maxLength);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void insRowButton_actionPerformed(ActionEvent e) {
        this.insRow();
    }

    protected void moveUpButton_actionPerformed(ActionEvent e) {
        this.moveUpRow();
    }

    protected void moveDownButton_actionPerformed(ActionEvent e) {
        this.moveDownRow();
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntityFilterRes, (String)"delWarning"));
        } else {
            this.delRow();
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    private boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = CommonConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kdtTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (compareSign.equalsIgnoreCase("YESTERDAY") || compareSign.equalsIgnoreCase("TODAY") || compareSign.equalsIgnoreCase("TOMORROW") || compareSign.equalsIgnoreCase("LASTWEEK") || compareSign.equalsIgnoreCase("THISWEEK") || compareSign.equalsIgnoreCase("NEXTWEEK") || compareSign.equalsIgnoreCase("LASTMONTH") || compareSign.equalsIgnoreCase("THISMONTH") || compareSign.equalsIgnoreCase("NEXTMONTH") || compareSign.equalsIgnoreCase("BEFORETODAY") || compareSign.equalsIgnoreCase("AFTERTODAY") || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kdtTable.getRow(rowIndex).getCell(3).getValue() != null) continue;
                    continue;
                }
                return true;
            }
            String strFilterValue = filterValue.toString();
            if (strFilterValue == null) {
                return true;
            }
            if (!strFilterValue.trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    private boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    private void addRow() {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
    }

    private void insRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex != -1) {
            this.kdtTable.addRow(selectedRowIndex);
        } else {
            this.addRow();
        }
    }

    private void moveUpRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)commonEntityFilterRes, (String)"selectToMoveUp"));
            return;
        }
        if (selectedRowIndex == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)commonEntityFilterRes, (String)"cannotMoveUp"));
            return;
        }
        IRow currentRow = this.kdtTable.getRow(selectedRowIndex);
        IRow upRow = this.kdtTable.getRow(selectedRowIndex - 1);
        this.kdtTable.addRow(selectedRowIndex - 1, currentRow);
        this.kdtTable.removeRow(selectedRowIndex + 1);
        this.kdtTable.getSelectManager().setActiveRowIndex(selectedRowIndex - 1);
        this.kdtTable.getLayoutManager().scrollRowToShow(selectedRowIndex - 1);
    }

    private void moveDownRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)commonEntityFilterRes, (String)"selectToMoveDown"));
            return;
        }
        if (selectedRowIndex == this.kdtTable.getRowCount() - 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)commonEntityFilterRes, (String)"cannotMoveDown"));
            return;
        }
        IRow currentRow = this.kdtTable.getRow(selectedRowIndex);
        IRow downRow = this.kdtTable.getRow(selectedRowIndex + 1);
        this.kdtTable.addRow(selectedRowIndex, downRow);
        this.kdtTable.removeRow(selectedRowIndex + 2);
        this.kdtTable.getSelectManager().setActiveRowIndex(selectedRowIndex + 1);
        this.kdtTable.getLayoutManager().scrollRowToShow(selectedRowIndex + 1);
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        this.kdtTable.removeRows();
    }

    private void setLeftBracketCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, columnIndex, Util.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setCompareSignCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
                KDComboBox comboBox = Util.setComboBoxField(this.kdtTable, rowIndex, columnIndex, Util.addObjectToArray(CompareSignEnum.getEnumList().toArray(), null));
                String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                this.removeIncludeEnum(comboBox);
                this.removeDateEnum(comboBox);
                if (value.indexOf(".") >= 0 || !this.isShowFieldCompare()) {
                    this.removeFieldCompare(comboBox);
                }
                if (this.isSelectVar(rowIndex)) {
                    this.removeVarEnum(comboBox);
                    this.addVarEnum(comboBox);
                } else {
                    this.removeVarEnum(comboBox);
                }
            }
        }
    }

    private void setCompareValueCell(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
            if (currentCell.getEditor() != null) {
                this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
                this.setNullSignLocked(rowIndex);
                Component editor = currentCell.getEditor().getComponent();
                if (editor instanceof KDDatePicker && currentCell.getValue() == null) {
                    currentCell.setValue((Object)new Date());
                }
                if (editor instanceof KDPromptBox) {
                    KDBizPromptBox f7Editor = (KDBizPromptBox)editor;
                    String strCompare = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                    if (!strCompare.equalsIgnoreCase("")) {
                        CompareSignEnum signEnum = CompareSignEnum.getEnum(strCompare.toUpperCase());
                        if (Util.isIncludeCompare(signEnum)) {
                            f7Editor.setEnabledMultiSelection(true);
                        } else {
                            f7Editor.setEnabledMultiSelection(false);
                        }
                    }
                }
            }
        }
    }

    private void setRightBracketCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, columnIndex, Util.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setLogicSignCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, columnIndex, Util.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 0: {
                    this.setLeftBracketCell(e);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.setCompareSignCell(e);
                    break;
                }
                case 3: {
                    this.setCompareValueCell(e);
                    break;
                }
                case 4: {
                    this.setRightBracketCell(e);
                    break;
                }
                case 5: {
                    this.setLogicSignCell(e);
                    break;
                }
            }
        }
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i) || !this.checkCurrentHasBlankCol(i)) continue;
            return true;
        }
        return false;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)commonEntityFilterRes, (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kdtTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = null;
            object = this.kdtTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)((Object)object)) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kdtTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)((Object)object)) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)commonEntityFilterRes, (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    private void setCurrentFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo4;
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = Util.getValue(iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue(iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue(iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue(iRow.getCell(5).getValue()).toString();
                if (logic == null || "".equals(logic)) {
                    logic = "AND";
                }
                Object compareValue = null;
                if (iRow.getCell(3).getEditor() != null && iRow.getCell(3).getEditor().getComponent() != null) {
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (obj instanceof KDBizPromptBox) {
                        KDBizPromptBox promptBox = (KDBizPromptBox)obj;
                        Object f7Data = promptBox.getData();
                        if (f7Data instanceof String) {
                            compareValue = (String)f7Data;
                        } else if (f7Data instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)f7Data;
                            compareValue = Util.getValue(objectValue.get(this.getLastProperty(condition)));
                        } else if (f7Data instanceof Object[]) {
                            compareValue = promptBox.getEditFormatter().valueToString(f7Data);
                        } else if (f7Data instanceof Object) {
                            compareValue = f7Data;
                        } else {
                            ICell valueCell = iRow.getCell(3);
                            if (valueCell != null) {
                                compareValue = valueCell.getValue();
                            }
                        }
                    } else {
                        compareValue = Util.getValue(iRow.getCell(3).getValue());
                        if (compareValue instanceof Date) {
                            DataObject tmpdo = Util.getRefMetaData(this.entity, condition);
                            String dateType = DataType.DATE.getName();
                            if (tmpdo != null) {
                                dateType = tmpdo.getName();
                            }
                            compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum(compare));
                        }
                    }
                } else {
                    compareValue = Util.getValue(iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        DataObject tmpdo = Util.getRefMetaData(this.entity, condition);
                        String dateType = DataType.DATE.getName();
                        if (tmpdo != null) {
                            dateType = tmpdo.getName();
                        }
                        compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum(compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign(compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)Util.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isDateCompareSign(compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)compare, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (QueryUtils.isDateFunctionCompareSign(compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)(compare + "$" + compareValue), CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.NOTEQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge(compare)) {
                    filterItemInfo4 = CommonFilterUtil.getFieldFilter(compare, condition, compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isVarJudge(compare)) {
                    filterItemInfo4 = CommonFilterUtil.getVarFilterForSave(compare, condition, compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign(compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN || compareSign == CompareSignEnum.LEFTLIKESIGN) {
                        compare = "like";
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN || compareSign == CompareSignEnum.RIGHTLIKESIGN) {
                        compare = "like";
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN || compareSign == CompareSignEnum.NOTLEFTLIKESIGN || compareSign == CompareSignStringEnum.NOTRIGHTLIKESIGN || compareSign == CompareSignEnum.NOTRIGHTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue(compareValue, compareSign);
                }
                DataObject dataInfo = Util.getRefMetaData(this.entity, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = Util.getRefMetaData(this.entity, condition).getName();
                    if (CommonFilterUtil.isIntType(dataType)) {
                        Number tmpCompareValue = null;
                        if (compareValue == null || this.checkFilterData(compareValue.toString(), dataType)) {
                            compareValue = "0.0";
                        }
                        tmpCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : new Integer(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)tmpCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.isF7Type(dataType)) {
                        filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo2);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                if ((strFormula = strFormula.trim()).endsWith("AND")) {
                    strFormula = strFormula.substring(0, strFormula.length() - "AND".length());
                }
                newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    private String getLastProperty(String condition) {
        if (condition == null) {
            return null;
        }
        int index = condition.lastIndexOf(".");
        if (index < 0) {
            return condition;
        }
        return condition.substring(index + 1);
    }

    private void setCurrentInnerFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo4;
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = Util.getValue(iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue(iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue(iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue(iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue(iRow.getCell(5).getValue()).toString();
                if (logic == null || "".equals(logic)) {
                    logic = "AND";
                }
                Object compareValue = null;
                if (Util.isF7CompareValue(iRow)) {
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    KDBizPromptBox promptBox = (KDBizPromptBox)obj;
                    Object f7Data = promptBox.getData();
                    if (f7Data instanceof String) {
                        compareValue = (String)f7Data;
                    } else if (f7Data instanceof IObjectValue) {
                        IObjectValue objectValue = (IObjectValue)f7Data;
                        compareValue = Util.getValue(objectValue.get(this.getLastProperty(condition)));
                    } else if (f7Data instanceof Object[]) {
                        compareValue = promptBox.getEditFormatter().valueToString(f7Data);
                    } else if (f7Data instanceof Object) {
                        compareValue = f7Data;
                    }
                } else {
                    compareValue = Util.getValue(iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        String dateType = Util.getRefMetaData(this.entity, condition).getName();
                        compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum(compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign(compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)Util.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isDateCompareSign(compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)compare, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (QueryUtils.isDateFunctionCompareSign(compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)(compare + "$" + compareValue), CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.NOTEQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge(compare)) {
                    filterItemInfo4 = CommonFilterUtil.getFieldFilter(compare, condition, compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isVarJudge(compare)) {
                    filterItemInfo4 = CommonFilterUtil.getVarFilterForQuery(compare, condition, compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign(compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN || compareSign == CompareSignEnum.LEFTLIKESIGN) {
                        compare = "like";
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN || compareSign == CompareSignEnum.RIGHTLIKESIGN) {
                        compare = "like";
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN || compareSign == CompareSignEnum.NOTLEFTLIKESIGN || compareSign == CompareSignStringEnum.NOTRIGHTLIKESIGN || compareSign == CompareSignEnum.NOTRIGHTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue(compareValue, compareSign);
                }
                DataObject dataInfo = Util.getRefMetaData(this.entity, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    Object[] value;
                    String dataType = Util.getRefMetaData(this.entity, condition).getName();
                    if (CommonFilterUtil.isIntType(dataType)) {
                        Number oCompareValue = null;
                        if (compareValue == null) {
                            compareValue = "0.0";
                        }
                        oCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : new Integer(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)oCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (dataType.equals("F7")) {
                        value = this.setStringFilter(leftBracket, rightBracket, logic, newFilterInfo, sbFormula, condition, Util.processStringValue(compareValue.toString()), CompareType.getEnum((String)compare));
                        newFilterInfo = (FilterInfo)value[0];
                        sbFormula = (StringBuffer)value[1];
                        continue;
                    }
                    if (dataType.equals(DataType.DATE.getName()) && compare.equals(CompareType.EQUALS.toString())) {
                        newFilterInfo = CommonFilterUtil.getEqualDateFilter(newFilterInfo, condition, compareValue);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (dataType.equals(DataType.DATE.getName()) && compare == CompareType.NOTEQUALS.toString()) {
                        newFilterInfo = CommonFilterUtil.getNotEqualDateFilter(newFilterInfo, condition, compareValue);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 3)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (compareValue instanceof Date) {
                        String dateType = Util.getRefMetaData(this.entity, condition).getName();
                        compareValue = Util.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum(compare));
                        String formats = QueryUtils.getTimeFormat(dateType);
                        SimpleDateFormat sdFormat = new SimpleDateFormat(formats);
                        compareValue = sdFormat.format(compareValue);
                    }
                    value = this.setStringFilter(leftBracket, rightBracket, logic, newFilterInfo, sbFormula, condition, Util.processStringValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo = (FilterInfo)value[0];
                    sbFormula = (StringBuffer)value[1];
                    continue;
                }
                Object[] value = this.setStringFilter(leftBracket, rightBracket, logic, newFilterInfo, sbFormula, condition, Util.processStringValue(compareValue.toString()), CompareType.getEnum((String)compare));
                newFilterInfo = (FilterInfo)value[0];
                sbFormula = (StringBuffer)value[1];
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                if ((strFormula = strFormula.trim()).endsWith("AND")) {
                    strFormula = strFormula.substring(0, strFormula.length() - "AND".length());
                }
                newFilterInfo.setMaskString(strFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    private Object[] setStringFilter(String leftBracket, String rightBracket, String logic, FilterInfo newFilterInfo, StringBuffer sbFormula, String condition, Vector vect, CompareType type) {
        FilterItemInfo filterItemInfo = null;
        Object[] value = new Object[2];
        if (vect.size() > 1) {
            sbFormula.append("(");
        }
        String linkType = "OR";
        if (CompareType.NOTEQUALS.equals((Object)type) || CompareType.NOTLIKE.equals((Object)type)) {
            linkType = "AND";
        }
        sbFormula.append(leftBracket).append(" ");
        int size = vect.size();
        for (int i = 0; i < size; ++i) {
            String str = (String)vect.get(i);
            filterItemInfo = new FilterItemInfo(condition, (Object)str, type);
            newFilterInfo.getFilterItems().add(filterItemInfo);
            sbFormula.append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(linkType).append(" ");
        }
        sbFormula = sbFormula.delete(sbFormula.length() - 4, sbFormula.length() - 1);
        sbFormula.append(rightBracket);
        if (vect.size() > 1) {
            sbFormula.append(")");
        }
        sbFormula.append(" ").append(logic);
        value[0] = newFilterInfo;
        value[1] = sbFormula;
        return value;
    }

    @Override
    public FilterInfo getFilterInfo() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }

    @Override
    public boolean verify() {
        boolean flag = true;
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return flag;
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    public KDWorkButton getAddRowButton() {
        return this.addRowButton;
    }

    public KDWorkButton getInsRowButton() {
        return this.insRowButton;
    }

    public KDWorkButton getClearButton() {
        return this.clearButton;
    }

    public KDWorkButton getDelRowButton() {
        return this.delRowButton;
    }

    public KDWorkButton getMoveUpRowButton() {
        return this.moveUpButton;
    }

    public KDWorkButton getMoveDownRowButton() {
        return this.moveDownButton;
    }

    public KDPanel getFilterButtonPanel() {
        return this.filterButtonPanel;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    @Override
    public void clear() {
        this.clearTable();
        this.fillLeftRows();
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    @Override
    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    @Override
    public FilterInfo getInnerFilterInfo() {
        this.setCurrentInnerFilterInfo();
        return this.filterInfo;
    }

    private void editedCompareSignCellAfter(KDTEditEvent e) throws BOSException {
        int rowIndex = e.getRowIndex();
        ICell conditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        ICell compareSignCell = this.kdtTable.getRow(rowIndex).getCell(2);
        ICell compareValueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        DataObject conditionDataObject = this.getProperty(conditionCell);
        String sCompareSign = Util.getValue(this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        String type = conditionDataObject.getName();
        this.setDataObjectCompareValue(conditionDataObject, rowIndex, sCompareSign, compareValueCell);
    }

    private boolean checkIsNumber(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Float(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }
}

