/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.SorterSignEnum;
import com.kingdee.eas.base.commonquery.client.CommonConstant;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.ISorterPanel;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class CommonEntitySorterPanel
extends KDPanel
implements ISorterPanel {
    private KDTable kdtTable;
    private KDWorkButton moveUpRowButton;
    private KDWorkButton moveDownRowButton;
    private KDPanel sorterKDPanel;
    private EntityObjectInfo entity;
    private SorterItemCollection sorterItems;
    private String panelName;
    private String[] sorterProperties;
    private static int[] SORTER_COLUMN_WIDTHs;
    protected Logger logger;
    private static final String commonEntitySorterRes = "com.kingdee.eas.base.commonquery.client.CommonEntitySorter";
    private int width;
    private int height;

    public CommonEntitySorterPanel(String name, IMetaDataPK entityPK, SorterItemCollection sorterItemCollection, String[] sorterProperties, int width, int height) throws BaseCommonQueryClientException {
        this.panelName = name;
        this.entity = Util.getEntity(entityPK);
        this.sorterItems = sorterItemCollection == null ? null : (SorterItemCollection)sorterItemCollection.clone();
        this.sorterProperties = sorterProperties == null ? Util.getDefaultProperties(this.entity) : sorterProperties;
        this.width = width;
        this.height = height;
        SORTER_COLUMN_WIDTHs = this.calculateWidths();
        this.jbInit();
    }

    public CommonEntitySorterPanel(String name, IMetaDataPK entityPK, SorterItemCollection sorterItemCollection, String[] sorterProperties) throws BaseCommonQueryClientException {
        this(name, entityPK, sorterItemCollection, sorterProperties, 540, 400);
    }

    public CommonEntitySorterPanel(IMetaDataPK entityPK, SorterItemCollection sorterItemCollection, String[] sorterProperties, int width, int height) throws BaseCommonQueryClientException {
        this(EASResource.getString((String)commonEntitySorterRes, (String)"panelName"), entityPK, sorterItemCollection, sorterProperties, width, height);
    }

    private int[] calculateWidths() {
        int unit = (this.width - 8 - 8) / 4;
        return new int[]{unit * 2, unit, unit - 45};
    }

    private void jbInit() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.moveUpRowButton = new KDWorkButton();
        this.moveUpRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.moveUpRowButton.setToolTipText(EASResource.getString((String)commonEntitySorterRes, (String)"moveUp"));
        this.moveUpRowButton.setBounds(this.width - 8 - 22 - 3 - 22, 3, 22, 19);
        this.moveUpRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntitySorterPanel.this.moveUpRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveUpRowButton);
        this.moveDownRowButton = new KDWorkButton();
        this.moveDownRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.moveDownRowButton.setToolTipText(EASResource.getString((String)commonEntitySorterRes, (String)"moveDown"));
        this.moveDownRowButton.setBounds(this.width - 8 - 22, 3, 22, 19);
        this.moveDownRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonEntitySorterPanel.this.moveDownRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveDownRowButton);
        this.kdtTable = new KDTable();
        this.initTable();
        this.kdtTable.setBounds(8, 23, this.width - 8 - 8, this.height - 19 - 1 - 3);
        this.add((Component)this.kdtTable);
    }

    public Logger getLogger(Class type) {
        return Logger.getLogger((Class)type);
    }

    protected void kdtTable_editStopped(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        if (colIndex == 1) {
            try {
                this.setSortTypeField(e);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    protected void kdtTable_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 2) {
            Object objIsChecked = this.kdtTable.getRow(rowIndex).getCell(1).getValue();
            boolean isChecked = false;
            if (objIsChecked instanceof Boolean) {
                isChecked = (Boolean)objIsChecked;
            }
            if (isChecked) {
                e.setCancel(false);
            } else {
                e.setCancel(true);
            }
        }
    }

    protected void moveUpRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntitySorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == 0) {
                return;
            }
            this.moveUpRow();
            this.kdtTable.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    protected void moveDownRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonEntitySorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == this.kdtTable.getRowCount() - 1) {
                return;
            }
            this.moveDownRow();
        }
    }

    private void moveUpRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        Object[] modifyRowData = this.getRowData(selectedRowIndex - 1);
        Object[] currentRowData = this.getRowData(selectedRowIndex);
        this.setRowData(selectedRowIndex - 1, currentRowData);
        this.setRowData(selectedRowIndex, modifyRowData);
        boolean currentLocked = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().isLocked();
        Color currentBgColor = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().getBackground();
        boolean modifyLocked = this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().isLocked();
        Color modifyBgColor = this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().getBackground();
        this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().setBackground(currentBgColor);
        this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().setLocked(currentLocked);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setBackground(modifyBgColor);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setLocked(currentLocked);
        this.kdtTable.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
    }

    private void moveDownRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        Object[] modifyRowData = this.getRowData(selectedRowIndex + 1);
        Object[] currentRowData = this.getRowData(selectedRowIndex);
        this.setRowData(selectedRowIndex + 1, currentRowData);
        this.setRowData(selectedRowIndex, modifyRowData);
        boolean currentLocked = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().isLocked();
        Color currentBgColor = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().getBackground();
        boolean modifyLocked = this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().isLocked();
        Color modifyBgColor = this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().getBackground();
        this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().setBackground(currentBgColor);
        this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().setLocked(currentLocked);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setLocked(modifyLocked);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setBackground(modifyBgColor);
        this.kdtTable.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
    }

    private Object[] getRowData(int rowIndex) {
        int length = CommonConstant.SORTER_COLUMN_CODEs.length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
        }
        return objects;
    }

    private void setRowData(int rowIndex, Object[] objects) {
        if (objects != null) {
            int length = objects.length;
            for (int i = 0; i < length; ++i) {
                this.kdtTable.getRow(rowIndex).getCell(i).setValue(objects[i]);
            }
        }
    }

    private void initTable() {
        int columnSize = CommonConstant.SORTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setWidth(SORTER_COLUMN_WIDTHs[i]);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)commonEntitySorterRes, (String)CommonConstant.SORTER_COLUMN_CODEs[i]));
        }
        this.kdtTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                CommonEntitySorterPanel.this.onMouseClicked(e);
            }
        });
        this.fillSorterTableBody();
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                CommonEntitySorterPanel.this.kdtTable_editStopped(e);
            }

            public void editStarting(KDTEditEvent e) {
                CommonEntitySorterPanel.this.kdtTable_editStarting(e);
            }
        });
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private void fillSorterTableBody() {
        PropertyCollection allProperties = Util.getEntitySorterProperties(this.entity, this.sorterProperties);
        int sorterSize = this.sorterItems.size();
        for (int i = 0; i < sorterSize; ++i) {
            SorterItemInfo sorterItemInfo = this.sorterItems.get(i);
            this.kdtTable.addRow(i);
            RowObject rowObject = new RowObject();
            rowObject.setCondition(sorterItemInfo.getPropertyName());
            rowObject.setIsChecked(Boolean.TRUE.toString());
            rowObject.setSortType(sorterItemInfo.getSortType().getName());
            this.loadSorters(i, rowObject);
        }
        int allSize = allProperties.size();
        Set sSorters = Util.getConditionSet(this.sorterItems);
        int index = this.kdtTable.getRowCount();
        for (int i = 0; i < allSize; ++i) {
            if (sSorters.contains(allProperties.get(i).getName())) continue;
            this.kdtTable.addRow(index);
            RowObject rowObject = new RowObject();
            rowObject.setCondition(allProperties.get(i).getName());
            rowObject.setIsChecked(Boolean.FALSE.toString());
            rowObject.setSortType("");
            this.loadSorters(index, rowObject);
            ++index;
        }
    }

    private void checkSorters() {
        int filterSize = this.sorterItems.size();
        if (filterSize > 0) {
            for (int i = 0; i < filterSize; ++i) {
                int length = this.sorterProperties.length;
                String currentField = this.sorterItems.get(i).getPropertyName();
                boolean flag = true;
                for (int j = 0; j < length; ++j) {
                    if (!this.sorterProperties[j].toLowerCase().equalsIgnoreCase(currentField.toLowerCase())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)commonEntitySorterRes, (String)"checkSortersWarning")));
                SysUtil.abort();
            }
        }
    }

    private void loadCondition(int rowIndex, RowObject rowObject) {
        DataObject dataObject = new DataObject();
        dataObject.setName(Util.getEntityPropertyAlias(this.entity, rowObject.getCondition()));
        dataObject.setValue(rowObject.getCondition());
        this.kdtTable.getRow(rowIndex).getCell(0).setValue((Object)dataObject);
    }

    private void loadIsChecked(int rowIndex, RowObject rowObject) {
        this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)Boolean.valueOf(rowObject.getIsChecked()));
    }

    private void loadSorterType(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, SorterSignEnum.class.getName(), rowObject.getSortType());
    }

    protected void loadSorters(int rowIndex, RowObject rowObject) {
        int length = CommonConstant.SORTER_COLUMN_CODEs.length;
        block5: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block5;
                }
                case 1: {
                    this.loadIsChecked(rowIndex, rowObject);
                    continue block5;
                }
                case 2: {
                    this.loadSorterType(rowIndex, rowObject);
                    continue block5;
                }
            }
        }
    }

    private void setIsCheckedCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)false);
        }
    }

    private void setSorterTypeCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, columnIndex, Util.addObjectToArray(SorterSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 1: {
                    this.setIsCheckedCell(e);
                    break;
                }
                case 2: {
                    this.setSorterTypeCell(e);
                    break;
                }
            }
        }
    }

    protected String getSorterWarning() {
        String sorterWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String sorterType;
            String temp = Util.getValue(this.kdtTable.getRow(i).getCell(1).getValue()).toString();
            String strIsCheck = temp.equalsIgnoreCase("") ? "false" : temp;
            boolean isCheck = Boolean.valueOf(strIsCheck);
            if (!isCheck || (sorterType = Util.getValue(this.kdtTable.getRow(i).getCell(2).getValue()).toString()) != null && !sorterType.trim().equalsIgnoreCase("")) continue;
            sorterWarning = EASResource.getString((String)commonEntitySorterRes, (String)"sorterWarning");
            return sorterWarning;
        }
        return sorterWarning;
    }

    private void setCurrentSorterItems() {
        int rowCount = this.kdtTable.getRowCount();
        SorterItemCollection newSorterItemCollection = new SorterItemCollection();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.kdtTable.getRow(i);
            String condition = Util.getValue(iRow.getCell(0).getValue()).toString();
            String temp = Util.getValue(iRow.getCell(1).getValue()).toString().toLowerCase();
            String strIsCheck = temp.equalsIgnoreCase("") ? "false" : temp;
            boolean isCheck = Boolean.valueOf(strIsCheck);
            String sorter = Util.getValue(iRow.getCell(2).getValue()).toString();
            if (!isCheck) continue;
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName(condition);
            sorterItemInfo.setSortType(SortType.getEnum((String)sorter));
            newSorterItemCollection.add(sorterItemInfo);
        }
        this.sorterItems = newSorterItemCollection;
    }

    @Override
    public SorterItemCollection getSorterItems() {
        this.setCurrentSorterItems();
        return this.sorterItems;
    }

    @Override
    public void setSorterItems(SorterItemCollection sorterItems) {
        this.sorterItems = sorterItems;
    }

    private void setSortTypeField(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        Object objIsChecked = e.getValue();
        boolean isCheck = false;
        if (objIsChecked instanceof Boolean) {
            isCheck = (Boolean)objIsChecked;
        }
        if (isCheck) {
            this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)SorterSignEnum.ASC);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).setValue(null);
        }
    }

    @Override
    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    protected void clearTable() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtTable.getRow(i);
            row.getCell(1).setValue(null);
            row.getCell(2).setValue(null);
        }
    }

    @Override
    public boolean verify() {
        boolean flag = true;
        String sorterWarning = this.getSorterWarning();
        if (sorterWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)sorterWarning);
            return false;
        }
        return flag;
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    public KDWorkButton getMoveDownRowButton() {
        return this.moveDownRowButton;
    }

    public KDWorkButton getMoveUpRowButton() {
        return this.moveUpRowButton;
    }

    public KDPanel getSorterKDPanel() {
        return this.sorterKDPanel;
    }

    @Override
    public void clear() {
        this.clearTable();
    }
}

