/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComponentDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.JVM;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.data.NLSSortType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldCollection;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.SorterSignEnum;
import com.kingdee.eas.base.commonquery.client.CommonConstant;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.ISorterPanel;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CommonSorterPanel
extends KDPanel
implements ISorterPanel {
    private static final long serialVersionUID = -4503392811946603218L;
    private KDTable kdtTable;
    private KDWorkButton moveUpRowButton;
    private KDWorkButton moveDownRowButton;
    private KDWorkButton moveUpToTopButton;
    private KDWorkButton moveDownToBottomButton;
    private KDWorkButton findButton;
    private KDPanel sorterButtonPanel;
    private SorterItemCollection sorterItems;
    private SorterItemCollection lockedSorterItems;
    private SorterItemCollection defalutSorters;
    private MetaDataPK queryPK;
    private String panelName;
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private static final String commonTableRes = "com.kingdee.eas.base.commonquery.client.CommonTablePanelResource";
    private int width;
    private int height;
    public int[] SORTER_COLUMN_WIDTHs;
    protected Logger logger = Logger.getLogger(CommonSorterPanel.class);
    private int SMALL_BUTTON_HEIGHT = 19;
    private int SMALL_BUTTON_WIDTH = 22;
    private KDComponentDialog findDialog;
    private KDButton findNextBtn;
    private KDButton closeBtn;
    private KDLabelContainer findNextLabel;
    private KDTextField findNextTxt;
    private String textToFound = "";
    private int foundIndex = -1;
    private int currentIndex = 0;
    private KDComponentDialog notFoundDialog;
    private KDComponentDialog finishSearchDialog;
    private boolean finishSearch = false;
    private int SPACE = 3;

    public CommonSorterPanel(String panelName, MetaDataPK queryPK, SorterItemCollection sorters, SorterItemCollection lockedSorters, int width, int height) throws BOSException {
        this.panelName = panelName;
        this.sorterItems = sorters == null ? null : (SorterItemCollection)sorters.clone();
        this.lockedSorterItems = lockedSorters;
        this.queryPK = queryPK;
        this.width = width;
        this.height = height;
        this.SORTER_COLUMN_WIDTHs = this.calculateWidths();
        this.jbInit();
    }

    public CommonSorterPanel(String panelName, MetaDataPK queryInfo, SorterItemCollection sorters, int width, int height) throws BOSException {
        this(EASResource.getString((String)commonSorterRes, (String)"panelName"), queryInfo, sorters, null, width, height);
    }

    public CommonSorterPanel(MetaDataPK queryInfo, SorterItemCollection sorters, int width, int height) throws BOSException {
        this(EASResource.getString((String)commonSorterRes, (String)"panelName"), queryInfo, sorters, width, height);
    }

    public CommonSorterPanel(MetaDataPK queryInfo, SorterItemCollection sorters, SorterItemCollection lockedSorters, int width, int height) throws BOSException {
        this(EASResource.getString((String)commonSorterRes, (String)"panelName"), queryInfo, sorters, lockedSorters, width, height);
    }

    public CommonSorterPanel(String panelName, MetaDataPK queryInfo, SorterItemCollection sorters) throws BOSException {
        this(panelName, queryInfo, sorters, 540, 400);
    }

    public CommonSorterPanel(MetaDataPK queryInfo, SorterItemCollection sorters) throws BOSException {
        this(EASResource.getString((String)commonSorterRes, (String)"panelName"), queryInfo, sorters, 540, 400);
    }

    private void jbInit() throws BOSException {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.initMoveUpRowButton();
        this.initMoveDownRowButton();
        this.initMoveUpToTopButton();
        this.initMoveDownToBotton();
        this.initFindBotton();
        this.kdtTable = new KDTable();
        this.initTable();
        this.kdtTable.setBounds(this.SPACE, this.SMALL_BUTTON_HEIGHT + this.SPACE * 2, this.width - 2 * this.SPACE, this.height - this.SPACE * 2 - this.SMALL_BUTTON_HEIGHT);
        this.add((Component)this.kdtTable);
    }

    private void initMoveUpRowButton() {
        this.moveUpRowButton = new KDWorkButton();
        this.moveUpRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.moveUpRowButton.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.moveUpRowButton.setBounds(this.width - 5 * (this.SMALL_BUTTON_WIDTH + this.SPACE), this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.moveUpRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonSorterPanel.this.moveUpRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveUpRowButton);
    }

    private void initMoveDownRowButton() {
        this.moveDownRowButton = new KDWorkButton();
        this.moveDownRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.moveDownRowButton.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        this.moveDownRowButton.setBounds(this.width - 4 * (this.SMALL_BUTTON_WIDTH + this.SPACE), this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.moveDownRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonSorterPanel.this.moveDownRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveDownRowButton);
    }

    private void initMoveUpToTopButton() {
        this.moveUpToTopButton = new KDWorkButton();
        this.moveUpToTopButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.moveUpToTopButton.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUpToTop"));
        this.moveUpToTopButton.setBounds(this.width - 3 * (this.SMALL_BUTTON_WIDTH + this.SPACE), this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.moveUpToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonSorterPanel.this.moveUpToTopButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveUpToTopButton);
    }

    private void initMoveDownToBotton() {
        this.moveDownToBottomButton = new KDWorkButton();
        this.moveDownToBottomButton.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.moveDownToBottomButton.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDownToBottom"));
        this.moveDownToBottomButton.setBounds(this.width - 2 * (this.SMALL_BUTTON_WIDTH + this.SPACE), this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.moveDownToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonSorterPanel.this.moveDownToBottomButton_actionPerformed(e);
            }
        });
        this.add((Component)this.moveDownToBottomButton);
    }

    private void initFindBotton() {
        this.findButton = new KDWorkButton();
        this.findButton.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.findButton.setToolTipText(EASResource.getString((String)commonTableRes, (String)"find"));
        this.findButton.setBounds(this.width - this.SMALL_BUTTON_WIDTH - this.SPACE, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonSorterPanel.this.findRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.findButton);
    }

    protected void findRowButton_actionPerformed(ActionEvent e) {
        this.showFindNextDialog();
    }

    private void showFindNextDialog() {
        if (this.kdtTable == null || this.kdtTable.getRowCount() == 0) {
            return;
        }
        if (this.findDialog == null) {
            Window w = SwingUtilities.windowForComponent((Component)((Object)this));
            this.findDialog = w instanceof Dialog ? new KDComponentDialog((Dialog)w) : (w instanceof Frame ? new KDComponentDialog((Frame)w) : new KDComponentDialog());
            this.setFindDialogModal();
            this.findDialog.setLFStyle(2);
            this.findDialog.setTitle(EASResource.getString((String)commonTableRes, (String)"findProperty"));
            this.findNextBtn = new KDButton(EASResource.getString((String)commonTableRes, (String)"findNext"));
            this.findNextBtn.setLimitedSize(false);
            this.findNextBtn.setFocusable(false);
            this.closeBtn = new KDButton(EASResource.getString((String)commonTableRes, (String)"close"));
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonSorterPanel.this.findDialog.dispose();
                }
            });
            this.findDialog.addButton(this.closeBtn);
            this.findDialog.addButton(this.findNextBtn);
            this.findNextLabel = new KDLabelContainer();
            this.findNextTxt = new KDTextField();
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.findNextTxt, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
            this.findNextLabel.setBoundLabelText(EASResource.getString((String)commonTableRes, (String)"findInput"));
            this.findNextLabel.setBoundEditor((JComponent)this.findNextTxt);
            this.findNextLabel.setPreferredSize(new Dimension(270, 21));
            this.findNextLabel.setBoundLabelUnderline(true);
            this.findDialog.setDialogComponent((Component)this.findNextLabel);
            this.findDialog.setSize(290, 118);
            this.findDialog.setResizable(false);
            this.findNextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonSorterPanel.this.findRow();
                }
            });
        }
        this.findDialog.getRootPane().setDefaultButton((JButton)this.findNextBtn);
        this.findDialog.setLocation(this.findButton.getLocationOnScreen());
        this.findDialog.show();
    }

    private void setFindDialogModal() {
        if (JVM.current().isOverOneDotFive() && this.findDialog != null) {
            this.findDialog.setModal(true);
        }
    }

    private void findRow() {
        String input = this.findNextTxt.getText().toLowerCase().trim();
        if (input != null && input.trim().length() > 0) {
            KDButton ok;
            if (!this.textToFound.equalsIgnoreCase(input)) {
                this.finishSearch = false;
                this.textToFound = input;
                this.foundIndex = -1;
                this.currentIndex = 0;
            }
            this.currentIndex = this.foundIndex + 1;
            if (this.kdtTable != null && this.kdtTable.getRowCount() > 0) {
                int i;
                for (i = this.currentIndex; i < this.kdtTable.getRowCount(); ++i) {
                    String propertyAlias;
                    if (this.kdtTable.getRow(i).getCell(0) == null || this.kdtTable.getRow(i).getCell(0).getValue() == null || (propertyAlias = this.kdtTable.getRow(i).getCell(0).getValue().toString()).indexOf(this.textToFound) < 0) continue;
                    this.foundIndex = i;
                    this.kdtTable.getSelectManager().select(i, 0);
                    this.kdtTable.getLayoutManager().scrollRowToShow(i);
                    break;
                }
                if (i == this.kdtTable.getRowCount()) {
                    this.finishSearch = true;
                }
            }
            if (this.foundIndex == -1) {
                if (this.notFoundDialog == null) {
                    this.notFoundDialog = new KDComponentDialog((Dialog)this.findDialog);
                    this.notFoundDialog.setLFStyle(2);
                    this.notFoundDialog.setTitle(EASResource.getString((String)commonTableRes, (String)"confirmMsg"));
                    ok = new KDButton(EASResource.getString((String)commonTableRes, (String)"confirm"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CommonSorterPanel.this.notFoundDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(EASResource.getString((String)commonTableRes, (String)"nosuchresult"));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    this.notFoundDialog.addButton(ok);
                    this.notFoundDialog.setDialogComponent((Component)notFoundLbl);
                }
                this.notFoundDialog.setLocation(this.findDialog.getLocation());
                this.notFoundDialog.setSize(290, 118);
                this.notFoundDialog.setModal(true);
                this.notFoundDialog.show();
            } else if (this.finishSearch) {
                this.textToFound = "";
                if (this.finishSearchDialog == null) {
                    this.finishSearchDialog = new KDComponentDialog((Dialog)this.findDialog);
                    this.finishSearchDialog.setLFStyle(2);
                    this.finishSearchDialog.setTitle(EASResource.getString((String)commonTableRes, (String)"confirmMsg"));
                    ok = new KDButton(EASResource.getString((String)commonTableRes, (String)"confirm"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CommonSorterPanel.this.finishSearchDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(EASResource.getString((String)commonTableRes, (String)"finished"));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    this.finishSearchDialog.addButton(ok);
                    this.finishSearchDialog.setDialogComponent((Component)notFoundLbl);
                }
                this.finishSearchDialog.setLocation(this.findDialog.getLocation());
                this.finishSearchDialog.setSize(290, 118);
                this.finishSearchDialog.setModal(true);
                this.finishSearchDialog.show();
            }
        }
    }

    private int[] calculateWidths() {
        int unit = (this.width - this.SPACE * 2) / 4;
        return new int[]{unit * 1, unit, unit / 2, unit / 2};
    }

    public Logger getLogger(Class type) {
        return Logger.getLogger((Class)type);
    }

    protected void kdtTable_editChanged(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        if (colIndex == 1) {
            try {
                this.setSortTypeField(e);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    protected void kdtTable_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 2) {
            Object objIsChecked = this.kdtTable.getRow(rowIndex).getCell(1).getValue();
            boolean isChecked = false;
            if (objIsChecked instanceof Boolean) {
                isChecked = (Boolean)objIsChecked;
            }
            if (isChecked) {
                e.setCancel(false);
            } else {
                e.setCancel(true);
            }
        }
    }

    private void loadCondition(int rowIndex, RowObject rowObject) throws BOSException {
        DataObject dataObject = new DataObject();
        dataObject.setName(Util.getQueryFieldAlias(rowObject.getQueryFieldInfo()));
        dataObject.setValue(rowObject.getCondition());
        this.kdtTable.getRow(rowIndex).getCell(0).setValue((Object)dataObject);
    }

    private void loadIsChecked(int rowIndex, RowObject rowObject) {
        this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)Boolean.valueOf(rowObject.getIsChecked()));
    }

    private void loadSorterType(int rowIndex, RowObject rowObject) {
        Util.setEnumComboBoxField(this.kdtTable, rowIndex, 2, SorterSignEnum.class.getName(), rowObject.getSortType());
    }

    private void loadSorterRule(int rowIndex, RowObject rowObject) {
        ConstDataType fieldType = null;
        if (rowObject.getQueryFieldInfo() != null) {
            fieldType = rowObject.getQueryFieldInfo().getReturnType();
        }
    }

    protected void loadSorters(int rowIndex, RowObject rowObject) throws BOSException {
        this.loadCondition(rowIndex, rowObject);
        this.loadIsChecked(rowIndex, rowObject);
        this.loadSorterType(rowIndex, rowObject);
        this.loadSorterRule(rowIndex, rowObject);
    }

    private void setSortTypeField(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        Object objIsChecked = e.getValue();
        boolean isCheck = false;
        if (objIsChecked instanceof Boolean) {
            isCheck = (Boolean)objIsChecked;
        }
        if (isCheck) {
            this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)SorterSignEnum.ASC);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).setValue(null);
        }
    }

    private void moveDownToBottomButton_actionPerformed(ActionEvent e) {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.kdtTable);
        if (selectedRows.length == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
            return;
        }
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        for (int i = 0; i < selectedRows.length; ++i) {
            this.moveDownOneRowTo(selectedRows[selectedRows.length - i - 1], this.kdtTable.getRowCount() - i - 1);
        }
        this.kdtTable.getSelectManager().select(this.kdtTable.getRowCount() - selectedRows.length, selectedColIndex, this.kdtTable.getRowCount(), selectedColIndex);
    }

    private void moveUpToTopButton_actionPerformed(ActionEvent e) {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.kdtTable);
        if (selectedRows.length == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
            return;
        }
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        for (int i = 0; i < selectedRows.length; ++i) {
            this.moveUpOneRowTo(selectedRows[i], i);
        }
        this.kdtTable.getSelectManager().select(0, selectedColIndex, selectedRows.length - 1, selectedColIndex);
    }

    private void moveDownOneRowTo(int fromRow, int toRow) {
        for (int i = 0; i < toRow - fromRow; ++i) {
            this.moveDownRow(fromRow + i);
        }
    }

    private void moveUpOneRowTo(int fromRow, int toRow) {
        for (int i = 0; i < fromRow - toRow; ++i) {
            this.moveUpRow(fromRow - i);
        }
    }

    protected void moveUpRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == 0) {
                return;
            }
            this.moveUpRow(selectedRowIndex);
            this.kdtTable.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    protected void moveDownRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.kdtTable.getSelectManager().getActiveColumnIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == this.kdtTable.getRowCount() - 1) {
                return;
            }
            this.moveDownRow(selectedRowIndex);
            this.kdtTable.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
        }
    }

    private void moveUpRow(int selectedRowIndex) {
        Object[] modifyRowData = this.getRowData(selectedRowIndex - 1);
        Object[] currentRowData = this.getRowData(selectedRowIndex);
        this.setRowData(selectedRowIndex - 1, currentRowData);
        this.setRowData(selectedRowIndex, modifyRowData);
        boolean currentLocked = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().isLocked();
        Color currentBgColor = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().getBackground();
        this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().isLocked();
        Color modifyBgColor = this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().getBackground();
        this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().setBackground(currentBgColor);
        this.kdtTable.getRow(selectedRowIndex - 1).getStyleAttributes().setLocked(currentLocked);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setBackground(modifyBgColor);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setLocked(currentLocked);
    }

    private void moveDownRow(int selectedRowIndex) {
        Object[] modifyRowData = this.getRowData(selectedRowIndex + 1);
        Object[] currentRowData = this.getRowData(selectedRowIndex);
        this.setRowData(selectedRowIndex + 1, currentRowData);
        this.setRowData(selectedRowIndex, modifyRowData);
        boolean currentLocked = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().isLocked();
        Color currentBgColor = this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().getBackground();
        boolean modifyLocked = this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().isLocked();
        Color modifyBgColor = this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().getBackground();
        this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().setBackground(currentBgColor);
        this.kdtTable.getRow(selectedRowIndex + 1).getStyleAttributes().setLocked(currentLocked);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setLocked(modifyLocked);
        this.kdtTable.getRow(selectedRowIndex).getStyleAttributes().setBackground(modifyBgColor);
    }

    private Object[] getRowData(int rowIndex) {
        int length = CommonConstant.SORTER_COLUMN_CODEs.length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
        }
        return objects;
    }

    private void setRowData(int rowIndex, Object[] objects) {
        if (objects != null) {
            int length = objects.length;
            for (int i = 0; i < length; ++i) {
                this.kdtTable.getRow(rowIndex).getCell(i).setValue(objects[i]);
            }
        }
    }

    private void initTable() throws BOSException {
        int columnSize = CommonConstant.SORTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setWidth(this.SORTER_COLUMN_WIDTHs[i]);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)commonSorterRes, (String)CommonConstant.SORTER_COLUMN_CODEs[i]));
        }
        this.kdtTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                CommonSorterPanel.this.onMouseClicked(e);
            }
        });
        this.fillSorterTableBody();
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                CommonSorterPanel.this.kdtTable_editChanged(e);
            }

            public void editStarting(KDTEditEvent e) {
                CommonSorterPanel.this.kdtTable_editStarting(e);
            }
        });
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        int dbTypeCode = (Integer)((LoginContext)SysContext.getSysContext().getProperty((Object)"logincontext")).get("dbTypeCode");
    }

    private void dealSortId() {
        int size;
        if (this.sorterItems != null && (size = this.sorterItems.size()) == 1 && this.sorterItems.getSorter().get(0).getPropertyName().equals("id")) {
            this.sorterItems.clear();
        }
    }

    protected void fillSorterTableBody() throws BOSException {
        this.fillSorterTableBody(null);
    }

    protected void fillSorterTableBody(DynQuerySelectFieldCollection aExcludedFieldColl) throws BOSException {
        this.kdtTable.removeRows();
        SimplePropertyUnitCollection sorters = Util.getConditionList(this.queryPK, QueryPanelTypeEnum.SORTER_PANEL, new String[]{"displayName", "returnType"}, new String[]{"revserseLinkProName", "displayFormat", "editFormat", "commitFormat"});
        this.removeExcludedField(sorters, aExcludedFieldColl);
        Map<String, SimplePropertyUnit> mAllSorters = Util.getConditionMap(sorters);
        this.checkSorters(this.sorterItems);
        this.checkSorters(this.lockedSorterItems);
        int size = this.sorterItems.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtTable.addRow(i);
            RowObject rowObject = new RowObject();
            SimplePropertyUnit queryFieldInfo = mAllSorters.get(this.sorterItems.get(i).getPropertyName());
            if (queryFieldInfo != null) {
                rowObject.setCondition(queryFieldInfo.getName());
                rowObject.setQueryFieldInfo(queryFieldInfo);
            }
            rowObject.setIsChecked(Boolean.TRUE.toString());
            rowObject.setSortType(this.sorterItems.get(i).getSortType().getName());
            if (NLSSortType.SCHINESE_PINYIN.equals((Object)this.sorterItems.get(i).getNLSSortType())) {
                rowObject.setSortRule("PINYIN");
            }
            if (this.isLockedSorter(this.sorterItems.get(i).getPropertyName())) {
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(CommonConstant.LOCKED_COLOR);
            }
            this.loadSorters(i, rowObject);
        }
        Set sSorters = Util.getConditionSet(this.sorterItems);
        int sizeAll = sorters.size();
        int index = this.kdtTable.getRowCount();
        for (int i = 0; i < sizeAll; ++i) {
            SimplePropertyUnit queryFieldInfo = sorters.get(i);
            if (queryFieldInfo == null || sSorters.contains(queryFieldInfo.getName())) continue;
            this.kdtTable.addRow(index);
            RowObject rowObject = new RowObject();
            rowObject.setCondition(queryFieldInfo.getName());
            rowObject.setIsChecked(Boolean.FALSE.toString());
            rowObject.setSortType("");
            rowObject.setQueryFieldInfo(queryFieldInfo);
            this.loadSorters(index, rowObject);
            ++index;
        }
    }

    private void removeExcludedField(SimplePropertyUnitCollection aList, DynQuerySelectFieldCollection aExcludedFieldColl) {
        if (aExcludedFieldColl != null && aExcludedFieldColl.size() != 0) {
            int size = aExcludedFieldColl.size();
            for (int i = 0; i < size; ++i) {
                DynQuerySelectFieldInfo excludedField = aExcludedFieldColl.get(i);
                for (int j = 0; j < aList.size(); ++j) {
                    if (!aList.get(j).getName().equals(excludedField.getNumber())) continue;
                    aList.removeObject(j);
                }
            }
        }
    }

    private void checkSorters(SorterItemCollection checkSorters) throws BOSException {
        int sorterSize = checkSorters.size();
        if (sorterSize > 0) {
            for (int i = 0; i < sorterSize; ++i) {
                DataObject[] dataObjects = Util.getConditionArray(this.queryPK, QueryPanelTypeEnum.SORTER_PANEL);
                int dataObjectsLength = dataObjects.length;
                String currentField = checkSorters.get(i).getPropertyName();
                boolean notInQuery = true;
                for (int j = 0; j < dataObjectsLength; ++j) {
                    if (!dataObjects[j].getValue().equalsIgnoreCase(currentField)) continue;
                    notInQuery = false;
                    break;
                }
                if (!notInQuery) continue;
                String detail = currentField + EASResource.getString((String)commonSorterRes, (String)"checkSortersWarning") + this.queryPK.getFullName() + EASResource.getString((String)commonSorterRes, (String)"checkSortersOtherWarning");
                this.logger.info((Object)detail);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)commonSorterRes, (String)"UPGRADE_ALERT"), (String)detail, (int)1);
            }
        }
    }

    protected boolean isLockedSorter(String propertyName) {
        if (this.lockedSorterItems != null) {
            int size = this.lockedSorterItems.size();
            for (int i = 0; i < size; ++i) {
                SorterItemInfo lockedSorterItemInfo = this.lockedSorterItems.get(i);
                if (!lockedSorterItemInfo.getPropertyName().equalsIgnoreCase(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    private void setIsCheckedCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)false);
        }
    }

    private void setSorterTypeCell(KDTMouseEvent e) {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        Object objIsChecked = this.kdtTable.getRow(rowIndex).getCell(1).getValue();
        boolean isChecked = false;
        if (objIsChecked instanceof Boolean) {
            isChecked = (Boolean)objIsChecked;
        }
        if (isChecked && this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
            Util.setComboBoxField(this.kdtTable, rowIndex, columnIndex, Util.addObjectToArray(SorterSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 1: {
                    this.setIsCheckedCell(e);
                    break;
                }
                case 2: {
                    this.setSorterTypeCell(e);
                    break;
                }
            }
        }
    }

    protected String getSorterWarning() {
        String sorterWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String sorterType;
            String temp = Util.getValue(this.kdtTable.getRow(i).getCell(1).getValue()).toString();
            String strIsCheck = temp.equalsIgnoreCase("") ? Boolean.FALSE.toString() : temp;
            boolean isCheck = Boolean.valueOf(strIsCheck);
            if (!isCheck || (sorterType = Util.getValue(this.kdtTable.getRow(i).getCell(2).getValue()).toString()) != null && !sorterType.trim().equalsIgnoreCase("")) continue;
            sorterWarning = EASResource.getString((String)commonSorterRes, (String)"sorterWarning");
            return sorterWarning;
        }
        return sorterWarning;
    }

    private void setCurrentSorterItems() {
        int rowCount = this.kdtTable.getRowCount();
        SorterItemCollection newSorterItemCollection = new SorterItemCollection();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.kdtTable.getRow(i);
            String condition = Util.getValue(iRow.getCell(0).getValue()).toString();
            String sorterRule = "";
            String temp = Util.getValue(iRow.getCell(1).getValue()).toString().toLowerCase();
            String strIsCheck = temp.equalsIgnoreCase("") ? Boolean.FALSE.toString() : temp;
            boolean isCheck = Boolean.valueOf(strIsCheck);
            String sorter = Util.getValue(iRow.getCell(2).getValue()).toString();
            if (!isCheck) continue;
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName(condition);
            sorterItemInfo.setSortType(SortType.getEnum((String)sorter));
            if ("PINYIN".equals(sorterRule)) {
                sorterItemInfo.setNLSSortType(NLSSortType.SCHINESE_PINYIN);
            }
            newSorterItemCollection.add(sorterItemInfo);
        }
        this.sorterItems = newSorterItemCollection;
    }

    private String deleteLastComma(String origin) {
        if (origin.endsWith(",")) {
            origin = origin.substring(0, origin.length() - 1);
        }
        return origin;
    }

    private String addSorterRule(String sorterRule, String condition) {
        String ret = null;
        ret = "PINYIN".equals(sorterRule) ? condition + " SCHINESE_PINYIN" : condition;
        return ret;
    }

    private String getSorterRule(String sorterRule) {
        String ret = null;
        ret = "PINYIN".equals(sorterRule) ? " SCHINESE_PINYIN " : " ";
        return ret;
    }

    @Override
    public SorterItemCollection getSorterItems() {
        this.setCurrentSorterItems();
        return this.sorterItems;
    }

    @Override
    public void setSorterItems(SorterItemCollection sorterItems) {
        this.sorterItems = sorterItems;
    }

    @Override
    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    @Override
    public String getPanelName() {
        return this.panelName;
    }

    protected void clearTable() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtTable.getRow(i);
            if (this.isLockedSorter(Util.getValue(row.getCell(0).getValue()).toString())) continue;
            row.getCell(1).setValue(null);
            row.getCell(2).setValue(null);
        }
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    @Override
    public boolean verify() {
        String sorterWarning = this.getSorterWarning();
        if (sorterWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)sorterWarning);
            return false;
        }
        return true;
    }

    public KDWorkButton getMoveDownRowButton() {
        return this.moveDownRowButton;
    }

    public KDWorkButton getMoveUpRowButton() {
        return this.moveUpRowButton;
    }

    public KDPanel getSorterButtonPanel() {
        return this.sorterButtonPanel;
    }

    @Override
    public void clear() {
        if (this.defalutSorters != null) {
            this.sorterItems = this.defalutSorters;
            try {
                this.fillSorterTableBody();
            }
            catch (BOSException bOSException) {}
        } else {
            this.clearTable();
        }
    }

    public void setLockedSorterItems(SorterItemCollection collection) {
        this.lockedSorterItems = collection;
    }

    public void setDefalutSorter(SorterItemCollection sorters) {
        this.defalutSorters = sorters == null ? null : (SorterItemCollection)sorters.clone();
    }
}

