/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoCollection;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoInfo;
import com.kingdee.eas.base.commonquery.DyQueryFieldCollection;
import com.kingdee.eas.base.commonquery.DyQueryFieldInfo;
import com.kingdee.eas.base.commonquery.DySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.DynamicSolutionFactory;
import com.kingdee.eas.base.commonquery.DynamicSolutionInfo;
import com.kingdee.eas.base.commonquery.IDySolutionFacade;
import com.kingdee.eas.base.commonquery.IDynamicSolution;
import com.kingdee.eas.base.commonquery.client.AbstractDySolutionAssignUI;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class DySolutionAssignUI
extends AbstractDySolutionAssignUI {
    private static final Logger logger = CoreUIObject.getLogger(DySolutionAssignUI.class);
    private static final String commonRes = "com.kingdee.eas.base.commonquery.client.DynamicQueryResource";
    private HashMap map = new HashMap();

    public DySolutionAssignUI() throws Exception {
        this.init();
    }

    private void init() {
        this.assignButton.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.allSelectButton.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.allClearButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String id = (String)this.getUIContext().get("solutionId");
        if (!StringUtils.isEmpty((String)id)) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            try {
                IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
                DynamicSolutionInfo info = dy.getDynamicSolutionInfo((IObjectPK)pk);
                this.DySolutionBox.setData((Object)info);
                this.DySolutionBox.setQueryInfo("com.kingdee.eas.base.commonquery.app.DynamicSolutionQuery");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    protected void SelectPersonButton_actionPerformed(ActionEvent e) throws Exception {
        super.SelectPersonButton_actionPerformed(e);
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        MetaDataPK pk = this.parseQueryInfo("com.kingdee.eas.base.permission.app.F7AllUserQuery");
        dlg.setQueryInfo(pk);
        EntityViewInfo view = new EntityViewInfo();
        UserListUIHelper helper = new UserListUIHelper();
        view.setFilter(helper.getCurrentRangeUser());
        dlg.setEntityViewInfo(view);
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        this.fillTable(dlg.getData());
    }

    private void fillTable(Object obj) {
        UserInfo info;
        if (obj instanceof Object[]) {
            Object[] ob = (Object[])obj;
            int size = ob.length;
            for (int i = 0; i < size; ++i) {
                UserInfo info2 = (UserInfo)ob[i];
                if (this.isInList(info2)) continue;
                IRow row = this.kDTable1.addRow();
                this.setRowData(row, info2);
                this.map.put(info2.getId().toString(), info2);
            }
        } else if (obj instanceof UserInfo && !this.isInList(info = (UserInfo)obj)) {
            IRow row = this.kDTable1.addRow();
            this.setRowData(row, info);
            this.map.put(info.getId().toString(), info);
        }
    }

    private void setRowData(IRow row, UserInfo info) {
        row.getCell(0).setValue((Object)info.getId());
        row.getCell(1).setValue((Object)new Boolean(true));
        row.getCell(2).setValue((Object)info.getName());
        row.getCell(3).setValue((Object)info.getNumber());
        if (info.getCU().getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)info.getCU().getId().toString()));
            try {
                CtrlUnitInfo ctrlInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)pk);
                row.getCell(4).setValue((Object)ctrlInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isInList(UserInfo info) {
        Set mySet = this.map.keySet();
        boolean flag = false;
        for (String key : mySet) {
            if (!info.getId().toString().equals(key)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    protected MetaDataPK parseQueryInfo(String info) {
        if (StringUtil.isEmptyString((String)info)) {
            return null;
        }
        int pos = info.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String packageName = info.substring(0, pos);
        String className = info.substring(pos + 1);
        return new MetaDataPK(packageName, className);
    }

    private void assignUser() {
        int size = this.kDTable1.getRowCount();
        if (this.DySolutionBox.getData() == null || size == 0) {
            MsgBox.showError((String)EASResource.getString((String)commonRes, (String)"NoSolutionUser"));
            return;
        }
        DynamicSolutionInfo info = (DynamicSolutionInfo)this.DySolutionBox.getData();
        DyAssignUserInfoCollection coll = new DyAssignUserInfoCollection();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (!row.getCell(1).getValue().toString().equals("true")) continue;
            DyAssignUserInfoInfo assignInfo = new DyAssignUserInfoInfo();
            assignInfo.setSolution(info);
            UserInfo userinfo = (UserInfo)this.map.get(row.getCell(0).getValue().toString());
            if (this.checkHasSolution(info, userinfo)) continue;
            assignInfo.setUser(userinfo);
            coll.add(assignInfo);
        }
        if (coll.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)commonRes, (String)"CannotAssign"));
            return;
        }
        try {
            IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
            info.getAssignUser().addCollection(coll);
            dy.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        MsgBox.showInfo((String)EASResource.getString((String)commonRes, (String)"AssignSuccess"));
        this.getUIWindow().close();
    }

    private boolean checkHasSolution(DynamicSolutionInfo info, UserInfo userinfo) {
        DyQueryFieldCollection coll = info.getQueryFields();
        boolean flag = false;
        if (coll != null) {
            int size = coll.size();
            ArrayList<String> soList = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                DyQueryFieldInfo field = coll.get(i);
                soList.add(field.getEntityName());
            }
            if (soList.size() < 1) {
                return flag;
            }
            try {
                IDySolutionFacade dyFacade = DySolutionFacadeFactory.getRemoteInstance();
                DyAssignUserInfoCollection coList = dyFacade.getDysolutionList(userinfo.getId().toString());
                if (coList != null && coList.size() > 0) {
                    for (int j = 0; j < coList.size(); ++j) {
                        DyAssignUserInfoInfo assignInfo = coList.get(j);
                        String sId = assignInfo.getSolution().getId().toString();
                        if (sId.equals(info.getId().toString())) {
                            return true;
                        }
                        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)sId));
                        IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
                        DynamicSolutionInfo dInfo = dy.getDynamicSolutionInfo((IObjectPK)pk);
                        DyQueryFieldCollection dColl = dInfo.getQueryFields();
                        int dSize = dColl.size();
                        for (int k = 0; k < dSize; ++k) {
                            DyQueryFieldInfo field = dColl.get(k);
                            for (int n = 0; n < soList.size(); ++n) {
                                String value = (String)soList.get(n);
                                if (!field.getEntityName().equals(value)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return flag;
    }

    @Override
    protected void allClearButton_actionPerformed(ActionEvent e) throws Exception {
        super.allClearButton_actionPerformed(e);
        int size = this.kDTable1.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTable1.getRow(i);
            Boolean flag = new Boolean(false);
            row.getCell(1).setValue((Object)flag);
        }
    }

    @Override
    protected void allSelectButton_actionPerformed(ActionEvent e) throws Exception {
        super.allSelectButton_actionPerformed(e);
        int size = this.kDTable1.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kDTable1.getRow(i);
            Boolean flag = new Boolean(true);
            row.getCell(1).setValue((Object)flag);
        }
    }

    @Override
    protected void assignButton_actionPerformed(ActionEvent e) throws Exception {
        super.assignButton_actionPerformed(e);
        this.assignUser();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }
}

