/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.AbstractDySubSysF7UI;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class DySubSysF7UI
extends AbstractDySubSysF7UI {
    private static final Logger logger = CoreUIObject.getLogger(DySubSysF7UI.class);
    private ArrayList returnValueList = new ArrayList();
    private boolean isSingleSelect = false;

    public DySubSysF7UI() throws Exception {
        this.init();
    }

    public void onLoad() {
        super.onLoad();
        Map map = this.getUIContext();
        if (map.get("isSingleSelect") != null) {
            this.isSingleSelect = (Boolean)map.get("isSingleSelect");
        }
        this.doTreeNodeChange();
    }

    private void init() {
        this.kDTree1.setShowCheckBox(true);
        this.kDScrollPane1.setBorder(LineBorder.createGrayLineBorder());
        this.kDTree1.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DySubSysF7UI.this.doTreeNodeStateChange(event);
            }
        });
    }

    private void doTreeNodeChange() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
        if (root != null) {
            if (this.isSingleSelect && !this.canTheNodeBeSelected(root)) {
                root.setCheckBoxVisible(false);
                root.setCheckBoxEnabled(false);
            }
            this.tracedisPlayNode(root);
        }
    }

    private void tracedisPlayNode(DefaultKingdeeTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (this.isSingleSelect && !this.canTheNodeBeSelected(tmpNode)) {
                tmpNode.setCheckBoxVisible(false);
            }
            this.tracedisPlayNode(tmpNode);
        }
    }

    private void doTreeNodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean selected = node.isChecked();
        if (node.getChildCount() > 0) {
            node.setChecked(false);
        }
        if (this.isSingleSelect && this.canTheNodeBeSelected(node)) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot();
            if (root != null) {
                this.traceSelectNode(root);
            }
            node.setChecked(true);
        } else if (!this.isSingleSelect) {
            this.selectAllChildrenOfTheSelectedNode(node, selected);
        }
        this.kDTree1.repaint();
    }

    private void traceSelectNode(DefaultKingdeeTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            tmpNode.setChecked(false);
            this.traceSelectNode(tmpNode);
        }
    }

    private void selectAllChildrenOfTheSelectedNode(DefaultKingdeeTreeNode node, boolean selected) {
        DefaultKingdeeTreeNode subNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (this.canTheNodeBeSelected(subNode)) {
                subNode.setChecked(selected);
            }
            this.selectAllChildrenOfTheSelectedNode(subNode, selected);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        if (this.isSingleSelect) {
            return node.isCheckBoxVisible() && node.isCheckBoxEnabled() && node.getChildCount() == 0;
        }
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kDTree1_valueChanged(e);
    }

    protected void kDTree1_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.selectNode()) {
            this.getUIWindow().close();
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectNode()) {
            this.getUIWindow().close();
        }
    }

    private boolean selectNode() throws Exception {
        DefaultKingdeeTreeNode root;
        if (this.kDTree1.getModel() != null && (root = (DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot()) != null) {
            this.traceNode(root);
        }
        if (this.returnValueList != null) {
            this.returnValue = new MetaDataBriefInfo[this.returnValueList.size()];
            for (int i = 0; i < this.returnValueList.size(); ++i) {
                this.returnValue[i] = (MetaDataBriefInfo)this.returnValueList.get(i);
            }
            if (this.returnValue.length > 0) {
                return true;
            }
        }
        return false;
    }

    private void traceNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root.getUserObject() instanceof MetaDataBriefInfo && root.isChecked()) {
            this.returnValueList.add((MetaDataBriefInfo)root.getUserObject());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

