/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.DynQuerySolutionFactory;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.IDynQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.client.AbstractDynQueryListUI;
import com.kingdee.eas.base.commonquery.client.DynQueryAccreditUI;
import com.kingdee.eas.base.commonquery.client.DynQueryEditUI;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynQueryListUI
extends AbstractDynQueryListUI {
    private static final Logger logger = CoreUIObject.getLogger(DynQueryListUI.class);
    private String parentUIName = null;
    private String queryFullName = null;
    private static final String STATUS_COL_INDEX = "status";
    public static final String PARENT_UI_NAME = "parentUIName";
    public static final String QUERY_FULL_NAME = "queryFullName";
    private static final String RESOURCE = "com.kingdee.eas.base.commonquery.client.DynQueryResource";
    private static final String CQ_RESOURCE = "com.kingdee.eas.base.commonquery.cqResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void getParameter() {
        this.parentUIName = (String)this.getUIContext().get(PARENT_UI_NAME);
        this.queryFullName = (String)this.getUIContext().get(QUERY_FULL_NAME);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)PARENT_UI_NAME, (Object)this.parentUIName);
        uiContext.put((Object)QUERY_FULL_NAME, (Object)this.queryFullName);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("baseQuery", (Object)this.queryFullName));
        fInfo.getFilterItems().add(new FilterItemInfo("uiName", (Object)this.parentUIName));
        fInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        fInfo.setMaskString("#0 and #1 and #2 ");
        return fInfo;
    }

    public void onLoad() throws Exception {
        this.getParameter();
        super.onLoad();
        this.initButton();
        this.initButtonStat();
    }

    private void initButton() {
        this.btnAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this.btnVerify.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnSetSysDefault.setIcon(EASResource.getIcon((String)"tbtn_defaultgroupschemesetting"));
        this.btnCancelSysDefault.setIcon(EASResource.getIcon((String)"tbtn_canceldefaultgroupscheme"));
        this.btnSetSysSolution.setIcon(EASResource.getIcon((String)"tbtn_setgroupscheme"));
        this.btnCancelSysSolution.setIcon(EASResource.getIcon((String)"tbtn_canceldefaultgroupscheme"));
        this.btnUAssignSolution.setIcon(EASResource.getIcon((String)"tbtn_delegatescheme"));
    }

    private void initButtonStat() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
        } else {
            boolean isEnable = this.getSelectedStatus(0);
            this.btnCancel.setEnabled(isEnable);
            this.btnCancelCancel.setEnabled(!isEnable);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (e.getClickCount() == 1) {
            int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            boolean hasEnable = false;
            boolean hasCancel = false;
            if (rowID.length > 0 && rowID[0] >= 0) {
                boolean isEnable = this.getSelectedStatus(rowID[0]);
                hasEnable = hasEnable || isEnable;
                hasCancel = hasCancel || !isEnable;
            }
            this.btnCancel.setEnabled(hasEnable);
            this.btnCancelCancel.setEnabled(hasCancel);
        }
    }

    private boolean getSelectedStatus(int rowIndex) {
        BizEnumValueDTO stat = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell(STATUS_COL_INDEX).getValue();
        return DeletedStatusEnum.NORMAL.getValue() == Integer.parseInt(stat.getValue().toString());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        this.checkReference(ids);
        super.actionRemove_actionPerformed(e);
    }

    private void checkReference(List ids) throws Exception {
        String oql = "select id,name,dynQuery.id,dynQuery.name where dynQuery.id in (" + ToolUtils.aryToStr((List)ids) + ")";
        QuerySolutionCollection col = QuerySolutionFactory.getRemoteInstance().getQuerySolutionCollection(oql);
        if (col != null && col.size() > 0) {
            String shortMsg = EASResource.getString((String)CQ_RESOURCE, (String)"DYN_QUERY_REF_SHORT");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)shortMsg, (String)this.getReferencDetail(col), (int)1);
            this.abort();
        }
    }

    private String getReferencDetail(QuerySolutionCollection col) {
        StringBuffer ret = new StringBuffer();
        Map dynQueryMap = this.getDynAndQueryMap(col);
        for (DynQuerySolutionInfo dyn : dynQueryMap.keySet()) {
            List queryList = (List)dynQueryMap.get(dyn);
            StringBuffer queryMsg = new StringBuffer();
            int size = queryList.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo query = (QuerySolutionInfo)queryList.get(i);
                queryMsg.append(query.getName());
                if (i >= size - 1) continue;
                queryMsg.append(",");
            }
            String msg = MessageFormat.format(EASResource.getString((String)CQ_RESOURCE, (String)"DYN_QUERY_REF_DETAIL"), dyn.getName(), queryMsg.toString());
            ret.append(msg);
            ret.append(System.getProperty("line.separator"));
        }
        return ret.toString();
    }

    private Map getDynAndQueryMap(QuerySolutionCollection col) {
        HashMap dynQueryMap = new HashMap();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo qsi = col.get(i);
            DynQuerySolutionInfo dynQuery = qsi.getDynQuery();
            List<QuerySolutionInfo> queryList = new ArrayList<QuerySolutionInfo>();
            if (dynQueryMap.containsKey(dynQuery)) {
                queryList = (List)dynQueryMap.get(dynQuery);
            }
            queryList.add(qsi);
            dynQueryMap.put(dynQuery, queryList);
        }
        return dynQueryMap;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected String getEditUIName() {
        return DynQueryEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DynQuerySolutionFactory.getRemoteInstance();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.cancelCancel();
        this.btnCancelCancel.setEnabled(false);
        this.btnCancel.setEnabled(true);
        this.refresh(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        this.checkReference(ids);
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    protected void cancel() throws Exception {
        super.cancel();
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(false);
    }

    @Override
    public void actionAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAccredit_actionPerformed(e);
        UIContext uictx = new UIContext();
        uictx.put((Object)PARENT_UI_NAME, (Object)this.parentUIName);
        uictx.put((Object)QUERY_FULL_NAME, (Object)this.queryFullName);
        uictx.put((Object)"Owner", (Object)this);
        UITools.showUI((Object)((Object)this), (String)DynQueryAccreditUI.class.getName(), (UIContext)uictx);
    }

    @Override
    public void actionVerify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        DynQuerySolutionInfo info = (DynQuerySolutionInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(key));
        EntityViewInfo entityViewInfo = QueryUtils.getEntityViewInfoByDynQuery(null, info);
        try {
            IQueryExecutor qe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(info.getBaseQuery()));
            qe.setObjectView(entityViewInfo);
            logger.info((Object)("entityviewinfo:" + entityViewInfo));
            qe.executeQuery(0, 1);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"dynQueryVerifyFail"), (String)ex.getMessage(), (int)2);
            return;
        }
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"dynQueryVerifySuccess"));
    }

    @Override
    public void actionSetSysDefault_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetSysDefault_actionPerformed(e);
        String sErrorMsg = this.validateSelectedForSysDefault();
        if (StringUtils.isEmpty((String)sErrorMsg)) {
            ((IDynQuerySolution)this.getBizInterface()).setSysDefault(this.parentUIName, (IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
            this.refresh(e);
        } else {
            MsgBox.showError((String)sErrorMsg);
        }
    }

    @Override
    public void actionCancelSysDefault_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelSysDefault_actionPerformed(e);
        String sErrorMsg = this.validateSelectedForSysDefault();
        if (StringUtils.isEmpty((String)sErrorMsg)) {
            ((IDynQuerySolution)this.getBizInterface()).cancelSysDefault(this.parentUIName, (IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
            this.refresh(e);
        } else {
            MsgBox.showError((String)sErrorMsg);
        }
    }

    @Override
    public void actionSetSysSolution_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetSysSolution_actionPerformed(e);
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        DynQuerySolutionInfo info = (DynQuerySolutionInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(key));
        info.setIsSysSolution(true);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isSysSolution"));
        ((IDynQuerySolution)this.getBizInterface()).updatePartial(info, selector);
        this.refresh(e);
    }

    @Override
    public void actionCancelSysSolution_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelSysSolution_actionPerformed(e);
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        DynQuerySolutionInfo info = (DynQuerySolutionInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(key));
        info.setIsSysSolution(false);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isSysSolution"));
        ((IDynQuerySolution)this.getBizInterface()).updatePartial(info, selector);
        this.refresh(e);
    }

    @Override
    public void actionAssignRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssignRule_actionPerformed(e);
        this.checkSelected();
        int isAssign = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"ASSIGN_SOLURION"));
        if (isAssign == 0) {
            UserPromptBox pmt = new UserPromptBox((IUIObject)this);
            pmt.setEntityViewInfo(this.getUserFilter());
            pmt.show();
            Object[] users = (Object[])pmt.getData();
            if (!pmt.isCanceled()) {
                this.checkEmpty(users);
                String key = this.getSelectedKeyValue();
                DynQuerySolutionInfo info = (DynQuerySolutionInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(key));
                IDynQuerySolution iDynQuerySolution = DynQuerySolutionFactory.getRemoteInstance();
                DynQuerySolutionInfo info1 = info;
                IObjectPK onePK = this.getObjectPK("ID", info.getId().toString());
                iDynQuerySolution.delete(onePK);
                info1.setCreator((UserInfo)users[users.length - 1]);
                iDynQuerySolution.addnew(info1);
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ASSIGNRULE"));
                this.refresh(e);
            }
        } else {
            return;
        }
    }

    private IObjectPK getObjectPK(String keyField, String keyValue) {
        ObjectMultiPK onePK = new ObjectMultiPK();
        onePK.setKeyValue(keyField, (Object)keyValue);
        return onePK;
    }

    private EntityViewInfo getUserFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.NOTEQUALS));
        evi.setFilter(filter);
        return evi;
    }

    private void checkEmpty(Object[] users) {
        if (users == null || users.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"USER_NOT_SELECTED"));
            SysUtil.abort();
        }
    }

    private List getUserList(Object[] users) {
        ArrayList<UserInfo> userIdList = new ArrayList<UserInfo>();
        for (int i = users.length - 1; i >= 0; --i) {
            userIdList.add((UserInfo)users[i]);
        }
        return userIdList;
    }

    private String validateSelectedForSysDefault() {
        int iTop;
        int size = this.tblMain.getSelectManager().size();
        if (size < 1) {
            return EASResource.getString((String)RESOURCE, (String)"noSelected");
        }
        if (size > 1) {
            return EASResource.getString((String)RESOURCE, (String)"shouldSelectedOnlyOne");
        }
        int iBotton = this.tblMain.getSelectManager().get(0).getBottom();
        if (iBotton != (iTop = this.tblMain.getSelectManager().get(0).getTop())) {
            return EASResource.getString((String)RESOURCE, (String)"shouldSelectedOnlyOne");
        }
        return "";
    }
}

