/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.TreeWillExpandAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DyQueryFieldCollection;
import com.kingdee.eas.base.commonquery.DyQueryFieldInfo;
import com.kingdee.eas.base.commonquery.DynamicSolutionFactory;
import com.kingdee.eas.base.commonquery.DynamicSolutionInfo;
import com.kingdee.eas.base.commonquery.IDynamicSolution;
import com.kingdee.eas.base.commonquery.client.AbstractDySubSysF7UI;
import com.kingdee.eas.base.commonquery.client.AbstractDynamiQueryConfigUI;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.DySubSysF7UI;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DynamiQueryConfigUI
extends AbstractDynamiQueryConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(DynamiQueryConfigUI.class);
    private static final String SubSystemName = "com_kingdee_eas_base_subsystemEntity";
    private MetaDataBriefInfo[] infos;
    private ArrayList list = new ArrayList();
    private MetaDataBriefInfo currentEntity;
    private EntityObjectInfo entity;
    private String mainEntity;
    private DefaultKingdeeTreeNode result = null;
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private static final String commonRes = "com.kingdee.eas.base.commonquery.client.DynamicQueryResource";

    public DynamiQueryConfigUI() throws Exception {
        this.jbinit();
    }

    private void jbinit() {
        this.fieldList.setAutoscrolls(true);
        this.allUPButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.allRightButton.setVisible(false);
        this.allDownButton.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.upButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.downButton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnGroupAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.setButtonDefaultStyl(this.saveButton);
        this.saveButton.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.entityTree.setScrollsOnExpand(true);
        ((DefaultTreeModel)this.entityALLTree.getModel()).setRoot(null);
        ((DefaultTreeModel)this.entityTree.getModel()).setRoot(null);
        this.entityALLTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    DynamiQueryConfigUI.this.entityALLTree_valueChanged(e);
                }
                catch (Exception exc) {
                    DynamiQueryConfigUI.this.handUIException(exc);
                }
            }
        });
        this.entityALLTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    DynamiQueryConfigUI.this.entityALLTree_mouseClicked(e);
                }
                catch (Exception exc) {
                    DynamiQueryConfigUI.this.handUIException(exc);
                }
            }
        });
    }

    public void loadData() throws Exception {
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.selectMainEntityUI();
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.fieldList.setEnabled(true);
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            this.fieldList.setEnabled(false);
            this.nameTextField.setEnabled(false);
            this.numberTextField.setEnabled(false);
            this.btnGroupAddNew.setEnabled(false);
            this.toLeftButton.setEnabled(false);
            this.allLeftButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.toRightButton.setEnabled(false);
            this.allRightButton.setEnabled(false);
            this.btnGroupRemove.setEnabled(false);
        }
        String id = (String)this.getUIContext().get("ID");
        if (StringUtils.isEmpty((String)id)) {
            this.kDTextField3.setText(SysContext.getSysContext().getCurrentOrgUnit().getName());
            this.kDTextField3.setUserObject((Object)SysContext.getSysContext().getCurrentOrgUnit());
            this.creatorTextField.setText(SysContext.getSysContext().getCurrentUserInfo().getNumber());
            this.creatorTextField.setUserObject((Object)SysContext.getSysContext().getCurrentUserInfo());
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            try {
                IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
                DynamicSolutionInfo info = dy.getDynamicSolutionInfo((IObjectPK)pk);
                if (info.getOrgunit() != null) {
                    ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)info.getOrgunit().getId().toString()));
                    FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)orgPk);
                    this.kDTextField3.setText(orgInfo.getName());
                    this.kDTextField3.setUserObject((Object)orgInfo);
                }
                if (info.getCreator() != null) {
                    ObjectUuidPK creatorPk = new ObjectUuidPK(BOSUuid.read((String)info.getCreator().getId().toString()));
                    UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)creatorPk);
                    this.creatorTextField.setText(userInfo.getNumber());
                    this.creatorTextField.setUserObject((Object)userInfo);
                }
                this.nameTextField.setText(info.getName());
                this.numberTextField.setText(info.getNumber());
                this.mainEntity = info.getMainEntity();
                DyQueryFieldCollection coll = info.getQueryFields();
                HashMap<String, MetaDataBriefInfo> map = new HashMap<String, MetaDataBriefInfo>();
                if (coll != null) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        DyQueryFieldInfo dInfo = coll.get(i);
                        MetaDataBriefInfo obm = this.getMetaDataBriefInfoByFullName(dInfo.getExtendValue());
                        if (obm != null && map.get(obm.getFullName()) == null) {
                            map.put(obm.getFullName(), obm);
                        }
                        this.fieldList.addElement((Object)dInfo);
                    }
                    for (String fullName : map.keySet()) {
                        this.list.add(map.get(fullName));
                    }
                    this.construtSubTree();
                    this.entity = Util.getEntity((IMetaDataPK)MetaDataPK.create((String)info.getMainEntity()));
                    this.createEntityTree();
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadData();
        this.kDTextField3.setEnabled(false);
        this.creatorTextField.setEnabled(false);
        this.entityTreeView.getControlPane().add((Component)this.btnGroupAddNew);
        this.entityTreeView.getControlPane().add((Component)this.btnGroupRemove);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void selectMainEntityUI() throws Exception {
        MetaDataBriefInfo[] infoTemp;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isMultiSelect", (Object)new Boolean(false));
        uiContext.put((Object)"isMustSelectLeaf", (Object)new Boolean(false));
        uiContext.put((Object)"types", (Object)new BOSObjectType[]{MetaDataTypeList.ENTITY});
        uiContext.put((Object)"isRemoveEmptyPackage", (Object)new Boolean(true));
        uiContext.put((Object)"mdbViewName", (Object)SubSystemName);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"isSingleSelect", (Object)new Boolean(true));
        uiContext.put((Object)"Title", (Object)EASResource.getString((String)commonRes, (String)"SelectEntityTitle"));
        uiContext.put((Object)"Owner", (Object)this.getUIWindow());
        IUIWindow window = uiFactory.create(DySubSysF7UI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        if (((DySubSysF7UI)window.getUIObject()).getReturnValues() != null && (infoTemp = ((DySubSysF7UI)window.getUIObject()).getReturnValues()) != null && infoTemp.length == 1) {
            this.mainEntity = infoTemp[0].getFullName();
            this.addToEntityTree(infoTemp);
            this.arrayToList();
            if (this.list != null && this.list.size() >= 1) {
                this.construtSubTree();
            }
        }
    }

    public void onShow() throws Exception {
        if (this.mainEntity == null) {
            SysUtil.abort();
        } else {
            super.onShow();
        }
    }

    private void showSubSystemUI() throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isMultiSelect", (Object)new Boolean(false));
        uiContext.put((Object)"isMustSelectLeaf", (Object)new Boolean(false));
        uiContext.put((Object)"types", (Object)new BOSObjectType[]{MetaDataTypeList.ENTITY});
        uiContext.put((Object)"isRemoveEmptyPackage", (Object)new Boolean(true));
        uiContext.put((Object)"mdbViewName", (Object)SubSystemName);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"Title", (Object)new ResourceBundleHelper(AbstractDySubSysF7UI.class.getName()).getString("this.title"));
        uiContext.put((Object)"Owner", (Object)this.getUIWindow());
        IUIWindow window = uiFactory.create(DySubSysF7UI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        if (((DySubSysF7UI)window.getUIObject()).getReturnValues() != null) {
            MetaDataBriefInfo[] infoTemp = ((DySubSysF7UI)window.getUIObject()).getReturnValues();
            this.addToEntityTree(infoTemp);
            this.arrayToList();
            if (this.list != null && this.list.size() >= 1) {
                this.construtSubTree();
            }
        }
    }

    public MetaDataBriefInfo getMetaDataBriefInfoByFullName(String fullName) {
        MetaDataBriefInfo info = null;
        IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)SubSystemName, (BOSObjectType[])new BOSObjectType[]{MetaDataTypeList.ENTITY});
        DefaultKingdeeTreeNode node = SubSystemUtils.getKDTreeNodeAfterHandle((IBriefViewTreeNode)root);
        MetaDataBriefInfo mdbi = null;
        DefaultKingdeeTreeNode aNode = null;
        Enumeration enu = node.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            aNode = (DefaultKingdeeTreeNode)enu.nextElement();
            mdbi = (MetaDataBriefInfo)aNode.getUserObject();
            if (!mdbi.getFullName().equals(fullName)) continue;
            info = mdbi;
            break;
        }
        return info;
    }

    private void arrayToList() {
        if (this.infos != null && this.infos.length >= 1) {
            int length = this.infos.length;
            this.list.clear();
            for (int i = 0; i < length; ++i) {
                this.list.add(this.infos[i]);
            }
        }
    }

    private void addToEntityTree(MetaDataBriefInfo[] infoTemp) {
        if (this.infos == null) {
            this.infos = infoTemp;
            return;
        }
        if (infoTemp != null) {
            int size = infoTemp.length;
            ArrayList<MetaDataBriefInfo> myList = new ArrayList<MetaDataBriefInfo>();
            for (int i = 0; i < size; ++i) {
                boolean flag = false;
                for (int j = 0; j < this.infos.length; ++j) {
                    if (!infoTemp[i].toString().equals(this.infos[j].toString())) continue;
                    flag = true;
                    break;
                }
                if (flag || !Util.isReverseLink(this.mainEntity, infoTemp[i].getFullName())) continue;
                myList.add(infoTemp[i]);
            }
            int sum = myList.size();
            int length = this.infos.length;
            MetaDataBriefInfo[] metaInfo = new MetaDataBriefInfo[sum + length];
            for (int k = 0; k < length; ++k) {
                metaInfo[k] = this.infos[k];
            }
            for (int n = length; n < sum + length; ++n) {
                metaInfo[n] = (MetaDataBriefInfo)myList.get(n - length);
            }
            this.infos = metaInfo;
        }
    }

    private void construtSubTree() {
        DefaultKingdeeTreeNode tree = new DefaultKingdeeTreeNode();
        tree.setText(EASResource.getString((String)commonRes, (String)"Entity"));
        this.buildchild(tree);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)tree);
        this.entityALLTree.setModel((TreeModel)model);
    }

    private void buildchild(DefaultKingdeeTreeNode tree) {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            MetaDataBriefInfo tInfo = (MetaDataBriefInfo)this.list.get(i);
            if (this.isHasParent(tInfo)) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)tInfo);
            this.setDisplayText(tInfo, node);
            tree.add((MutableTreeNode)node);
            ArrayList list = this.getAllChild(tInfo);
            this.buildSubChild(node, list);
        }
    }

    private void buildSubChild(DefaultKingdeeTreeNode node, ArrayList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            MetaDataBriefInfo tInfo = (MetaDataBriefInfo)list.get(i);
            DefaultKingdeeTreeNode subNode = new DefaultKingdeeTreeNode((Object)tInfo);
            node.add((MutableTreeNode)subNode);
            this.setDisplayText(tInfo, subNode);
            ArrayList subList = this.getAllChild(tInfo);
            this.buildSubChild(subNode, subList);
        }
    }

    private void setDisplayText(MetaDataBriefInfo tInfo, DefaultKingdeeTreeNode subNode) {
        if (!StringUtils.isEmpty((String)tInfo.getAlias())) {
            subNode.setText(tInfo.getAlias());
        } else {
            subNode.setText(tInfo.getName());
        }
    }

    private boolean isHasParent(MetaDataBriefInfo Info) {
        int length = this.list.size();
        boolean flag = false;
        for (int i = 0; i < length; ++i) {
            MetaDataBriefInfo tInfo = (MetaDataBriefInfo)this.list.get(i);
            if (!Info.getParent().equals(tInfo.getFullName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private ArrayList getAllChild(MetaDataBriefInfo info) {
        ArrayList<MetaDataBriefInfo> myList = new ArrayList<MetaDataBriefInfo>();
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            MetaDataBriefInfo tInfo = (MetaDataBriefInfo)this.list.get(i);
            if (!tInfo.getParent().equals(info.getFullName())) continue;
            myList.add(tInfo);
        }
        return myList;
    }

    private void createEntityTree() {
        DefaultKingdeeTreeNode root = this.createRoot();
        this.entityTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        ((DefaultTreeModel)this.entityTree.getModel()).setAsksAllowsChildren(true);
        this.entityTree.addTreeWillExpandListener((TreeWillExpandListener)new TreeWillExpandAdapter(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DynamiQueryConfigUI.this.entityTree_treeWillExpand(event);
            }
        });
        this.entityTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DynamiQueryConfigUI.this.entityTree_mouseClicked(e);
            }
        });
        this.entityTree.repaint();
    }

    private DefaultKingdeeTreeNode createRoot() {
        EntityObjectInfo entity = Util.getEntity((IMetaDataPK)new MetaDataPK(this.entity.getFullName()));
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(Util.getEntityAlias(this.entity));
        DataObject dataObject = new DataObject();
        dataObject.setExtendValue(entity.getFullName());
        dataObject.setName("");
        dataObject.setValue("");
        root.setUserObject((Object)dataObject);
        this.createChildNode(root);
        return root;
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode) {
        DataObject dataObject = (DataObject)parentNode.getUserObject();
        EntityObjectInfo entity = Util.getEntity((IMetaDataPK)MetaDataPK.create((String)dataObject.getExtendValue()));
        ArrayList al = Util.getWithOutProperties(dataObject.getExtendValue());
        PropertyCollection properties = Util.getAllEntityProperties(entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            DataObject childDataObject = new DataObject();
            childDataObject.setName(this.getName(dataObject, Util.getPropertyAlias(propertyInfo)));
            childDataObject.setValue(this.getValue(dataObject, propertyInfo.getName()));
            childDataObject.setExtendValue(this.getExtendValue(dataObject, propertyInfo));
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childDataObject);
            childNode.setText(Util.getPropertyAlias(propertyInfo));
            if (!(propertyInfo instanceof LinkPropertyInfo)) {
                childNode.setAllowsChildren(false);
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.BYTEARRAY)) continue;
            }
            if (al.contains(propertyInfo.getName())) continue;
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private String getValue(DataObject parent, String propertyName) {
        String value = "";
        String parentValue = parent.getValue();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private String getName(DataObject parent, String propertyAlias) {
        String name = "";
        String parentName = parent.getName();
        name = parentName.length() == 0 ? propertyAlias : parentName + "." + propertyAlias;
        return name;
    }

    private String getExtendValue(DataObject parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = Util.getEntity(parentExtendValue, linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? parentExtendValue : refEntityName;
        return extendValue;
    }

    private void entityTree_treeWillExpand(TreeExpansionEvent e) {
        this.result = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (this.result.getChildCount() == 0) {
            this.createChildNode(this.result);
            ((DefaultTreeModel)this.entityTree.getModel()).reload((TreeNode)this.result);
        }
    }

    private void entityTree_mouseClicked(MouseEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.entityTree.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.result == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
            } else if (!(this.result instanceof DefaultKingdeeTreeNode) || !this.result.getAllowsChildren()) {
                // empty if block
            }
        }
    }

    protected void entityALLTree_valueChanged(TreeSelectionEvent e) throws Exception {
    }

    protected void entityALLTree_mouseClicked(MouseEvent e) throws Exception {
        TreePath[] paths = this.entityALLTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
            if (treeNode.isLeaf()) {
                this.currentEntity = (MetaDataBriefInfo)treeNode.getUserObject();
                if (this.currentEntity == null) continue;
                IMetaDataPK srcEntityPk = this.currentEntity.getMetaDataPK();
                this.entity = Util.getEntity(srcEntityPk);
                this.createEntityTree();
                continue;
            }
            this.entityTree.setModel(null);
        }
    }

    @Override
    protected void toLeftButton_actionPerformed(ActionEvent e) throws Exception {
        super.toLeftButton_actionPerformed(e);
        if (this.fieldList.getSelectedIndex() != -1) {
            this.fieldList.removeElement(this.fieldList.getSelectedValue());
        }
    }

    @Override
    protected void allDownButton_actionPerformed(ActionEvent e) throws Exception {
        super.allDownButton_actionPerformed(e);
        if (this.fieldList.getSelectedIndex() != -1) {
            DyQueryFieldInfo ob = (DyQueryFieldInfo)this.fieldList.getSelectedValue();
            this.fieldList.removeElement(this.fieldList.getSelectedValue());
            this.fieldList.insertElement((Object)ob, this.fieldList.getElementCount());
            this.fieldList.setSelectedValue((Object)ob, true);
        }
    }

    @Override
    protected void allLeftButton_actionPerformed(ActionEvent e) throws Exception {
        super.allLeftButton_actionPerformed(e);
        this.fieldList.removeAllElements();
    }

    @Override
    protected void allRightButton_actionPerformed(ActionEvent e) throws Exception {
        super.allRightButton_actionPerformed(e);
    }

    @Override
    protected void allUPButton_actionPerformed(ActionEvent e) throws Exception {
        super.allUPButton_actionPerformed(e);
        if (this.fieldList.getSelectedIndex() != -1) {
            DyQueryFieldInfo ob = (DyQueryFieldInfo)this.fieldList.getSelectedValue();
            this.fieldList.removeElement(this.fieldList.getSelectedValue());
            this.fieldList.insertElement((Object)ob, 0);
            this.fieldList.setSelectedIndex(0);
        }
    }

    @Override
    protected void downButton_actionPerformed(ActionEvent e) throws Exception {
        super.downButton_actionPerformed(e);
        if (this.fieldList.getSelectedIndex() != -1) {
            DyQueryFieldInfo ob = (DyQueryFieldInfo)this.fieldList.getSelectedValue();
            int index = this.fieldList.getSelectedIndex();
            if (index < this.fieldList.getElementCount() - 1) {
                this.fieldList.removeElement(this.fieldList.getSelectedValue());
                this.fieldList.insertElement((Object)ob, index + 1);
                this.fieldList.setSelectedValue((Object)ob, true);
            }
        }
    }

    @Override
    protected void upButton_actionPerformed(ActionEvent e) throws Exception {
        super.upButton_actionPerformed(e);
        if (this.fieldList.getSelectedIndex() != -1) {
            DyQueryFieldInfo ob = (DyQueryFieldInfo)this.fieldList.getSelectedValue();
            int index = this.fieldList.getSelectedIndex();
            if (index > 0) {
                this.fieldList.removeElement(this.fieldList.getSelectedValue());
                this.fieldList.insertElement((Object)ob, index - 1);
                this.fieldList.setSelectedValue((Object)ob, true);
            }
        }
    }

    @Override
    protected void toRightButton_actionPerformed(ActionEvent e) throws Exception {
        super.toRightButton_actionPerformed(e);
        TreePath[] paths = this.entityTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)paths[0].getLastPathComponent();
        if (!treeNode.getAllowsChildren()) {
            DataObject temp = (DataObject)treeNode.getUserObject();
            DyQueryFieldInfo ob = new DyQueryFieldInfo();
            ob.setExtendValue(temp.getExtendValue());
            ob.setName(this.currentEntity.getAlias() + "." + temp.getName());
            ob.setValue(temp.getValue());
            ob.setEntityName(this.currentEntity.getFullName());
            if (this.currentEntity.getFullName().equalsIgnoreCase(this.mainEntity)) {
                ob.setIsReverseLink(false);
            } else {
                ob.setIsReverseLink(true);
            }
            if (!this.isInList(ob)) {
                this.fieldList.addElement((Object)ob);
            }
        }
    }

    private boolean isInList(DyQueryFieldInfo ob) {
        boolean flag = false;
        for (int i = 0; i < this.fieldList.getElementCount(); ++i) {
            if (!ob.toString().equals(this.fieldList.getElement(i).toString())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isEntityInList(MetaDataBriefInfo ob) {
        boolean flag = false;
        for (int i = 0; i < this.fieldList.getElementCount(); ++i) {
            if (!ob.getFullName().equals(((DyQueryFieldInfo)this.fieldList.getElement(i)).getExtendValue())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void removeFromFieldList(MetaDataBriefInfo ob) {
        ArrayList<Object> myList = new ArrayList<Object>();
        for (int i = 0; i < this.fieldList.getElementCount(); ++i) {
            if (!ob.getFullName().equals(((DyQueryFieldInfo)this.fieldList.getElement(i)).getExtendValue())) continue;
            myList.add(this.fieldList.getElement(i));
        }
        int sum = myList.size();
        for (int j = 0; j < sum; ++j) {
            this.fieldList.removeElement(myList.get(j));
        }
    }

    private boolean saveData() throws Exception {
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            if (this.fieldList.getElementCount() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)commonRes, (String)"NoEntityField"));
                return false;
            }
            IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
            DynamicSolutionInfo info = new DynamicSolutionInfo();
            info.setName(this.nameTextField.getText());
            info.setNumber(this.numberTextField.getText());
            info.setOrgunit((FullOrgUnitInfo)this.kDTextField3.getUserObject());
            info.setCreator((UserInfo)this.creatorTextField.getUserObject());
            info.setMainEntity(this.mainEntity);
            EntityObjectInfo mainEntityInfo = Util.getEntity((IMetaDataPK)MetaDataPK.create((String)this.mainEntity));
            info.setMainEntityName(mainEntityInfo.getDescription());
            DyQueryFieldCollection coll = new DyQueryFieldCollection();
            for (int i = 0; i < this.fieldList.getElementCount(); ++i) {
                DyQueryFieldInfo ob = (DyQueryFieldInfo)this.fieldList.getElement(i);
                coll.add(ob);
            }
            info.getQueryFields().addCollection(coll);
            dy.addnew(info);
            return true;
        }
        String id = (String)this.getUIContext().get("ID");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        try {
            IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
            DynamicSolutionInfo info = dy.getDynamicSolutionInfo((IObjectPK)pk);
            info.setName(this.nameTextField.getText());
            info.setNumber(this.numberTextField.getText());
            info.setOrgunit((FullOrgUnitInfo)this.kDTextField3.getUserObject());
            info.setCreator((UserInfo)this.creatorTextField.getUserObject());
            info.setMainEntity(this.mainEntity);
            EntityObjectInfo mainEntityInfo = Util.getEntity((IMetaDataPK)MetaDataPK.create((String)this.mainEntity));
            info.setMainEntityName(mainEntityInfo.getDescription());
            DyQueryFieldCollection coll = new DyQueryFieldCollection();
            for (int i = 0; i < this.fieldList.getElementCount(); ++i) {
                DyQueryFieldInfo ob = (DyQueryFieldInfo)this.fieldList.getElement(i);
                coll.add(ob);
            }
            info.getQueryFields().addCollection(coll);
            dy.update((IObjectPK)pk, info);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.showSubSystemUI();
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupRemove_actionPerformed(e);
        TreePath[] paths = this.entityALLTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)paths[0].getLastPathComponent();
        MetaDataBriefInfo ob = (MetaDataBriefInfo)treeNode.getUserObject();
        if (ob == null) {
            return;
        }
        if (!this.isEntityInList(ob)) {
            this.list.remove(ob);
            this.construtSubTree();
            this.entityTree.setModel(null);
        } else if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)commonRes, (String)"ConfirmDeleteEntity")) == 0) {
            this.list.remove(ob);
            this.removeFromFieldList(ob);
            this.construtSubTree();
            this.entityTree.setModel(null);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    protected void saveButton_actionPerformed(ActionEvent e) throws Exception {
        super.saveButton_actionPerformed(e);
        if (this.saveData()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            this.getUIWindow().close();
        }
    }
}

