/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryUI;
import com.kingdee.eas.base.commonquery.client.CommonTablePanel;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.IQueryInfoPanel;
import com.kingdee.eas.base.commonquery.client.ISorterPanel;
import com.kingdee.eas.base.commonquery.client.SolutionPromptUI;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.bireport.BireportBaseFacadeFactory;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.config.IUserCustomConfig;
import com.kingdee.eas.framework.config.UserCustomConfigCollection;
import com.kingdee.eas.framework.config.UserCustomConfigFactory;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryToolBar
extends KDPanel {
    private static Logger logger = Logger.getLogger(QueryToolBar.class);
    private KDComboBox shareTypeComboBox;
    private KDWorkButton newButton;
    private KDWorkButton saveButton;
    private KDWorkButton saveAsButton;
    private KDWorkButton delButton;
    private KDWorkButton reNameButton;
    private BOSUuid owner;
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.client.CommonQueryPanel";
    private String currentSolutionName;
    private ShareTypeEnum currentShareType;
    private QuerySolutionInfo currentQuerySolutionInfo;
    private QuerySolutionInfo querySolutionTemp;
    private UserCustomConfigInfo userCustomConfig;
    private int showShareType;
    private static final String toolBarRes = "com.kingdee.eas.base.commonquery.client.ToolBar";
    private boolean isInitCombox = true;
    public static final String QUERY_USERCUSTOMCONFIG = "select UserID,UiClassName,ConfigXML where UiClassName=''{0}'' and user.id=''{1}''";

    public boolean isInitCombox() {
        return this.isInitCombox;
    }

    public void setIsInitCombox(boolean isInit) {
        this.isInitCombox = isInit;
    }

    protected void disEditButton() {
        this.saveButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.reNameButton.setEnabled(false);
    }

    protected void enEditButton() {
        this.saveButton.setEnabled(true);
        this.delButton.setEnabled(true);
        this.reNameButton.setEnabled(true);
    }

    protected void setSaveButtonStatus(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    protected void setSaveAsButtonStatus(boolean enable) {
        this.saveAsButton.setEnabled(enable);
    }

    protected void setRenameButtonStatus(boolean enable) {
        this.reNameButton.setEnabled(enable);
    }

    protected void setDelButtonStatus(boolean enable) {
        this.delButton.setEnabled(enable);
    }

    public QueryToolBar() {
        this.initUI();
        this.initOther();
    }

    public QueryToolBar(int showShareType) {
        this.showShareType = showShareType;
        this.initUI();
        this.initOther();
    }

    private void initUI() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(180, 20));
        this.shareTypeComboBox = Util.createShareTypeComboBox(this.showShareType, true);
        this.newButton = new KDWorkButton();
        this.newButton.setSize(22, 19);
        this.saveButton = new KDWorkButton();
        this.saveButton.setSize(22, 19);
        this.saveAsButton = new KDWorkButton();
        this.saveAsButton.setSize(22, 19);
        this.delButton = new KDWorkButton();
        this.delButton.setSize(22, 19);
        this.reNameButton = new KDWorkButton();
        this.reNameButton.setSize(22, 19);
        this.shareTypeComboBox.setSize(90, 19);
        this.newButton.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.newButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"new"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.newButton_actionPerformed(e);
            }
        });
        this.saveButton.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.saveButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"save"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.saveButton_actionPerformed(e);
            }
        });
        this.saveAsButton.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.saveAsButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"saveAs"));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.saveAsButton_actionPerformed(e);
            }
        });
        this.delButton.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"del"));
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.delButton_actionPerformed(e);
            }
        });
        this.reNameButton.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.reNameButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"modifyName"));
        this.reNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.reNameButton_actionPerformed(e);
            }
        });
        this.add((Component)this.newButton);
        this.newButton.setBounds(0, 0, 21, 19);
        this.add((Component)this.saveButton);
        this.saveButton.setBounds(22, 0, 21, 19);
        this.add((Component)this.saveAsButton);
        this.saveAsButton.setBounds(44, 0, 21, 19);
        this.add((Component)this.delButton);
        this.delButton.setBounds(66, 0, 21, 19);
        this.add((Component)this.reNameButton);
        this.reNameButton.setBounds(88, 0, 21, 19);
        this.add((Component)this.shareTypeComboBox);
        this.shareTypeComboBox.setBounds(110, 0, 83, 19);
        this.shareTypeComboBox.setVisible(true);
    }

    private void initOther() {
        this.currentShareType = ShareTypeEnum.USER_LEVEL;
        this.currentSolutionName = null;
    }

    public int getShowShareType() {
        return this.showShareType;
    }

    public void setShowShareType(int showShareType) {
        this.showShareType = showShareType;
    }

    private void newButton_actionPerformed(ActionEvent e) {
        ActionCache.clear();
        this.resetToolBar();
        this.resetUserPanels();
        this.resetFilterPanel();
        this.resetSorterPanel();
        QuerySolutionInfo defaultSln = this.getDefaultSolution(this.currentShareType);
        this.getCommonQueryPanel().getSolutionListPanel().setSelected(defaultSln);
        this.setCurrentSolution(defaultSln);
    }

    protected void newDefaultSolution() {
        this.resetToolBar();
        this.resetUserPanels();
        this.resetFilterPanel();
        this.resetSorterPanel();
        this.setCurrentSolution(null);
    }

    private void resetToolBar() {
    }

    private void resetUserPanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Collection panels = commonQueryPanel.getPanels().values();
        for (KDPanel tempPanel : panels) {
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    private void resetFilterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowFilter() && commonQueryPanel.getCommonFilterPanel() != null) {
            commonQueryPanel.getCommonFilterPanel().clear();
        }
    }

    private void resetSorterPanel() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.isShowSorter() && commonQueryPanel.getCommonSorterPanel() != null) {
            commonQueryPanel.getCommonSorterPanel().clear();
        }
    }

    private String getSameNameSolutionID() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String queryName = commonQueryPanel.getQueryInfo().getFullName();
        String parentUI = commonQueryPanel.getParentUIClassName();
        String orgID = this.getOrgID(queryName);
        ShareTypeEnum shareType = this.currentShareType;
        String saveAsName = this.currentSolutionName;
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            return iQuerySolution.getSameNameSolutionID(orgID, queryName, parentUI, shareType, saveAsName);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private String getSolutionID() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String queryName = commonQueryPanel.getQueryInfo().getFullName();
        String parentUI = commonQueryPanel.getParentUIClassName();
        String orgID = this.getOrgID(queryName);
        ShareTypeEnum shareType = this.currentShareType;
        String saveAsName = this.currentQuerySolutionInfo.getName();
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            return iQuerySolution.getSameNameSolutionID(orgID, queryName, parentUI, shareType, saveAsName);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private String getOrgID(String queryName) {
        try {
            BOSUuid id = Util.getOrgID(queryName);
            if (id != null) {
                return id.toString();
            }
        }
        catch (BOSException e1) {
            logger.info((Object)"error!", (Throwable)e1);
        }
        return null;
    }

    private QuerySolutionInfo getSameNameSolution() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String queryName = commonQueryPanel.getQueryInfo().getFullName();
        String parentUI = commonQueryPanel.getParentUIClassName();
        String orgID = this.getOrgID(queryName);
        if (orgID == null) {
            logger.info((Object)("orgid is null," + queryName + " has no org type;"));
        }
        ShareTypeEnum shareType = this.currentShareType;
        String saveAsName = this.currentSolutionName;
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            return iQuerySolution.getOwnerSolutionByName(orgID, queryName, parentUI, shareType, saveAsName);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveButton_actionPerformed(ActionEvent e) {
        ActionCache.clear();
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (!commonQueryPanel.verify() || this.currentQuerySolutionInfo == null) return;
        if (!this.currentShareType.equals((Object)this.currentQuerySolutionInfo.getShareType())) {
            if (!this.showSolutionDialog()) return;
            String sameNameSolutionID = this.getSameNameSolutionID();
            if (sameNameSolutionID != null) {
                int flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"solutionNameExist"));
                if (flag != 0) return;
                if (!this.editSolution(sameNameSolutionID)) return;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"overwriteSolutionSucceed"));
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolutionInfo);
                return;
            }
            if (!this.addSolution()) return;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"));
            commonQueryPanel.getSolutionListPanel().refreshSolutionList();
            commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolutionInfo);
            return;
        }
        if (!this.editSolution(this.currentQuerySolutionInfo.getId().toString())) return;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"));
        commonQueryPanel.getSolutionListPanel().refreshSolutionList();
        commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolutionInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveAsButton_actionPerformed(ActionEvent e) {
        ActionCache.clear();
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (!commonQueryPanel.verify() || !this.showSolutionDialog()) return;
        String sameNameSolutionID = null;
        String sameNameSolutionName = null;
        QuerySolutionInfo asdf = this.getSameNameSolution();
        if (asdf != null) {
            sameNameSolutionID = this.getSameNameSolution().getId().toString();
            sameNameSolutionName = this.getSameNameSolution().getName(SysContext.getSysContext().getLocale());
        }
        if (sameNameSolutionID != null && sameNameSolutionName != null) {
            int flag;
            if (EASResource.getString((String)commonQueryRes, (String)"sysDefaultRule").equals(sameNameSolutionName)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)commonQueryRes, (String)"CanNotOverDefaultSolution"));
                SysUtil.abort();
            }
            if ((flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"solutionNameExist"))) != 0) return;
            if (!this.editSolution(sameNameSolutionID)) return;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"overwriteSolutionSucceed"));
            commonQueryPanel.getSolutionListPanel().refreshSolutionList();
            commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolutionInfo);
            return;
        }
        if (this.addSolution()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveAsSolutionSucceed"));
            commonQueryPanel.getSolutionListPanel().refreshSolutionList();
            commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolutionInfo);
            this.getCommonQueryPanel().setDefaultViewSelected(false);
            if (this.userCustomConfig == null) return;
            this.insertCoreUI(this.userCustomConfig);
            return;
        }
        commonQueryPanel.getSolutionListPanel().refreshSolutionList();
    }

    private void insertCoreUI(UserCustomConfigInfo userConfigInfo) {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String parentUIName = commonQueryPanel.getParentUIClassName();
        String schemaKey = this.currentQuerySolutionInfo.getName();
        if (schemaKey != null) {
            parentUIName = parentUIName + schemaKey;
        }
        if (userConfigInfo != null) {
            userConfigInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
            userConfigInfo.setUiClassName(parentUIName);
        }
        try {
            this.getBizInterface().addnew(userConfigInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private UserCustomConfigInfo gecoreUIConfig(QuerySolutionInfo currentQuerySolutionInfo) {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String parentUIName = commonQueryPanel.getParentUIClassName();
        String schemaKey = currentQuerySolutionInfo.getName();
        if (schemaKey != null) {
            parentUIName = parentUIName + schemaKey;
        }
        String queryOSQL = MessageFormat.format(QUERY_USERCUSTOMCONFIG, parentUIName, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        UserCustomConfigInfo userConfigInfo = new UserCustomConfigInfo();
        try {
            UserCustomConfigCollection userConfigCollection = this.getBizInterface().getCollection(queryOSQL);
            for (UserCustomConfigInfo next : userConfigCollection) {
                userConfigInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
                userConfigInfo.setUiClassName(next.getUiClassName());
                userConfigInfo.setConfigXML(next.getConfigXML());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return userConfigInfo;
    }

    public IUserCustomConfig getBizInterface() throws Exception {
        return UserCustomConfigFactory.getRemoteInstance();
    }

    private void reNameButton_actionPerformed(ActionEvent e) {
        ActionCache.clear();
        if (!this.isSolutionOwner(this.currentQuerySolutionInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)commonQueryRes, (String)"cannotothersolution"));
            return;
        }
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        if (commonQueryPanel.verify() && this.currentQuerySolutionInfo != null && this.showSolutionDialog(true)) {
            if (this.reNameSolution(this.getSolutionID(), this.currentSolutionName)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"ModifyNameSucceed"));
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolutionInfo);
                return;
            }
            commonQueryPanel.getSolutionListPanel().refreshSolutionList();
            return;
        }
    }

    private void delButton_actionPerformed(ActionEvent e) {
        ActionCache.clear();
        QuerySolutionInfo delSolution = this.getCommonQueryPanel().getSolutionListPanel().getSelectedQuerySolutionInfo();
        if (delSolution == null) {
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"chooseSolutionWarning"));
            return;
        }
        int flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"delWarning"));
        if (flag == 0) {
            CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
            if (this.delSolution(delSolution)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"delSolutionSucceed"));
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                commonQueryPanel.getSolutionListPanel().setSelected(this.getDefaultSolution(this.currentShareType));
                return;
            }
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"delSolutionWarning"));
            commonQueryPanel.getSolutionListPanel().refreshSolutionList();
            commonQueryPanel.getSolutionListPanel().setSelected(delSolution);
            return;
        }
    }

    private QuerySolutionCollection changeTurns(QuerySolutionCollection querySolutionCollection) {
        ArrayList<QuerySolutionInfo> a = new ArrayList<QuerySolutionInfo>();
        for (int i = 0; i < querySolutionCollection.size(); ++i) {
            a.add(querySolutionCollection.get(i));
        }
        Collections.sort(a);
        for (int j = 0; j < a.size(); ++j) {
            querySolutionCollection.addObject((IObjectValue)((QuerySolutionInfo)a.get(j)));
        }
        return querySolutionCollection;
    }

    protected QuerySolutionCollection getQuerySolutions(ShareTypeEnum shareType) {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String queryName = commonQueryPanel.getQueryInfo().getFullName();
        String parentUI = commonQueryPanel.getParentUIClassName();
        String orgID = this.getOrgID(queryName);
        QuerySolutionCollection querySolutionCollection = null;
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            querySolutionCollection = iQuerySolution.getQuerySolutions(orgID, queryName, parentUI, shareType);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return querySolutionCollection;
    }

    protected QuerySolutionInfo getDefaultSolution(ShareTypeEnum shareType) {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String queryName = commonQueryPanel.getQueryInfo().getFullName();
        String parentUI = commonQueryPanel.getParentUIClassName();
        String orgID = this.getOrgID(queryName);
        QuerySolutionCollection querySolutionCollection = null;
        QuerySolutionInfo querySolutionInfo = null;
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            querySolutionCollection = iQuerySolution.getQuerySolutions(orgID, queryName, parentUI, shareType);
            if (querySolutionCollection.size() > 0) {
                for (int i = 0; i < querySolutionCollection.size(); ++i) {
                    if (!"10".equals(querySolutionCollection.get(i).getSolutionType().getValue())) continue;
                    querySolutionInfo = querySolutionCollection.get(i);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return querySolutionInfo;
    }

    protected boolean addSolution() {
        try {
            CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            this.userCustomConfig = this.gecoreUIConfig(this.currentQuerySolutionInfo);
            QuerySolutionInfo querySolutionInfo = this.querySolutionTemp;
            BOSUuid owner = this.getOwner();
            String name = this.querySolutionTemp.getName();
            String queryObjectName = commonQueryPanel.getQueryInfo().getFullName();
            BOSUuid orgID = null;
            orgID = this.currentShareType == ShareTypeEnum.CU_LEVEL ? SysContext.getSysContext().getCurrentCtrlUnit().getId() : Util.getOrgID(queryObjectName);
            ShareTypeEnum shareType = this.currentShareType;
            String parentUIName = commonQueryPanel.getParentUIClassName();
            querySolutionInfo.setOwner(owner);
            querySolutionInfo.setOrgID(orgID);
            querySolutionInfo.setQueryObjectName(queryObjectName);
            querySolutionInfo.setEntityViewInfo(commonQueryPanel.getEntityViewInfo().toString());
            querySolutionInfo.setLockedEntityViewInfo(commonQueryPanel.getLockedEntityViewInfo().toString());
            querySolutionInfo.setShareType(shareType);
            querySolutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            querySolutionInfo.setParentUIName(parentUIName);
            querySolutionInfo.setTableParams(this.getTableParams());
            QueryPanelCollection queryPanelCollection = QueryToolBar.getQueryPanelCollection(commonQueryPanel);
            querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
            if (this.getCommonQueryPanel().isDisShowRowCount()) {
                querySolutionInfo.setRowCount(-1);
            } else {
                querySolutionInfo.setRowCount(commonQueryPanel.getRowCount());
            }
            querySolutionInfo.setDynQuery(commonQueryPanel.getDynQuerySolutionInfo());
            IObjectPK objectPK = iQuerySolution.addnew(querySolutionInfo);
            querySolutionInfo.setId(BOSUuid.read((String)objectPK.toString()));
            this.setCurrentSolution(querySolutionInfo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    public static QueryPanelCollection getQueryPanelCollection(CommonQueryPanel commonQueryPanel) throws Exception {
        QueryPanelCollection queryPanelCollection = new QueryPanelCollection();
        String panelName = null;
        String panelClassName = null;
        String filterInfo = "";
        String sorterInfo = "";
        QueryPanelTypeEnum queryPanelType = null;
        for (Object object : commonQueryPanel.getPanels().values()) {
            FilterInfo temp;
            QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
            if (object == null) continue;
            if (object instanceof IQueryInfoPanel) {
                IQueryInfoPanel iQueryInfoPanel = (IQueryInfoPanel)object;
                panelName = iQueryInfoPanel.getPanelName();
                CustomerParams cp = new CustomerParams();
                cp = iQueryInfoPanel.getCustomerParams();
                String customerParams = null;
                if (cp != null) {
                    Collection keys = cp.getKeys();
                    Collection values = cp.getValues();
                    if (keys.size() > 0) {
                        customerParams = XMLBean.CreateXMLStrRecursion(keys, values);
                    }
                }
                queryPanelInfo.setCustomerParams(customerParams);
                panelClassName = object.getClass().getName();
                if (iQueryInfoPanel.getSorterItems() != null) {
                    String oql = EntityViewInfo.toOQL((SorterItemCollection)iQueryInfoPanel.getSorterItems());
                    if (!(oql == null || oql.trim().equalsIgnoreCase("") || oql.indexOf("ORDER") != -1 && oql.indexOf("order") != -1)) {
                        oql = "ORDER BY " + oql;
                    }
                    sorterInfo = oql;
                }
                if (iQueryInfoPanel.getFilterInfo() != null) {
                    filterInfo = iQueryInfoPanel.getFilterInfo().toString();
                }
                queryPanelType = QueryPanelTypeEnum.CUSTOMER_PANEL;
            } else if (object instanceof IFilterPanel) {
                IFilterPanel iFilterPanel = (IFilterPanel)object;
                panelName = iFilterPanel.getPanelName();
                panelClassName = object.getClass().getName();
                temp = commonQueryPanel.getCommonFilterPanel().getFilterInfo();
                if (temp != null) {
                    filterInfo = temp.toString();
                }
                queryPanelType = QueryPanelTypeEnum.FILTER_PANEL;
                queryPanelInfo.setMaskString(temp.getMaskString());
            } else if (object instanceof ISorterPanel) {
                ISorterPanel iSorterPanel = (ISorterPanel)object;
                panelName = iSorterPanel.getPanelName();
                panelClassName = object.getClass().getName();
                temp = commonQueryPanel.getCommonSorterPanel().getSorterItems();
                if (temp != null) {
                    String oql = EntityViewInfo.toOQL((SorterItemCollection)temp);
                    if (!(oql == null || oql.trim().equalsIgnoreCase("") || oql.indexOf("ORDER") != -1 && oql.indexOf("order") != -1)) {
                        oql = "ORDER BY " + oql;
                    }
                    sorterInfo = oql;
                }
                queryPanelType = QueryPanelTypeEnum.SORTER_PANEL;
            } else if (object instanceof CommonTablePanel) {
                queryPanelType = QueryPanelTypeEnum.TABLE_PANEl;
                panelClassName = CommonTablePanel.class.getName();
                panelName = QueryPanelTypeEnum.TABLE_PANEl.getAlias();
                filterInfo = "";
                sorterInfo = "";
            }
            KDBizMultiLangBox solutionNameTextField = new KDBizMultiLangBox();
            List langList = KDBizMultiLangBox.getLanguageList();
            for (int i = 0; i < langList.size(); ++i) {
                if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
                solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
            }
            solutionNameTextField.getEditor().setItem(panelName);
            UIHelper.storeMultiLangFields((KDMultiLangBox)solutionNameTextField, (IObjectValue)queryPanelInfo, (String)"panelName");
            queryPanelInfo.setPanelClassName(panelClassName);
            queryPanelInfo.setFilterInfo(filterInfo);
            queryPanelInfo.setSorterInfo(sorterInfo);
            queryPanelInfo.setParam(null);
            queryPanelInfo.setQueryPanelType(queryPanelType);
            queryPanelCollection.add(queryPanelInfo);
        }
        return queryPanelCollection;
    }

    private boolean isSolutionOwner(QuerySolutionInfo solutionInfo) {
        return solutionInfo != null && solutionInfo.getOwner().equals((Object)this.getOwner());
    }

    public boolean reNameSolution(String solutionID, String newName) {
        try {
            CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            QuerySolutionInfo querySolutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionID)));
            if (!this.isSolutionOwner(querySolutionInfo)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveOtherSolutionFail"));
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                return false;
            }
            querySolutionInfo.setName(newName);
            if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L2")) {
                querySolutionInfo.setName(STConverter.sc2tc((String)querySolutionInfo.getName(new Locale("L2"))), new Locale("L3"));
            } else if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L3")) {
                querySolutionInfo.setName(STConverter.tc2sc((String)querySolutionInfo.getName(new Locale("L3"))), new Locale("L2"));
            }
            iQuerySolution.update((IObjectPK)new ObjectUuidPK(querySolutionInfo.getId()), querySolutionInfo);
            this.setCurrentSolution(querySolutionInfo);
            return true;
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            return false;
        }
    }

    public boolean editSolution(String solutionID) {
        try {
            CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            QuerySolutionInfo querySolutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionID)));
            boolean hasEditRight = PermissionChecker.hasEditOtherCQSolutionPerm(null);
            if (!this.isSolutionOwner(querySolutionInfo) && !hasEditRight) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveOtherSolutionFail"));
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                return false;
            }
            querySolutionInfo.setEntityViewInfo(commonQueryPanel.getEntityViewInfo().toString());
            querySolutionInfo.setLockedEntityViewInfo(commonQueryPanel.getLockedEntityViewInfo().toString());
            String name = this.currentSolutionName;
            ShareTypeEnum shareType = this.currentShareType;
            String tableParams = this.getTableParams();
            if (tableParams != null) {
                querySolutionInfo.setTableParams(tableParams);
            }
            KDBizMultiLangBox solutionNameTextField = new KDBizMultiLangBox();
            List langList = KDBizMultiLangBox.getLanguageList();
            for (int i = 0; i < langList.size(); ++i) {
                if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
                solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
            }
            solutionNameTextField.getEditor().setItem(name);
            UIHelper.storeMultiLangFields((KDMultiLangBox)solutionNameTextField, (IObjectValue)querySolutionInfo, (String)"name");
            querySolutionInfo.setShareType(shareType);
            QueryPanelCollection queryPanelCollection = QueryToolBar.getQueryPanelCollection(commonQueryPanel);
            querySolutionInfo.getQueryPanelInfo().clear();
            querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
            if (this.getCommonQueryPanel().isDisShowRowCount()) {
                querySolutionInfo.setRowCount(-1);
            } else {
                querySolutionInfo.setRowCount(commonQueryPanel.getRowCount());
            }
            querySolutionInfo.setDynQuery(commonQueryPanel.getDynQuerySolutionInfo());
            iQuerySolution.update((IObjectPK)new ObjectUuidPK(querySolutionInfo.getId()), querySolutionInfo);
            commonQueryPanel.saveDefaultViewOrRowCount(querySolutionInfo);
            this.setCurrentSolution(querySolutionInfo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    public static boolean editSolutionInfo(QuerySolutionInfo querySolutionInfo) {
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            iQuerySolution.update((IObjectPK)new ObjectUuidPK(querySolutionInfo.getId()), querySolutionInfo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle(null, (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    public static boolean addSolutionInfo(QuerySolutionInfo querySolutionInfo) {
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            iQuerySolution.addnew(querySolutionInfo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle(null, (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    private boolean delSolution(QuerySolutionInfo delSolution) {
        try {
            if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)delSolution.getSolutionType())) {
                return false;
            }
            String solutionID = delSolution.getId().toString();
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            ObjectUuidPK iObjectPK = new ObjectUuidPK(solutionID);
            iQuerySolution.delete((IObjectPK)iObjectPK);
            this.deletePrintSolutionInfo(solutionID);
            this.setCurrentSolution(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePrintSolutionInfo(String solutionId) {
        StringBuffer sql = new StringBuffer();
        sql.append("IF EXISTS(SELECT * FROM  KSQL_USERTABLES WHERE KSQL_TABNAME='t_bg_bganalyseconfig') delete from t_bg_bganalyseconfig where fid = '");
        sql.append(solutionId);
        sql.append("'");
        try {
            IBireportBaseFacade iBireportBaseFacade = BireportBaseFacadeFactory.getRemoteInstance();
            if (iBireportBaseFacade == null) {
                throw new NullPointerException();
            }
            iBireportBaseFacade.executeUpdate(sql.toString(), null);
        }
        catch (EASBizException ex) {
            logger.info((Object)"error!", (Throwable)ex);
        }
        catch (BOSException e) {
            logger.info((Object)"error!", (Throwable)e);
        }
    }

    protected KDComboBox getShareTypeComboBox() {
        return this.shareTypeComboBox;
    }

    private CommonQueryPanel getCommonQueryPanel() {
        return (CommonQueryPanel)((Object)Util.getComponent((Component)((Object)this), CommonQueryPanel.class.getName()));
    }

    protected CommonQueryUI getCommonQueryUI() {
        return (CommonQueryUI)((Object)Util.getComponent((Component)((Object)this), CommonQueryUI.class.getName()));
    }

    public String getTableParams() {
        if (this.getCommonQueryPanel().getCommonTablePanel() != null) {
            return this.getCommonQueryPanel().getCommonTablePanel().getTableParams();
        }
        if (this.getCurrentQuerySolutionInfo() != null) {
            String tableParams = this.getCurrentQuerySolutionInfo().getTableParams();
            if (this.getCommonQueryPanel().getHiddenTableCols() != null) {
                return QueryUtils.hiddenOrVisibleDefaultSolutionCol((Component)this.getCommonQueryUI().getCommonQueryParam().getUiObject(), tableParams, this.getCommonQueryPanel().getHiddenTableCols(), true);
            }
            if (this.getCommonQueryPanel().getVisibleTableCols() != null) {
                return QueryUtils.hiddenOrVisibleDefaultSolutionCol((Component)this.getCommonQueryUI().getCommonQueryParam().getUiObject(), tableParams, this.getCommonQueryPanel().getVisibleTableCols(), false);
            }
            return tableParams;
        }
        return null;
    }

    public QuerySolutionInfo getCurrentQuerySolutionInfo() {
        if (this.currentQuerySolutionInfo != null) {
            this.currentQuerySolutionInfo.setRowCount(this.getCommonQueryPanel().getRowCount());
        }
        return this.currentQuerySolutionInfo;
    }

    protected void setCurrentSolution(QuerySolutionInfo info) {
        this.currentQuerySolutionInfo = info;
    }

    protected String getOrgID() {
        CompanyOrgUnitInfo defCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (defCompany != null) {
            return defCompany.getId().toString();
        }
        return null;
    }

    protected void setSolutionName(String solutionName) {
        this.currentSolutionName = solutionName;
    }

    protected BOSUuid getOwner() {
        BOSUuid owner = SysContext.getSysContext().getCurrentUserInfo().getId();
        return owner;
    }

    protected void setOwner(BOSUuid owner) {
        this.owner = owner;
    }

    private boolean showSolutionDialog() {
        return this.showSolutionDialog(false);
    }

    private boolean showSolutionDialog(boolean isReName) {
        boolean isConfirm = false;
        UIContext uiContext = new UIContext((Object)this.getCommonQueryPanel().getParentUI());
        uiContext.put((Object)"TOOLBAR", (Object)this);
        uiContext.put((Object)"current_solution", (Object)this.currentQuerySolutionInfo);
        if (isReName) {
            uiContext.put((Object)"RENAMEACTION", (Object)"reNameAction");
        } else {
            uiContext.put((Object)"RENAMEACTION", null);
        }
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(SolutionPromptUI.class.getName(), (Map)uiContext, null, "");
            window.show();
            isConfirm = 0 == ((SolutionPromptUI)window.getUIObject()).getCloseWindowType();
            this.shareTypeComboBox.repaint();
            return isConfirm;
        }
        catch (UIException e) {
            return isConfirm;
        }
    }

    public void setQuerySolution(QuerySolutionInfo qsi) {
        this.querySolutionTemp = qsi;
    }

    public void setShareType(ShareTypeEnum enum1) {
        this.currentShareType = enum1;
    }

    public ShareTypeEnum getCurrentShareType() {
        return this.currentShareType;
    }
}

