/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.NewSolutionListPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class SolutionRenamePromptUI
extends CoreUI {
    private static Logger logger = Logger.getLogger(SolutionRenamePromptUI.class);
    private static final String toolBarRes = "com.kingdee.eas.base.commonquery.client.ToolBar";
    private static final String cqResource = "com.kingdee.eas.base.commonquery.cqResource";
    private KDBizMultiLangBox solutionNameTextField;
    private KDButton confirmButton;
    private KDButton cancelButton;
    private CommonQueryPanel commonQueryPanel;
    public static final String COMMONQUERYPANEL = "commonquerypanel";
    public static final String NEWSOLUTIONLISTPANEL = "newsolutionlistpanel";
    private NewSolutionListPanel newSolutionListPanel;
    private QuerySolutionInfo currentQuerySolutionInfo;
    public static final String CURRENT_SOLUTION = "current_solution";
    private static final String solutionDialogRes = "com.kingdee.eas.base.commonquery.client.SolutionPromptUI";

    public SolutionRenamePromptUI() throws Exception {
        this.init();
    }

    private void init() {
        this.setUITitle(EASCommonResource.getString((String)cqResource, (String)"rename", (Locale)SysContext.getSysContext().getLocale()));
        KDLabelContainer solutionLabContainer = new KDLabelContainer();
        solutionLabContainer.setBoundLabel((JLabel)new KDLabel(EASResource.getString((String)solutionDialogRes, (String)"text")));
        solutionLabContainer.setBoundLabelLength(80);
        solutionLabContainer.setBoundLabelUnderline(true);
        solutionLabContainer.setBounds(new Rectangle(10, 15, 280, 19));
        this.solutionNameTextField = new KDBizMultiLangBox();
        this.solutionNameTextField.setRequired(true);
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
            this.solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
        }
        solutionLabContainer.setBoundEditor((JComponent)this.solutionNameTextField);
        this.solutionNameTextField.setMaxLength(79);
        this.add((Component)solutionLabContainer);
        this.confirmButton = new KDButton();
        this.confirmButton.setText(EASResource.getString((String)solutionDialogRes, (String)"confirmButtonText"));
        this.confirmButton.setBounds(new Rectangle(141, 71, 73, 19));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionRenamePromptUI.this.confirmButton_actionPerformed(e);
            }
        });
        this.add((Component)this.confirmButton);
        this.cancelButton = new KDButton();
        this.cancelButton.setText(EASResource.getString((String)solutionDialogRes, (String)"cancelButtonText"));
        this.cancelButton.setBounds(new Rectangle(217, 71, 73, 19));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionRenamePromptUI.this.cancelButton_actionPerformed(e);
            }
        });
        this.add((Component)this.cancelButton);
        KDSeparator separator = new KDSeparator();
        separator.setBounds(new Rectangle(0, 64, 300, 2));
        this.add((Component)separator);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(300, 100));
    }

    private void confirmButton_actionPerformed(ActionEvent e) {
        this.saveSolution();
        Util.getWindow((Component)((Object)this)).dispose();
        this.newSolutionListPanel.refreshSolutionList();
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        Util.getWindow((Component)((Object)this)).dispose();
        this.newSolutionListPanel.refreshSolutionList();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentQuerySolutionInfo = (QuerySolutionInfo)this.getUIContext().get(CURRENT_SOLUTION);
        this.commonQueryPanel = (CommonQueryPanel)((Object)this.getUIContext().get(COMMONQUERYPANEL));
        this.newSolutionListPanel = (NewSolutionListPanel)((Object)this.getUIContext().get(NEWSOLUTIONLISTPANEL));
        if (this.currentQuerySolutionInfo != null) {
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)this.currentQuerySolutionInfo, (String)"name");
        }
        this.solutionNameTextField.setMaxLength(200);
        this.solutionNameTextField.setRequired(true);
    }

    protected void saveSolution() {
        try {
            String solutionName = this.solutionNameTextField.getSelectedItem().toString();
            if (solutionName == null || solutionName.trim().equalsIgnoreCase("")) {
                MsgBox.showWarning((String)EASResource.getString((String)solutionDialogRes, (String)"solutionNameIsNull"));
                SysUtil.abort();
            }
            QuerySolutionInfo querySolutionInfo = this.currentQuerySolutionInfo;
            UIHelper.storeMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)querySolutionInfo, (String)"name");
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            if (querySolutionInfo.getId() != null) {
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("name"));
                iQuerySolution.checkSameName(querySolutionInfo);
                iQuerySolution.updatePartial(querySolutionInfo, selectors);
            } else {
                iQuerySolution.addnew(querySolutionInfo);
            }
            this.getCommonQueryPanel().showInfo(EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"), "info");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            SysUtil.abort();
        }
    }

    public CommonQueryPanel getCommonQueryPanel() {
        return this.commonQueryPanel;
    }
}

