/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

public class BizComboQueryAgent {
    private static final Logger logger = Logger.getLogger(BizComboQueryAgent.class);
    protected IQueryExecutor queryExecutor;
    protected MetaDataPK queryInfoPK;
    protected QueryInfo queryInfo;
    protected SelectorItemCollection selectorCollection;
    protected EntityViewInfo runtimeEntityView;
    protected EntityViewInfo entityView;

    public IQueryExecutor getQueryExecutor() {
        MetaDataPK pk;
        if (this.queryExecutor == null && (pk = this.getQueryInfoPK()) != null) {
            this.queryExecutor = BosHelper.createQueryExecutor(pk);
        }
        return this.queryExecutor;
    }

    public void setQueryExecutor(IQueryExecutor exec) {
        this.queryExecutor = exec;
    }

    public MetaDataPK getQueryInfoPK() {
        return this.queryInfoPK;
    }

    public void setQueryInfoPK(MetaDataPK dataPK) {
        if (dataPK != null) {
            if (dataPK.equals((Object)this.queryInfoPK)) {
                return;
            }
            this.queryInfoPK = dataPK;
            this.setQueryInfo(null);
            this.setQueryExecutor(null);
        } else if (this.queryInfoPK != null) {
            this.queryInfoPK = null;
            this.setQueryInfo(null);
            this.setQueryExecutor(null);
        } else {
            return;
        }
    }

    public QueryInfo getQueryInfo() {
        MetaDataPK pk;
        if (this.queryInfo == null && (pk = this.getQueryInfoPK()) != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            this.queryInfo = loader.getQuery((IMetaDataPK)pk);
        }
        return this.queryInfo;
    }

    protected void setQueryInfo(QueryInfo info) {
        this.queryInfo = info;
    }

    public SelectorItemCollection getSelectorCollection() {
        return this.selectorCollection;
    }

    public void setSelectorCollection(SelectorItemCollection collection) {
        this.selectorCollection = collection;
    }

    public IRowSet executeQuery(int start, int length) {
        IRowSet rowset = null;
        IQueryExecutor exec = this.getQueryExecutor();
        if (exec == null) {
            return null;
        }
        if (this.getRuntimeEntityView().getSorter() != null && this.getRuntimeEntityView().getSorter().size() > 0) {
            exec.option().isIgnoreOrder = true;
        }
        exec.setObjectView(this.getRuntimeEntityView());
        try {
            rowset = length < 0 ? exec.executeQuery() : exec.executeQuery(start, length);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.resetRuntimeEntityView();
        return rowset;
    }

    public EntityViewInfo getEntityViewInfo() {
        return this.entityView;
    }

    public void setEntityViewInfo(EntityViewInfo v) {
        FilterInfo f;
        this.entityView = v;
        if (this.entityView != null && (f = this.entityView.getFilter()) == null) {
            f = new FilterInfo();
            this.entityView.setFilter(f);
        }
    }

    public void resetRuntimeEntityView() {
        this.runtimeEntityView = null;
    }

    public EntityViewInfo getRuntimeEntityView() {
        if (this.runtimeEntityView == null) {
            if (this.entityView != null) {
                String str = this.getEntityViewInfo().toString();
                try {
                    this.runtimeEntityView = new EntityViewInfo(str);
                }
                catch (ParserException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                this.runtimeEntityView = new EntityViewInfo();
            }
        }
        return this.runtimeEntityView;
    }
}

