/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols.ext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.util.BaseDataFactory;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class ControlTypeFilterInfoProducer
implements IFilterInfoProducer {
    private CtrlUnitInfo currentCU;
    private FilterInfo fiToReturn;
    private String queryName = null;
    private String controlType = null;
    private BOSObjectType bosType;
    private boolean hasCUDefaultFilter = true;

    ControlTypeFilterInfoProducer(String queryName) {
        this.queryName = queryName;
        this.currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
    }

    ControlTypeFilterInfoProducer(String queryName, boolean hasCUDefaultFilter) {
        this.queryName = queryName;
        this.currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        this.hasCUDefaultFilter = hasCUDefaultFilter;
    }

    @Override
    public FilterInfo getFilterInfo() {
        if (this.fiToReturn == null) {
            this.fiToReturn = this.getFilterInfoWhenHasControlType();
            if (this.fiToReturn == null) {
                this.fiToReturn = new FilterInfo();
            }
        }
        return this.fiToReturn;
    }

    private FilterInfo getFilterInfoWhenHasControlType() {
        FilterInfo fi = null;
        String ct = this.getControlType();
        if (ct != null && !ct.equals("")) {
            if (ct.equals("I")) {
                fi = this.getFilterInfoForControlTypeI();
            } else if (ct.equals("D")) {
                fi = this.getFilterInfoForControlTypeD();
            } else if (ct.equals("S4")) {
                fi = this.getFilterInfoForControlTypeS4();
            }
        }
        return fi;
    }

    private FilterInfo getFilterInfoForControlTypeI() {
        if (!this.hasCUDefaultFilter) {
            return null;
        }
        FilterInfo filterInfoForControlTypeI = new FilterInfo();
        FilterItemCollection fic = filterInfoForControlTypeI.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)this.getCurrentCtrlUnitID(), CompareType.EQUALS));
        return filterInfoForControlTypeI;
    }

    private BOSObjectType getBOSTypeFromQueryMainObject() {
        if (this.bosType != null) {
            return this.bosType;
        }
        return Utils.getBOSTypeFromQueryPK((IMetaDataPK)MetaDataPK.create((String)this.queryName), null);
    }

    private FilterInfo getFilterInfoForControlTypeD() {
        BOSObjectType bosType = this.getBOSTypeFromQueryMainObject();
        if (bosType == null) {
            return null;
        }
        if (!this.hasCUDefaultFilter) {
            return null;
        }
        FilterInfo filterInfoForControlTypeD = null;
        try {
            return BaseDataFactory.getInstance().getDatabaseDFilter(bosType, (IObjectPK)new ObjectUuidPK(this.getCurrentCtrlUnitID()), "id", "CU.id");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return filterInfoForControlTypeD;
        }
    }

    private FilterInfo getFilterInfoForControlTypeS4() {
        if (!this.hasCUDefaultFilter) {
            return null;
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)this.getCurrentCtrlUnitID()));
        String ln = this.getCurrentCtrlUnit().getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("CU.longNumber", lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }

    private CtrlUnitInfo getCurrentCtrlUnit() {
        return this.currentCU;
    }

    private String getCurrentCtrlUnitID() {
        return this.currentCU.getId().toString();
    }

    private String getControlType() {
        if (this.controlType != null) {
            return this.controlType;
        }
        this.controlType = "";
        if (StringUtils.isEmpty((String)this.queryName)) {
            return this.controlType;
        }
        BOSObjectType bosType = this.getBOSTypeFromQueryMainObject();
        if (bosType == null) {
            return this.controlType;
        }
        try {
            this.controlType = BaseDataFactory.getInstance().getControlType(bosType);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return this.controlType;
    }

    @Override
    public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        if (cui != null) {
            this.currentCU = cui;
        }
        this.fiToReturn = null;
    }

    @Override
    public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
    }
}

