/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.netctrl.IntegerCompareEnum;
import com.kingdee.eas.base.netctrl.StringCompareEnum;
import com.kingdee.eas.base.netctrl.client.AbstractMutexFilterUI;
import com.kingdee.eas.base.netctrl.client.FilterItem;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MutexFilterUI
extends AbstractMutexFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MutexFilterUI.class);
    private List filterInfo = null;
    private final int OBJECT_LOCK = 0;
    private final int MUTEX_LOCK = 1;
    private int mutexType = 0;
    String resClass = "com.kingdee.eas.base.netctrl.client.MutexServiceResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        NewOrgF7 of7 = new NewOrgF7();
        of7.setNeedAddOrgRange(false);
        of7.setNeedConsiderFaultTree(false);
        this.orgF7.setSelector((KDPromptSelector)of7);
        this.orgF7.setHistoryRecordEnabled(false);
        this.orgF7.setQueryInfo("com.kingdee.eas.basedata.org.app.BaseUnitInfoQuery");
        this.createTimePicker.setValue(null);
        GregorianCalendar initDate = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        this.delayTimePicker.setValue((Object)initDate.getTime());
        if (this.mutexType == this.MUTEX_LOCK) {
            this.objNumberCB.setVisible(false);
            this.objNumberTxt.setVisible(false);
            this.objTypeCB.setVisible(false);
            this.objTypeTxt.setVisible(false);
            this.l2.setText(this.getResource("LockName"));
            this.mutexCB.setVisible(true);
            this.mutexTxt.setVisible(true);
            this.mutexCB.setEnabled(false);
            this.mutexTxt.setEnabled(false);
            this.l3.setText(this.getResource("LockDescription"));
            this.descriptionCB.setVisible(true);
            this.descriptionTxt.setVisible(true);
            this.descriptionCB.setEnabled(false);
            this.descriptionTxt.setEnabled(false);
        }
        this.initFilterItems();
    }

    private void initContext() {
        this.filterInfo = (List)this.getUIContext().get("filterInfo");
        if (this.filterInfo == null) {
            this.filterInfo = new ArrayList();
            this.getUIContext().put("filterInfo", this.filterInfo);
        }
        if (this.getUIContext().get("mutexType") != null) {
            this.mutexType = (Integer)this.getUIContext().get("mutexType");
        }
    }

    private void initFilterItems() {
        if (this.filterInfo != null && this.filterInfo.size() > 0) {
            for (FilterItem item : this.filterInfo) {
                switch (item.getAttrType()) {
                    case 0: {
                        this.orgF7.setValue((Object)item.getAttrValue());
                        this.orgCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                        break;
                    }
                    case 2: {
                        this.objNumberTxt.setText(item.getAttrValue());
                        this.objNumberCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                        break;
                    }
                    case 1: {
                        this.objTypeTxt.setText(item.getAttrValue());
                        this.objTypeCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                        break;
                    }
                    case 6: {
                        this.mutexTxt.setText(item.getAttrValue());
                        this.mutexCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                        break;
                    }
                    case 7: {
                        this.descriptionTxt.setText(item.getAttrValue());
                        this.descriptionCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                        break;
                    }
                    case 3: {
                        this.creatorTxt.setText(item.getAttrValue());
                        this.creatorCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                        break;
                    }
                    case 4: {
                        this.createTimePicker.setValue((Object)new Timestamp(Long.parseLong(item.getAttrValue())));
                        this.createTimeCB.setSelectedItem((Object)this.getIntCompareType(item.getCompareType()));
                        break;
                    }
                    case 5: {
                        long ldTime = Long.parseLong(item.getAttrValue());
                        Timestamp dTime = new Timestamp(ldTime);
                        dTime.setHours((int)ldTime / 3600000);
                        this.delayTimePicker.setValue((Object)dTime);
                        this.delayTimeCB.setSelectedItem((Object)this.getIntCompareType(item.getCompareType()));
                    }
                }
            }
        }
    }

    private IntegerCompareEnum getIntCompareType(int compareType) {
        switch (compareType) {
            case 0: {
                return IntegerCompareEnum.EQUAL;
            }
            case 1: {
                return IntegerCompareEnum.GREATER;
            }
            case -1: {
                return IntegerCompareEnum.LESS;
            }
        }
        return IntegerCompareEnum.EQUAL;
    }

    private void setEnableState(KDCheckBox box, KDComboBox cb, JComponent txt) {
        boolean enableFlag = false;
        if (box.isSelected()) {
            enableFlag = true;
        }
        cb.setEnabled(enableFlag);
        txt.setEnabled(enableFlag);
    }

    private void addFilterItem(int attrType, KDComboBox cb, String strValue) {
        int compareType = -999;
        Object objCp = cb.getSelectedItem();
        if (objCp instanceof StringCompareEnum) {
            compareType = ((StringCompareEnum)((Object)objCp)).equals((Object)StringCompareEnum.EQUAL) ? 0 : 5;
        } else if (objCp instanceof IntegerCompareEnum) {
            IntegerCompareEnum comparator = (IntegerCompareEnum)((Object)objCp);
            if (comparator.equals((Object)IntegerCompareEnum.EQUAL)) {
                compareType = 0;
            } else if (comparator.equals((Object)IntegerCompareEnum.GREATER)) {
                compareType = 1;
            } else if (comparator.equals((Object)IntegerCompareEnum.LESS)) {
                compareType = -1;
            }
        }
        if (attrType == -1 || compareType == -999) {
            return;
        }
        FilterItem item = new FilterItem(attrType, compareType, strValue);
        this.filterInfo.add(item);
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void ok_actionPerformed(ActionEvent e) throws Exception {
        long dlTime;
        this.filterInfo.clear();
        if (this.orgF7.getValue() != null && this.orgF7.getValue().toString().length() > 0) {
            this.addFilterItem(0, this.orgCB, this.orgF7.getValue().toString());
        }
        if (this.objNumberTxt.getText() != null && this.objNumberTxt.getText().trim().length() > 0) {
            this.addFilterItem(2, this.objNumberCB, this.objNumberTxt.getText().trim());
        }
        if (this.objTypeTxt.getText() != null && this.objTypeTxt.getText().trim().length() > 0) {
            this.addFilterItem(1, this.objTypeCB, this.objTypeTxt.getText().trim());
        }
        if (this.mutexTxt.getText() != null && this.mutexTxt.getText().trim().length() > 0) {
            this.addFilterItem(6, this.mutexCB, this.mutexTxt.getText().trim());
        }
        if (this.descriptionTxt.getText() != null && this.descriptionTxt.getText().trim().length() > 0) {
            this.addFilterItem(7, this.descriptionCB, this.descriptionTxt.getText().trim());
        }
        if (this.createTimePicker.getValue() != null) {
            this.addFilterItem(4, this.createTimeCB, this.createTimePicker.getTimestamp().getTime() + "");
        }
        if (this.creatorTxt.getText() != null && this.creatorTxt.getText().trim().length() > 0) {
            this.addFilterItem(3, this.creatorCB, this.creatorTxt.getText().trim());
        }
        if (!((Date)this.delayTimePicker.getValue()).equals(new GregorianCalendar(0, 0, 0, 0, 0, 0).getTime()) && (dlTime = (long)(this.delayTimePicker.getTimestamp().getHours() * 3600 + this.delayTimePicker.getTimestamp().getMinutes() * 60 + this.delayTimePicker.getTimestamp().getSeconds())) != 0L) {
            this.addFilterItem(5, this.delayTimeCB, dlTime * 1000L + "");
        }
        this.destroyWindow();
    }

    private String getResource(String key) {
        return EASResource.getString((String)(this.resClass + key));
    }
}

