/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.base.report.MenuBarPropertyEvent;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class MenuBuilder {
    private HashMap dctUserToolBar = new HashMap();
    private HashMap dctUserMenuItem = new HashMap();
    private JToolBar toolBar;
    private JMenu menu;

    public MenuBuilder(JToolBar toolBar, JMenu menu) {
        this.toolBar = toolBar;
        this.menu = menu;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setMenuProperty(MenuBarPropertyEvent event) {
        if (this.isExistsMenu(event.getName())) {
            KDWorkButton button = (KDWorkButton)this.dctUserToolBar.get(event.getName());
            KDMenuItem item = (KDMenuItem)this.dctUserMenuItem.get(event.getName());
            switch (event.getPropName()) {
                case 1: {
                    Boolean b = (Boolean)event.getPropValue();
                    button.setEnabled(b.booleanValue());
                    item.setEnabled(b.booleanValue());
                    break;
                }
                case 2: {
                    Boolean b = (Boolean)event.getPropValue();
                    button.setVisible(b.booleanValue());
                    item.setVisible(b.booleanValue());
                    break;
                }
                case 3: {
                    button.setText(event.getPropValue().toString());
                    item.setText(event.getPropValue().toString());
                }
            }
        }
    }

    public MenuBarPropertyEvent getMenuProperty(String name, int propName) {
        MenuBarPropertyEvent event = null;
        if (this.isExistsMenu(name)) {
            KDWorkButton button = (KDWorkButton)this.dctUserToolBar.get(name);
            switch (propName) {
                case 1: {
                    event = new MenuBarPropertyEvent(name, propName, new Boolean(button.isEnabled()));
                    break;
                }
                case 2: {
                    event = new MenuBarPropertyEvent(name, propName, new Boolean(button.isVisible()));
                    break;
                }
                case 3: {
                    event = new MenuBarPropertyEvent(name, propName, button.getText());
                }
            }
        }
        return event;
    }

    public void addBarItem(String name, String caption, String description, String toolTipText, String imageKey, Object image, boolean beginGroup, IItemAction action) {
        this.addWorkButton(this.toolBar, name, caption, description, toolTipText, imageKey, image, beginGroup, action);
        this.addMenuItem(this.menu, name, caption, description, toolTipText, imageKey, image, beginGroup, action);
    }

    private KDWorkButton addWorkButton(JToolBar toolBar, String name, String caption, String description, String toolTipText, String imageKey, Object image, boolean beginGroup, IItemAction action) {
        if (!this.dctUserToolBar.containsKey(name)) {
            KDWorkButton button = new KDWorkButton();
            button.setName(name);
            button.setAction((Action)action);
            button.setText(caption);
            button.setToolTipText(toolTipText);
            if (imageKey != null) {
                button.setIcon(EASResource.getIcon((String)imageKey));
            } else if (image != null && image instanceof Icon) {
                button.setIcon((Icon)image);
            }
            if (beginGroup) {
                toolBar.addSeparator();
            }
            toolBar.add((Component)button);
            this.dctUserToolBar.put(name, button);
            return button;
        }
        return null;
    }

    private KDMenuItem addMenuItem(JMenu menu, String name, String caption, String description, String toolTipText, String imageKey, Object image, boolean beginGroup, IItemAction action) {
        if (!this.dctUserMenuItem.containsKey(name)) {
            KDMenuItem button = new KDMenuItem();
            button.setName(name);
            button.setAction((Action)action);
            button.setText(caption);
            button.setToolTipText(toolTipText);
            if (imageKey != null) {
                button.setIcon(EASResource.getIcon((String)imageKey));
            } else if (image != null && image instanceof Icon) {
                button.setIcon((Icon)image);
            }
            if (beginGroup) {
                menu.addSeparator();
            }
            menu.add((JMenuItem)button);
            this.dctUserMenuItem.put(name, button);
            return button;
        }
        return null;
    }

    public boolean isExistsMenu(String name) {
        return this.dctUserToolBar.containsKey(name);
    }
}

