/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.IRequestTableData;
import com.kingdee.bos.ctrl.kdf.table.print.MultiPrint;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.report.DefaultReportMoveImp;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.ReportUtil;
import com.kingdee.eas.base.report.formatcondition.ReportFromatCell;
import java.awt.Component;
import java.util.HashMap;
import javax.sql.RowSet;

public class MoveReportMultiPrinter {
    private KDTable table;
    private IReport report;
    private MultiPrint multiPrint = null;
    private String stitle;
    ReportUtil rptutil;

    public MoveReportMultiPrinter() throws Exception {
    }

    public MoveReportMultiPrinter(IReport reportmove, String title, Component parentWindow) throws Exception {
        this.report = reportmove;
        this.stitle = title;
        this.table = new KDTable();
        this.table.removeAll();
        this.rptutil = new ReportUtil();
        this.rptutil.showReport(this.report, this.table);
        this.multiPrint = new MultiPrint(parentWindow);
        this.multiPrint.setTable(this.table);
        this.multiPrint.setFrugalPrint(false);
    }

    public void doMultiPrint() {
        try {
            this.fillPrintData();
            this.multiPrint.print();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doMultiPreView() {
        try {
            this.fillPrintData();
            this.multiPrint.preview();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillPrintData() throws Exception {
        try {
            DefaultReportMoveImp rm = (DefaultReportMoveImp)this.report;
            for (int i = 1; i <= rm.getDataList().size(); ++i) {
                this.multiPrint.addPrintData(new Integer(i).toString());
            }
            this.multiPrint.setRequestData(new IRequestTableData(){
                DefaultReportMoveImp rm;
                {
                    this.rm = (DefaultReportMoveImp)MoveReportMultiPrinter.this.report;
                }

                public void requestTableData(String key) {
                    try {
                        MoveReportMultiPrinter.this.table.removeRows();
                        MoveReportMultiPrinter.this.table.removeHeadRows();
                        HashMap allheader = MoveReportMultiPrinter.this.report.getReportHeader().getAllChilds();
                        this.rm.moveTo(Integer.parseInt(key));
                        this.rm.getData().beforeFirst();
                        while (this.rm.getData().next()) {
                            IRow row = MoveReportMultiPrinter.this.table.addRow();
                            for (int j = 0; j < MoveReportMultiPrinter.this.table.getColumnCount(); ++j) {
                                ICell cell = row.getCell(j);
                                IColumn col = MoveReportMultiPrinter.this.table.getColumn(j);
                                if (col.getStyleAttributes().isHided()) continue;
                                cell.setValue((Object)ReportFromatCell.getFormatValue((ReportHeader)allheader.get(col.getKey()), this.rm.getData().getObject(col.getKey()), (RowSet)this.rm.getData()));
                            }
                        }
                        MoveReportMultiPrinter.this.buildPrintHeader();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildPrintHeader() {
        ReportTitles titles = this.report.getReportTitles();
        if (titles != null) {
            HeadFootModel header = new HeadFootModel();
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setBold(true);
            sa.setFontSize(12);
            header.addRow(this.stitle, sa);
            String sTitles = null;
            String sText = "";
            int count = 0;
            int i = 0;
            int j = 1;
            while (i < 12) {
                sTitles = titles.getTitle(i);
                if (sTitles == null) {
                    sTitles = " ";
                }
                sText = sText.equals("") ? sTitles : sText + "&|" + sTitles;
                if (j % 3 == 0) {
                    j = 0;
                    HeadFootRow headertemp = new HeadFootRow();
                    headertemp.setText(sText);
                    header.addRow(headertemp);
                    ++count;
                    sText = "";
                }
                ++i;
                ++j;
            }
            HeadFootModel foot = new HeadFootModel();
            String footText = "\u3010\u91d1\u8776\u8f6f\u4ef6\u3011\u6253\u5370\u65e5\u671f:&[Date]&|\u7b2c&[Page]\u9875 \u5171&[PageCount]\u9875";
            foot.addRow(footText);
            Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
            Page fPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)foot);
            this.table.getPrintManager().setHeaderHeight(350);
            this.table.getPrintManager().setHeaderFooter(hPage, fPage);
        }
    }
}

