/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class QueryFilterUIDialogAdapter {
    public static final String UICONTEXT_KEY_INITPARAMS = "UICONTEXT_KEY_INITPARAMS";
    public static final String CUSTOMERPARAM = "customerParam";
    protected CommonQueryDialog queryDialog = null;
    private CustomerQueryPanel[] userPanels = null;
    private CoreUI owner = new CoreUI();
    private IMetaDataPK pk;
    private String title;
    private boolean showFilter;
    private boolean showSorter;
    private RptParams filter;
    private String parentUIName;
    private FilterInfo filterinfo;
    private EntityViewInfo entityViewInfo;

    public EntityViewInfo getEntityViewInfo() {
        this.entityViewInfo = this.queryDialog.getEntityViewInfoResult();
        return this.entityViewInfo;
    }

    public void setEntityViewInfo(EntityViewInfo entityViewInfo) {
        this.entityViewInfo = entityViewInfo;
    }

    public FilterInfo getFilterinfo() throws BOSException {
        if (this.filterinfo == null) {
            this.filterinfo = new FilterInfo();
        }
        int n = this.userPanels.length;
        for (int i = 0; i < n; ++i) {
            if (this.userPanels[i].getFilterInfo() == null) continue;
            this.filterinfo.mergeFilter(this.userPanels[i].getFilterInfo(), "ALL");
        }
        return this.filterinfo;
    }

    public void setFilterinfo(FilterInfo filterinfo) {
        this.filterinfo = filterinfo;
    }

    public RptParams getFilter() {
        return this.filter;
    }

    public void setFilter(RptParams filter) {
        this.filter = filter;
    }

    public QueryFilterUIDialogAdapter(IMetaDataPK metaDataPK) throws Exception {
        this.pk = metaDataPK;
    }

    public void setCustomerQueryPanel(CustomerQueryPanel[] userPanels) {
        this.userPanels = userPanels;
        if (userPanels != null && userPanels.length > 0) {
            this.parentUIName = userPanels[0].getClass().getName();
        }
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanels != null) {
            int i;
            int n = this.userPanels.length;
            for (i = 0; i < n; ++i) {
                this.userPanels[i].loadFields();
            }
            for (i = 0; i < n; ++i) {
                this.userPanels[i].initLayout();
                this.queryDialog.addUserPanel((KDPanel)this.userPanels[i]);
            }
            Dimension dd = this.getQueryDialogSize(this.userPanels);
            this.queryDialog.setShowFieldCompare(false);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.setOwner((Component)this.owner);
            this.queryDialog.setQueryObjectPK(this.pk);
            this.queryDialog.setDisShowRowCount(true);
            if (this.title != null) {
                this.queryDialog.setTitle(this.title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            }
            this.queryDialog.setShowFilter(true);
            this.queryDialog.setShowSorter(true);
            this.queryDialog.setParentUIClassName(this.parentUIName);
            this.queryDialog.setDisShowRowCount(true);
            this.initUserPanels(n);
        }
    }

    private void initUserPanels(int n) throws Exception, IllegalAccessException, InvocationTargetException {
        CustomerParams cp = null;
        if (this.filter != null) {
            cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.filter);
        }
        for (int i = 0; i < n; ++i) {
            this.userPanels[i].initLayout();
            this.userPanels[i].setCustomerParams(cp);
            this.userPanels[i].getUIContext().clear();
            this.userPanels[i].getUIContext().putAll(this.owner.getUIContext());
        }
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        Dimension size = new Dimension(100, 100);
        int n = userPanels.length;
        for (int i = 0; i < n; ++i) {
            Dimension d = userPanels[i].getSize();
            if (d.height > size.height) {
                size.height = d.height;
            }
            if (d.width <= size.width) continue;
            size.width = d.width;
        }
        size.height += 35;
        size.width += 228;
        size.height += 105;
        if (size.width <= 290 && size.height <= 280) {
            size.width = 290;
            size.height = 280;
        } else if (size.width <= 580 && size.height <= 435) {
            size.width = 580;
            size.height = 435;
        } else if (size.width <= 680 && size.height <= 510) {
            size.width = 680;
            size.height = 510;
        } else if (size.width <= 792 && size.height <= 566) {
            size.width = 792;
            size.height = 566;
        }
        size.width -= 228;
        size.height -= 105;
        return size;
    }

    public boolean showQueryDialog(boolean useDefaultSolution) throws Exception {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            this.initQueryDialog();
        }
        int n = this.userPanels.length;
        if (useDefaultSolution) {
            this.loadDefaultSolution(n);
        }
        boolean ok = false;
        if ((this.filter == null || !useDefaultSolution) && this.queryDialog.show()) {
            if (this.filter == null) {
                this.filter = new RptParams();
            } else {
                this.filter.clear();
            }
            for (int i = 0; i < n; ++i) {
                this.filter.putAll((Map)this.userPanels[i].getCustomerParams().getCustomerParamsHashMap());
            }
            ok = true;
        }
        if (this.filter != null && (ok || useDefaultSolution)) {
            CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.filter);
            for (int i = 0; i < n; ++i) {
                this.userPanels[i].setCustomerParams(cp);
            }
            return true;
        }
        return false;
    }

    private void loadDefaultSolution(int n) throws BOSException, EASBizException {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (iQuery.hasDefaultSolution(this.parentUIName, queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.pk).getFullName())) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.parentUIName, queryName);
            QueryPanelInfo[] qpi = new QueryPanelInfo[n];
            for (int i = 0; i < n; ++i) {
                qpi[i] = solution.getQueryPanelInfo().get(i);
            }
            if (qpi[0] != null) {
                try {
                    byte[] bs = qpi[0].getParam();
                    if (bs != null) {
                        this.filter = (RptParams)CommonUtil.getObject((byte[])bs);
                    }
                    if (this.filter != null) {
                        CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.filter);
                        for (int i = 0; i < n; ++i) {
                            this.userPanels[i].setCustomerParams(cp);
                        }
                    } else {
                        CustomerParams[] cp = new CustomerParams[n];
                        for (int i = 0; i < n; ++i) {
                            cp[i] = CustomerParams.getCustomerParams2((String)qpi[i].getCustomerParams());
                            if (cp[i] == null) continue;
                            Object obj = RptParamsUtil.getFromCustomerParams((CustomerParams)cp[i]);
                            if (obj instanceof RptParams) {
                                this.filter = (RptParams)obj;
                                continue;
                            }
                            if (this.filter == null) {
                                this.filter = new RptParams();
                            }
                            for (int j = 0; j < n; ++j) {
                                if (!this.userPanels[j].getClass().toString().endsWith(qpi[i].getPanelClassName().toString())) continue;
                                this.userPanels[j].setCustomerParams(cp[i]);
                                this.filter.putAll((Map)this.userPanels[j].getCustomerParams().getCustomerParamsHashMap());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isShowFilter() {
        return this.showFilter;
    }

    public void setShowFilter(boolean showFilter) {
        this.showFilter = showFilter;
    }

    public boolean isShowSorter() {
        return this.showSorter;
    }

    public void setShowSorter(boolean showSorter) {
        this.showSorter = showSorter;
    }

    public static boolean showFilterDialog(String filterUIName, QueryFilterUIDialogAdapter adapter, boolean useDefaultSolution) throws Exception {
        if (adapter.queryDialog == null) {
            String[] uiName = filterUIName.split(",");
            CustomerQueryPanel[] filterUIs = new CustomerQueryPanel[uiName.length];
            for (int i = 0; i < uiName.length; ++i) {
                CustomerQueryPanel filterUI;
                filterUIs[i] = filterUI = (CustomerQueryPanel)Class.forName(uiName[i]).newInstance();
            }
            adapter.setCustomerQueryPanel(filterUIs);
        }
        return adapter.showQueryDialog(useDefaultSolution);
    }
}

