/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.DefaultReportMoveImp;
import com.kingdee.eas.base.report.HiberarchyObject;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.IReportConnectQuery;
import com.kingdee.eas.base.report.IReportManager;
import com.kingdee.eas.base.report.IReportMove;
import com.kingdee.eas.base.report.IReportViewer;
import com.kingdee.eas.base.report.MenuBarPropertyEvent;
import com.kingdee.eas.base.report.ReportCellTreeRenderer;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportRowObject;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.VirtualRowSet;
import com.kingdee.eas.base.report.client.AbstractReportViewerUI;
import com.kingdee.eas.base.report.client.MenuBuilder;
import com.kingdee.eas.base.report.client.MoveReportMultiPrinter;
import com.kingdee.eas.base.report.client.ReportQueryDlg;
import com.kingdee.eas.base.report.client.note.ReportNotePrintHelper;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatCondition;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.base.report.formatcondition.ReportFromatCell;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class ReportViewerUI
extends AbstractReportViewerUI
implements KDTDataRequestListener,
IReportViewer,
KDTMouseListener {
    private static final long serialVersionUID = 1L;
    public static final String strResource = "com.kingdee.eas.base.report.ReportFramework_Resource.";
    IRowSet rs;
    private List rshiberarchy = new ArrayList();
    private KDTDataFillListener kdtDataFillListener = null;
    private boolean ishiberarchyreport;
    private ReportHeader header;
    private ReportCellTreeRenderer hiberarchyRender = null;
    private int rowCount = 0;
    private KDTSortManager sm;
    private boolean colIsMergeable = false;
    private static final Logger logger = CoreUIObject.getLogger(ReportViewerUI.class);
    protected IReport report;
    public final String RPTKEY = "report";
    public static final String UICONTEXT_KEY_BE_JOINQUERY = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_BE_JOINQUERY";
    public static final String UICONTEXT_KEY_JOINQUERY_PARAMS = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_PARAMS";
    public static final String UICONTEXT_KEY_JOINQUERY_DATA = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_DATA";
    private ReportQueryDlg filterDlg;
    private MenuBuilder menuBuilder = new MenuBuilder((JToolBar)this.toolBar, (JMenu)this.menuEdit);

    public boolean destroyWindow() {
        if (this.report != null) {
            try {
                ReportFactory.releaseLicense1(this.report.getReportProperty().getFilterPanelName());
                this.report.closeReport();
            }
            catch (BaseException baseException) {
                // empty catch block
            }
        }
        return super.destroyWindow();
    }

    @Override
    public void actionNoteSetup_actionPerformed(ActionEvent e) throws Exception {
        ReportNotePrintHelper helper = new ReportNotePrintHelper();
        helper.writeMetaClass(this.report);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.report.ReportFramework_Resource.PRINT_TEMPLATE_SETTING_PROMPT"));
    }

    public ReportViewerUI() throws Exception {
        this.filterDlg = ReportQueryDlg.getDefaultReportQueryDlg(this);
        this.menuEdit.setMnemonic('V');
        this.menuItemRefresh.setMnemonic('R');
        this.menuItemPrint.setMnemonic('P');
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.menuItemPrintPreview.setMnemonic('V');
        this.menuItemPrintPreview.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.menuItemFilter.setMnemonic('F');
    }

    private void initKDTable() {
        this.tableMain.getDataRequestManager().setDataRequestMode(1);
        this.tableMain.removeKDTDataRequestListener((KDTDataRequestListener)this);
        this.tableMain.addKDTDataRequestListener((KDTDataRequestListener)this);
        this.tableMain.removeKDTMouseListener((KDTMouseListener)this);
        this.tableMain.addKDTMouseListener((KDTMouseListener)this);
        if (this.kdtDataFillListener == null) {
            this.kdtDataFillListener = new KDTDataFillListener(){

                public void afterDataFill(KDTDataRequestEvent e) {
                    if (ReportViewerUI.this.tableMain.getDataRequestManager().isExporting()) {
                        return;
                    }
                    List blocks = ReportViewerUI.this.tableMain.getMergeManager().getMergeBlockList();
                    int size = blocks.size();
                    for (int i = 0; i < size; ++i) {
                        KDTMergeBlock block = (KDTMergeBlock)blocks.get(i);
                        if (block.getLeft() == block.getRight() && block.getTop() == block.getBottom()) continue;
                        int rowIndex2 = block.getBottom();
                        for (int rowIndex1 = block.getTop(); rowIndex1 <= rowIndex2; ++rowIndex1) {
                            int columnIndex2 = block.getRight();
                            for (int columnIndex1 = block.getLeft(); columnIndex1 <= columnIndex2; ++columnIndex1) {
                                try {
                                    ICell cell = ReportViewerUI.this.tableMain.getCell(rowIndex1, columnIndex1);
                                    if (cell == null) continue;
                                    cell.getStyleAttributes().setBackground(Color.WHITE);
                                    continue;
                                }
                                catch (Exception e1) {
                                    try {
                                        FileOutputStream out = new FileOutputStream("c:\\myErrorDump.txt");
                                        PrintStream p = new PrintStream(out);
                                        e1.printStackTrace(p);
                                        p.println("-----------------------");
                                        p.println("blocks info:");
                                        p.println(blocks.toString());
                                        p.println("row count = " + ReportViewerUI.this.tableMain.getRowCount3() + ", col count=" + ReportViewerUI.this.tableMain.getColumnCount());
                                        p.println("rowIndex1 = " + rowIndex1 + ", columnIndex1=" + columnIndex1);
                                        ICell c = ReportViewerUI.this.tableMain.getCell(rowIndex1, columnIndex1);
                                        p.println("tableMain.getCell(rowIndex1, columnIndex1) is null? " + (c == null));
                                        if (c == null) continue;
                                        p.println("tableMain.getCell(rowIndex1, columnIndex1).getStyleAttributes = " + (c.getStyleAttributes() == null));
                                        continue;
                                    }
                                    catch (Exception e2) {
                                        MsgBox.showWarning((String)e2.getStackTrace().toString());
                                    }
                                }
                            }
                        }
                    }
                }
            };
        } else {
            this.tableMain.removeKDTDataFillListener(this.kdtDataFillListener);
        }
        this.tableMain.addKDTDataFillListener(this.kdtDataFillListener);
        this.tableMain.getStyleAttributes().setLocked(true);
        this.rshiberarchy.clear();
    }

    private void comparehead() {
        if (this.header == null) {
            return;
        }
        for (int i = 0; i < this.tableMain.getColumnCount(); ++i) {
            IColumn col = this.tableMain.getColumn(i);
            String key = col.getKey();
            ReportHeader tmheader = (ReportHeader)this.header.getAllChilds().get(key);
            if (tmheader == null) continue;
            tmheader.setVisible(!col.getStyleAttributes().isHided());
        }
    }

    private void setHiberarchyReportStatus(KDTable table) {
        HashMap allheader = this.report.getReportHeader().getAllChilds();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            ReportHeader rh = (ReportHeader)allheader.get(table.getColumn(i).getKey());
            if (!rh.isIshiberarchy()) continue;
            this.ishiberarchyreport = true;
            break;
        }
    }

    public KDPanel getTitlesPanel() {
        return this.titlesPanel;
    }

    public MenuBuilder getMenuBuilder() {
        return this.menuBuilder;
    }

    public void showReport(IReport report) {
        this.header = report.getReportHeader();
        this.comparehead();
        this.initKDTable();
        this.tableMain.removeColumns();
        this.report = report;
        this.setTableSelectMode();
        this.setUITitle(report.getReportProperty().getName());
        this.buildReportHeader();
        if (report.getReportProperty().getReporttye() == 0) {
            this.buildReportTitle(report.getReportTitles());
        }
        this.setHiberarchyReportStatus(this.tableMain);
        if (this.ishiberarchyreport) {
            IRowSet rslocal = report.getData();
            this.showData(this.tableMain, rslocal);
            this.tableMain.setRowCount(rslocal.size());
        } else {
            this.tableMain.setRowCount(-1);
            this.tableMain.setRefresh(true);
            this.tableMain.repaint();
        }
        if (!this.colIsMergeable && report.isSort().booleanValue() && report.totalRowCount() <= 1) {
            this.sm = new KDTSortManager(this.tableMain);
            this.sm.setSortAuto(true);
            int sortClickType = report.sortClickType();
            System.out.println("\u62a5\u8868\u4e8c\u6b21\u5f00\u53d1\u8bbe\u7f6e\uff0c\u8fc7\u6ee4\u64cd\u4f5c\u5355\u51fb\u7c7b\u578b\u4e3a:" + sortClickType);
            this.sm.setClickCount(sortClickType);
        }
    }

    private void setTableSelectMode() {
        boolean mutilSelect = this.report.getReportProperty().isMultiSelect();
        boolean cellSelect = this.report.getReportProperty().isCellSelect();
        int selectMode = mutilSelect ? (cellSelect ? 15 : 10) : (cellSelect ? 1 : 2);
        this.tableMain.getSelectManager().setSelectMode(selectMode);
    }

    protected void close() {
        SysUtil.abort();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onLoad() throws Exception {
        super.onLoad();
        Map ctx = this.getUIContext();
        this.hiberarchyRender = new ReportCellTreeRenderer();
        String uiParam = (String)ctx.get("UIClassParam");
        if (uiParam != null) {
            IReport report = ReportFactory.createReport(uiParam, null);
            this.filterDlg.setTitle(report.getReportProperty().getName());
            if (Boolean.valueOf(String.valueOf(ctx.get(UICONTEXT_KEY_BE_JOINQUERY))).booleanValue()) {
                RptParams filter = (RptParams)ctx.get(UICONTEXT_KEY_JOINQUERY_PARAMS);
                HashMap mapData = (HashMap)ctx.get(UICONTEXT_KEY_JOINQUERY_DATA);
                if (!(report instanceof IReportConnectQuery)) throw new ReportException(ReportException.REPORT_NOT_CONNECTQUERY, new Object[]{report.getReportProperty().getName()});
                ((IReportConnectQuery)((Object)report)).ConnectQuery(filter, mapData);
            } else {
                String filterUIName = report.getFilterPanelName();
                if (filterUIName != null && filterUIName.trim().length() > 0) {
                    try {
                        if (!this.showFilter(report, true)) {
                            ReportFactory.releaseLicense1(report.getReportProperty().getFilterPanelName());
                            this.close();
                            return;
                        }
                        report.setFilter(this.filterDlg.getFilter());
                    }
                    catch (Exception e) {
                        ReportFactory.releaseLicense1(report.getReportProperty().getFilterPanelName());
                        throw e;
                    }
                } else {
                    report.setFilter(new RptParams());
                }
            }
            this.initUserConfig();
            report.Refresh();
            report.setReportViewer(this);
            this.showReport(report);
            if (report instanceof IReportMove) {
                this.initMoveButton();
                this.enableButtonState();
            }
            report.getReportEventProxy().fireOnInitialize();
            return;
        } else {
            RptParams filter = (RptParams)ctx.get("rptparams");
            Object rptKey = ctx.get("report");
            IReport report = null;
            report = rptKey instanceof String ? ReportFactory.createReport((String)rptKey, null) : (IReport)rptKey;
            this.filterDlg.setTitle(report.getReportProperty().getName());
            report.setFilter(filter);
            report.Refresh();
            report.setReportViewer(this);
            this.showReport(report);
            if (report instanceof IReportMove) {
                this.initMoveButton();
                this.enableButtonState();
            }
            report.getReportEventProxy().fireOnInitialize();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void initMoveButton() {
        this.addNavigatingToolbarButton("btnFirst", "NAVIGATING_FIRST", "imgTbtn_first", null, "", true, true, true);
        this.addNavigatingToolbarButton("btnPrev", "NAVIGATING_PREVIOUS", "imgTbtn_previous", null, "", true, true, false);
        this.addNavigatingToolbarButton("btnNext", "NAVIGATING_NEXT", "imgTbtn_next", null, "", true, true, false);
        this.addNavigatingToolbarButton("btnLast", "NAVIGATING_LAST", "imgTbtn_last", null, "", true, true, false);
        this.addNavigatingToolbarButton("btnMoveto", "NAVIGATING_GOTO", "imgTbtn_move", null, "", true, true, false);
    }

    private void addNavigatingToolbarButton(String name, String resourceKey, String imageKey, Object image, String shortcut, boolean enabled, boolean visible, boolean beginGroup) {
        String description = EASResource.getString((String)(strResource + resourceKey + "_DESC"));
        this.addBarItem(name, EASResource.getString((String)(strResource + resourceKey)), description, description, imageKey, image, shortcut, enabled, visible, beginGroup);
    }

    private boolean showFilter(IReport report, boolean useDefaultSolution) throws Exception {
        String op = this.getLogActionName(report, this.menuItemFilter.getText());
        IObjectPK pk = LogUtil.beginLog(null, (String)op, (BOSObjectType)new BOSObjectType("CE4FCE63"), null, (String)op);
        String filterUIName = report.getFilterPanelName();
        boolean ret = true;
        if (filterUIName != null && filterUIName.trim().length() > 0) {
            ret = this.filterDlg.showFilterDialog(filterUIName, useDefaultSolution);
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
        return ret;
    }

    protected void buildReportHeader() {
        this.tableMain.getHeadMergeManager().setMergeMode(3);
        this.tableMain.getHeadMergeManager().setMergeMode(0);
        this.tableMain.getGroupManager().setGroup(true);
        this.tableMain.getStyleAttributes().setWrapText(false);
        this.buildTableColumn(this.tableMain, this.header);
        int maxLevel = this.header.getMaxLevel();
        for (int i = 0; i < maxLevel; ++i) {
            this.tableMain.addHeadRow();
        }
        this.buildTableHeader(this.tableMain, null, this.header, maxLevel);
    }

    protected void buildReportTitle(ReportTitles reportTitles) {
        boolean isExistsTitles = false;
        this.titlesPanel.removeAll();
        this.titlesPanel.setVisible(false);
        if (reportTitles != null) {
            int row = 0;
            int col = 0;
            int maxRows = 0;
            for (int i = 12; i > 0; --i) {
                String sTitle = reportTitles.getTitle(i - 1);
                if (sTitle == null) continue;
                maxRows = (i - 1) / 3 + 1;
                isExistsTitles = true;
                break;
            }
            if (isExistsTitles) {
                TableLayout layout = TableLayout.split((int)maxRows, (int)3);
                layout.getStyle().setMarginLeft(4);
                layout.getStyle().setMarginTop(3);
                layout.getStyle().setMarginBottom(3);
                this.titlesPanel.setLayout((LayoutManager)layout);
                for (int i = 0; i < 12; ++i) {
                    String sTitle = reportTitles.getTitle(i);
                    if (sTitle == null) continue;
                    KDLabel label = new KDLabel(sTitle);
                    col = i % 3;
                    row = i / 3;
                    this.titlesPanel.add((Component)label, (Object)layout.cell(row, col));
                }
            }
            Rectangle r = (Rectangle)this.getClientProperty("OriginalBounds");
            int y = maxRows * 15 + 10;
            this.add((Component)this.titlesPanel, new KDLayout.Constraints(5, 5, r.width, y + 20 - 5, 13));
            this.add((Component)this.tableMain, new KDLayout.Constraints(5, y + 20, r.width - 10, r.height - y - 20 - 5, 15));
            this.titlesPanel.setVisible(isExistsTitles);
        }
    }

    protected void buildTableHeader(KDTable table, IRow row, ReportHeader header, int maxLevel) {
        ArrayList child = header.getChilds();
        if (child != null) {
            ReportHeader leftChild;
            IRow newRow = table.getHeadRow(header.getLevel());
            if (newRow != null) {
                newRow.getStyleAttributes().setWrapText(true);
            }
            for (int i = 0; i < child.size(); ++i) {
                this.buildTableHeader(table, newRow, (ReportHeader)child.get(i), maxLevel);
            }
            if (child.size() > 1 && header.getCaption() != null && row != null && (leftChild = header.getMostLeftChild()) != null) {
                ICell cell = row.getCell(leftChild.getFieldName());
                cell.setValue((Object)header.getCaption());
                KDTMergeManager mm = table.getHeadMergeManager();
                mm.mergeBlock(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + header.getAllLeafCount() - 1, 4);
            }
        } else if (row != null) {
            row.getStyleAttributes().setWrapText(true);
            ICell cell = row.getCell(header.getFieldName());
            cell.setValue((Object)header.getCaption());
            KDTMergeManager mm = table.getHeadMergeManager();
            if (maxLevel > header.getLevel()) {
                mm.mergeBlock(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex() + (maxLevel - header.getLevel()), cell.getColumnIndex(), 4);
            }
        }
    }

    protected void buildTableColumn(KDTable table, ReportHeader header) {
        ArrayList arrayList = header.getChilds();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.buildTableColumn(table, (ReportHeader)arrayList.get(i));
            }
        } else {
            IColumn col = table.addColumn();
            if (header.isMergeable()) {
                col.setGroup(true);
                col.setMergeable(true);
                if (!this.colIsMergeable) {
                    this.colIsMergeable = true;
                }
            }
            col.setKey(header.getFieldName());
            col.setWidth(header.getWidth());
            col.setSortable(true);
            StyleAttributes st = col.getStyleAttributes();
            st.setHided(!header.isVisible());
            Styles.HorizontalAlignment align = Styles.HorizontalAlignment.NORMAL;
            switch (header.getAlign()) {
                case 1: {
                    align = Styles.HorizontalAlignment.LEFT;
                    break;
                }
                case 3: {
                    align = Styles.HorizontalAlignment.RIGHT;
                    break;
                }
                case 2: {
                    align = Styles.HorizontalAlignment.CENTER;
                    break;
                }
            }
            st.setHorizontalAlign(align);
        }
    }

    protected void showData(KDTable table, IRowSet data) {
        try {
            HashMap allheader = this.report.getReportHeader().getAllChilds();
            IRowSet rslocal = null;
            if (data instanceof VirtualRowSet) {
                rslocal = ((VirtualRowSet)data).getRs(0);
            }
            int index = 0;
            while (rslocal.next()) {
                ++index;
                IRow row = table.addRow();
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    ICell cell = row.getCell(j);
                    IColumn col = table.getColumn(j);
                    this.setFormatValue(cell, (ReportHeader)allheader.get(col.getKey()), rslocal.getObject(col.getKey()), rslocal, 1, "", index);
                }
                this.formatCondition(this.report.getReportFormatConditions(), row, (RowSet)rslocal);
                ReportRowObject reportRowObject = new ReportRowObject();
                reportRowObject.setRowindex(index);
                reportRowObject.setRs(rslocal);
                reportRowObject.setDataRowIndex(index);
                row.setUserObject((Object)reportRowObject);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        KDTable table = (KDTable)e.getSource();
        try {
            this.rs = this.report.getData(from, len);
            HashMap allheader = this.report.getReportHeader().getAllChilds();
            if (this.rs.absolute(from)) {
                if (0 == from) {
                    this.rowCount = this.report.getRowCount();
                    if (this.rowCount > 0) {
                        table.setRowCount(this.rowCount);
                    }
                }
                int index = 0;
                IRowSet rslocal = null;
                rslocal = this.rs instanceof VirtualRowSet ? ((VirtualRowSet)this.rs).getRs(from) : this.rs;
                table.setRefresh(false);
                for (int i = 0; i < len; ++i) {
                    IRow row = null;
                    row = this.rowCount > 0 ? table.addRow(from + i) : table.addRow();
                    index = rslocal.getRow();
                    for (int j = 0; j < table.getColumnCount(); ++j) {
                        IColumn col = table.getColumn(j);
                        ICell cell = row.getCell(j);
                        this.setFormatValue(cell, (ReportHeader)allheader.get(col.getKey()), rslocal.getObject(col.getKey()), rslocal, 1, "", index);
                    }
                    this.formatCondition(this.report.getReportFormatConditions(), row, (RowSet)rslocal);
                    ReportRowObject reportRowObject = new ReportRowObject();
                    reportRowObject.setRowindex(from + i);
                    reportRowObject.setRs(rslocal);
                    reportRowObject.setDataRowIndex(index);
                    row.setUserObject((Object)reportRowObject);
                    if (!rslocal.next()) break;
                }
                if (this.rowCount > 0) {
                    table.setRefresh(true);
                    table.reLayoutAndPaint();
                }
            }
            if (!this.colIsMergeable && this.report.isSort().booleanValue() && this.report.totalRowCount() == 1 && this.sm != null && from + len > table.getRowCount3()) {
                this.sm.addGroup(0, table.getRowCount3() - 2);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private Object castValue(Object value, Object referValue) {
        if (value.getClass().equals(referValue.getClass())) {
            return value;
        }
        if (value instanceof String && ((String)value).trim().length() > 0) {
            if (referValue instanceof BigDecimal) {
                return new BigDecimal((String)value);
            }
            if (referValue instanceof Integer) {
                return new Integer((String)value);
            }
            return null;
        }
        return null;
    }

    private void formatCondition(ReportFormatConditions conditions, IRow row, RowSet data) throws SQLException {
        if (conditions != null) {
            Vector vctCondtion = conditions.getFormatConditions();
            block10: for (int i = 0; i < vctCondtion.size(); ++i) {
                ReportFormatCondition condition = (ReportFormatCondition)vctCondtion.get(i);
                Object value = data.getObject(condition.getFieldName());
                if (value == null) {
                    value = "";
                }
                Object valueTo = this.castValue(condition.getCellValue(), value);
                Object valueTo2 = null;
                if (condition.getCellValue2() != null) {
                    valueTo2 = this.castValue(condition.getCellValue2(), value);
                }
                if (!(value instanceof Comparable)) continue;
                Comparable c = (Comparable)value;
                switch (condition.getCondition()) {
                    case 1: {
                        if (c.compareTo(valueTo) != 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 2: {
                        if (c.compareTo(valueTo) == 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 6: {
                        if (c.compareTo(valueTo) <= 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 7: {
                        if (c.compareTo(valueTo) < 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 5: {
                        if (c.compareTo(valueTo) >= 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 8: {
                        if (c.compareTo(valueTo) > 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 3: {
                        if (c.compareTo(valueTo) < 0 || c.compareTo(valueTo2) > 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                        continue block10;
                    }
                    case 4: {
                        if (c.compareTo(valueTo) >= 0 || c.compareTo(valueTo2) <= 0) continue block10;
                        this.executeMatchCondition(row, condition.getFieldName(), condition);
                    }
                }
            }
        }
    }

    private void executeMatchCondition(IRow row, String key, ReportFormatCondition condition) {
        Appearance apr = condition.getAppearance();
        if (condition.isApplyRow()) {
            apr.ApplyRowAppearnce(row);
        } else {
            ICell cell = row.getCell(key);
            apr.ApplyCellAppearnce(cell);
        }
    }

    private String getLogActionName(String oprName) {
        return this.getLogActionName(this.report, oprName);
    }

    private String getLogActionName(IReport report, String oprName) {
        String op = null;
        int pos = oprName.indexOf(40);
        if (pos >= 0) {
            op = oprName.substring(0, pos);
        }
        if (report != null && report.getReportProperty() != null && report.getReportProperty().getName() != null) {
            op = report.getReportProperty().getName() + "--" + op;
        }
        return op;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkPrintPermission();
        String op = this.getLogActionName(this.menuItemPrint.getText());
        IObjectPK pk = LogUtil.beginLog(null, (String)op, (BOSObjectType)new BOSObjectType("CE4FCE63"), null, (String)op);
        this.report.getReportEventProxy().fireBeforePrint(false);
        if (!this.chkMenuItemNote.isSelected()) {
            if (this.report instanceof IReportMove) {
                MoveReportMultiPrinter mrmp = new MoveReportMultiPrinter(this.report, this.getUITitle(), (Component)((Object)this));
                mrmp.doMultiPrint();
            } else {
                this.buildPrintHeader();
                this.tableMain.getPrintManager().print();
            }
        } else {
            ReportNotePrintHelper helper = new ReportNotePrintHelper();
            helper.print(this.report, (Component)((Object)this));
        }
        this.report.getReportEventProxy().fireAfterPrint();
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private void checkPrintPermission() throws Exception {
        String printPermission = this.report.getReportProperty().getPrintPermissionItem();
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkPrintPermission();
        this.report.getReportEventProxy().fireBeforePrint(true);
        if (!this.chkMenuItemNote.isSelected()) {
            if (this.report instanceof IReportMove) {
                int curPage = ((DefaultReportMoveImp)this.report).getCurrentPos();
                MoveReportMultiPrinter mrmp = new MoveReportMultiPrinter(this.report, this.getUITitle(), (Component)((Object)this));
                mrmp.doMultiPreView();
                ((DefaultReportMoveImp)this.report).moveTo(curPage);
            } else {
                this.buildPrintHeader();
                this.tableMain.getPrintManager().printPreview();
            }
        } else {
            ReportNotePrintHelper helper = new ReportNotePrintHelper();
            helper.printPreview(this.report, (Component)((Object)this));
        }
    }

    private void buildPrintHeader() {
        ReportTitles titles = this.report.getReportTitles();
        if (titles != null) {
            HeadFootModel header = new HeadFootModel();
            String title = this.getUITitle();
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setBold(true);
            sa.setFontSize(12);
            header.addRow(title, sa);
            String sTitles = null;
            String sText = "";
            int count = 0;
            int i = 0;
            int j = 1;
            while (i < 12) {
                sTitles = titles.getTitle(i);
                if (sTitles == null) {
                    sTitles = " ";
                }
                sText = sText.equals("") ? sTitles : sText + "&|" + sTitles;
                if (j % 3 == 0) {
                    j = 0;
                    HeadFootRow headertemp = new HeadFootRow();
                    headertemp.setText(sText);
                    header.addRow(headertemp);
                    ++count;
                    sText = "";
                }
                ++i;
                ++j;
            }
            HeadFootModel foot = new HeadFootModel();
            String footText = EASResource.getString((String)"com.kingdee.eas.base.report.ReportFramework_Resource.PRINT_FOOT_INFO");
            foot.addRow(footText);
            Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
            Page fPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)foot);
            this.tableMain.getPrintManager().setHeaderHeight(350);
            this.tableMain.getPrintManager().setHeaderFooter(hPage, fPage);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.rowCount = 0;
        this.report.Refresh();
        this.enableButtonState();
        this.showReport(this.report);
    }

    protected void setFormatValue(ICell cell, ReportHeader header, Object cellValue, IRowSet rsData, int level, String parentKey, int rsRowIndex) throws Exception {
        if (rsData == null || rsData.size() == 0) {
            return;
        }
        String sText = null;
        cell.getStyleAttributes().setNumberFormat(ReportFromatCell.getFormatString(header, cellValue, (RowSet)rsData));
        HiberarchyObject hiberarchyObject = null;
        if (header.isIshiberarchy()) {
            if (!this.ishiberarchyreport) {
                this.ishiberarchyreport = true;
            }
            hiberarchyObject = new HiberarchyObject();
            hiberarchyObject.setKey(BOSUuid.create((String)"D06006D0").toString());
            hiberarchyObject.setLevel(level);
            hiberarchyObject.setRows(rsData.size());
            hiberarchyObject.setParentKey(parentKey);
            hiberarchyObject.setRowindex(rsRowIndex);
            hiberarchyObject.setRs(rsData);
            if (cellValue != null && cellValue.toString() != null && cellValue.toString().trim().length() > 0) {
                String leaffield = header.getFleaffield().toString();
                if (!"".equals(leaffield) && this.hasFieldName(rsData, leaffield) && "1".equals(rsData.getString(leaffield).toString())) {
                    hiberarchyObject.setLeaf(true);
                }
                cell.setRenderer((IBasicRender)this.hiberarchyRender);
                hiberarchyObject.setCaption(cellValue.toString());
            } else {
                hiberarchyObject.setCaption("");
            }
        }
        CellEvent event = new CellEvent(this, header, cellValue);
        this.report.getReportEventProxy().fireCellFormat(event);
        if (event.isHandled()) {
            sText = event.getDisplayValue();
            cell.setValue((Object)sText);
        } else if (header.isIshiberarchy() && hiberarchyObject != null) {
            cell.setValue((Object)hiberarchyObject);
        } else if (header.getType() == 2 && cellValue != null) {
            BigDecimal b;
            BigDecimal a = new BigDecimal(String.valueOf(cellValue));
            if (a.compareTo(b = SysConstant.BIGZERO) == 0) {
                cell.setValue(null);
            } else {
                cell.setValue(cellValue);
            }
        } else if (header.getType() == 3 && cellValue != null) {
            if (cellValue.toString().equals("0")) {
                cell.setValue((Object)Boolean.FALSE);
            } else {
                cell.setValue((Object)Boolean.TRUE);
            }
        } else {
            cell.setValue(cellValue);
        }
    }

    private boolean hasFieldName(IRowSet rs, String fieldName) {
        boolean bresult = false;
        try {
            ResultSetMetaData rsm = rs.getMetaData();
            for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                if (!rsm.getColumnName(i).equalsIgnoreCase(fieldName)) continue;
                bresult = true;
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bresult;
    }

    @Override
    public void removeBarItem(String name) {
    }

    @Override
    public void addBarItem(String name, String caption, String description, String toolTipText, String imageKey, Object image, String shortcut, boolean enabled, boolean visible, boolean beginGroup) {
        if (!this.menuBuilder.isExistsMenu(name)) {
            IItemAction action = (IItemAction)ActionProxyFactory.getProxy((Object)((Object)new ActionUserButton((IUIObject)this, name, caption, description)), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext());
            this.menuBuilder.addBarItem(name, caption, description, toolTipText, imageKey, image, beginGroup, action);
            if (shortcut != null && shortcut.toString() != "") {
                action.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke(shortcut));
            }
        }
    }

    @Override
    public void setActionVisiable(String actionName, boolean visiable) {
        ItemAction action = this.getActionManager().getAction(actionName);
        if (action != null) {
            action.setVisible(visiable);
            if ("actionNoteSetup".equals(actionName)) {
                this.chkMenuItemNote.setVisible(visiable);
            }
        }
    }

    @Override
    public void setActionEnable(String actionName, boolean enable) {
        ItemAction action = this.getActionManager().getAction(actionName);
        if (action != null) {
            action.setEnabled(enable);
            if ("actionNoteSetup".equals(actionName)) {
                this.chkMenuItemNote.setEnabled(enable);
            }
        }
    }

    public void actionUserBotton_actionPerformed(ActionEvent e) throws Exception {
        String buttonName = ((Component)e.getSource()).getName();
        if (buttonName.equals("btnFirst")) {
            this.moveFirst();
        } else if (buttonName.equals("btnLast")) {
            this.moveLast();
        } else if (buttonName.equals("btnNext")) {
            this.moveNext();
        } else if (buttonName.equals("btnPrev")) {
            this.movePrev();
        } else if (buttonName.equals("btnMoveto")) {
            this.moveTo();
        }
        this.report.getReportEventProxy().fireOnMenuClick(buttonName);
    }

    private void moveTo() {
        IReportMove reportMove = (IReportMove)((Object)this.report);
        try {
            int count = 0;
            IRowSet rslist = null;
            if (!(this.report instanceof DefaultReportMoveImp)) {
                return;
            }
            DefaultReportMoveImp moveImp = (DefaultReportMoveImp)this.report;
            rslist = moveImp.getDataList();
            count = rslist.size();
            if (count == 0) {
                return;
            }
            String ldf = moveImp.getListDisplayFileName();
            Object[] str = new String[count];
            rslist.beforeFirst();
            for (int i = 0; i < count; ++i) {
                if (ldf == null || ldf == "") {
                    str[i] = String.valueOf(i + 1);
                    continue;
                }
                rslist.absolute(i + 1);
                str[i] = rslist.getString(ldf).toString();
            }
            Object val = JOptionPane.showInputDialog(null, "", EASResource.getString((String)"com.kingdee.eas.base.report.ReportFramework_Resource.PROMPT_CHOOSE_GOTO_PAGE"), -1, null, str, str[0]);
            if (val == null) {
                return;
            }
            int pos = 0;
            if (ldf == "") {
                pos = Integer.parseInt(val.toString());
            } else {
                for (int i = 0; i < count; ++i) {
                    if (!val.equals(str[i])) continue;
                    pos = i + 1;
                    break;
                }
            }
            reportMove.moveTo(pos);
            this.enableButtonStateAndShowReport();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void moveFirst() {
        IReportMove reportMove = (IReportMove)((Object)this.report);
        try {
            reportMove.moveFirst();
            this.enableButtonStateAndShowReport();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void moveLast() {
        IReportMove reportMove = (IReportMove)((Object)this.report);
        try {
            reportMove.moveLast();
            this.enableButtonStateAndShowReport();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void moveNext() {
        IReportMove reportMove = (IReportMove)((Object)this.report);
        try {
            reportMove.moveNext();
            this.enableButtonStateAndShowReport();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void movePrev() {
        IReportMove reportMove = (IReportMove)((Object)this.report);
        try {
            reportMove.movePrev();
            this.enableButtonStateAndShowReport();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void enableButtonStateAndShowReport() throws SQLException {
        this.enableButtonState();
        this.showReport(this.report);
    }

    private void enableButtonState() throws SQLException {
        if (this.report instanceof IReportMove) {
            IReportMove reportMove = (IReportMove)((Object)this.report);
            if (reportMove.hasData()) {
                MenuBarPropertyEvent event;
                if (reportMove.isFirst()) {
                    event = new MenuBarPropertyEvent("btnPrev", 1, Boolean.FALSE);
                    this.setBarProperty(event);
                } else {
                    event = new MenuBarPropertyEvent("btnPrev", 1, Boolean.TRUE);
                    this.setBarProperty(event);
                }
                if (reportMove.isLast()) {
                    event = new MenuBarPropertyEvent("btnNext", 1, Boolean.FALSE);
                    this.setBarProperty(event);
                } else {
                    event = new MenuBarPropertyEvent("btnNext", 1, Boolean.TRUE);
                    this.setBarProperty(event);
                }
                event = new MenuBarPropertyEvent("btnFirst", 1, Boolean.TRUE);
                this.setBarProperty(event);
                event = new MenuBarPropertyEvent("btnLast", 1, Boolean.TRUE);
                this.setBarProperty(event);
                event = new MenuBarPropertyEvent("btnMoveto", 1, Boolean.TRUE);
                this.setBarProperty(event);
            } else {
                MenuBarPropertyEvent event = new MenuBarPropertyEvent("btnFirst", 1, Boolean.FALSE);
                this.setBarProperty(event);
                event = new MenuBarPropertyEvent("btnPrev", 1, Boolean.FALSE);
                this.setBarProperty(event);
                event = new MenuBarPropertyEvent("btnLast", 1, Boolean.FALSE);
                this.setBarProperty(event);
                event = new MenuBarPropertyEvent("btnNext", 1, Boolean.FALSE);
                this.setBarProperty(event);
                event = new MenuBarPropertyEvent("btnMoveto", 1, Boolean.FALSE);
                this.setBarProperty(event);
            }
        }
    }

    @Override
    public HashMap getCurrentRow() throws SQLException {
        this.checkSelected();
        return this.getOneRowData(this.tableMain.getSelectManager().get().getTop());
    }

    @Override
    public CellEvent getCurrentCell() {
        int selectMode = this.tableMain.getSelectManager().getSelectMode();
        KDTSelectBlock sb = this.tableMain.getSelectManager().get();
        if (selectMode == 1 || selectMode == 15) {
            int col = sb.getLeft();
            int row = sb.getTop();
            try {
                return this.buildCellFormatEvent(col, row);
            }
            catch (SQLException e) {
                return null;
            }
        }
        return null;
    }

    private ReportHeader getReportHeader(String fieldName) {
        return (ReportHeader)this.report.getReportHeader().getAllChilds().get(fieldName);
    }

    private CellEvent buildCellFormatEvent(int col, int row) throws SQLException {
        Object value;
        IColumn tableCol = this.tableMain.getColumn(col);
        boolean level = false;
        boolean irow = false;
        Object hiberarchyObject = null;
        if (this.ishiberarchyreport) {
            IRowSet rslocal = this.getCurrentRs(row);
            value = rslocal.getObject(tableCol.getKey());
        } else {
            IRow ir = this.tableMain.getRow(row);
            ReportRowObject reportRowObject = (ReportRowObject)ir.getUserObject();
            if (!reportRowObject.getRs().absolute(reportRowObject.getDataRowIndex())) {
                return null;
            }
            value = reportRowObject.getRs().getObject(tableCol.getKey());
        }
        System.out.println("value: " + value + " row:" + row);
        ICell cell = this.tableMain.getCell(row, col);
        String displayValue = cell.getValue() == null ? null : cell.getValue().toString();
        CellEvent event = new CellEvent(this, this.getReportHeader(tableCol.getKey()), value, col, row);
        event.setDisplayValue(displayValue);
        return event;
    }

    public void tableClicked(KDTMouseEvent e) {
        block18: {
            int rowIndex = e.getRowIndex();
            int columnIndex = e.getColIndex();
            IColumn column = this.tableMain.getColumn(columnIndex);
            if (column == null) {
                return;
            }
            String key = column.getKey();
            ReportHeader tempheader = (ReportHeader)this.header.getAllChilds().get(key);
            if (e.getClickCount() == 1 && e.getType() == 1) {
                try {
                    CellEvent event;
                    if (tempheader.isIshiberarchy()) {
                        this.cellClicked(rowIndex, columnIndex, e.getX(), e.getY());
                    }
                    if (tempheader.getType() == 3) {
                        // empty if block
                    }
                    if ((event = this.buildCellFormatEvent(e.getColIndex(), e.getRowIndex())) == null) break block18;
                    this.report.getReportEventProxy().fireOnCellClick(event);
                    if (event.isHandled() && event.getOperateType() == 0) {
                        String sText = event.getDisplayValue();
                        this.tableMain.getCell(event.getRow(), event.getCol()).setValue((Object)sText);
                    }
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
            } else if (e.getClickCount() == 2 && e.getType() == 1) {
                String detailReportID = this.report.getReportProperty().getDetailRptID();
                if (detailReportID != null && detailReportID.trim().length() > 0) {
                    try {
                        this.showDetailReport(this.report.getReportProperty().getDetailRptID(), this.report.getFilter(), this.getOneRowData(e.getRowIndex()));
                    }
                    catch (Exception e1) {
                        this.handleException(e1);
                    }
                } else {
                    String keyFieldName = this.report.getReportProperty().getKeyFieldName();
                    String editUIName = this.report.getReportProperty().getEditUIName();
                    try {
                        if (keyFieldName != null && keyFieldName.trim().length() > 0 && editUIName != null && editUIName.trim().length() > 0) {
                            long l = System.currentTimeMillis();
                            this.showEditUI(keyFieldName, editUIName);
                            System.out.println("\u8c03\u7528\u5355\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) / 1000L + "\u79d2");
                        } else {
                            CellEvent event = this.buildCellFormatEvent(e.getColIndex(), e.getRowIndex());
                            if (event != null) {
                                this.report.getReportEventProxy().fireTableDbClick(event);
                            }
                        }
                    }
                    catch (Exception e1) {
                        this.handleException(e1);
                    }
                }
            }
        }
    }

    private HiberarchyObject getCurrentHiberarchyObject(int row) {
        HiberarchyObject hiberarchyObject = null;
        for (int i = 0; i < this.tableMain.getColumnCount(); ++i) {
            Object obj = this.tableMain.getCell(row, i).getValue();
            if (!(obj instanceof HiberarchyObject)) continue;
            hiberarchyObject = (HiberarchyObject)obj;
            break;
        }
        return hiberarchyObject;
    }

    private IRowSet getHiberarchyObjectRowSet(int row) throws SQLException {
        IRowSet rslocal = null;
        HiberarchyObject hiberarchyObject = null;
        hiberarchyObject = this.getCurrentHiberarchyObject(row);
        System.out.println(hiberarchyObject.toString());
        rslocal = hiberarchyObject.getRs();
        rslocal.absolute(hiberarchyObject.getRowindex());
        return rslocal;
    }

    private IRowSet getCurrentRs(int row) throws SQLException {
        IRowSet rslocal = null;
        if (this.ishiberarchyreport) {
            rslocal = this.getHiberarchyObjectRowSet(row);
        } else {
            IRow ir = this.tableMain.getRow(row);
            ReportRowObject rm = (ReportRowObject)ir.getUserObject();
            rslocal = rm.getRs();
            if (rslocal != null) {
                rslocal.absolute(rm.getDataRowIndex());
            }
        }
        return rslocal;
    }

    private HashMap getOneRowData(int row) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IRowSet rslocal = null;
        rslocal = this.getCurrentRs(row);
        ResultSetMetaData meta = rslocal.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            map.put(meta.getColumnName(i).toUpperCase(), rslocal.getObject(meta.getColumnName(i)));
        }
        return map;
    }

    protected void showDetailReport(String detailReportID, RptParams filter, HashMap mapData) throws Exception {
        this.setCursorOfWair();
        String mode = this.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"UIClassParam", (Object)detailReportID);
        ctx.put((Object)UICONTEXT_KEY_BE_JOINQUERY, (Object)true);
        ctx.put((Object)UICONTEXT_KEY_JOINQUERY_PARAMS, (Object)filter);
        ctx.put((Object)UICONTEXT_KEY_JOINQUERY_DATA, (Object)mapData);
        ctx.put((Object)"ID", (Object)("ss" + mapData.hashCode()));
        String reportClassName = "";
        IReportManager reportFacade = ReportFactory.getReportManager(null);
        HashMap map = reportFacade.GetReportByID(detailReportID);
        IRowSet rs = (IRowSet)map.get("report");
        switch (rs.getInt("freporttype")) {
            case 0: {
                reportClassName = "com.kingdee.eas.base.report.client.ReportViewerUI";
                break;
            }
            case 1: {
                reportClassName = "com.kingdee.eas.base.report.client.ReportTreeViewerUI";
            }
        }
        IUIWindow win = UIFactory.createUIFactory((String)mode).create(reportClassName, (Map)ctx, null);
        win.show();
        this.setCursorOfDefault();
    }

    @Override
    public void showEditUI(String keyFieldName, String editUIName) throws Exception {
        String sID;
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        Object id = keyFieldName != "" ? this.getCurrentRow().get(keyFieldName) : this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        if (id instanceof String && (sID = (String)id).trim().length() == 0) {
            return;
        }
        uiContext.put((Object)"ID", id);
        this.report.prepareUIContext(uiContext);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(editUIName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private Object getSelectedKeyValue() throws SQLException {
        String keyFieldName = this.report.getReportProperty().getKeyFieldName();
        int row = this.tableMain.getSelectManager().get().getTop();
        IRowSet rslocal = this.getCurrentRs(row);
        return rslocal.getObject(keyFieldName);
    }

    protected void checkSelected() {
        if (this.tableMain.getRowCount() == 0 || this.tableMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public MenuBarPropertyEvent getBarProperty(String name, int propName) {
        return this.menuBuilder.getMenuProperty(name, propName);
    }

    @Override
    public void setBarProperty(MenuBarPropertyEvent event) {
        this.menuBuilder.setMenuProperty(event);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        this.rowCount = 0;
        if (this.report.getFilterPanelName().trim().toString().equals("")) {
            return;
        }
        if (this.showFilter(this.report, false)) {
            this.report.setFilter(this.filterDlg.getFilter());
            this.Refresh();
        }
    }

    @Override
    public ArrayList getSelectRows() throws SQLException {
        ArrayList<HashMap> listData = new ArrayList<HashMap>();
        int size = this.tableMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tableMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                if (j < 0) continue;
                listData.add(this.getOneRowData(j));
            }
        }
        return listData;
    }

    @Override
    public void Refresh() throws Exception {
        this.initUserConfig();
        this.report.Refresh();
        this.enableButtonState();
        this.showReport(this.report);
    }

    @Override
    public IRowSet getDataSource() throws Exception {
        if (this.tableMain.getSelectManager().get() == null) {
            return this.rs;
        }
        return this.getCurrentRs(this.tableMain.getSelectManager().get().getTop());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cellClicked(int row, int column, int x, int y) {
        HiberarchyObject hiberarchyObject = (HiberarchyObject)this.tableMain.getRow(row).getCell(column).getValue();
        if (this.hiberarchyRender.inRect(hiberarchyObject, x, y)) {
            try {
                this.setCursorOfWair();
                this.doExpand(hiberarchyObject, row, column);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    private void doExpand(HiberarchyObject hiberarchyObject, int rowIndex, int column) throws Exception {
        int rowCount = this.tableMain.getExpandedRowCount();
        if (hiberarchyObject.isLeaf()) {
            return;
        }
        this.tableMain.setRefresh(false);
        System.out.println("doExpend rowcount:" + rowCount);
        if (hiberarchyObject.isExpanded()) {
            for (int i = rowIndex + 1; i < rowCount; ++i) {
                IRow row2 = this.tableMain.getRow(i);
                Object obj = row2.getCell(column).getValue();
                if (!(obj instanceof HiberarchyObject)) continue;
                HiberarchyObject hiberarchyObject2 = (HiberarchyObject)obj;
                if (hiberarchyObject2 == null) {
                    row2.getStyleAttributes().setHided(true);
                    continue;
                }
                if (hiberarchyObject2.getLevel() <= hiberarchyObject.getLevel()) break;
                row2.getStyleAttributes().setHided(true);
                hiberarchyObject.setExpanded(false);
            }
            if (this.ishiberarchyreport) {
                this.tableMain.setRowCount(this.tableMain.getExpandedRowCount());
            }
            hiberarchyObject.setExpanded(false);
        } else if (hiberarchyObject.isHasExpanded()) {
            this.expandRow(rowIndex, column);
            hiberarchyObject.setExpanded(true);
        } else {
            int levle = hiberarchyObject.getLevel() + 1;
            hiberarchyObject.setExpanded(true);
            hiberarchyObject.setHasExpanded(true);
            if (this.showHiberarchyData(this.tableMain, this.getOneRowData(rowIndex), rowIndex, levle, hiberarchyObject.getKey().toString()) == 0) {
                hiberarchyObject.setLeaf(true);
            }
        }
        this.tableMain.setRefresh(true);
        this.tableMain.repaint();
    }

    private int expandRow(int rowIndex, int column) {
        IRow row = this.tableMain.getRow(rowIndex);
        HiberarchyObject hiberarchyObject = (HiberarchyObject)row.getCell(column).getValue();
        int rowCount = this.tableMain.getExpandedRowCount();
        while (++rowIndex < rowCount) {
            IRow row2 = this.tableMain.getRow(rowIndex);
            Object obj = row2.getCell(column).getValue();
            if (!(obj instanceof HiberarchyObject)) continue;
            HiberarchyObject hiberarchyObject1 = (HiberarchyObject)obj;
            if (hiberarchyObject1.getLevel() > hiberarchyObject.getLevel()) {
                row2.getStyleAttributes().setHided(false);
                if (hiberarchyObject1.isExpanded()) {
                    rowIndex = this.expandRow(rowIndex, column);
                    continue;
                }
                if (hiberarchyObject1.isLeaf()) continue;
                rowIndex = this.expandSkipChildren(rowIndex, column);
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }

    private int expandSkipChildren(int rowIndex, int column) {
        HiberarchyObject hiberarchyObject2;
        IRow row2;
        Object obj;
        IRow row = this.tableMain.getRow(rowIndex);
        HiberarchyObject hiberarchyObject = (HiberarchyObject)row.getCell(column).getValue();
        int rowCount = this.tableMain.getRowCount3();
        while (!(++rowIndex >= rowCount || (obj = (row2 = this.tableMain.getRow(rowIndex)).getCell(column).getValue()) instanceof HiberarchyObject && (hiberarchyObject2 = (HiberarchyObject)obj).getLevel() == hiberarchyObject.getLevel() && hiberarchyObject2.getParentKey().toString() == hiberarchyObject.getParentKey().toString())) {
        }
        return rowIndex - 1;
    }

    protected int showHiberarchyData(KDTable table, HashMap subRowdata, int startRow, int level, String parentKey) {
        try {
            IRowSet rslocal = null;
            rslocal = this.report.getHiberarchyData(this.report.getReportProperty().getReportID(), this.report.getFilter(), subRowdata);
            if (rslocal == null || rslocal.size() == 0) {
                return 0;
            }
            this.rshiberarchy.add(rslocal);
            HashMap allheader = this.report.getReportHeader().getAllChilds();
            int i = 0;
            while (rslocal != null && rslocal.next()) {
                IRow row = table.addRow(startRow + ++i);
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    IColumn col = table.getColumn(j);
                    ICell cell = row.getCell(j);
                    this.setFormatValue(cell, (ReportHeader)allheader.get(col.getKey()), rslocal.getObject(col.getKey()), rslocal, level, parentKey, i);
                }
                this.formatCondition(this.report.getReportFormatConditions(), row, (RowSet)rslocal);
            }
            if (this.ishiberarchyreport) {
                this.tableMain.setRowCount(this.tableMain.getExpandedRowCount());
            }
            System.out.println("getdata rowcount:" + this.tableMain.getExpandedRowCount());
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        return 1;
    }

    public Object getTablePreferenceSchemaKey() {
        if (this.filterDlg != null && this.filterDlg.getClass().getName().toString().equals("com.kingdee.eas.base.report.client.CommonQueryDialogAdapter")) {
            Class<?> adapterClass = this.filterDlg.getClass();
            try {
                Field queryDialogField = adapterClass.getDeclaredField("queryDialog");
                Object queryDialogFieldValue = queryDialogField.get(this.filterDlg);
                if (queryDialogFieldValue != null) {
                    Class<?> queryDialogFieldValueClass = queryDialogFieldValue.getClass();
                    Method getCurrSoluInfoMethod = queryDialogFieldValueClass.getMethod("getCurrentSolutionInfo", new Class[0]);
                    Object soluInfo = getCurrSoluInfoMethod.invoke(queryDialogFieldValue, new Object[0]);
                    Object id = null;
                    Method getIdMethod = null;
                    Class<?> soluInfoClass = null;
                    if (soluInfo != null) {
                        soluInfoClass = soluInfo.getClass();
                    } else {
                        Class<?> commonParamClass;
                        Method getCommonParamMethod = queryDialogFieldValueClass.getMethod("getCommonQueryParam", new Class[0]);
                        Object commonParam = getCommonParamMethod.invoke(queryDialogFieldValue, new Object[0]);
                        if (commonParam != null && (soluInfo = (getCurrSoluInfoMethod = (commonParamClass = commonParam.getClass()).getMethod("getCurrentSolutionInfo", new Class[0])).invoke(commonParam, new Object[0])) != null) {
                            soluInfoClass = soluInfo.getClass();
                        }
                    }
                    if (soluInfoClass != null) {
                        getIdMethod = soluInfoClass.getMethod("getId", new Class[0]);
                        id = getIdMethod.invoke(soluInfo, new Object[0]);
                        return id;
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return super.getTablePreferenceSchemaKey();
    }

    public KDTable getTableForPrint() {
        return this.tableMain;
    }

    protected class ActionUserButton
    extends ItemAction {
        private static final long serialVersionUID = 3928731251252993656L;

        public ActionUserButton(IUIObject uiObject, String name, String caption, String description) {
            super(uiObject);
            this.putValue("ShortDescription", caption);
            this.putValue("LongDescription", description);
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            ReportViewerUI.this.rowCount = 0;
            ReportViewerUI.this.getUIContext().put("ORG.PK", ReportViewerUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)ReportViewerUI.this, "ActionUserButton", "actionUserBotton_actionPerformed", e);
        }
    }
}

