/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kds.model.util.Base64Encoder;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUSBKey;
import com.kingdee.eas.base.permission.IUsbKeyUserMap;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.permission.USBKeyFactory;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUSBKeyStateEnum;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.client.AbstractCAConfigUI;
import com.kingdee.eas.base.security.provider.IPKIConfig;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKIConfigFactory;
import com.kingdee.eas.base.security.provider.PKIException;
import com.kingdee.eas.base.security.provider.PKIServerAndClientExtFactory;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.eas.base.security.usbkey.UsbkeyConfigInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class CAConfigUI
extends AbstractCAConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(CAConfigUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.security.client.CAConfigUIResource";
    ISecurityAuthParamManager iSecurityAuthParamManager = null;
    IPKIServerExtProvider serverPKI = null;
    IPKIClientExt2Provider clientPKI = null;
    byte[] cert = null;

    public CAConfigUI() throws Exception {
        this.init();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDTabbedPane2.setSelectedIndex(1);
        this.kDButton3.setEnabled(true);
        this.kDButton4.setEnabled(true);
    }

    private void init() throws Exception {
        this.iSecurityAuthParamManager = SecurityAuthParamManagerFactory.getRemoteInstance();
        IPKIConfig pk = PKIConfigFactory.getRemoteInstance();
        try {
            pk.isCAEnabled();
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"exception_label5"));
            SysUtil.abort();
        }
        this.serverPKI = PKIServerAndClientExtFactory.getServerExtProviderRemote();
        this.clientPKI = PKIServerAndClientExtFactory.getClientExtProvider();
        if (this.clientPKI == null) {
            MsgBox.showInfo((String)(EASResource.getString((String)RESOURCE, (String)"exception_label4") + "\r\n" + EASResource.getString((String)RESOURCE, (String)"exception_label7")));
        } else {
            String isUsbKeyExistent = this.clientPKI.isUsbKeyExistent();
            if (StringUtils.isEmpty((String)isUsbKeyExistent)) {
                MsgBox.showInfo((String)(EASResource.getString((String)RESOURCE, (String)"exception_label4") + "\r\n" + EASResource.getString((String)RESOURCE, (String)"exception_label7")));
            }
        }
    }

    @Override
    public void actionCheckCAConfig_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable1.removeRows();
        UsbkeyConfigInfo usbkeyConfigInfo = this.getUsbkeyConfigInfo();
        String isIDSecondAuthorize = EASResource.getString((String)RESOURCE, (String)"config_label1");
        String isEnableUSBkeyAuth = EASResource.getString((String)RESOURCE, (String)"config_label2");
        String isUsbkeySupplierClass = EASResource.getString((String)RESOURCE, (String)"config_label3");
        String isGetCertFromRAServe = EASResource.getString((String)RESOURCE, (String)"config_label4");
        String isItrusCertFromServePath = EASResource.getString((String)RESOURCE, (String)"config_label5");
        String isSignatureConfigurationMadeUTF8 = EASResource.getString((String)RESOURCE, (String)"config_label6");
        String isSignWhenApprove = EASResource.getString((String)RESOURCE, (String)"config_label7");
        String decimal = EASResource.getString((String)RESOURCE, (String)"config_label8");
        int standValue_USBkeyAuth = this.kDCheckBox1.getSelected();
        int standValue_FromRAServe = this.kDCheckBox2.getSelected();
        int standValue_Approve = this.kDCheckBox3.getSelected();
        boolean standValue_USBkeyAuth_b = standValue_USBkeyAuth == 32;
        boolean standValue_FromRAServe_b = standValue_FromRAServe == 32;
        boolean standValue_Approve_b = standValue_Approve == 32;
        this.setRowTable1(isIDSecondAuthorize, "true", Boolean.toString(this.isIDSecondAuthorize()));
        if (StringUtils.equalsIgnoreCase((String)usbkeyConfigInfo.getUsbkeyUseable(), (String)"unknown")) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u914d\u7f6e\u9879USBKEY_USEABLE\u88ab\u6539\u52a8\uff01");
        }
        this.setRowTable1(isEnableUSBkeyAuth, Boolean.toString(standValue_USBkeyAuth_b), usbkeyConfigInfo.getUsbkeyUseable());
        this.setRowTable1(isGetCertFromRAServe, Boolean.toString(standValue_FromRAServe_b), Boolean.toString(this.isGetCertFromRAServe()));
        this.setRowTable1(isItrusCertFromServePath, "true", Boolean.toString(this.isItrusCertFromServePath()));
        this.setRowTable1(isSignatureConfigurationMadeUTF8, "true", Boolean.toString(this.isSignatureConfigurationMadeUTF8()));
        this.setRowTable1(isSignWhenApprove, "" + Boolean.toString(standValue_Approve_b), this.isSignWhenApprove());
        this.setRowTable1(decimal, "", this.getDecimal());
        this.setRowTable1(isUsbkeySupplierClass, "", usbkeyConfigInfo.getUsbkeySupplierClass());
    }

    public boolean isIDSecondAuthorize() throws BOSException {
        boolean isEnableIDAuthorize = this.iSecurityAuthParamManager.isEnableIDAuthorize();
        return isEnableIDAuthorize;
    }

    public UsbkeyConfigInfo getUsbkeyConfigInfo() throws BOSException {
        UsbkeyConfigInfo usbkeyConfigInfo = this.iSecurityAuthParamManager.getUsbkeyConfigInfo();
        return usbkeyConfigInfo;
    }

    public boolean isGetCertFromRAServe() throws BOSException {
        boolean isGetCertFromRAServe = this.iSecurityAuthParamManager.isGetCertFromRAServe();
        return isGetCertFromRAServe;
    }

    public boolean isItrusCertFromServePath() throws BOSException, Exception {
        boolean isItrusCertFromServePath = this.iSecurityAuthParamManager.isItrusCertFromServePath();
        return isItrusCertFromServePath;
    }

    public boolean isSignatureConfigurationMadeUTF8() throws IOException {
        boolean isUTF8CharSet = this.iSecurityAuthParamManager.isUTF8CharSet();
        return isUTF8CharSet;
    }

    public String isSignWhenApprove() throws BOSException {
        StringBuffer approveInfo = new StringBuffer();
        SignatureFieldInfo info = null;
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        Map signaturConfigMap = facade.getSignatrueConfig();
        for (String key : signaturConfigMap.keySet()) {
            info = (SignatureFieldInfo)signaturConfigMap.get(key);
            approveInfo.append(key + ":" + info.isSignatureWhenApprove() + " ");
        }
        return approveInfo.toString();
    }

    public String getDecimal() throws BOSException {
        StringBuffer decimal = new StringBuffer();
        SignatureFieldInfo info = null;
        Map signatureFieldDecimalInfo = null;
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        Map signaturConfigMap = facade.getSignatrueConfig();
        for (String key : signaturConfigMap.keySet()) {
            info = (SignatureFieldInfo)signaturConfigMap.get(key);
            if (info == null) continue;
            Map signatureFieldsMap = info.getFields();
            signatureFieldDecimalInfo = info.getFieldDecimalInfo();
            decimal.append("[" + key + ",");
            for (Object fieldKey : signatureFieldsMap.keySet()) {
                String field = (String)signatureFieldsMap.get(fieldKey);
                String decimal_temp = (String)signatureFieldDecimalInfo.get(fieldKey);
                if (StringUtils.isEmpty((String)decimal_temp)) continue;
                decimal.append(fieldKey + ":" + field + " decimal:" + decimal_temp);
            }
            decimal.append("] ");
        }
        return decimal.toString();
    }

    public void setRowTable1(String name, String standValue, String value) {
        IRow row = this.kDTable1.addRow();
        row.getCell("column1").setValue((Object)name);
        row.getCell("column3").setValue((Object)standValue);
        row.getCell("column2").setValue((Object)value);
        if (!StringUtils.isEmpty((String)standValue)) {
            int indexAprove = value.indexOf(":");
            if (indexAprove != -1) {
                return;
            }
            if (!standValue.equals(value)) {
                row.getCell("column2").getStyleAttributes().setFontColor(Color.RED);
            }
        }
        row.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionGetCertInfo_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable2.removeRows();
        UsbkeyConfigInfo usbkeyConfigInfo = this.getUsbkeyConfigInfo();
        String isInitUSBKey = EASResource.getString((String)RESOURCE, (String)"cert_label1");
        String usbKeyUserInfo = EASResource.getString((String)RESOURCE, (String)"cert_label2");
        String usbKeyOfferInfo = EASResource.getString((String)RESOURCE, (String)"cert_label3");
        String usbKeySerialNo = EASResource.getString((String)RESOURCE, (String)"cert_label4");
        String usbKeyFinalDate = EASResource.getString((String)RESOURCE, (String)"cert_label5");
        String usbKeyCertBASE64Str = EASResource.getString((String)RESOURCE, (String)"cert_label6");
        this.setRowTable2(isInitUSBKey, this.isUsbkeyInit(this.getUserName()));
        this.setRowTable2(usbKeyUserInfo, this.usbKeyUserInfo());
        this.setRowTable2(usbKeyOfferInfo, this.usbKeyOfferInfo());
        this.setRowTable2(usbKeySerialNo, this.usbKeySerialNo());
        this.setRowTable2(usbKeyFinalDate, this.usbKeyFinalDate());
        this.setRowTable2(usbKeyCertBASE64Str, this.usbKeyCertBASE64Str());
        this.kDTabbedPane2.setSelectedIndex(0);
    }

    public String isUsbkeyInit(String username) throws BOSException, EASBizException {
        IUSBKey usbKey = USBKeyFactory.getRemoteInstance();
        IUser user = UserFactory.getRemoteInstance();
        UserInfo userInfo = user.getUser(username);
        if (userInfo == null) {
            return EASResource.getString((String)RESOURCE, (String)"exception_label3");
        }
        String oql = "select * where user.number='" + userInfo.getNumber() + "'";
        IUsbKeyUserMap usbKeyUserMap = UsbKeyUserMapFactory.getRemoteInstance();
        UsbKeyUserMapInfo usbKeyUserInfo = usbKeyUserMap.getUsbKeyUserMapInfo(oql);
        UserUSBKeyStateEnum keyState = usbKeyUserInfo.getState();
        return keyState.toString();
    }

    public String usbKeyUserInfo() {
        if (this.cert == null) {
            try {
                String isUsbKeyExistent;
                if (this.clientPKI == null) {
                    this.clientPKI = PKIServerAndClientExtFactory.getClientExtProvider();
                }
                if (StringUtils.isEmpty((String)(isUsbKeyExistent = this.clientPKI.isUsbKeyExistent()))) {
                    return EASResource.getString((String)RESOURCE, (String)"exception_label4");
                }
                this.cert = this.clientPKI.exportCertificate();
            }
            catch (Exception e) {
                e.printStackTrace();
                return EASResource.getString((String)RESOURCE, (String)"exception_label4");
            }
        }
        X509Certificate xCert = this.getCert(this.cert);
        String name = xCert.getSubjectDN().getName();
        return name;
    }

    public String usbKeyOfferInfo() throws Exception {
        if (this.cert == null) {
            try {
                this.cert = this.clientPKI.exportCertificate();
            }
            catch (Exception e) {
                return EASResource.getString((String)RESOURCE, (String)"exception_label4");
            }
        }
        X509Certificate xCert = this.getCert(this.cert);
        String name = xCert.getIssuerDN().getName();
        return name;
    }

    public String usbKeySerialNo() throws Exception {
        if (this.cert == null) {
            try {
                this.cert = this.clientPKI.exportCertificate();
            }
            catch (Exception e) {
                return EASResource.getString((String)RESOURCE, (String)"exception_label4");
            }
        }
        X509Certificate xCert = this.getCert(this.cert);
        String number = xCert.getSerialNumber().toString(16);
        return number;
    }

    public String usbKeyFinalDate() throws Exception {
        if (this.cert == null) {
            try {
                this.cert = this.clientPKI.exportCertificate();
            }
            catch (Exception e) {
                return EASResource.getString((String)RESOURCE, (String)"exception_label4");
            }
        }
        X509Certificate xCert = this.getCert(this.cert);
        Date date = xCert.getNotAfter();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sdf.format(date);
        return dateStr;
    }

    public String usbKeyCertBASE64Str() {
        if (this.cert == null) {
            try {
                this.cert = this.clientPKI.exportCertificate();
            }
            catch (Exception e) {
                return EASResource.getString((String)RESOURCE, (String)"exception_label4");
            }
        }
        X509Certificate xCert = this.getCert(this.cert);
        String cert1 = Base64Encoder.byteArrayToBase64((byte[])this.cert);
        return cert1;
    }

    public IRow setRowTable2(String name, Object value) {
        IRow row = this.kDTable2.addRow();
        row.getCell("column1").setValue((Object)name);
        row.getCell("column2").setValue(value);
        row.getStyleAttributes().setLocked(true);
        return row;
    }

    private String getUserName() {
        String userName = this.kDTextField1.getText();
        if (StringUtils.isEmpty((String)userName)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label1"));
            SysUtil.abort();
        }
        return userName;
    }

    public X509Certificate getCert(byte[] certificate) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(certificate);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "TopSM");
            if (bais.available() > 0) {
                return (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (CertificateException e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected void kDTable1_tableClickedAction(KDTMouseEvent e) throws Exception {
        if (e.getRowIndex() > 0) {
            String value = (String)this.kDTable1.getRow(e.getRowIndex()).getCell("column2").getValue();
            this.kDTextArea4.setText(value);
        }
    }

    @Override
    protected void kDTable2_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getRowIndex() > 0) {
            String value = (String)this.kDTable2.getRow(e.getRowIndex()).getCell("column2").getValue();
            this.kDTextArea3.setText(value);
        }
    }

    @Override
    public void actionVerifyPin_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkPassword()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"info_label1"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label2"));
            SysUtil.abort();
        }
    }

    private boolean checkPassword() throws UsbKeyException {
        String userName = this.getUserName();
        String password = String.valueOf(this.kDPasswordField1.getPassword());
        boolean result = false;
        try {
            result = this.clientPKI.checkPasswd(password.getBytes("UTF-8"));
        }
        catch (NullPointerException e1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label4"));
            SysUtil.abort();
        }
        catch (Exception e2) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label2"));
            SysUtil.abort();
        }
        return result;
    }

    @Override
    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        String keyUserName;
        String userName = this.getUserName();
        String password = this.checkPassword() ? String.valueOf(this.kDPasswordField1.getPassword()) : "";
        String plaintext = this.kDTextArea1.getText();
        if (StringUtils.isEmpty((String)plaintext)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label6"));
            SysUtil.abort();
        }
        if (!userName.equals(keyUserName = new String(this.clientPKI.getUserID(), "UTF-8"))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label3"));
            SysUtil.abort();
        }
        byte[] dataSignature = null;
        try {
            dataSignature = this.clientPKI.sign(plaintext.getBytes("UTF-8"), keyUserName, password.getBytes("UTF-8"));
        }
        catch (PKIException e1) {
            SysUtil.abort();
        }
        String signatureStr = new String(dataSignature, "UTF-8");
        this.kDTextArea2.setText(signatureStr);
    }

    @Override
    public void actionVerify_actionPerformed(ActionEvent e) throws Exception {
        String isUsbKeyExistent;
        String plaintext = this.kDTextArea1.getText();
        String signatureStr = this.kDTextArea2.getText();
        if (this.clientPKI == null) {
            this.clientPKI = PKIServerAndClientExtFactory.getClientExtProvider();
        }
        if (!StringUtils.isEmpty((String)(isUsbKeyExistent = this.clientPKI.isUsbKeyExistent()))) {
            byte[] cert = this.clientPKI.exportCertificate();
            int res = this.serverPKI.verify(null, plaintext.getBytes("UTF-8"), signatureStr.getBytes("UTF-8"), this.getUserName());
            if (res == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6821\u9a8c\u901a\u8fc7");
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)("\u6821\u9a8c\u5931\u8d25\uff0cresult:" + res));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"exception_label4"));
        }
    }
}

