/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.security.FingerprintSupplierEnum;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.client.AbstractFingerprintConfigUI;
import com.kingdee.eas.base.security.fingerprint.FingerprintConfigInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FingerprintConfigUI
extends AbstractFingerprintConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(FingerprintConfigUI.class);
    public static final String SECURITY_RESOURCE = "com.kingdee.eas.base.security.SecurityResource";
    private ISecurityAuthParamManager manager = SecurityAuthParamManagerFactory.getRemoteInstance();
    private boolean isFingerprintUseable = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.fingerprintSupplierComboBox.addItems(FingerprintSupplierEnum.getEnumList().toArray());
        this.enableFingerprintAuthCheckBox.setSelected(false);
        this.serverIPTextField.setDigit(true);
        this.serverIPTextField.setValidCharacters(".");
        this.serverPortTextField.setDigit(true);
    }

    private void initData() {
        FingerprintConfigInfo configInfo = this.manager.getFingerprintConfigInfo();
        if (!StringUtils.isEmpty((String)configInfo.getEnableFingerprint())) {
            this.isFingerprintUseable = Boolean.valueOf(configInfo.getEnableFingerprint());
            this.enableFingerprintAuthCheckBox.setSelected(this.isFingerprintUseable);
        }
        this.initSupplierClass(configInfo.getFingerprintSupplierClass());
        if (!StringUtils.isEmpty((String)configInfo.getAuthType())) {
            this.authTypeTextField.setText(configInfo.getAuthType());
        }
        if (!StringUtils.isEmpty((String)configInfo.getServerIP())) {
            this.serverIPTextField.setText(configInfo.getServerIP());
        }
        if (!StringUtils.isEmpty((String)configInfo.getServerPort())) {
            this.serverPortTextField.setText(configInfo.getServerPort());
        }
        if (!StringUtils.isEmpty((String)configInfo.getProductId())) {
            this.productIdTextField.setText(configInfo.getProductId());
        }
        if (!StringUtils.isEmpty((String)configInfo.getAdminName())) {
            this.adminNameTextField.setText(configInfo.getAdminName());
        }
        if (!StringUtils.isEmpty((String)configInfo.getAdminPassword())) {
            this.adminPasswordTextField.setText(configInfo.getAdminPassword());
        }
    }

    private void initSupplierClass(String supplierClass) {
        if (!StringUtils.isEmpty((String)supplierClass)) {
            supplierClass = supplierClass.trim();
            Iterator iter = FingerprintSupplierEnum.getEnumList().iterator();
            boolean isDefaultClass = false;
            while (iter.hasNext()) {
                FingerprintSupplierEnum supplier = (FingerprintSupplierEnum)((Object)iter.next());
                if (!supplierClass.equals(supplier.getValue())) continue;
                this.fingerprintSupplierComboBox.setSelectedItem((Object)supplier);
                isDefaultClass = true;
                break;
            }
            if (!isDefaultClass) {
                this.fingerprintSupplierComboBox.setSelectedItem((Object)FingerprintSupplierEnum.CUSTOM);
                this.customImplClassTextField.setText(supplierClass);
            }
        }
    }

    @Override
    protected void enableFingerprintAuthCheckBox_actionPerformed(ActionEvent e) throws Exception {
        super.enableFingerprintAuthCheckBox_actionPerformed(e);
    }

    @Override
    protected void saveBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateData()) {
            this.saveData();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SECURITY_RESOURCE, (String)"saveSuccessMsg"));
            this.destroyWindow();
        }
    }

    private boolean validateData() {
        boolean result = this.validateCustomImplClass();
        result = result && this.validateEnableFingerprint();
        return result;
    }

    private boolean validateCustomImplClass() {
        String customClass = this.customImplClassTextField.getText();
        if (FingerprintSupplierEnum.CUSTOM.equals(this.fingerprintSupplierComboBox.getSelectedItem()) && StringUtils.isEmpty((String)customClass)) {
            MsgBox.showWarning((String)EASResource.getString((String)SECURITY_RESOURCE, (String)"customClassIsEmptyMsg"));
            return false;
        }
        return true;
    }

    private boolean validateEnableFingerprint() {
        if (this.enableFingerprintAuthCheckBox.isSelected() == this.isFingerprintUseable) {
            return true;
        }
        String message = null;
        message = this.isFingerprintUseable ? "forbidFingerprintMsg" : "enableFingerprintMsg";
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)SECURITY_RESOURCE, (String)message)));
    }

    private void saveData() throws Exception {
        FingerprintConfigInfo configInfo = new FingerprintConfigInfo();
        String enableFingerprint = "false";
        if (this.enableFingerprintAuthCheckBox.isSelected()) {
            enableFingerprint = "true";
        }
        configInfo.setEnableFingerprint(enableFingerprint);
        if (FingerprintSupplierEnum.CUSTOM.equals(this.fingerprintSupplierComboBox.getSelectedItem())) {
            configInfo.setFingerprintSupplierClass(this.customImplClassTextField.getText());
        } else {
            String supplierClass = ((FingerprintSupplierEnum)((Object)this.fingerprintSupplierComboBox.getSelectedItem())).getValue();
            configInfo.setFingerprintSupplierClass(supplierClass);
        }
        configInfo.setAuthType(this.authTypeTextField.getText());
        configInfo.setServerIP(this.serverIPTextField.getText());
        configInfo.setServerPort(this.serverPortTextField.getText());
        configInfo.setProductId(this.productIdTextField.getText());
        configInfo.setAdminName(this.adminNameTextField.getText());
        String password = String.valueOf(this.adminPasswordTextField.getPassword());
        configInfo.setAdminPassword(password);
        IObjectPK logPK = LogUtil.beginLog(null, (String)"storeFingerprintConfigInfo", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)"\u64cd\u4f5c\u670d\u52a1\u5668\u8bbe\u7f6e", (String)"finger_server_setting");
        this.manager.storeFingerprintConfigInfo(configInfo);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    @Override
    protected void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void fingerprintSupplierComboBox_actionPerformed(ActionEvent e) throws Exception {
        if (FingerprintSupplierEnum.CUSTOM.equals(this.fingerprintSupplierComboBox.getSelectedItem())) {
            this.customImplClassTextField.setEnabled(true);
        } else {
            this.customImplClassTextField.setEnabled(false);
        }
    }
}

