/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDImageIcon;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.NumberSignCollection;
import com.kingdee.eas.base.permission.NumberSignException;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.numbersign.NumberImageSignService;
import com.kingdee.eas.base.security.client.AbstractNumberSignListUI;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class NumberSignListUI
extends AbstractNumberSignListUI {
    private static final Logger logger = CoreUIObject.getLogger(NumberSignListUI.class);
    public static final String BOID = "boId";
    private KDPanel scrollPanel;
    private NumberImageSignService signService = new NumberImageSignService();
    private NumberSignCollection signCol = new NumberSignCollection();

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.scrollPanel = new KDPanel();
        this.scrollPanel.setBounds(0, 0, 430, 185);
        this.signImageScrollPane.setViewportView((Component)this.scrollPanel);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    private void initData() throws Exception {
        if (this.getUIContext().get(BOID) != null) {
            ObjectUuidPK boId = new ObjectUuidPK(BOSUuid.read((String)((String)this.getUIContext().get(BOID))));
            this.signCol = this.signService.findSignInfoNoVerify((IObjectPK)boId);
        }
        this.initSignInfoTable();
        this.showAllImagecheckBox.setSelected(true);
    }

    protected void initListener() {
        super.initListener();
        this.signInfoTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    NumberSignListUI.this.tableSelectChangedAction(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
        this.showAllImagecheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    NumberSignListUI.this.checkBoxSelectChangedAction(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    private void initSignInfoTable() {
        this.signInfoTable.checkParsed();
        this.signInfoTable.setEditable(false);
        this.signInfoTable.getStyleAttributes().setLocked(true);
        this.signInfoTable.getSelectManager().setSelectMode(10);
        for (NumberSignInfo signInfo : this.signCol) {
            IRow signRow = this.signInfoTable.addRow();
            signRow.getCell("id").setValue((Object)signInfo.getId().toString());
            if (signInfo.getUserId() != null) {
                signRow.getCell("userName").setValue((Object)signInfo.getUserId().getName());
                signRow.getCell("userNumber").setValue((Object)signInfo.getUserId().getNumber());
            }
            signRow.getCell("signTime").setValue((Object)signInfo.getCreateTime());
        }
    }

    private void tableSelectChangedAction(KDTSelectEvent e) throws Exception {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.signInfoTable);
        this.showAllImagecheckBox.setSelected(false);
        this.scrollPanel.removeAll();
        for (int index = 0; index < selectedRows.length; ++index) {
            IRow row = this.signInfoTable.getRow(selectedRows[index]);
            if (row == null || row.getCell("id") == null) continue;
            this.addSignImage((String)row.getCell("id").getValue());
        }
        this.scrollPanel.revalidate();
        this.scrollPanel.repaint();
    }

    private void checkBoxSelectChangedAction(ChangeEvent e) throws Exception {
        this.scrollPanel.removeAll();
        if (this.showAllImagecheckBox.isSelected()) {
            this.signInfoTable.getSelectManager().removeAll();
            for (int index = 0; index < this.signInfoTable.getRowCount(); ++index) {
                IRow row = this.signInfoTable.getRow(index);
                if (row == null || row.getCell("id") == null) continue;
                this.addSignImage((String)row.getCell("id").getValue());
            }
        }
        this.scrollPanel.revalidate();
        this.scrollPanel.repaint();
    }

    private void addSignImage(String id) throws Exception {
        Image signImage = this.getSignInfoImageById(id);
        if (signImage != null) {
            KDImageIcon imageIcon = new KDImageIcon(signImage);
            KDLabel imageLabel = new KDLabel((Icon)imageIcon);
            this.scrollPanel.add((Component)imageLabel);
        }
    }

    private Image getSignInfoImageById(String id) throws NumberSignException {
        if (!StringUtils.isEmpty((String)id)) {
            for (NumberSignInfo signInfo : this.signCol) {
                if (!id.equals(signInfo.getId().toString())) continue;
                return this.signService.getImageFromSignInfo(signInfo.getSignInfo());
            }
        }
        return null;
    }
}

