/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.security.framework.SignatureFieldInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.security.CertificateStatusEnum;
import com.kingdee.eas.base.security.EASCertificateCollection;
import com.kingdee.eas.base.security.EASCertificateFactory;
import com.kingdee.eas.base.security.EASCertificateInfo;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.EASSignatureInfo;
import com.kingdee.eas.base.security.IEASCertificate;
import com.kingdee.eas.base.security.SignatureStatusEnum;
import com.kingdee.eas.base.security.client.AbstractSecurityTestUI;
import com.kingdee.eas.base.security.client.ClientSecurityService;
import com.kingdee.eas.base.security.provider.client.imp.ItrusPKIClientProvider;
import com.kingdee.eas.common.client.SysContext;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;

public class SecurityTestUI
extends AbstractSecurityTestUI {
    private static final Logger logger = CoreUIObject.getLogger(SecurityTestUI.class);
    private Random random = new Random();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void sigList_componentShown(ComponentEvent e) throws Exception {
        if (this.kDTable2.getRowCount() == 0) {
            IUIFactory uiFactory = null;
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("Owner", (Object)this);
            hm.put("bosType", "13B7DE7F");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.security.client.SignatureListUI", hm, null, null);
            uiWindow.show();
        }
        super.sigList_componentShown(e);
    }

    @Override
    protected void cfList_componentShown(ComponentEvent e) throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.refresh();
        if (this.kDTable1.getRowCount() == 0) {
            EASCertificateCollection col = EASCertificateFactory.getRemoteInstance().getEASCertificateCollection();
            int size = col.size();
            for (int index = 0; index < size; ++index) {
                IRow row = this.kDTable1.addRow();
                EASCertificateInfo certificateInfo = col.get(index);
                row.getCell("user.number").setValue((Object)certificateInfo.getUser().getId());
                row.getCell("user.name").setValue((Object)certificateInfo.getUser().getName());
                row.getCell("status").setValue((Object)certificateInfo.getStatus());
                row.getCell("number").setValue((Object)certificateInfo.getNumber());
                row.getCell("certificate").setValue((Object)certificateInfo.getCertificate());
                row.getCell("validDate").setValue((Object)certificateInfo.getValidDate());
                row.getCell("invalidDate").setValue((Object)certificateInfo.getInvalidDate());
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.plainText.setText("I love your money");
        this.filePath.setText("F:/tmp/certificate/kingdee.cer");
    }

    @Override
    protected void btnSign_actionPerformed(ActionEvent e) throws Exception {
        String plainText = this.plainText.getText();
        byte[] signature = null;
        try {
            signature = ClientSecurityService.getService().sign(plainText.getBytes());
            logger.info((Object)("\u6570\u5b57\u7b7e\u540d\u4fe1\u606f\uff1a" + new String(signature)));
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        this.signatureText.setText(new String(signature));
        EASSignatureInfo signatureInfo = new EASSignatureInfo();
        signatureInfo.setSignature(this.signatureText.getText());
        signatureInfo.setPlainText(plainText);
        signatureInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
        signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
        signatureInfo.setBosType("testBosType");
        signatureInfo.setFormatPlainText(plainText);
    }

    @Override
    protected void btnSaveCertificate_actionPerformed(ActionEvent e) throws Exception {
        IEASCertificate cert = EASCertificateFactory.getRemoteInstance();
        EASCertificateInfo certInfo = new EASCertificateInfo();
        certInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
        byte[] byteCert = new ItrusPKIClientProvider().exportCertificate();
        logger.info((Object)("\u4eceusbkey \u4e2d\u5bfc\u51fa\u7684\u8bc1\u4e66\u4e3a\uff1a" + new String(byteCert)));
        certInfo.setCertificate(byteCert);
        certInfo.setStatus(CertificateStatusEnum.VALID);
        certInfo.setValidDate(new Date());
        certInfo.setInvalidDate(new Date());
        certInfo.setNumber("" + this.random.nextInt());
        cert.addnew(certInfo);
    }

    @Override
    protected void btnFieldQuery_actionPerformed(ActionEvent e) throws Exception {
        String bosType = "bostype";
        if (this.txtBosType.getText().length() > 0) {
            bosType = this.txtBosType.getText();
        }
        SignatureFieldInfo signatureFieldInfo = EASSignatureFactory.getRemoteInstance().getSignatureFieldInfo(bosType);
        this.fieldInfo.setText(signatureFieldInfo.toString());
    }
}

