/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.security.client.AbstractSignatureDetailUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SignatureDetailUI
extends AbstractSignatureDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(SignatureDetailUI.class);
    private String bosType = null;
    private String[] formatPlainTexts = null;
    private List headKeys = new ArrayList();
    private List plainTextList = new ArrayList();

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void onShow() throws Exception {
        this.initTable();
        super.onShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.parsePlainText();
    }

    private void initContext() {
        this.bosType = (String)this.getUIContext().get("bosType");
        if (this.bosType == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"bosTypeUnknow"));
            SysUtil.abort();
        }
        this.formatPlainTexts = (String[])this.getUIContext().get("formatPlainTexts");
        if (this.formatPlainTexts == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void initTable() {
        this.initTableHead();
        this.initTableBody();
        this.tableSortManagerConfig(this.mainTable);
    }

    private void initTableBody() {
        int size = this.plainTextList.size();
        for (int index = 0; index < size; ++index) {
            Map detailPlainText = (Map)this.plainTextList.get(index);
            IRow row = this.mainTable.addRow();
            for (String property : detailPlainText.keySet()) {
                if (row.getCell(property) == null) continue;
                row.getCell(property).setValue(detailPlainText.get(property));
            }
            row.getStyleAttributes().setLocked(true);
        }
    }

    public void tableSortManagerConfig(KDTable kdTable) {
        KDTSortManager sm = new KDTSortManager(kdTable);
        sm.setSortAuto(true);
        for (int index = 0; index < kdTable.getColumnCount(); ++index) {
            kdTable.getColumn(index).setSortable(true);
        }
    }

    public void initTableListner(KDTable table) {
    }

    private void initTableHead() {
        IRow headRow = this.mainTable.addHeadRow();
        int size = this.headKeys.size();
        for (int index = 0; index < size; ++index) {
            int width = 500 / size;
            if (width > 200) {
                width = 200;
            }
            if (width < 100) {
                width = 100;
            }
            IColumn col = this.mainTable.addColumn();
            String colKey = (String)this.headKeys.get(index);
            col.setKey(colKey);
            col.setWidth(width);
            headRow.getCell(index).setValue((Object)PropertyTransfer.getTransfer(this.bosType).getPropAlias(colKey));
        }
    }

    private void parsePlainText() {
        for (String curPlainText : this.formatPlainTexts) {
            String[] pt = curPlainText.split("__split__");
            HashMap<String, String> detailPlainText = new HashMap<String, String>();
            int ptyLen = pt.length;
            for (int ptyIdx = 0; ptyIdx < ptyLen; ++ptyIdx) {
                String[] keyValue;
                if (StringUtils.isEmpty((String)pt[ptyIdx]) || (keyValue = pt[ptyIdx].split("=")).length != 2) continue;
                if (!this.headKeys.contains(keyValue[0])) {
                    this.headKeys.add(keyValue[0].trim());
                }
                detailPlainText.put(keyValue[0].trim(), keyValue[1]);
            }
            this.plainTextList.add(detailPlainText);
        }
    }

    static class PropertyTransfer {
        private static Map etyProps = new HashMap();
        private static final IMetaDataLoader metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        private String bosType = null;

        private PropertyTransfer(String bosType) {
            this.bosType = bosType;
        }

        public static PropertyTransfer getTransfer(String bosType) {
            return new PropertyTransfer(bosType);
        }

        public String getPropAlias(String propName) {
            String propAlias = "";
            propAlias = etyProps.get(propName) != null ? ((PropertyInfo)etyProps.get(propName)).getAlias() : this.getPropAliasFromEntity(propName);
            return propAlias;
        }

        private String getPropAliasFromEntity(String propName) {
            String aliasFromConfig;
            String propAlias = "";
            EntityObjectInfo ety = metaLoader.getEntity(BOSObjectType.create((String)this.bosType));
            PropertyInfo ptyInfo = ety.getPropertyByName(propName);
            propAlias = ptyInfo != null ? ptyInfo.getAlias() : (!StringUtils.isEmpty((String)(aliasFromConfig = this.getAliasFromConfig(this.bosType, propName))) ? aliasFromConfig : EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"unknowProperty"));
            etyProps.put(propName, ptyInfo);
            return propAlias;
        }

        private String getAliasFromConfig(String bosString, String fieldName) {
            try {
                IPermissionManager permissionManage = PermissionManagerFactory.getRemoteInstance();
                SignatureFieldInfo info = permissionManage.getSignatureFieldInfo(bosString);
                return info.getFieldAlias(fieldName);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return null;
            }
        }
    }
}

