/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUsbKeyUserMap;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserUSBKeyStateEnum;
import com.kingdee.eas.base.security.EASCertificateFactory;
import com.kingdee.eas.base.security.EASCertificateInfo;
import com.kingdee.eas.base.security.IEASCertificate;
import com.kingdee.eas.base.security.client.AbstractUsbKeyCertInfoUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UsbKeyCertInfoUI
extends AbstractUsbKeyCertInfoUI {
    private static final Logger logger = CoreUIObject.getLogger(UsbKeyCertInfoUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.security.client.CAConfigUIResource";
    private static String userName = "";
    private static byte[] cert = null;

    public void onload() throws Exception {
        super.onLoad();
    }

    public void onShow() throws Exception {
        this.mainQuery.setFilter(new FilterInfo());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"abc"));
        try {
            this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.toolBar.setVisible(false);
        super.onShow();
        this.initData();
    }

    private void initData() throws Exception {
        this.getUserName();
        this.addDataToTable();
    }

    private String getUserName() throws EASBizException, BOSException {
        HashMap context = (HashMap)this.getUIContext().get("Owner");
        userName = (String)context.get("USERNAME");
        if (StringUtils.isEmpty((String)userName)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label3"));
            SysUtil.abort();
        }
        if (this.isUsbkeyInit(userName).getValue() == 10) {
            this.destroyWindow();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"exception_label8"));
            SysUtil.abort();
        }
        return userName;
    }

    public void addDataToTable() throws Exception {
        this.tblMain.removeRows(false);
        String USBKeyUser = EASResource.getString((String)RESOURCE, (String)"cert_label7");
        String usbKeyUserInfo = EASResource.getString((String)RESOURCE, (String)"cert_label2");
        String usbKeyOfferInfo = EASResource.getString((String)RESOURCE, (String)"cert_label3");
        String usbKeySerialNo = EASResource.getString((String)RESOURCE, (String)"cert_label4");
        String usbKeyFinalDate = EASResource.getString((String)RESOURCE, (String)"cert_label5");
        String usbKeyCertBASE64Str = EASResource.getString((String)RESOURCE, (String)"cert_label6");
        this.setRowTable2(USBKeyUser, userName);
        this.setRowTable2(usbKeyUserInfo, this.usbKeyUserInfo());
        this.setRowTable2(usbKeyOfferInfo, this.usbKeyOfferInfo());
        this.setRowTable2(usbKeySerialNo, this.usbKeySerialNo());
        this.setRowTable2(usbKeyFinalDate, this.usbKeyFinalDate());
        this.setRowTable2(usbKeyCertBASE64Str, this.usbKeyCertBASE64Str());
    }

    public UserUSBKeyStateEnum isUsbkeyInit(String username) throws BOSException, EASBizException {
        String oql = "select * where user.number='" + userName + "'";
        IUsbKeyUserMap usbKeyUserMap = UsbKeyUserMapFactory.getRemoteInstance();
        UsbKeyUserMapInfo usbKeyUserInfo = usbKeyUserMap.getUsbKeyUserMapInfo(oql);
        UserUSBKeyStateEnum keyState = usbKeyUserInfo.getState();
        return keyState;
    }

    public String usbKeyUserInfo() {
        if (cert == null) {
            cert = this.getCertForByte(userName);
        }
        X509Certificate xCert = this.getCert(userName);
        String name = xCert.getSubjectDN().getName();
        return name;
    }

    public String usbKeyOfferInfo() throws Exception {
        if (cert == null) {
            cert = this.getCertForByte(userName);
        }
        X509Certificate xCert = this.getCert(userName);
        String name = xCert.getIssuerDN().getName();
        return name;
    }

    public String usbKeySerialNo() throws Exception {
        if (cert == null) {
            cert = this.getCertForByte(userName);
        }
        X509Certificate xCert = this.getCert(userName);
        String number = xCert.getSerialNumber().toString(16);
        return number;
    }

    public String usbKeyFinalDate() throws Exception {
        if (cert == null) {
            cert = this.getCertForByte(userName);
        }
        X509Certificate xCert = this.getCert(userName);
        Date date = xCert.getNotAfter();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sdf.format(date);
        return dateStr;
    }

    public String usbKeyCertBASE64Str() {
        if (cert == null) {
            cert = this.getCertForByte(userName);
        }
        String cert1 = Base64Encoder.byteArrayToBase64((byte[])cert);
        return cert1;
    }

    public IRow setRowTable2(String name, Object value) {
        IRow row = this.tblMain.addRow();
        row.getCell("column1").setValue((Object)name);
        row.getCell("column2").setValue(value);
        row.getStyleAttributes().setLocked(true);
        return row;
    }

    public X509Certificate getCert(String userNumber) {
        cert = this.getCertForByte(userNumber);
        X509Certificate xcert1 = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            if (Security.getProperty("TopSM") == null) {
                Security.addProvider((Provider)Class.forName("cn.topca.security.sm.TopSMProvider").newInstance());
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "TopSM");
            if (bais.available() > 0) {
                xcert1 = (X509Certificate)cf.generateCertificate(bais);
                return xcert1;
            }
        }
        catch (CertificateException e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getCertForByte(String userNumber) {
        IEASCertificate certificate = null;
        try {
            certificate = EASCertificateFactory.getRemoteInstance();
            String oql = "select * where user.number='" + userNumber + "'";
            EASCertificateInfo info = certificate.getEASCertificateInfo(oql);
            cert = info.getCertificate();
        }
        catch (BOSException e) {
            logger.error((Object)"get IEASCertificate failure");
        }
        catch (EASBizException e) {
            logger.error((Object)"get IEASCertificate failure");
        }
        return cert;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        String value = (String)this.tblMain.getRow(e.getRowIndex()).getCell("column2").getValue();
        this.kDTextArea1.setText(value);
    }
}

