/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.dynamiccard.strategy;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.base.security.dynamiccard.DynamiCodeConfigInfo;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardServerConfigUtil;
import com.kingdee.eas.base.security.dynamiccard.strategy.DynamicCardStratrgy;
import com.kingdee.eas.base.security.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class DynamiCodeStratrgy
implements DynamicCardStratrgy {
    private static final String SERVER_NAME = "ServerIP";
    private static final String PORT_NAME = "ServerPort";
    private static final String ETPSAPPID_NAME = "EtpsAppID";
    private static final String LANGFLAG_NAME = "LangFlag";
    private static final String KEY_NAME = "ClientKey";
    private static final String DEFAULT_SERVERIP = "127.0.0.1";
    private static final String DEFAULT_PORT = "2008";
    private static final String DEFAULT_ETPSAPPID = "57";
    private static final String DEFAULT_LANGFLAG = "zh_CN";
    private static final String DEFAULT_KEY = "20080808";
    private Properties props = null;

    @Override
    public DynamicCardConfigInfo getDynamicCardConfigInfo() throws IOException {
        this.getProperties();
        DynamiCodeConfigInfo info = new DynamiCodeConfigInfo();
        info.setServerIP(this.props.getProperty(SERVER_NAME));
        info.setServerPort(this.props.getProperty(PORT_NAME));
        info.setEtpsAppID(this.props.getProperty(ETPSAPPID_NAME));
        info.setLangFlag(this.props.getProperty(LANGFLAG_NAME));
        info.setKey(this.props.getProperty(KEY_NAME));
        return info;
    }

    private void getProperties() throws IOException {
        File configFile = DynamicCardServerConfigUtil.getConifgFile();
        this.props = PropertiesUtil.getProperties(configFile);
        if (this.props.isEmpty() || StringUtils.isEmpty((String)this.props.getProperty(ETPSAPPID_NAME))) {
            this.props = this.createDefaultConfig();
        }
    }

    private Properties createDefaultConfig() {
        Properties props = new Properties();
        props.put(SERVER_NAME, DEFAULT_SERVERIP);
        props.put(PORT_NAME, DEFAULT_PORT);
        props.put(ETPSAPPID_NAME, DEFAULT_ETPSAPPID);
        props.put(LANGFLAG_NAME, DEFAULT_LANGFLAG);
        props.put(KEY_NAME, DEFAULT_KEY);
        return props;
    }

    @Override
    public void storeDynamicCardConfigInfo(DynamicCardConfigInfo info) throws IOException {
        DynamiCodeConfigInfo configInfo = (DynamiCodeConfigInfo)info;
        if (configInfo != null) {
            if (configInfo.getServerIP() != null) {
                this.props.setProperty(SERVER_NAME, configInfo.getServerIP());
            }
            if (configInfo.getServerPort() != null) {
                this.props.setProperty(PORT_NAME, configInfo.getServerPort());
            }
            if (configInfo.getEtpsAppID() != null) {
                this.props.setProperty(ETPSAPPID_NAME, configInfo.getEtpsAppID());
            }
            if (configInfo.getLangFlag() != null) {
                this.props.setProperty(LANGFLAG_NAME, configInfo.getLangFlag());
            }
            if (configInfo.getKey() != null) {
                this.props.setProperty(KEY_NAME, configInfo.getKey());
            }
            File configFile = DynamicCardServerConfigUtil.getConifgFile();
            PropertiesUtil.storeProperties(this.props, configFile);
        }
    }
}

