/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertificateUtils {
    public static X509CRL getX509CRLFromBytes(byte[] crlBuf, String providerName) throws CertificateException, NoSuchProviderException, CRLException {
        CertificateFactory cf = providerName == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", providerName);
        X509CRL x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crlBuf));
        return x509CRL;
    }

    public static X509Certificate changeProvider(X509Certificate cert, String strProvider) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = strProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", strProvider);
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static boolean isValid(X509Certificate cert) {
        Date notBefore = cert.getNotBefore();
        Date notAfter = cert.getNotAfter();
        Date now = new Date();
        return !now.before(notBefore) && !now.after(notAfter);
    }

    public static String getIEValidSerialNumber(String serialNumber) {
        if (serialNumber == null) {
            return null;
        }
        if (serialNumber.length() == 0) {
            return serialNumber;
        }
        serialNumber = serialNumber.toLowerCase();
        String firstWord = serialNumber.substring(0, 1);
        int firstNumber = 0;
        try {
            firstNumber = Integer.parseInt(firstWord, 16);
        }
        catch (Exception e) {
            return serialNumber;
        }
        if (firstNumber >= 8) {
            return "00" + serialNumber;
        }
        return serialNumber;
    }

    public static String getICAValidSerialNumber(String serialNumber) {
        if (serialNumber == null) {
            return null;
        }
        if (serialNumber.startsWith("00")) {
            return serialNumber.substring(2).toUpperCase();
        }
        return serialNumber.toUpperCase();
    }

    public static X509Certificate getX509CertificateFromBytes(byte[] certBuf) throws CertificateException {
        if (certBuf == null) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBuf));
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getX509CertificateFromFile(String certFileName) throws CertificateException, IOException {
        if (certFileName == null) {
            return null;
        }
        X509Certificate cert = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(certFileName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(fis);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cert;
    }
}

