/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.util;

import com.kingdee.eas.base.security.util.PropertiesUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PermissionParameterConfigUtil {
    private static final Logger logger = Logger.getLogger(PermissionParameterConfigUtil.class);
    public static String USBKEY_USEABLE = "USBKEY_USEABLE";
    public static String USBKEYIMP = "USBKEYIMP";
    public static String WEB_COMPONENT = "WebOjbImp";
    public static String DYNAMIC_CARD_PWD_CHECK_CLASS = "DynamicCardPwdCheckClass";
    public static String DYNAMIC_CARD_USER_NUMBER_TYPE = "DynCardUserNumberType";
    public static String DEFAULT_PERMPARAM_NAME = "PermParam.properties";
    public static String DEFAULT_SIGNATURECONFIGURATION_NAME = "SignatureConfiguration.xml";
    public static String DEFAULT_SERVERCERT_NAME = "servercert.properties";
    public static String DEFAULT_ITRUSSERVERCFG_PATH = "itrusservercfg";
    public static final String BOTPSIGNCONFIG_FILE_NAME = "BOTPSignConfig.properties";
    public static final String SMARTPAYCONFIG_FILE_NAME = "SmartPaySignConfig.properties";

    public static Properties getPermissionParam() throws IOException {
        return PropertiesUtil.getProperties(PermissionParameterConfigUtil.getParamFile());
    }

    public static void storePermissionParam(Properties props) throws IOException {
        PropertiesUtil.storeProperties(props, PermissionParameterConfigUtil.getParamFile());
    }

    private static File getParamFile() throws IOException {
        String easDeployPath = System.getProperty("eas.deploy");
        String filePath = new StringBuffer(easDeployPath).append(File.separator).append(DEFAULT_PERMPARAM_NAME).toString();
        File file = new File(filePath);
        if (file != null && !file.exists()) {
            file.createNewFile();
            PropertiesUtil.storeProperties(PermissionParameterConfigUtil.createDefaultParam(), file);
        }
        return file;
    }

    private static Properties createDefaultParam() {
        Properties props = new Properties();
        props.put(USBKEY_USEABLE, "false");
        props.put(USBKEYIMP, "");
        props.put(WEB_COMPONENT, "");
        props.put(DYNAMIC_CARD_PWD_CHECK_CLASS, "");
        return props;
    }

    public static String getCharset() throws IOException {
        return PermissionParameterConfigUtil.getCharset(PermissionParameterConfigUtil.getCAConfigFile());
    }

    private static File getCAConfigFile() throws IOException {
        String filePath = System.getProperty("EAS_HOME") + "/server/properties/" + DEFAULT_SIGNATURECONFIGURATION_NAME;
        File file = new File(filePath);
        return file;
    }

    private static File getBOTPSignConfigFile() throws IOException {
        String filePath = System.getProperty("EAS_HOME") + "/server/properties/" + BOTPSIGNCONFIG_FILE_NAME;
        File file = new File(filePath);
        return file;
    }

    public static Properties getBOTPSignConfig() throws IOException {
        return PropertiesUtil.getProperties(PermissionParameterConfigUtil.getBOTPSignConfigFile());
    }

    public static Properties getSmartPaySignConfig() throws IOException {
        File file = new File(System.getProperty("EAS_HOME") + "/server/properties/" + SMARTPAYCONFIG_FILE_NAME);
        return PropertiesUtil.getProperties(file);
    }

    public static File getItrusConfigFile() throws IOException {
        String easDeployPath = System.getProperty("eas.properties.dir");
        String filePath = new StringBuffer(easDeployPath).append(File.separator).append(DEFAULT_ITRUSSERVERCFG_PATH).append(File.separator).append(DEFAULT_SERVERCERT_NAME).toString();
        File file = new File(filePath);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCharset(File file) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        BufferedInputStream bis = null;
        try {
            boolean checked = false;
            bis = new BufferedInputStream(new FileInputStream(file));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                String string = charset;
                return string;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
                System.out.println(loc + " " + Integer.toHexString(read));
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return charset;
    }
}

