/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.IClientLoginContextFilter;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.KickoutFacadeFactory;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.client.KDPromptPane;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.ILoginListener;
import com.kingdee.eas.common.client.LoginEvent;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserLoginCheckListener
implements ILoginListener,
IClientLoginContextFilter {
    private static final String IS_AWOKE_RELOGIN_FOR_GUI = "isAwokeAtUserReLoginForGUI";
    private static final String RESOURCE_CLASS_NAME = "com.kingdee.eas.base.usermonitor.client.UserMonitorResource";
    private static final String VIRTUAL_USER = "virtualUser";
    protected static final Logger logger = Logger.getLogger(UserLoginCheckListener.class);

    public void logined(LoginEvent e) throws BOSException, EASBizException {
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        List userList = iUserMonitor.findUsers(SysContext.getSysContext().getDcName(), SysContext.getSysContext().getUserName());
        userList = this.filter(userList, SysContext.getSysContext().getSessionID());
        this.handleShowPromptUserKickOut(userList);
        this.loadParams();
    }

    private String showPromptUserTickOut() {
        try {
            String msg = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg0") + "\n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg1") + "\n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg2") + "\n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg3") + "\n  ";
            String[] options = new String[]{EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn0"), EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn1"), EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn2")};
            String title = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"promptTitle");
            KDPromptPane kdPromptPane = new KDPromptPane(SystemEntry.instance.getOwnerFrame(), title, msg, null, options, 3, 1);
            kdPromptPane.show();
            return "" + kdPromptPane.getResult();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String showUserAdminTickOut() {
        try {
            String msg = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg0") + "\n  \n" + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg2") + "\n  \n" + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg3") + "\n  ";
            String[] options = new String[3];
            options[1] = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn1");
            options[2] = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn2");
            String title = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"promptTitle");
            KDPromptPane kdPromptPane = new KDPromptPane(SystemEntry.instance.getOwnerFrame(), title, msg, null, options, 3, 1234);
            kdPromptPane.show();
            return "" + kdPromptPane.getResult();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String showOverLicenseTickOut() {
        try {
            String msg = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"overLicenseCount") + "\n  \n" + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg2") + "\n  \n" + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg3") + "\n  ";
            String[] options = new String[]{EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn0"), EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn1"), EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn2")};
            String title = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"promptTitle");
            KDPromptPane kdPromptPane = new KDPromptPane(SystemEntry.instance.getOwnerFrame(), title, msg, null, options, 3, 1234);
            kdPromptPane.show();
            return "" + kdPromptPane.getResult();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String showPromptUserNotAllowRepeatLogin() {
        try {
            String msg = "\n  \n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg4") + "\n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg2") + "\n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"msg3") + "\n  ";
            String[] options = new String[]{EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn0"), EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn1"), EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn2")};
            String title = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"promptTitle");
            KDPromptPane kdPromptPane = new KDPromptPane(SystemEntry.instance.getOwnerFrame(), title, msg, null, options, 3, 1234);
            kdPromptPane.show();
            return "" + kdPromptPane.getResult();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String showPortalUserBeKickedOut() {
        try {
            String msg = "\n  \n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"portalUserBeKickedOut") + "\n  " + EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"cannotLoginFromPortal") + "\n";
            String[] options = new String[3];
            options[1] = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"btn0");
            String title = EASResource.getString((String)RESOURCE_CLASS_NAME, (String)"loginFail");
            AdvMsgBox kdPromptPane = new AdvMsgBox(SystemEntry.instance.getOwnerFrame(), title, msg, null, options, 2, 2);
            kdPromptPane.setModal(true);
            kdPromptPane.setAlwaysOnTop(true);
            kdPromptPane.show();
            return "" + kdPromptPane.getResult();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void beforeAuthenticating(LoginContext loginCtx) throws BOSLoginException {
    }

    public void afterAuthenticated(Context ctx) throws BOSLoginException {
        try {
            List userList = (List)ctx.get((Object)"SameUserList");
            userList = this.filter(userList, ctx.getContextID());
            this.handleShowPromptUserKickOut(userList);
            this.loadParams();
        }
        catch (EASBizException e) {
            throw new BOSLoginException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSLoginException((Throwable)e);
        }
    }

    private void handleShowPromptUserKickOut(List userList) throws EASBizException, BOSException {
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        if (SystemEntry.instance.isWebStart()) {
            boolean isPortalUserExists = true;
            isPortalUserExists = iUserMonitor.isPortalUserExists(SysContext.getSysContext().getSessionID());
            if (!isPortalUserExists) {
                // empty if block
            }
        }
        boolean hasSameNameUser = this.checkShowPromptUserKickOut(userList);
        boolean isAllowedRepeatLogin = this.checkAllowUserRepeatLogin();
        boolean isAwokeReloginForGUI = true;
        try {
            ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            try {
                Class<?> c = Class.forName("com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil");
                Method m = c.getMethod("getParamValue", String.class, String.class, Object.class);
                isAwokeReloginForGUI = Boolean.valueOf(StringUtils.cnulls((Object)m.invoke(c, IS_AWOKE_RELOGIN_FOR_GUI, StringUtils.cnulls((Object)pk), Boolean.TRUE)));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                isAwokeReloginForGUI = Boolean.valueOf(ParamManager.getParamValue(null, (IObjectPK)pk, (String)IS_AWOKE_RELOGIN_FOR_GUI));
            }
        }
        catch (Exception e) {
            logger.error((Object)"ParamManager.getParamValue err ,number is isAwokeAtUserReLoginForGUI", (Throwable)e);
        }
        SysContext sysContext = SysContext.getSysContext();
        boolean isOverLicenseCount = iUserMonitor.isOverLicenseCount(sysContext.getUserName(), sysContext.getDCNumber(), sysContext.getSessionID());
        String userAnswer = null;
        if (isOverLicenseCount) {
            userAnswer = this.showOverLicenseTickOut();
        } else if (hasSameNameUser && !isAllowedRepeatLogin) {
            userAnswer = this.showPromptUserNotAllowRepeatLogin();
        } else if (hasSameNameUser && isAwokeReloginForGUI) {
            userAnswer = this.showPromptUserTickOut();
        }
        if ("1".equals(userAnswer)) {
            UMRegistryInfo currentUserMonitorInfo = (UMRegistryInfo)iUserMonitor.getValue(sysContext.getSessionID());
            String kickIp = currentUserMonitorInfo.getClientIPAddress();
            String kickUserName = currentUserMonitorInfo.getUserName();
            if (kickIp == null || kickIp.isEmpty()) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    kickIp = inetAddress.getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (kickUserName == null || kickUserName.isEmpty()) {
                kickUserName = sysContext.getUserName();
            }
            for (int i = 0; i < userList.size(); ++i) {
                UMRegistryInfo info = (UMRegistryInfo)userList.get(i);
                String sessionID = info.getId();
                String beKickIp = info.getClientIPAddress();
                String beKickUserName = info.getUserName();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String kickTime = sdf.format(new Date());
                Map kickOutMap = this.getSouceInfo("kickOutMessage1", kickIp, beKickIp, kickUserName, beKickUserName, kickTime);
                Map userNameMap = this.getSouceInfoBySet(SysContext.getSysContext().getUserName());
                if (iUserMonitor.isSendTickoutMessage()) {
                    iUserMonitor.sendMessageToUser(sessionID, userNameMap, kickOutMap, kickOutMap);
                }
                KickoutFacadeFactory.getRemoteInstance().kickoutUser(info.getUserName());
                try {
                    logger.info((Object)"UserLoginCheckListener releaseLicenseBySessionID begin");
                    ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
                    agent.releaseLicenseBySessionID(sessionID);
                    logger.info((Object)"UserLoginCheckListener releaseLicenseBySessionID success");
                }
                catch (Exception e) {
                    logger.info((Object)("UserLoginCheckListener releaseLicenseBySessionID err!" + e));
                }
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            }
        } else if ("2".equals(userAnswer) || "-1".equals(userAnswer)) {
            this.deleteUserMonitorInfo(iUserMonitor);
        }
    }

    private void deleteUserMonitorInfo(IUserMonitor iUserMonitor) throws EASBizException, BOSException, EASLoginException {
        SysContext ctx = SysContext.getSysContext();
        String id = ctx.getSessionID();
        iUserMonitor.deleteSessionAndUserMonitorInfo(id, null);
        throw new EASLoginException(EASLoginException.ALREADY_LOGIN);
    }

    private boolean checkAllowUserRepeatLogin() throws EASBizException, BOSException {
        boolean allowRepeatLogin = true;
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (user != null) {
            allowRepeatLogin = NotAllowRepeatLoginUserFactory.getRemoteInstance().isAllowRepeatLogin(user.getId().toString());
        } else {
            logger.info((Object)"UserLoginCheckListener.checkAllowUserRepeatLogin() getCurrentUserInfo fail!");
        }
        return allowRepeatLogin;
    }

    private boolean checkShowPromptUserKickOut(List userList) {
        if (SystemEntry.instance.isWebStart()) {
            return false;
        }
        if (userList == null || userList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < userList.size(); ++i) {
            UMRegistryInfo info = (UMRegistryInfo)userList.get(i);
            if (!VIRTUAL_USER.equalsIgnoreCase(info.getUserName())) continue;
            return false;
        }
        return true;
    }

    private Map getSouceInfo(String sourceName, String kickIp, String beKickIp, String kickUserName, String beKickUserName, String kickTime) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            String msgBody = StringUtils.cnulls((String)ResourceBase.getString((String)RESOURCE_CLASS_NAME, (String)sourceName, (Locale)curLocal));
            String msg = msgBody.replaceAll("beKickUserName", beKickUserName).replaceAll("kickIp", kickIp).replaceAll("kickTime", kickTime).replaceAll("kickUserName", kickUserName);
            sourceMap.put(curLocal, msg);
        }
        return sourceMap;
    }

    private Map getSouceInfoBySet(String value) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            sourceMap.put(curLocal, StringUtils.cnulls((String)value));
        }
        return sourceMap;
    }

    private List filter(List users, String currentSessionId) {
        if (currentSessionId == null || users == null) {
            return users;
        }
        ArrayList<UMRegistryInfo> result = new ArrayList<UMRegistryInfo>();
        for (UMRegistryInfo user : users) {
            if (user.getId().equals(currentSessionId)) continue;
            result.add(user);
        }
        return result;
    }

    private void loadParams() {
        try {
            String numberType = PermissionCommonUtil.getDynamicCardUserNumberType(null);
            if (numberType == null) {
                numberType = "";
            }
            SysContext.getSysContext().setProperty((Object)"dynamicCardUserNumberType", (Object)numberType);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to cache the parameter 'dynamicCardUserNumberType'.", (Throwable)e);
        }
    }
}

