/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.client.MessageHandleUI;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSettingInfo;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientThread;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class UserMonitorClientTool {
    private static Logger logger = Logger.getLogger((String)UserMonitorClientTool.class.getName());
    private static UMRegistryInfo registryInfo = new UMRegistryInfo();
    private static UserMonitorClientThread clientThread = null;
    private static boolean isMonitorUserAction = true;
    private static boolean hasGetMonitorSetting = false;
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.base.usermonitor.UserMonitorServerResource";

    public static UserMonitorClientThread getClientThread() {
        return clientThread;
    }

    public static void setClientThread(UserMonitorClientThread clientThread) {
        UserMonitorClientTool.clientThread = clientThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRegistryInfo(UMRegistryInfo reg) {
        UMRegistryInfo uMRegistryInfo = registryInfo;
        synchronized (uMRegistryInfo) {
            reg.put("updateDate", new Date());
            registryInfo = reg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UMRegistryInfo getRegistryInfo() {
        UMRegistryInfo uMRegistryInfo = registryInfo;
        synchronized (uMRegistryInfo) {
            return registryInfo;
        }
    }

    public static void register() {
        try {
            UMRegistryInfo reg = UserMonitorClientTool.getRegistryInfoFromClient();
            UserMonitorClientTool.submit(reg, true);
        }
        catch (Exception err) {
            UserMonitorClientTool.handleUnExpectedException(err);
        }
    }

    public static void monitor(CoreUIObject ui) {
        try {
            if (!UserMonitorClientTool.isMonitorUserAction()) {
                return;
            }
            if (ui instanceof MessageHandleUI) {
                String titleName = EASResource.getString((String)RESOURCE_FULLNAME, (String)"kickOut");
                if (((MessageHandleUI)ui).getDataObject() instanceof BMCMessageInfo && titleName.equals(((BMCMessageInfo)((MessageHandleUI)ui).getDataObject()).getTitle())) {
                    return;
                }
            }
            String title = ui.getUITitle();
            Runner runner = new Runner(title, (IUIObject)ui, null, null, true);
            runner.start();
        }
        catch (Exception err) {
            UserMonitorClientTool.handleUnExpectedException(err);
        }
    }

    public static void monitor(IItemAction action, boolean isFinished) {
        if (!UserMonitorClientTool.isMonitorUserAction()) {
            return;
        }
        try {
            if (UserMonitorClientTool.isActionEnableMonitor(action) && action != null) {
                String title = null;
                if (action.getUIObject() != null) {
                    title = action.getUIObject().getUITitle();
                }
                String actionName = action.getExtendProperty("Name");
                String actionDescription = action.getExtendProperty("ShortDescription");
                Runner runner = new Runner(title, action.getUIObject(), actionName, actionDescription, isFinished);
                runner.start();
            }
        }
        catch (Exception err) {
            UserMonitorClientTool.handleUnExpectedException(err);
        }
    }

    public static void monitor(ActionEvent e, boolean isFinished) {
        if (!UserMonitorClientTool.isMonitorUserAction()) {
            return;
        }
        try {
            AbstractButton btn;
            ItemAction action;
            if (UserMonitorClientTool.isActionEnableMonitor(e) && e != null && e.getSource() != null && e.getSource() instanceof AbstractButton && (action = (ItemAction)(btn = (AbstractButton)e.getSource()).getAction()) != null) {
                String title = null;
                if (action.getUIObject() != null) {
                    title = action.getUIObject().getUITitle();
                }
                String actionName = action.getExtendProperty("Name");
                String actionDescription = action.getExtendProperty("ShortDescription");
                Runner runner = new Runner(title, action.getUIObject(), actionName, actionDescription, isFinished);
                runner.start();
            }
        }
        catch (Exception err) {
            UserMonitorClientTool.handleUnExpectedException(err);
        }
    }

    public static boolean isMonitorUserAction() {
        try {
            if (!hasGetMonitorSetting) {
                isMonitorUserAction = UserMonitorClientTool.getMonitorUserActionSetting();
                hasGetMonitorSetting = true;
            }
            return isMonitorUserAction;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void setMonitorUserAction(boolean isMonitorUserAction) {
        UserMonitorClientTool.isMonitorUserAction = isMonitorUserAction;
    }

    private static boolean getMonitorUserActionSetting() throws EASBizException {
        UserMonitorSettingInfo settingInfo = UserMonitorFactory.getRemoteInstance().getUserMonitorSetting();
        return settingInfo.isMonitorUserAction();
    }

    private static boolean isActionEnableMonitor(IItemAction action) {
        if (action != null) {
            String disableUserMonitor = action.getExtendProperty("disableUserMonitor");
            return disableUserMonitor == null || !disableUserMonitor.equalsIgnoreCase("true");
        }
        return false;
    }

    private static boolean isActionEnableMonitor(ActionEvent e) {
        if (e == null) {
            logger.error((Object)"User monitor register err info\uff1aActionEvent is null");
            return false;
        }
        if (e.getSource() != null && e.getSource() instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)e.getSource();
            ItemAction action = (ItemAction)btn.getAction();
            if (action != null) {
                String disableUserMonitor = action.getExtendProperty("disableUserMonitor");
                return disableUserMonitor == null || !disableUserMonitor.equalsIgnoreCase("true");
            }
            return false;
        }
        return false;
    }

    private static void submit(UMRegistryInfo reg, boolean isRegister) {
        if (reg == null) {
            logger.error((Object)"User monitor registry err info\uff1aUMRegistryInfo is null");
            return;
        }
        if (reg.getId() == null || reg.getId().trim().length() == 0) {
            StringBuffer detail = new StringBuffer();
            detail.append("User monitor register err info\uff1asession ID is empty");
            detail.append(System.getProperty("line.separator"));
            detail.append("UMRegistry detail info\uff1a");
            detail.append(reg.toString());
            logger.error((Object)detail.toString());
        } else {
            try {
                IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
                if (isRegister) {
                    iUserMonitor.addnew(reg);
                } else {
                    iUserMonitor.update(reg);
                }
            }
            catch (Exception e) {
                logger.error((Object)UserMonitorClientTool.buildDetail(e));
            }
        }
    }

    private static UMRegistryInfo getRegistryInfoFromClient() {
        UMRegistryInfo reg = new UMRegistryInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        reg.setId(SysContext.getSysContext().getSessionID());
        reg.setClientIPAddress(SysContext.getSysContext().getClientIP());
        reg.setUserId(userInfo.getId().toString());
        reg.setUserName(SysContext.getSysContext().getUserName());
        reg.setUserRealName(userInfo.getName());
        reg.setUserType(userInfo.getType().getValue());
        reg.setDataCenterName(SysContext.getSysContext().getDcName());
        if (userInfo.getCU() != null) {
            reg.setUserCUName(userInfo.getCU().getName());
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() != null) {
            reg.setCurrentMainBizUnitName(SysContext.getSysContext().getCurrentCtrlUnit().getName());
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() != null) {
            reg.setCurrentCtrlUnitId(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        }
        return reg;
    }

    private static UMRegistryInfo getUpdateInfoFromClient(String title, IUIObject uiObject, String actionName, String actionDescription, boolean isFinished) {
        CoreUI coreUI;
        OrgUnitInfo unitInfo;
        UMRegistryInfo reg = new UMRegistryInfo();
        reg.setId(SysContext.getSysContext().getSessionID());
        if (SysContext.getSysContext().getCurrentCtrlUnit() != null) {
            reg.setCurrentMainBizUnitName(SysContext.getSysContext().getCurrentCtrlUnit().getName());
        }
        if (uiObject instanceof CoreUI && (unitInfo = (coreUI = (CoreUI)uiObject).getMainOrgInfo()) != null) {
            reg.setCurrentMainBizUnitName(unitInfo.getName());
        }
        if (SysContext.getSysContext().getCurrentCtrlUnit() != null) {
            reg.setCurrentCtrlUnitId(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        }
        reg.setFinished(isFinished);
        reg.setOpenWindowTitle(title);
        reg.setActionName(actionName);
        reg.setActionDescription(actionDescription);
        return reg;
    }

    private static void handleUnExpectedException(Exception e) {
        try {
            logger.error((Object)"User monitor registry err info\uff1aunexpected exception");
            logger.error((Object)UserMonitorClientTool.buildDetail(e));
        }
        catch (Exception e1) {
            e.printStackTrace();
        }
    }

    private static String buildDetail(Throwable err) {
        StringBuffer detail = new StringBuffer();
        detail.append("Error info\uff1a");
        detail.append(err.getMessage());
        detail.append(System.getProperty("line.separator"));
        detail.append("Detail err stack info\uff1a");
        detail.append(ExceptionUtil.getExcLinkStackTrace((Throwable)err));
        return detail.toString();
    }

    static class Runner
    extends Thread {
        private String title;
        private String actionName;
        private String actionDescription;
        private boolean isFinished = false;
        private IUIObject uiObject;

        public Runner(String title, IUIObject uiObject, String actionName, String actionDescription, boolean isFinished) {
            this.title = title;
            this.actionName = actionName;
            this.actionDescription = actionDescription;
            this.isFinished = isFinished;
            this.uiObject = uiObject;
        }

        @Override
        public void run() {
            try {
                UMRegistryInfo reg = UserMonitorClientTool.getUpdateInfoFromClient(this.title, this.uiObject, this.actionName, this.actionDescription, this.isFinished);
                UserMonitorClientTool.setRegistryInfo(reg);
            }
            catch (Exception err) {
                UserMonitorClientTool.handleUnExpectedException(err);
            }
        }
    }
}

