/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.basesync.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncErrorCode;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncServiceFactoryHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.BaseSyncHelperImpFactory;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.IBaseSyncHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SyncLogUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils");
    public static String[] baseLogColName = new String[]{"FID", "FType", "FSuccess", "FMsgCode", "FErrorMsg", "FSyncTimeID", "FCreateTime", "FCreatorID"};

    public static void syncLog(SyncContext syncCtx, Map logMap, JSONArray logArray, String syncType) throws BOSException {
        List logParamList = (List)logMap.get("logColValue");
        String[] logColName = (String[])logMap.get("logColName");
        String insertSql = SyncLogUtils.buildInsertSql(syncCtx, logColName);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String syncTimeId = SyncLogUtils.getLastSyncTime(syncCtx);
        for (int i = 0; i < logParamList.size(); ++i) {
            List logInfo = (List)logParamList.get(i);
            logInfo.add(BOSUuid.create((String)"F4AF4F04").toString());
            logInfo.add(syncType);
            JSONObject jsonObject = logArray.getJSONObject(i);
            String errorMsg = "\u6210\u529f";
            int errorCode = Integer.parseInt(jsonObject.getString("errcode"));
            if (errorCode != 0) {
                logInfo.add(1);
                SyncErrorCode enum1 = SyncErrorCode.getEnum(errorCode + "");
                if (enum1 == null) {
                    logger.error((Object)("\u7c7b\u578b\u4e3a" + syncCtx.getType() + ",\u9519\u8bef\u7801\u4e3a" + errorCode));
                    errorMsg = jsonObject.getString("errmsg");
                } else {
                    errorMsg = enum1.getName();
                }
            } else {
                logInfo.add(0);
            }
            logInfo.add(errorCode);
            logInfo.add(errorMsg);
            logInfo.add(syncTimeId);
            logInfo.add(new Timestamp(new Date().getTime()));
            String currUser = ContextUtil.getCurrentUserInfo((Context)syncCtx.getCtx()).getId().toString();
            logInfo.add(currUser);
            Object[] paramArray = logInfo.toArray();
            paramList.add(paramArray);
        }
        try {
            DbUtil.executeBatch((Context)syncCtx.getCtx(), (String)insertSql, paramList);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static String getLastSyncTime(SyncContext syncCtx) throws BOSException {
        String sql = "select top 1 fid from t_bs_synchtime where ftype = " + syncCtx.getType() + "order by fsynchtime desc";
        String FSynchTimeId = null;
        IRowSet rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sql);
        try {
            if (rs.next()) {
                FSynchTimeId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return FSynchTimeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSyncLogCount(SyncContext syncCtx, String itemType, String synchTimeId, String filterSql, boolean success) throws BOSException {
        BOSUuid.read((String)synchTimeId);
        StringBuilder sql = new StringBuilder();
        sql.append("select count(0) from " + syncCtx.getLogTableName() + " where");
        sql.append(" FSyncTimeID='" + synchTimeId + "'").append(" AND FType='" + itemType + "'");
        if (success) {
            sql.append(" AND FSuccess=0 ");
        } else {
            sql.append(" AND FSuccess=1 ");
        }
        if (!StringUtils.isEmpty((String)filterSql)) {
            sql.append(filterSql);
        }
        IRowSet rowSet1 = null;
        int count = 0;
        try {
            rowSet1 = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sql.toString());
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    public static HSSFWorkbook exportFilterData(Context ctx, JSONObject condition, int type) throws BOSException {
        String syncType = condition.getString("syncType");
        String subAction = condition.getString("subAction");
        SyncHighItemType highItemType = null;
        if ("viewOrgLog".equalsIgnoreCase(subAction) || "viewXtOrg".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.Dept;
        } else if ("viewPersonLog".equalsIgnoreCase(subAction) || "viewXtUser".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.Person;
        } else if ("viewDeptLeaderLog".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.DeptLeader;
        } else if ("viewPartJobLog".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.PartJob;
        } else if ("viewRelationsLog".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.Relations;
        }
        if (highItemType == null) {
            return null;
        }
        SyncContext syncCtx = SyncServiceFactoryHelper.getSyncServiceFactoryHelper(type).getSyncContextByType(highItemType, type);
        syncCtx.setCtx(ctx);
        IBaseSyncHelper instance = BaseSyncHelperImpFactory.getInstance(ctx, type);
        if ("viewXtOrg".equalsIgnoreCase(subAction)) {
            return instance.exportAllXtOrg(syncCtx, condition);
        }
        if ("viewXtUser".equalsIgnoreCase(subAction)) {
            return instance.exportAllXtUser(syncCtx, condition);
        }
        condition.put("highItemType", (Object)highItemType.getValue());
        return instance.exportFilterDataWrokbook(syncCtx, condition, type);
    }

    private static String buildInsertSql(SyncContext syncCtx, String[] logColName) {
        String tableName = syncCtx.getLogTableName();
        StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + "(");
        for (String colName : logColName) {
            sql.append(colName + ",");
        }
        for (int i = 0; i < baseLogColName.length; ++i) {
            if (i == baseLogColName.length - 1) {
                sql.append(baseLogColName[i] + ")");
                break;
            }
            sql.append(baseLogColName[i] + ",");
        }
        sql.append(" values(");
        int paramSize = logColName.length + baseLogColName.length;
        for (int i = 0; i < paramSize; ++i) {
            if (i == paramSize - 1) {
                sql.append("?)");
                break;
            }
            sql.append("?,");
        }
        return sql.toString();
    }
}

