/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncPartBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.WLSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLHttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WLSyncPartService
extends SyncPartBaseService {
    public WLSyncPartService(SyncContext syncCtx) {
        super(syncCtx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        this.updatePartJobInfo();
        this.deleteMapPartJob();
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            return super.sync(itemType);
        }
        WLSyncItemType wlType = WLSyncUtil.getWLSyncEnum(itemType);
        if (WLSyncItemType.BatchUpdatePersonPartJob.equals((Object)wlType)) {
            String sql = WLSyncConfigUtil.getInstance().getValue("selectPartJobChanged");
            IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            try {
                ArrayList<String> logValue = null;
                while (rowSet.next()) {
                    int i;
                    JSONObject dataJSON = new JSONObject();
                    for (i = 0; i < syncJsonKey.length; ++i) {
                        if ("deptCodes".equals(syncJsonKey[i])) {
                            ArrayList<String> orgids = JSONArray.parseArray((String)rowSet.getString("FWLORGIDS"), String.class);
                            if (orgids == null) {
                                orgids = new ArrayList<String>();
                            }
                            orgids.add(0, rowSet.getString("fmaindepartment"));
                            dataJSON.put(syncJsonKey[i], (Object)orgids.toArray());
                            continue;
                        }
                        Object value = rowSet.getObject(syncJsonValue[i]);
                        dataJSON.put(syncJsonKey[i], (Object)(value == null ? "" : value.toString()));
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; syncLogColName != null && i < syncLogColName.length; ++i) {
                        Object value2 = rowSet.getObject(syncLogColValue[i]);
                        logValue.add(value2 == null ? "" : value2.toString());
                    }
                    logArrays.add(logValue);
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                String string = this.syncPart(this.syncCtx, dataArray, itemType, logMap);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
            }
            finally {
                if (rowSet != null) {
                    try {
                        rowSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected String syncPart(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException {
        WLSyncItemType type = WLSyncUtil.getWLSyncEnum(itemType);
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            String syncUrl = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/update");
            JSONObject url0 = JSONObject.parseObject((String)syncUrl);
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                result = WLHttpSendUtil.startPost(url0.getString("url"), dataJSON, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                result.put("errcode", result.get((Object)"code"));
                result.put("errmsg", result.get((Object)"message"));
                logArray.add((Object)result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    @Override
    public String afterSync() throws BOSException, EASBizException {
        return this.insertPartInfo();
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        return new String[]{"userId", "deptCodes", "mainDeptCode"};
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        return new String[]{"FWLId", "fwlorgids", "fmaindepartment"};
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        return new String[]{"FWLId", "FJobtitles", "FOldWLOrgIds", "FWLOrgIds"};
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        return new String[]{"FWLId", "FJobtitles", "FOldWLOrgIds", "FWLOrgIds"};
    }

    private String insertPartInfo() throws BOSException {
        String syncTimeId = SyncLogUtils.getLastSyncTime(this.syncCtx);
        String sql = "SELECT FWLID FROM T_WL_SYNCPARTLOG WHERE FSyncTimeID = '" + syncTimeId + "'";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                String userid = rs.getString("FWLID");
                if (StringUtils.isEmpty((String)userid)) continue;
                userIds.add(userid);
            }
            HashMap paramMap = new HashMap();
            String syncUrl = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/detail");
            JSONObject url0 = JSONObject.parseObject((String)syncUrl);
            JSONObject jsonBody = new JSONObject();
            for (int i = 0; i < userIds.size(); ++i) {
                String userID = (String)userIds.get(i);
                jsonBody.put("userId", (Object)userID);
                try {
                    JSONObject result = WLHttpSendUtil.startPost(url0.getString("url"), jsonBody, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                    JSONArray departs = result.getJSONArray("deptCodes");
                    if (departs.size() <= 1) continue;
                    String mainDepart = result.getString("mainDeptCode");
                    for (int j = 0; j < departs.size(); ++j) {
                        if (!mainDepart.equals(departs.get(j).toString())) continue;
                        departs.remove(j);
                        break;
                    }
                    ArrayList<String> param = new ArrayList<String>();
                    Collections.sort((List)departs);
                    param.add(departs.toString());
                    param.add(userID);
                    paramMap.put(userID, param);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Set allUserId = paramMap.keySet();
            if (allUserId.size() < 1) {
                return null;
            }
            StringBuilder sb = new StringBuilder("select FUserId FROM T_WL_PART WHERE FUserId in (");
            for (String uId : allUserId) {
                sb.append("'" + uId + "',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") ");
            IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            String updateSql = "UPDATE T_WL_PART SET FOrgIds = ? WHERE FUserId = ?";
            while (rs1.next()) {
                String FUserId = rs1.getString("FUserId");
                updateParams.add(((List)paramMap.get(FUserId)).toArray());
                paramMap.remove(FUserId);
            }
            EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
            String insertSql = "INSERT INTO T_WL_PART (FID,FOrgIds,FUserId,FJobTitle) VALUES (?,?,?,?)";
            Set insertUserIdSet = paramMap.keySet();
            ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
            for (String uId : insertUserIdSet) {
                ArrayList<String> updateParam = new ArrayList<String>();
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.addAll((Collection)paramMap.get(uId));
                updateParam.add(null);
                updateParams1.add(updateParam.toArray());
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void deleteMapPartJob() throws BOSException {
        String sql = WLSyncConfigUtil.getInstance().getValue("deleteNotExistPartJob");
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    private void updatePartJobInfo() throws BOSException {
        HashMap<String, PartInfo> partMap = new HashMap<String, PartInfo>();
        String sql = WLSyncConfigUtil.getInstance().getValue("selectPersonPartJob");
        try {
            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
            while (rs.next()) {
                String personId = rs.getString("FPersonId");
                String wlId = rs.getString("FXTId");
                PartInfo info = (PartInfo)partMap.get(personId);
                if (info == null) {
                    info = new PartInfo(personId, wlId);
                    partMap.put(personId, info);
                }
                info.addEasOrgId(rs.getString("FEasOrgId"));
                info.addWLOrgId(rs.getString("FWLOrgId"));
                info.addJobTitle(rs.getString("FJobTitle"));
                info.addEasOrgNumber(rs.getString("FOrgNumber"));
            }
            Set personIdSet = partMap.keySet();
            if (personIdSet.size() < 1) {
                return;
            }
            String truncateSql = "truncate table T_PM_EASWXPARTMAP";
            EasXtSyncUtil.execute(this.ctx, truncateSql);
            String insertSql = "INSERT INTO T_PM_EASWLPARTMAP (FID,FPERSONID,FEASORGIDS,FWLORGIDS,FWLID,FJOBTITLES,FEASORGNUMBERS ) VALUES (?,?,?,?,?,?,?)";
            ArrayList<String[]> updateParams = new ArrayList<String[]>();
            for (String pid : personIdSet) {
                ArrayList<String> updateParam = new ArrayList<String>();
                PartInfo pi = (PartInfo)partMap.get(pid);
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.add(pi.personId);
                updateParam.add(pi.easOrgIds.toString());
                updateParam.add(pi.wlOrgIds.toString().replace(" ", ""));
                updateParam.add(pi.wXId);
                updateParam.add(pi.jobTitle.toString());
                updateParam.add(pi.easOrgNumbers.toString());
                updateParams.add(updateParam.toArray(new String[updateParam.size()]));
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class PartInfo {
        String personId;
        String wXId;
        private JSONArray easOrgIds;
        private JSONArray wlOrgIds;
        private JSONArray jobTitle;
        private JSONArray easOrgNumbers;

        PartInfo(String personId, String wlId) {
            this.personId = personId;
            this.wXId = wlId;
            this.easOrgIds = new JSONArray();
            this.wlOrgIds = new JSONArray();
            this.jobTitle = new JSONArray();
            this.easOrgNumbers = new JSONArray();
        }

        public void addEasOrgId(String easOrgId) {
            if (!this.easOrgIds.contains((Object)easOrgId)) {
                this.easOrgIds.add((Object)easOrgId);
            }
        }

        public void addWLOrgId(String wlOrgId) {
            if (!this.wlOrgIds.contains((Object)wlOrgId)) {
                this.wlOrgIds.add((Object)wlOrgId);
            }
        }

        public void addJobTitle(String jobTitle) {
            this.jobTitle.add((Object)jobTitle);
        }

        public void addEasOrgNumber(String orgNumber) {
            if (!this.easOrgNumbers.contains((Object)orgNumber)) {
                this.easOrgNumbers.add((Object)orgNumber);
            }
        }
    }
}

