/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLHttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WLSyncURLUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncURLUtil");
    public static Map<String, Map> tokenMap = new HashMap<String, Map>();
    public static final String DEFAULT_MCLOUD = "https://open.welink.huaweicloud.com";
    public static final String WL_TOKEN = "/api/auth/v2/tickets";
    public static final String GETROOT = "/api/tenant/v1/tenants";
    public static final String GETALL_ORG = "/api/contact/v1/department/list";
    public static final String GETONE_ORG = "/api/contact/v1/department/detail";
    public static final String ADDNEW_ORG = "/api/contact/v1/department/create";
    public static final String UPDATE_ORG = "/api/contact/v1/department/update";
    public static final String DELETE_ORG = "/api/contact/v1/department/delete";
    public static final String GETONE_PERSON = "/api/contact/v1/user/detail";
    public static final String GETALL_PERSON = "/api/contact/v1/user/list";
    public static final String ADDNEW_PERSON = "/api/contact/v1/user/create";
    public static final String UPDATE_PERSON = "/api/contact/v1/user/update";
    public static final String DELETE_PERSON = "/api/contact/v1/user/delete";
    public static final String UPDATE_PHONE_PERSON = "/api/contact/v1/user/mobilenumber";

    public static String getSyncUrl(Context ctx, String syncTypeUrl) throws BOSException {
        String secret;
        String eip;
        Map config = new WLSyncHelper(ctx).getConfig();
        String mCloud = config.get("mCloud") == null ? DEFAULT_MCLOUD : (String)config.get("mCloud");
        String token = WLSyncURLUtil.getToken(ctx, mCloud, eip = (String)config.get("eip"), secret = (String)config.get("secret"));
        if (StringUtils.isEmpty((String)token)) {
            throw new BOSException("token\u4e3a\u7a7a");
        }
        JSONObject param = new JSONObject();
        param.put("url", (Object)(mCloud + syncTypeUrl));
        param.put("token", (Object)token);
        param.put("hwConfig", (Object)WLSyncHelper.getHWConfig(ctx));
        logger.debug((Object)("token\u53c2\u6570\u4e3a:" + param.toJSONString()));
        return param.toJSONString();
    }

    private static String getToken(Context ctx, String headUrl, String corpid, String corpsecret) {
        Map tMap = tokenMap.get(ctx.getAIS());
        if (tMap != null && tMap.get("token") != null) {
            long currentTimeMillis;
            long effectTime = (Long)tMap.get("effectime");
            if (effectTime <= (currentTimeMillis = System.currentTimeMillis())) {
                WLSyncURLUtil.sendToken(ctx, headUrl, corpid, corpsecret);
            }
        } else {
            WLSyncURLUtil.sendToken(ctx, headUrl, corpid, corpsecret);
        }
        return tokenMap.get(ctx.getAIS()).get("token").toString();
    }

    private static void sendToken(Context ctx, String headUrl, String corpid, String corpsecret) {
        JSONObject tokenParam = new JSONObject();
        tokenParam.put("client_id", (Object)corpid);
        tokenParam.put("client_secret", (Object)corpsecret);
        try {
            JSONObject tokenResult = WLHttpSendUtil.startPost(headUrl + WL_TOKEN, tokenParam.toJSONString(), WLSyncHelper.getHWConfig(ctx));
            if (tokenResult.getInteger("code") != 0) {
                logger.error((Object)("\u83b7\u53d6token\u5931\u8d25:" + tokenResult.toString()));
                throw new Exception("\u83b7\u53d6token\u5931\u8d25");
            }
            String token = tokenResult.getString("access_token");
            long effectime = System.currentTimeMillis() + (long)(tokenResult.getInteger("expires_in") * 1000);
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            tMap.put("token", token);
            tMap.put("effectime", effectime);
            tokenMap.put(ctx.getAIS(), tMap);
        }
        catch (Exception e) {
            logger.error((Object)("\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5931\u8d25;" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void clearTokenCache() {
        if (tokenMap != null) {
            tokenMap.clear();
        }
    }
}

