/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wxsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncRelationsBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.WXSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WXSyncRelationsService
extends SyncRelationsBaseService {
    public WXSyncRelationsService(SyncContext syncCtx) {
        super(syncCtx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        this.updateRelationsInfo();
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            return super.sync(itemType);
        }
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(itemType);
        if (WXSyncItemType.BatchUpdateRelations.equals((Object)wxType)) {
            String sql = WXSyncConfigUtil.getInstance().getValue("selectRELATIONSChanged");
            IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            Object result = null;
            try {
                ArrayList<String> logValue = null;
                while (rowSet.next()) {
                    int i;
                    JSONObject dataJSON = new JSONObject();
                    for (i = 0; i < syncJsonKey.length; ++i) {
                        if ("direct_leader".equals(syncJsonKey[i])) {
                            String[] array = new String[]{};
                            if (rowSet.getString("fnewLeaderWxids") != null) {
                                array = rowSet.getString("fnewLeaderWxids").replaceAll("\\[|\\]|\\s", "").split(",");
                            }
                            dataJSON.put(syncJsonKey[i], (Object)array);
                            continue;
                        }
                        Object value = rowSet.getObject(syncJsonValue[i]);
                        dataJSON.put(syncJsonKey[i], (Object)(value == null ? "" : value.toString()));
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; i < syncLogColName.length; ++i) {
                        Object value2 = rowSet.getObject(syncLogColValue[i]);
                        logValue.add(value2 == null ? "" : value2.toString());
                    }
                    logger.info((Object)("logValue:" + ((Object)logValue).toString()));
                    logArrays.add(logValue);
                    logger.info((Object)("dataJSON:" + dataJSON.toJSONString()));
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                String string = this.syncRelations(this.syncCtx, dataArray, itemType, logMap);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
            }
            finally {
                if (rowSet != null) {
                    try {
                        rowSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    protected String syncRelations(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException {
        WXSyncItemType type = WXSyncUtil.getWXSyncEnum(itemType);
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            String url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/update");
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                result = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                logger.info((Object)("result:" + result.toString()));
                logArray.add((Object)result);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    @Override
    public String afterSync() throws BOSException, EASBizException {
        return this.insertRelationsInfo();
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(itemType);
        if (WXSyncItemType.BatchUpdateRelations.equals((Object)wxType)) {
            head = new String[]{"userid", "direct_leader"};
        }
        return head;
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(itemType);
        if (WXSyncItemType.BatchUpdateRelations.equals((Object)wxType)) {
            head = new String[]{"FWXId", "fnewLeaderWxids"};
        }
        return head;
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        String[] head = null;
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(itemType);
        if (WXSyncItemType.BatchUpdateRelations.equals((Object)wxType)) {
            head = new String[]{"FWXId", "fnewLeaderWxids", "FOldleaderwxids", "FLeaderNames"};
        }
        return head;
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        String[] head = null;
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(itemType);
        if (WXSyncItemType.BatchUpdateRelations.equals((Object)wxType)) {
            head = new String[]{"FWXId", "fnewLeaderWxids", "FOldleaderwxids", "FLeaderNames"};
        }
        return head;
    }

    private String insertRelationsInfo() throws BOSException {
        String syncTimeId = SyncLogUtils.getLastSyncTime(this.syncCtx);
        String sql = "SELECT FWXID FROM T_WX_SYNCRelationsLOG WHERE FSyncTimeID = '" + syncTimeId + "' and FSUCCESS = 0";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                String userid = rs.getString("FWXID");
                if (StringUtils.isEmpty((String)userid)) continue;
                userIds.add(userid);
            }
            if (userIds.size() < 50000000) {
                HashMap paramMap = new HashMap();
                String syncUrl = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/get");
                String syncUrlReal = "";
                for (int i = 0; i < userIds.size(); ++i) {
                    String userID = (String)userIds.get(i);
                    syncUrlReal = syncUrl + "&userid=" + userID;
                    try {
                        logger.info((Object)("syncUrlReal:" + syncUrlReal));
                        JSONObject result = SyncCommunitcateUtil.getSyncResponse(syncUrlReal);
                        logger.info((Object)("insertPartInfo result:" + result));
                        if (!"0".equals(result.getString("errcode"))) {
                            if ("48009".equals(result.getString("errcode"))) {
                                syncUrlReal = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/get", "selfBuildtoken", "selfBuildSecret") + "&userid=" + userID;
                                logger.info((Object)("syncUrlReal:" + syncUrlReal));
                                result = SyncCommunitcateUtil.getSyncResponse(syncUrlReal);
                                logger.error((Object)("-\u5c1d\u8bd5\u901a\u8fc7\u81ea\u5efa\u5e94\u7528\u53bb\u8c03\u7528\u63a5\u53e3-result:" + result.toString()));
                                if (!"0".equals(result.getString("errcode"))) {
                                    throw new BOSException(result.getString("errmsg"));
                                }
                            } else {
                                throw new BOSException(result.getString("errmsg"));
                            }
                        }
                        JSONArray leaders = result.getJSONArray("direct_leader");
                        ArrayList<String> realLeaders = new ArrayList<String>();
                        for (Object str : leaders) {
                            realLeaders.add((String)str);
                        }
                        if (realLeaders.size() <= 0) continue;
                        ArrayList<String> param = new ArrayList<String>();
                        Collections.sort(realLeaders);
                        param.add(((Object)realLeaders).toString());
                        param.add(userID);
                        paramMap.put(userID, param);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Set allUserId = paramMap.keySet();
                if (allUserId.size() < 1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder("select FUserId FROM T_WX_RELATIONS WHERE FUserId in (");
                for (String uId : allUserId) {
                    sb.append("'" + uId + "',");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(") ");
                IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
                String updateSql = "UPDATE T_WX_RELATIONS SET FLeaderWxIds = ? WHERE FUserId = ?";
                while (rs1.next()) {
                    String FUserId = rs1.getString("FUserId");
                    updateParams.add(((List)paramMap.get(FUserId)).toArray());
                    paramMap.remove(FUserId);
                }
                EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
                String insertSql = "INSERT INTO T_WX_RELATIONS (FID,FLeaderWxIds,FUserId) VALUES (?,?,?)";
                Set insertUserIdSet = paramMap.keySet();
                ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
                for (String uId : insertUserIdSet) {
                    ArrayList<String> updateParam = new ArrayList<String>();
                    updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                    updateParam.addAll((Collection)paramMap.get(uId));
                    updateParams1.add(updateParam.toArray());
                }
                EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void updateRelationsInfo() throws BOSException {
        HashMap<String, RelationsInfo> relationsMap = new HashMap<String, RelationsInfo>();
        String sql = null;
        String dbType = (String)this.ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sql = "/*dialect*/" + WXSyncConfigUtil.getInstance().getValue("selectBatchSetRelations_Oracle");
        } else if ("MS SQL Server".equals(dbType)) {
            sql = "/*dialect*/" + WXSyncConfigUtil.getInstance().getValue("selectBatchSetRelations_sqlServer");
        } else if ("DB2 UDB".equals(dbType)) {
            sql = "/*dialect*/" + WXSyncConfigUtil.getInstance().getValue("selectBatchSetRelations_DB2");
        } else if ("PostgresSQL".equals(dbType) || "DM".equals(dbType)) {
            sql = "/*dialect*/" + WXSyncConfigUtil.getInstance().getValue("selectBatchSetRelations_PG");
        }
        if (StringUtils.isEmpty((String)sql)) {
            throw new BOSException("unsupported dbType, please check if the database type belongs to following types: Oracle, SqlServer, DB2, Postgresql, DM");
        }
        try {
            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
            while (rs.next()) {
                String wxId = rs.getString("FwxId");
                RelationsInfo info = (RelationsInfo)relationsMap.get(wxId);
                if (info == null) {
                    info = new RelationsInfo(wxId);
                    relationsMap.put(wxId, info);
                }
                info.addLeaderXtIds(rs.getString("Fleaderwxid"));
                info.addLeaderNames(rs.getString("fpersonname"));
                info.sortLeaderIds();
                logger.info((Object)("pi.wxId=" + info.wxId + ";pi.leaderwxIds=" + info.leaderNames.toString()));
            }
            Set personIdSet = relationsMap.keySet();
            if (personIdSet.size() < 1) {
                return;
            }
            String truncateSql = "truncate table T_PM_EASWXRELATIONSMAP";
            EasXtSyncUtil.execute(this.ctx, truncateSql);
            String insertSql = "INSERT INTO T_PM_EASWXRELATIONSMAP (FID,FWXID,fleaderwxids,FLeaderNames) VALUES (?,?,?,?)";
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            for (String pid : personIdSet) {
                ArrayList<String> updateParam = new ArrayList<String>();
                RelationsInfo pi = (RelationsInfo)relationsMap.get(pid);
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.add(pi.wxId);
                updateParam.add(pi.leaderwxIds.toString());
                updateParam.add(pi.leaderNames.toString());
                updateParams.add(updateParam.toArray());
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class RelationsInfo {
        String wxId;
        List<String> leaderwxIds;
        List<String> leaderNames;

        RelationsInfo(String wxId) {
            this.wxId = wxId;
            this.leaderwxIds = new ArrayList<String>();
            this.leaderNames = new ArrayList<String>();
        }

        public void addLeaderXtIds(String leaderwxId) {
            if (!this.leaderwxIds.contains(leaderwxId)) {
                this.leaderwxIds.add(leaderwxId);
            }
        }

        public void addLeaderNames(String leaderName) {
            if (!this.leaderNames.contains(leaderName)) {
                this.leaderNames.add(leaderName);
            }
        }

        public void sortLeaderIds() {
            Collections.sort(this.leaderwxIds);
        }
    }
}

