/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.web.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.web.AbstractEasXtSyncService;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class SyncRelationsService
extends AbstractEasXtSyncService {
    private Context ctx;

    public SyncRelationsService(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String beforeSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        logger.error((Object)"*******1 \tSyncRelationsService beforeSync *******");
        long time1 = System.currentTimeMillis();
        boolean flag = this.isItemUpdate(this.ctx, "isUpdateSuperiorsMsg");
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncRelationsService beforeSync " + (time2 - time1) + "\u79d2"));
        if (flag) {
            this.updateXtRelations(this.ctx);
            this.updateRelationsInfo(this.ctx);
        }
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncRelationsService beforeSync " + (time3 - time2) + "\u79d2"));
        return "true";
    }

    @Override
    public String sync(EasXtSyncItemType itemType) throws BOSException, EASBizException, EASBizException {
        if (EasXtSyncItemType.BatchSetRelations.equals((Object)itemType)) {
            return this.syncBatchSetRelations(this.ctx, itemType);
        }
        if (EasXtSyncItemType.BatchDeleteRelations.equals((Object)itemType)) {
            return this.syncBatchDeleteRelations(this.ctx, itemType);
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
    }

    @Override
    public String afterSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        boolean flag = this.isItemUpdate(this.ctx, "isUpdateSuperiorsMsg");
        if (flag) {
            this.updateXtRelations(this.ctx);
            this.updateRelationsInfo(this.ctx);
        }
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncBatchSetRelations(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        String sql = "truncate table T_PM_EASXTRELATIONSMAP";
        EasXtSyncUtil.execute(ctx, sql);
        sql = EasXtSyncUtil.getInstance(ctx).getValue("insertRelationsMap");
        EasXtSyncUtil.execute(ctx, sql);
        sql = EasXtSyncUtil.getInstance(ctx).getValue("selectBatchSetRelations");
        if (!this.isItemUpdate(ctx, "isUpdatePartSuperiorsMsg")) {
            sql = sql + " and rmap.fisprimary = 1 ";
        }
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("openId"));
                o.put("leaderOpenId", (Object)rowSet.getString("leaderOpenId"));
                o.put("relationType", (Object)"LEADER");
                o.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("leaderOpenId")));
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("openId", (Object)rowSet.getString("openId"));
                logO.put("leaderOpenId", (Object)rowSet.getString("leaderOpenId"));
                logO.put("relationType", (Object)"LEADER");
                logO.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("leaderOpenId")));
                logO.put("personName", (Object)rowSet.getString("personName"));
                logO.put("cell", (Object)rowSet.getString("cell"));
                logO.put("orgLongName", (Object)rowSet.getString("orgLongName"));
                logO.put("position", (Object)rowSet.getString("position"));
                logO.put("leaderPersonName", (Object)rowSet.getString("leaderPersonName"));
                logO.put("leaderPosition", (Object)rowSet.getString("leaderPosition"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncRelations(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******selectBatchSetRelations one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncRelations(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******selectBatchSetRelations over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncBatchDeleteRelations(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("selectBatchDelRelations");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        int i = 1;
        try {
            if (rowSet != null) {
                logger.error((Object)("******\u6279\u91cf\u5220\u9664\u4eba\u5458\u4e0a\u7ea7\u96c6\u5408\u5927\u5c0f\uff1a" + rowSet.size()));
            }
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("openId"));
                o.put("leaderOpenId", (Object)rowSet.getString("leaderOpenId"));
                o.put("relationType", (Object)"LEADER");
                o.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("leaderOpenId")));
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("openId", (Object)rowSet.getString("openId"));
                logO.put("leaderOpenId", (Object)rowSet.getString("leaderOpenId"));
                logO.put("relationType", (Object)"LEADER");
                logO.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("leaderOpenId")));
                logO.put("personName", (Object)rowSet.getString("personName"));
                logO.put("cell", (Object)rowSet.getString("cell"));
                logO.put("orgLongName", (Object)rowSet.getString("orgLongName"));
                logO.put("position", (Object)rowSet.getString("position"));
                logO.put("leaderPersonName", (Object)rowSet.getString("leaderPersonName"));
                logO.put("leaderPosition", (Object)rowSet.getString("leaderPosition"));
                logArray.add((Object)logO);
                if (dataArray.size() < 500) continue;
                this.syncRelations(ctx, dataArray, logArray, itemType);
                logger.error((Object)("******selectBatchDelRelations \u7b2c" + i + "\u6b21\u5220\u9664"));
                dataArray = new JSONArray();
                logArray = new JSONArray();
                ++i;
            }
            if (dataArray.size() > 0) {
                this.syncRelations(ctx, dataArray, logArray, itemType);
                logger.error((Object)("******selectBatchDelRelations \u7b2c" + i + "\u6b21\u5220\u9664\u7ed3\u675f"));
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            logger.error((Object)"******selectBatchDelRelations \u6279\u91cf\u5220\u9664\u4eba\u5458\u4e0a\u7ea7 \u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            if (e instanceof BOSException) {
                logger.error((Object)"******selectBatchDelRelations \u6279\u91cf\u5220\u9664\u4eba\u5458\u4e0a\u7ea7\u51fa\u73b0\u5f02\u5e382:", (Throwable)e);
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRelations(Context ctx, JSONArray dataArray, JSONArray logArray, EasXtSyncItemType itemType) throws EasXtException, BOSException {
        logger.error((Object)("*****" + itemType.getName() + "********"));
        boolean isAll = true;
        String description = "\u901a\u8fc7\u4e91\u4e4b\u5bb6\u63a5\u53e3_\u540c\u6b65\u4eba\u5458\u4e0a\u7ea7";
        logger.error((Object)("*****" + description + "********"));
        JSONObject result = null;
        try {
            JSONObject response = null;
            if (EasXtSyncItemType.BatchSetRelations.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchSetRelations(dataArray);
            } else if (EasXtSyncItemType.BatchDeleteRelations.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteRelations(dataArray);
            } else {
                return;
            }
            if (response.getBooleanValue("success")) {
                logger.error((Object)("***" + itemType.getName() + "  success*********"));
                isAll = false;
                result = response;
            } else {
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                description = response.getString("error");
                result = response;
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
        catch (EasXtException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
        }
        catch (BOSException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
        }
        finally {
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
    }
}

