/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class EasXtSyncLogUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils");
    private static String inserDeptSql = "insert into T_XT_SYNCDEPTLOG(FID,FCreatorID,FCreateTime,FOldOrgLongName,FOrgLongName,FType,FSuccess,FMsgCode,FSyncTimeID,FErrorMsg,FOldPOrgLongName,fweights) values(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String inserPersonSql = "insert into T_XT_SYNCPERSONLOG (FID,FCreatorID,FCreateTime,FPersonId,FCell,FPersonName,FOldOrgName,FOrgName,FJobTitle,FEmail,FUpdStatus,FType,FMsgCode,FSuccess,FSyncTimeID,FErrorMsg,FGender,FWeights,FBirthday,FHireDate,FOfficePhone1,FOfficePhone2,fcontact,fpersonnumber,fxtid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String insertOrgLeaderSyncSql = "insert into T_XT_SYNCORGLEADERLOG(FID,FCreatorID,FCreateTime,FOrgLongName,FType,FSuccess,FSyncTimeID,FxtId,FErrorMsg,FMsgCode,FPersonName,FCell) values(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String insertPartJobSyncSql = "insert into T_XT_SYNCPARTLOG(FID,FCreatorID,FCreateTime,FJobTitle,FOrgId,FxtId,FType,FSuccess,FSyncTimeID,FErrorMsg,FMsgCode,FPersonName,FCell,FOrgLongName) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String insertRelationsSyncSql = "insert into T_XT_SYNCRELATIONSLOG(FID,FCreatorID,FCreateTime,FLeaderXtId,FxtId,FRelationType,FType,FSuccess,FSyncTimeID,FErrorMsg,FMsgCode,FPersonName,FCell,FOrgLongName,FPosition,FLeaderPersonName,FLeaderPosition) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String updateDeptSyncSql = "update T_XT_SYNCDEPTLOG set FSuccess=?,FMsgCode=?,FErrorMsg=? where (FOrgLongName = ? or FOldOrgLongName=?) and  FType=? and FSyncTimeID = ?";
    private static String updatePersonSyncSql = "update T_XT_SYNCPERSONLOG set FSuccess=?,FMsgCode=?,FErrorMsg=?,FXtId=? where FCell = ? and FSyncTimeID = ?";
    private static String updatePersonSyncSql1 = "update T_XT_SYNCPERSONLOG set FSuccess=?,FMsgCode=?,FErrorMsg=? where FXtId=? and FType=? and FSyncTimeID = ?";
    private static String updateOrgLeaderSyncSql = "update T_XT_SYNCORGLEADERLOG set FSuccess=?,FErrorMsg=? where FOrgLongName = ? and  FType=? and FSyncTimeID = ?";
    private static String updatePartJobSyncSql = "update T_XT_SYNCPARTLOG set FSuccess=?,FErrorMsg=? where FxtId = ? and FOrgId = ? and  FType=? and FSyncTimeID = ?";
    private static String updateRelationsSyncSql = "update T_XT_SYNCRELATIONSLOG set FSuccess=?,FErrorMsg=? where FxtId = ? and FLeaderXtId = ? and  FType=? and FSyncTimeID = ?";

    public static void syncLog(Context ctx, JSONArray dataArray, com.alibaba.fastjson.JSONObject result, EasXtSyncItemType itemType, boolean isAll) throws BOSException {
        String itemTypeStr = itemType.getValue();
        if (StringUtils.isEmpty((String)itemTypeStr)) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
        }
        int type = Integer.parseInt(itemTypeStr);
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 20: 
            case 21: {
                EasXtSyncLogUtils.syncDeptLog(ctx, dataArray, result, itemType, isAll);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                EasXtSyncLogUtils.syncPersonLog(ctx, dataArray, result, itemType, isAll);
                break;
            }
            case 9: 
            case 10: {
                EasXtSyncLogUtils.syncOrgLeaderLog(ctx, dataArray, result, itemType, isAll);
                break;
            }
            case 11: 
            case 12: {
                EasXtSyncLogUtils.syncPartJobLog(ctx, dataArray, result, itemType, isAll);
                break;
            }
            case 16: 
            case 17: {
                EasXtSyncLogUtils.syncRelationsLog(ctx, dataArray, result, itemType, isAll);
                break;
            }
        }
    }

    public static String getSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) throws BOSException {
        String itemTypeStr = itemType.getValue();
        String result = "";
        if (StringUtils.isEmpty((String)itemTypeStr)) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
        }
        int type = Integer.parseInt(itemTypeStr);
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 20: 
            case 21: {
                result = EasXtSyncLogUtils.getDeptSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                result = EasXtSyncLogUtils.getPersonSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
                break;
            }
            case 9: 
            case 10: {
                result = EasXtSyncLogUtils.getOrgLeaderSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
                break;
            }
            case 11: 
            case 12: {
                result = EasXtSyncLogUtils.getPartJobSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
                break;
            }
            case 16: 
            case 17: {
                result = EasXtSyncLogUtils.getRelationsSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
                break;
            }
        }
        return result;
    }

    public static int getSyncLogCount(Context ctx, EasXtSyncItemType itemType, String filterSql, String syncTimeId, boolean success) throws BOSException {
        String itemTypeStr = itemType.getValue();
        if (StringUtils.isEmpty((String)itemTypeStr)) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
        }
        int type = Integer.parseInt(itemTypeStr);
        int count = -1;
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 20: 
            case 21: {
                count = EasXtSyncLogUtils.getDeptSyncLogCount(ctx, itemType, filterSql, syncTimeId, success);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                count = EasXtSyncLogUtils.getPersonSyncLogCount(ctx, itemType, filterSql, syncTimeId, success);
                break;
            }
            case 9: 
            case 10: {
                count = EasXtSyncLogUtils.getOrgLeaderSyncLogCount(ctx, itemType, filterSql, syncTimeId, success);
                break;
            }
            case 11: 
            case 12: {
                count = EasXtSyncLogUtils.getPartJobSyncLogCount(ctx, itemType, filterSql, syncTimeId, success);
                break;
            }
            case 16: 
            case 17: {
                count = EasXtSyncLogUtils.getRelationsSyncLogCount(ctx, itemType, filterSql, syncTimeId, success);
                break;
            }
        }
        if (count == -1) {
            // empty if block
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPersonSyncLogCount(Context ctx, EasXtSyncItemType itemType, String filterSql, String syncTimeId, boolean success) {
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(0) from T_XT_SYNCPERSONLOG log where 1=1");
        EasXtSyncLogUtils.appendCommonFilter(sql, itemType, syncTimeId, success, null);
        if (!StringUtils.isEmpty((String)filterSql)) {
            sql.append(filterSql);
        }
        IRowSet rowSet1 = null;
        int count = 0;
        try {
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOrgLeaderSyncLogCount(Context ctx, EasXtSyncItemType itemType, String filterSql, String syncTimeId, boolean success) {
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(0) from T_XT_SYNCORGLEADERLOG log where 1=1");
        EasXtSyncLogUtils.appendCommonFilter(sql, itemType, syncTimeId, success, null);
        if (!StringUtils.isEmpty((String)filterSql)) {
            sql.append(filterSql);
        }
        IRowSet rowSet1 = null;
        int count = 0;
        try {
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDeptSyncLogCount(Context ctx, EasXtSyncItemType itemType, String filterSql, String syncTimeId, boolean success) {
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(0) from T_XT_SYNCDEPTLOG log where 1=1 ");
        EasXtSyncLogUtils.appendCommonFilter(sql, itemType, syncTimeId, success, null);
        if (!StringUtils.isEmpty((String)filterSql)) {
            sql.append(filterSql);
        }
        IRowSet rowSet1 = null;
        int count = 0;
        try {
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPartJobSyncLogCount(Context ctx, EasXtSyncItemType itemType, String filterSql, String syncTimeId, boolean success) {
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(0) from T_XT_SYNCPARTLOG log where 1=1");
        EasXtSyncLogUtils.appendCommonFilter(sql, itemType, syncTimeId, success, null);
        if (!StringUtils.isEmpty((String)filterSql)) {
            sql.append(filterSql);
        }
        IRowSet rowSet1 = null;
        int count = 0;
        try {
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRelationsSyncLogCount(Context ctx, EasXtSyncItemType itemType, String filterSql, String syncTimeId, boolean success) {
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count(0) from T_XT_SYNCRELATIONSLOG log where 1=1 ");
        EasXtSyncLogUtils.appendCommonFilter(sql, itemType, syncTimeId, success, null);
        if (!StringUtils.isEmpty((String)filterSql)) {
            sql.append(filterSql);
        }
        IRowSet rowSet1 = null;
        int count = 0;
        try {
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPersonSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.fsynctimeid,log.fcreatetime,log.fsuccess,log.FPersonId,log.FCell,log.FEmail,log.FOldOrgName,log.FOrgName,log.FType,log.FErrorMsg,log.FXtId,log.fpersonName,log.FMsgCode,log.FUpdStatus,log.FJobTitle,";
        sql = EasXtSyncItemType.UpdatePersonOther.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonName.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonGender.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonPosition.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonCustom.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonNumber.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonHireDate.equals((Object)itemType) ? sql + " log.FGender,log.FWeights,log.FBirthday,log.FHireDate,log.FOfficePhone1,log.FOfficePhone2,log.fcontact,log.FPersonNumber," : sql + " p.FGender,umap.fweights FWeights,p.FBirthday,log.FHireDate,p.FHomePhone fofficePhone1,p.FOfficePhone fofficePhone2,log.fcontact,log.FPersonNumber,";
        sql = sql + " empType.FinService, case when(umap.FXtId is null OR umap.FXtId ='') then 0 else 1 end isBindSucc,log.ftype itemType from T_XT_SYNCPERSONLOG log left join T_BD_Person p on log.fpersonid = p.FID left join T_HR_BDEmployeeType empType ON p.FEmployeeTypeID = empType.FID left join T_PM_EASXTUSERMAP umap on case when(umap.FCell is null or umap.fcell = '') then to_char(umap.FEmail) else to_char(umap.FCell) end = case when(log.FCell is null or log.fcell = '') then to_char(log.FEmail) else to_char(log.FCell) end where 1=1 ";
        StringBuilder extraFilter = new StringBuilder(sql);
        StringBuilder countSql = new StringBuilder("select count(1) from T_XT_SYNCPERSONLOG log left join T_BD_Person p on log.fpersonid = p.FID left join T_PM_EASXTUSERMAP umap on case when(umap.FCell is null or umap.fcell = '') then to_char(umap.FEmail) else to_char(umap.FCell) end = case when(log.FCell is null or log.fcell = '') then to_char(log.FEmail) else to_char(log.FCell) end where 1=1 ");
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        EasXtSyncLogUtils.appendCommonFilter(countSql, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(countSql, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append("and (log.fpersonname like '%").append(filter).append("%' or ").append(" log.fxtid like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.FOldOrgName like '%").append(filter).append("%' or ").append(" log.Femail like '%").append(filter).append("%' or ").append(" log.FJobTitle like '%").append(filter).append("%' or ").append(" log.fcell like '%").append(filter).append("%' or ").append(" log.fpersonnumber like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ");
            if ("\u5df2\u7ed1\u5b9a".equals(filter)) {
                filterBuilder.append(" (umap.fxtid is not null) or ");
            } else if ("\u672a\u7ed1\u5b9a".equals(filter)) {
                filterBuilder.append(" (umap.fxtid is null or umap.fxtid = '') or ");
            }
            if ("\u7537".equals(filter)) {
                filterBuilder.append(" p.FGender = '").append(1).append("' or ");
                filterBuilder.append(" log.FGender = '").append(1).append("' or ");
            } else if ("\u5973".equals(filter)) {
                filterBuilder.append(" p.FGender = '").append(2).append("' or ");
                filterBuilder.append(" log.FGender = '").append(2).append("' or ");
            }
            filterBuilder.append(" log.forgname like '%").append(filter).append("%' ").append(" )");
            extraFilter.append((CharSequence)filterBuilder);
            countSql.append((CharSequence)filterBuilder);
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
            extraFilter.append(" order by log.fcreatetime desc, log.FOldOrgName asc, log.fpersonName asc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fid", rs.getString("FID"));
                map.put("fpersonname", rs.getString("FPersonName"));
                map.put("fcell", rs.getString("FCell"));
                map.put("femail", rs.getString("FEmail"));
                map.put("forgname", "\\".equals(rs.getString("FOrgName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("FOrgName"));
                map.put("foldorgname", "\\".equals(rs.getString("FOldOrgName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("FOldOrgName"));
                map.put("fmsgcode", rs.getString("FMsgCode"));
                map.put("ferrormsg", StringUtils.isEmpty((String)rs.getString("FErrorMsg")) ? "\u6210\u529f" : "\u5931\u8d25\uff08" + rs.getString("FErrorMsg") + "\uff09");
                map.put("fxtId", StringUtils.isEmpty((String)rs.getString("FErrorMsg")) ? "\u6210\u529f" : "\u5931\u8d25\uff08" + rs.getString("FErrorMsg") + "\uff09");
                map.put("fsuccess", "1".equals(rs.getString("fsuccess")) ? "\u6210\u529f" : "\u5931\u8d25");
                map.put("ftype", EasXtSyncItemType.getEnum(rs.getString("itemType")) == null ? "" : EasXtSyncItemType.getEnum(rs.getString("itemType")).getAlias());
                map.put("index", index);
                map.put("fposition", rs.getString("FJobTitle"));
                map.put("fsynctimeid", rs.getString("fsynctimeid"));
                map.put("fcreatetime", rs.getString("fcreatetime") == null ? "" : rs.getString("fcreatetime").substring(0, 19));
                int updStatus = rs.getInt("FUpdStatus");
                int inService = rs.getInt("FinService");
                String fupdstatus = "";
                String finservice = "";
                switch (updStatus) {
                    case 1: {
                        fupdstatus = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        fupdstatus = "\u79bb\u804c";
                        break;
                    }
                    case 2: {
                        fupdstatus = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        fupdstatus = "\u79bb\u804c";
                        break;
                    }
                    case 4: {
                        fupdstatus = "\u5728\u804c";
                        break;
                    }
                    default: {
                        fupdstatus = "\u7981\u7528";
                    }
                }
                switch (inService) {
                    case 1: {
                        finservice = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        finservice = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        finservice = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        finservice = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        finservice = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        finservice = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                map.put("fupdstatus", fupdstatus);
                map.put("finservice", finservice);
                map.put("fgender", Genders.getEnum((int)rs.getInt("FGender")) == null ? "\u4e0d\u786e\u5b9a" : Genders.getEnum((int)rs.getInt("FGender")).getAlias());
                map.put("fbirthday", rs.getString("FBirthday"));
                map.put("fhiredate", rs.getString("FHireDate"));
                map.put("fofficephone1", rs.getString("FOfficePhone1"));
                map.put("fofficephone2", rs.getString("FOfficePhone2"));
                map.put("fweights", rs.getString("FWeights"));
                map.put("fpersonnumber", rs.getString("fpersonnumber"));
                map.put("fisbindsucc", rs.getString("isBindSucc"));
                String contact = rs.getString("fcontact");
                if (!StringUtils.isEmpty((String)contact) && contact.indexOf("======") > -1) {
                    String[] tmp = contact.split("======");
                    map.put("fxtid", tmp[0]);
                    if (tmp.length > 1) {
                        contact = tmp[1];
                    }
                }
                map.put("fcontact", "-" + contact + "-");
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOrgLeaderSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.fsynctimeid,log.fcreatetime,log.fsuccess,log.FOrgLongName,log.FXtId,log.FMsgCode,log.FErrorMsg,log.fcell,log.fpersonname fresponperson,log.ftype itemType from T_XT_SYNCORGLEADERLOG log where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        StringBuilder countFilter = new StringBuilder("select count(1) from T_XT_SYNCORGLEADERLOG log where 1=1 ");
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        EasXtSyncLogUtils.appendCommonFilter(countFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(countFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            StringBuilder filBuilder = new StringBuilder();
            filBuilder.append(" and (log.fxtid like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.FXtId = '").append(filter).append("' or ").append(" log.fcell like '%").append(filter).append("%' or ").append(" log.forglongname like '%").append(filter).append("%' or ").append(" log.fpersonname like '%").append(filter).append("%' ").append(" )");
            extraFilter.append((CharSequence)filBuilder);
            countFilter.append((CharSequence)filBuilder);
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)countFilter.toString());
            extraFilter.append(" order by log.fcreatetime desc, log.FOrgLongName asc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fid", rs.getString("FID"));
                map.put("fcell", rs.getString("FCell"));
                map.put("fmsgcode", rs.getString("FMsgCode"));
                map.put("forglongname", rs.getString("FOrgLongName"));
                map.put("fxtid", rs.getString("FXtId"));
                map.put("ferrormsg", StringUtils.isEmpty((String)rs.getString("FErrorMsg")) ? "\u6210\u529f" : "\u5931\u8d25\uff08" + rs.getString("FErrorMsg") + "\uff09");
                map.put("fresponperson", rs.getString("fresponperson"));
                map.put("fsuccess", "1".equals(rs.getString("fsuccess")) ? "\u6210\u529f" : "\u5931\u8d25");
                map.put("ftype", EasXtSyncItemType.getEnum(rs.getString("itemType")) == null ? "" : EasXtSyncItemType.getEnum(rs.getString("itemType")).getAlias());
                map.put("index", index);
                map.put("fsynctimeid", rs.getString("fsynctimeid"));
                map.put("fcreatetime", rs.getString("fcreatetime") == null ? "" : rs.getString("fcreatetime").substring(0, 19));
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDeptSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.fsynctimeid,log.fcreatetime,log.fsuccess,log.FOrgLongName,log.FOldPOrgLongName,log.FOldOrgLongName,log.FMsgCode,log.FErrorMsg,case when(omap.fxtorgid is null or omap.fxtorgid = '') then 0 else 1 end isBindSucc,log.ftype itemType,log.fweights weights from T_XT_SYNCDEPTLOG log left join t_pm_easxtorgmap omap on omap.forglongname = log.foldorglongname where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        StringBuilder countSql = new StringBuilder("select count(1) from T_XT_SYNCDEPTLOG log left join t_pm_easxtorgmap omap on omap.forglongname = log.foldorglongname where 1=1");
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        EasXtSyncLogUtils.appendCommonFilter(countSql, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(countSql, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append(" and (log.foldorglongname like '%").append(filter).append("%' or ").append(" ferrormsg like '%").append(filter).append("%' or ").append(" log.forglongname like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" FOldPOrgLongName like '%").append(filter).append("%' ").append(" )");
            extraFilter.append((CharSequence)filterBuilder);
            countSql.append((CharSequence)filterBuilder);
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
            extraFilter.append(" order by log.fcreatetime desc, log.FOldOrgLongName asc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fid", rs.getString("FID"));
                map.put("fmsgcode", rs.getString("FMsgCode"));
                map.put("forglongname", "\\".equals(rs.getString("forglongname")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("forglongname"));
                map.put("foldorglongname", "\\".equals(rs.getString("FOldOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("FOldOrgLongName"));
                map.put("foldporglongname", "\\".equals(rs.getString("FOldPOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("FOldPOrgLongName"));
                map.put("ferrormsg", StringUtils.isEmpty((String)rs.getString("FErrorMsg")) ? "\u6210\u529f" : "\u5931\u8d25\uff08" + rs.getString("FErrorMsg") + "\uff09");
                map.put("fsuccess", "1".equals(rs.getString("fsuccess")) ? "\u6210\u529f" : "\u5931\u8d25");
                map.put("ftype", EasXtSyncItemType.getEnum(rs.getString("itemType")) == null ? "" : EasXtSyncItemType.getEnum(rs.getString("itemType")).getAlias());
                map.put("index", index);
                map.put("fisbindsucc", rs.getString("isBindSucc"));
                map.put("fsynctimeid", rs.getString("fsynctimeid"));
                map.put("fcreatetime", rs.getString("fcreatetime") == null ? "" : rs.getString("fcreatetime").substring(0, 19));
                map.put("fweights", rs.getString("weights"));
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPartJobSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.fid FID,log.fsynctimeid,log.fcreatetime,log.FXtId,log.FOrgId,log.fsuccess,log.FMsgCode,log.FErrorMsg,log.fjobtitle jobtitle,log.FPersonName personName,log.FCell cell,log.FOrgLongName orglongname,log.ftype itemType from T_XT_SYNCPARTLOG log where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        StringBuilder countFilter = new StringBuilder("select count(1) from T_XT_SYNCPARTLOG log where 1=1 ");
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        EasXtSyncLogUtils.appendCommonFilter(countFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(countFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append(" and (log.FOrgLongName like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.FXtId like '%").append(filter).append("%' or ").append(" log.FOrgId like '%").append(filter).append("%' or ").append(" log.FCell like '%").append(filter).append("%' or ").append(" log.fjobtitle like '%").append(filter).append("%' or ").append(" log.FPersonName like '%").append(filter).append("%' ").append(" )");
            extraFilter.append((CharSequence)filterBuilder);
            countFilter.append((CharSequence)filterBuilder);
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)countFilter.toString());
            extraFilter.append(" order by log.fcreatetime desc, log.FOrgLongName asc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fid", rs.getString("FID"));
                map.put("fmsgcode", rs.getString("FMsgCode"));
                map.put("forglongname", "\\".equals(rs.getString("orglongname")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("orglongname"));
                map.put("fpersonname", rs.getString("personName"));
                map.put("fcell", rs.getString("cell"));
                map.put("fjobtitle", rs.getString("jobtitle"));
                map.put("ferrormsg", StringUtils.isEmpty((String)rs.getString("FErrorMsg")) ? "\u6210\u529f" : "\u5931\u8d25\uff08" + rs.getString("FErrorMsg") + "\uff09");
                map.put("fsuccess", "1".equals(rs.getString("fsuccess")) ? "\u6210\u529f" : "\u5931\u8d25");
                map.put("ftype", EasXtSyncItemType.getEnum(rs.getString("itemType")) == null ? "" : EasXtSyncItemType.getEnum(rs.getString("itemType")).getAlias());
                map.put("index", index);
                map.put("fsynctimeid", rs.getString("fsynctimeid"));
                map.put("fcreatetime", rs.getString("fcreatetime") == null ? "" : rs.getString("fcreatetime").substring(0, 19));
                map.put("forgid", rs.getString("forgid"));
                map.put("fxtid", rs.getString("fxtid"));
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRelationsSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.fid FID,log.fsynctimeid,log.fxtid,log.FLeaderxtid,log.fcreatetime,log.fsuccess,log.FMsgCode,log.FErrorMsg,log.FPersonName personName,log.FCell cell,log.FPosition jobtTitle,log.FOrgLongName orgLongName,log.FLeaderPersonName leaderPersonName,log.FLeaderPosition leaderJobTitle,log.ftype itemType from T_XT_SYNCRELATIONSLOG log left join T_PM_EASXTUSERMAP umap on umap.FXtId = log.fxtid left join T_PM_EASXTUSERMAP umapl on umapl.FXtId = log.FLeaderXtId  where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        StringBuilder countFilter = new StringBuilder("select count(1) from T_XT_SYNCRELATIONSLOG log left join T_PM_EASXTUSERMAP umap on umap.FXtId = log.fxtid left join T_PM_EASXTUSERMAP umapl on umapl.FXtId = log.FLeaderXtId  where 1=1 ");
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        EasXtSyncLogUtils.appendCommonFilter(countFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(countFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append(" and (umap.FOrgLongName like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ").append(" log.FLeaderPersonName like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.fxtid like '%").append(filter).append("%' or ").append(" log.FLeaderxtid like '%").append(filter).append("%' or ").append(" log.FPosition like '%").append(filter).append("%' or ").append(" log.FLeaderPosition like '%").append(filter).append("%' or ").append(" log.FOrgLongName like '%").append(filter).append("%' or ").append(" log.FCell like '%").append(filter).append("%' or ").append(" umap.FPersonName like '%").append(filter).append("%' or ").append(" umapl.FPersonName like '%").append(filter).append("%' ").append(" )");
            extraFilter.append((CharSequence)filterBuilder);
            countFilter.append((CharSequence)filterBuilder);
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)countFilter.toString());
            extraFilter.append(" order by log.fcreatetime desc, log.FOrgLongName asc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fid", rs.getString("FID"));
                map.put("fmsgcode", rs.getString("FMsgCode"));
                map.put("forglongname", "\\".equals(rs.getString("orgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString("orgLongName"));
                map.put("fpersonname", rs.getString("personName"));
                map.put("fleaderpersonname", rs.getString("leaderPersonName"));
                map.put("fcell", rs.getString("cell"));
                map.put("fjobtitle", rs.getString("jobtTitle"));
                map.put("fleaderjobtitle", rs.getString("leaderJobTitle"));
                map.put("fleaderxtid", rs.getString("fleaderxtid"));
                map.put("fxtid", rs.getString("fxtid"));
                map.put("ferrormsg", StringUtils.isEmpty((String)rs.getString("FErrorMsg")) ? "\u6210\u529f" : "\u5931\u8d25\uff08" + rs.getString("FErrorMsg") + "\uff09");
                map.put("fsuccess", "1".equals(rs.getString("fsuccess")) ? "\u6210\u529f" : "\u5931\u8d25");
                map.put("ftype", EasXtSyncItemType.getEnum(rs.getString("itemType")) == null ? "" : EasXtSyncItemType.getEnum(rs.getString("itemType")).getAlias());
                map.put("index", index);
                map.put("fsynctimeid", rs.getString("fsynctimeid"));
                map.put("fcreatetime", rs.getString("fcreatetime") == null ? "" : rs.getString("fcreatetime").substring(0, 19));
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    public static void appendCommonFilter(StringBuilder extraFilter, EasXtSyncItemType itemType, String syncTimeId, boolean success, String successReqStr) {
        if (!StringUtils.isEmpty((String)syncTimeId) && BOSUuid.isValid((String)syncTimeId, (boolean)true)) {
            extraFilter.append(" and log.fsynctimeid = '").append(syncTimeId).append("'");
        }
        if (null != itemType) {
            extraFilter.append(" and log.ftype = ").append(Integer.parseInt(itemType.getValue()));
        }
        if (!"All".equalsIgnoreCase(successReqStr)) {
            if (success) {
                extraFilter.append(" and log.fsuccess = 1");
            } else {
                extraFilter.append(" and log.fsuccess = 0 and log.fmsgcode != '209'");
            }
        }
    }

    public static void appendTimeFilter(StringBuilder sql, String createTimeStart, String createTimeEnd) {
        if (!StringUtils.isEmpty((String)createTimeStart) || !StringUtils.isEmpty((String)createTimeEnd)) {
            if (!StringUtils.isEmpty((String)createTimeStart) && !StringUtils.isEmpty((String)createTimeEnd)) {
                Timestamp endValue = new Timestamp(Timestamp.valueOf(createTimeEnd).getTime());
                sql.append(" and log.fcreatetime >={" + Timestamp.valueOf(createTimeStart) + "} and log.fcreatetime <{" + endValue + "} ");
            } else if (!StringUtils.isEmpty((String)createTimeEnd)) {
                Timestamp endValue = new Timestamp(Timestamp.valueOf(createTimeEnd).getTime());
                sql.append(" and log.fcreatetime <{" + endValue + "} ");
            } else {
                sql.append(" and log.fcreatetime >={" + Timestamp.valueOf(createTimeStart) + "} ");
            }
        }
    }

    public static void appendSearchTimeFilter(StringBuilder sql, int searchTime) {
        if (searchTime == 0) {
            return;
        }
        Date searchTimeDate = DateUtils.addDays((Date)new Date(), (int)(-searchTime));
        Timestamp searchTimeStamp = new Timestamp(searchTimeDate.getTime());
        sql.append(" and log.fcreatetime >={" + searchTimeStamp + "} ");
    }

    private static void syncDeptLog(Context ctx, JSONArray orgArray, com.alibaba.fastjson.JSONObject result, EasXtSyncItemType itemType, boolean isAll) {
        if (null == result || null == ctx || null == orgArray) {
            return;
        }
        String currUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String lastSyncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        int msgCode = 209;
        int success = 1;
        String errorMsg = "";
        boolean retSucc = result.getBooleanValue("success");
        if (!retSucc) {
            success = 0;
            msgCode = result.getIntValue("errorCode");
            errorMsg = result.getString("error");
        }
        long time = new Date().getTime();
        for (int i = 0; i < orgArray.size(); ++i) {
            param = new ArrayList();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(currUser);
            param.add(new Timestamp(time));
            if (EasXtSyncItemType.UpdateOrgName.equals((Object)itemType) || EasXtSyncItemType.MoveOrg.equals((Object)itemType)) {
                param.add(((com.alibaba.fastjson.JSONObject)orgArray.get(i)).getString("department"));
                param.add(((com.alibaba.fastjson.JSONObject)orgArray.get(i)).getString("todepartment"));
            } else if (EasXtSyncItemType.SetOrgWeights.equals((Object)itemType)) {
                param.add(((com.alibaba.fastjson.JSONObject)orgArray.get(i)).getString("department"));
                param.add(null);
            } else {
                param.add(orgArray.get(i));
                param.add(null);
            }
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(success);
            param.add(msgCode);
            param.add(lastSyncTimeId);
            param.add(errorMsg);
            if (EasXtSyncItemType.MoveOrg.equals((Object)itemType)) {
                param.add(((com.alibaba.fastjson.JSONObject)orgArray.get(i)).getString("oldPdepartment"));
            } else {
                param.add(null);
            }
            if (EasXtSyncItemType.SetOrgWeights.equals((Object)itemType)) {
                param.add(((com.alibaba.fastjson.JSONObject)orgArray.get(i)).getInteger("weights"));
            } else {
                param.add(Integer.valueOf("-1"));
            }
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u540c\u6b65\u7ec4\u7ec7\u65e5\u5fd7\u8bb0\u5f55----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)inserDeptSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONArray data = null;
        try {
            data = result.getJSONArray("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data != null && data.size() > 0) {
            EasXtSyncLogUtils.updateSyncResult4Dept(ctx, data, lastSyncTimeId, itemType);
        }
        logger.error((Object)inserDeptSql);
        logger.error((Object)"---------\u5168\u90e8\u540c\u6b65\u7ec4\u7ec7\u65e5\u5fd7\u8bb0\u5f55----------");
    }

    public static void updateSyncResult4Dept(Context ctx, JSONArray result, String lastSyncTimeId, EasXtSyncItemType itemType) {
        com.alibaba.fastjson.JSONObject ret = new com.alibaba.fastjson.JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        int msgCode = 209;
        for (int i = 0; i < result.size(); ++i) {
            ret = (com.alibaba.fastjson.JSONObject)result.get(i);
            param = new ArrayList();
            msgCode = ret.getIntValue("msgCode");
            if (202 == msgCode || 204 == msgCode || 205 == msgCode) {
                param.add(1);
            } else {
                param.add(0);
            }
            param.add(msgCode);
            param.add(ret.getString("msg"));
            param.add(ret.getString("msgId"));
            param.add(ret.getString("msgId"));
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(lastSyncTimeId);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u66f4\u65b0\u7ec4\u7ec7\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u5f00\u59cb----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)updateDeptSyncSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.error((Object)updateDeptSyncSql);
        logger.error((Object)"---------\u66f4\u65b0\u7ec4\u7ec7\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u7ed3\u675f----------");
    }

    private static void syncPersonLog(Context ctx, JSONArray personArray, com.alibaba.fastjson.JSONObject result, EasXtSyncItemType itemType, boolean isAll) {
        if (null == result || null == ctx || null == personArray) {
            return;
        }
        String currUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String lastSyncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        int msgCode = 209;
        int success = 1;
        String errorMsg = "";
        boolean retSucc = result.getBooleanValue("success");
        if (!retSucc) {
            success = 0;
            msgCode = result.getIntValue("errorCode");
            errorMsg = result.getString("error");
        }
        com.alibaba.fastjson.JSONObject person = new com.alibaba.fastjson.JSONObject();
        long time = new Date().getTime();
        for (int i = 0; i < personArray.size(); ++i) {
            person = (com.alibaba.fastjson.JSONObject)personArray.get(i);
            param = new ArrayList();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(currUser);
            param.add(new Timestamp(time));
            param.add(person.get((Object)"personId"));
            param.add(person.get((Object)"phone"));
            param.add(person.get((Object)"name"));
            param.add(person.get((Object)"department"));
            param.add(person.get((Object)"todepartment"));
            param.add(person.get((Object)"jobTitle"));
            param.add(person.get((Object)"email"));
            param.add(null == person.getInteger("type") ? Integer.valueOf(1) : person.getInteger("type"));
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(msgCode);
            param.add(success);
            param.add(lastSyncTimeId);
            param.add(errorMsg);
            param.add(null == person.getInteger("gender") ? Integer.valueOf(1) : person.getInteger("gender"));
            param.add(null == person.getInteger("weights") ? Integer.valueOf(1000) : person.getInteger("weights"));
            param.add(null == person.get((Object)"birthday") ? new Timestamp(new Date().getTime()) : Timestamp.valueOf(person.getString("birthday")));
            param.add(null == person.get((Object)"hireDate") ? null : person.getString("hireDate"));
            param.add(person.get((Object)"FOfficePhone1"));
            param.add(person.get((Object)"officePhone2"));
            if (EasXtSyncItemType.UpdatePersonCustom.equals((Object)itemType)) {
                param.add(person.get((Object)"contact"));
            } else {
                param.add(null);
            }
            param.add(person.get((Object)"number"));
            param.add(person.get((Object)"openId"));
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u4eba\u5458\u65e5\u5fd7\u8bb0\u5f55\u5f00\u59cb----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)inserPersonSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONArray data = null;
        try {
            data = result.getJSONArray("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data != null && data.size() > 0) {
            EasXtSyncLogUtils.updateSyncResult4Person(ctx, data, lastSyncTimeId, itemType);
        }
        logger.error((Object)inserPersonSql);
        logger.error((Object)"---------\u4eba\u5458\u65e5\u5fd7\u8bb0\u5f55\u7ed3\u675f----------");
    }

    public static void updateSyncResult4Person(Context ctx, JSONArray result, String lastSyncTimeId, EasXtSyncItemType itemType) {
        com.alibaba.fastjson.JSONObject retPerson = new com.alibaba.fastjson.JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        int msgCode = 209;
        for (int i = 0; i < result.size(); ++i) {
            retPerson = (com.alibaba.fastjson.JSONObject)result.get(i);
            param = new ArrayList();
            msgCode = retPerson.getIntValue("msgCode");
            if (209 == msgCode || 214 == msgCode || 213 == msgCode) continue;
            param.add(0);
            String openId = retPerson.getString("openId");
            String msgId = retPerson.getString("msgId");
            String cell = retPerson.getString("phone");
            if (StringUtils.isEmpty((String)openId)) {
                openId = msgId;
            }
            param.add(msgCode);
            param.add(retPerson.getString("msg"));
            param.add(openId);
            if (EasXtSyncItemType.AddNewPerson.equals((Object)itemType)) {
                param.add(msgId);
                param.add(lastSyncTimeId);
            } else {
                param.add(Integer.parseInt(itemType.getValue()));
                param.add(lastSyncTimeId);
            }
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u540c\u6b65\u4eba\u5458\u65e5\u5fd7\u8bb0\u5f55\u5f00\u59cb----------");
        try {
            if (EasXtSyncItemType.AddNewPerson.equals((Object)itemType)) {
                DbUtil.executeBatch((Context)ctx, (String)updatePersonSyncSql, params);
            } else {
                DbUtil.executeBatch((Context)ctx, (String)updatePersonSyncSql1, params);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.error((Object)updatePersonSyncSql1);
        logger.error((Object)"---------\u540c\u6b65\u4eba\u5458\u65e5\u5fd7\u8bb0\u5f55\u7ed3\u675f----------");
    }

    private static void syncOrgLeaderLog(Context ctx, JSONArray dataArray, com.alibaba.fastjson.JSONObject result, EasXtSyncItemType itemType, boolean isAll) {
        if (null == result || null == ctx || null == dataArray) {
            return;
        }
        String currUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String lastSyncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        int msgCode = 209;
        int success = 1;
        String errorMsg = "";
        boolean retSucc = result.getBooleanValue("success");
        if (!retSucc) {
            success = 0;
            msgCode = result.getIntValue("errorCode");
            errorMsg = result.getString("error");
        }
        long time = new Date().getTime();
        for (int i = 0; i < dataArray.size(); ++i) {
            param = new ArrayList();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(currUser);
            param.add(new Timestamp(time));
            param.add(((com.alibaba.fastjson.JSONObject)dataArray.get(i)).getString("department"));
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(success);
            param.add(lastSyncTimeId);
            param.add(((com.alibaba.fastjson.JSONObject)dataArray.get(i)).getString("openId"));
            param.add(errorMsg);
            param.add(msgCode);
            param.add(((com.alibaba.fastjson.JSONObject)dataArray.get(i)).getString("personName"));
            param.add(((com.alibaba.fastjson.JSONObject)dataArray.get(i)).getString("cell"));
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u540c\u6b65\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u65e5\u5fd7\u8bb0\u5f55----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)insertOrgLeaderSyncSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONArray data = null;
        try {
            data = result.getJSONArray("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data != null && data.size() > 0) {
            EasXtSyncLogUtils.updateSyncResult4OrgLeader(ctx, data, lastSyncTimeId, itemType);
        }
        logger.error((Object)inserDeptSql);
        logger.error((Object)"---------\u5168\u90e8\u540c\u6b65\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u65e5\u5fd7\u8bb0\u5f55----------");
    }

    private static void updateSyncResult4OrgLeader(Context ctx, JSONArray result, String lastSyncTimeId, EasXtSyncItemType itemType) {
        com.alibaba.fastjson.JSONObject ret = new com.alibaba.fastjson.JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        for (int i = 0; i < result.size(); ++i) {
            ret = (com.alibaba.fastjson.JSONObject)result.get(i);
            param = new ArrayList();
            param.add(0);
            param.add(ret.getString("errorMsg"));
            param.add(ret.getString("commitId"));
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(lastSyncTimeId);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u66f4\u65b0\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u5f00\u59cb----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)updateOrgLeaderSyncSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.error((Object)updateOrgLeaderSyncSql);
        logger.error((Object)"---------\u66f4\u65b0\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u7ed3\u675f----------");
    }

    private static void syncPartJobLog(Context ctx, JSONArray dataArray, com.alibaba.fastjson.JSONObject result, EasXtSyncItemType itemType, boolean isAll) {
        if (null == result || null == ctx || null == dataArray) {
            return;
        }
        String currUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String lastSyncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        com.alibaba.fastjson.JSONObject partJob = new com.alibaba.fastjson.JSONObject();
        int msgCode = 209;
        int success = 1;
        String errorMsg = "";
        boolean retSucc = result.getBooleanValue("success");
        if (!retSucc) {
            success = 0;
            msgCode = result.getIntValue("errorCode");
            errorMsg = result.getString("error");
        }
        long time = new Date().getTime();
        for (int i = 0; i < dataArray.size(); ++i) {
            param = new ArrayList();
            partJob = (com.alibaba.fastjson.JSONObject)dataArray.get(i);
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(currUser);
            param.add(new Timestamp(time));
            param.add(partJob.getString("jobTitle"));
            param.add(partJob.getString("orgId"));
            param.add(partJob.getString("openId"));
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(success);
            param.add(lastSyncTimeId);
            param.add(errorMsg);
            param.add(msgCode);
            param.add(partJob.getString("personName"));
            param.add(partJob.getString("cell"));
            param.add(partJob.getString("orgLongName"));
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u540c\u6b65\u517c\u804c\u65e5\u5fd7\u8bb0\u5f55----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)insertPartJobSyncSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONArray data = null;
        try {
            data = result.getJSONArray("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data != null && data.size() > 0) {
            EasXtSyncLogUtils.updateSyncResult4PartJob(ctx, data, lastSyncTimeId, itemType);
        }
        logger.error((Object)insertPartJobSyncSql);
        logger.error((Object)"---------\u5168\u90e8\u540c\u6b65\u517c\u804c\u65e5\u5fd7\u8bb0\u5f55----------");
    }

    private static void updateSyncResult4PartJob(Context ctx, JSONArray result, String lastSyncTimeId, EasXtSyncItemType itemType) {
        com.alibaba.fastjson.JSONObject ret = new com.alibaba.fastjson.JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = null;
        for (int i = 0; i < result.size(); ++i) {
            String[] comnitIds;
            String commitId;
            if (result.get(i) == null || StringUtils.isEmpty((String)(commitId = (ret = (com.alibaba.fastjson.JSONObject)result.get(i)).getString("commitId"))) || (comnitIds = commitId.split("____")).length < 2) continue;
            param = new ArrayList<Object>();
            param.add(0);
            param.add(ret.getString("errorMsg"));
            param.add(comnitIds[0]);
            param.add(comnitIds[1]);
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(lastSyncTimeId);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u66f4\u65b0\u517c\u804c\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u5f00\u59cb----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)updatePartJobSyncSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.error((Object)updatePartJobSyncSql);
        logger.error((Object)"---------\u66f4\u65b0\u517c\u804c\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u7ed3\u675f----------");
    }

    private static void syncRelationsLog(Context ctx, JSONArray dataArray, com.alibaba.fastjson.JSONObject result, EasXtSyncItemType itemType, boolean isAll) {
        if (null == result || null == ctx || null == dataArray) {
            return;
        }
        String currUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String lastSyncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        com.alibaba.fastjson.JSONObject relations = new com.alibaba.fastjson.JSONObject();
        int msgCode = 209;
        int success = 1;
        String errorMsg = "";
        boolean retSucc = result.getBooleanValue("success");
        if (!retSucc) {
            success = 0;
            msgCode = result.getIntValue("errorCode");
            errorMsg = result.getString("error");
        }
        long time = new Date().getTime();
        for (int i = 0; i < dataArray.size(); ++i) {
            param = new ArrayList();
            relations = (com.alibaba.fastjson.JSONObject)dataArray.get(i);
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(currUser);
            param.add(new Timestamp(time));
            param.add(relations.getString("leaderOpenId"));
            param.add(relations.getString("openId"));
            param.add(relations.getString("relationType"));
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(success);
            param.add(lastSyncTimeId);
            param.add(errorMsg);
            param.add(msgCode);
            param.add(relations.getString("personName"));
            param.add(relations.getString("cell"));
            param.add(relations.getString("orgLongName"));
            param.add(relations.getString("position"));
            param.add(relations.getString("leaderPersonName"));
            param.add(relations.getString("leaderPosition"));
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u540c\u6b65\u4e0a\u7ea7\u65e5\u5fd7\u8bb0\u5f55----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)insertRelationsSyncSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        JSONArray data = null;
        try {
            data = result.getJSONArray("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data != null && data.size() > 0) {
            EasXtSyncLogUtils.updateSyncResult4Relations(ctx, data, lastSyncTimeId, itemType);
        }
        logger.error((Object)insertRelationsSyncSql);
        logger.error((Object)"---------\u5168\u90e8\u540c\u4e0a\u7ea7\u65e5\u5fd7\u8bb0\u5f55----------");
    }

    private static void updateSyncResult4Relations(Context ctx, JSONArray result, String lastSyncTimeId, EasXtSyncItemType itemType) {
        com.alibaba.fastjson.JSONObject ret = new com.alibaba.fastjson.JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        for (int i = 0; i < result.size(); ++i) {
            String[] comnitIds;
            param = new ArrayList();
            ret = (com.alibaba.fastjson.JSONObject)result.get(i);
            String commitId = ret.getString("commitId");
            if (StringUtils.isEmpty((String)commitId) || (comnitIds = commitId.split("____")).length < 2) continue;
            param.add(0);
            param.add(ret.getString("errorMsg"));
            param.add(comnitIds[0]);
            param.add(comnitIds[1]);
            param.add(Integer.parseInt(itemType.getValue()));
            param.add(lastSyncTimeId);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u66f4\u65b0\u4eba\u5458\u4e0a\u7ea7\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u5f00\u59cb----------");
        try {
            DbUtil.executeBatch((Context)ctx, (String)updateRelationsSyncSql, params);
        }
        catch (Exception e) {
            logger.error((Object)"---------\u66f4\u65b0\u4eba\u5458\u4e0a\u7ea7\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
        logger.error((Object)updateRelationsSyncSql);
        logger.error((Object)"---------\u66f4\u65b0\u4eba\u5458\u4e0a\u7ea7\u65e5\u5fd7\u72b6\u6001\u8bb0\u5f55\u7ed3\u675f----------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastSyncTimeId(Context ctx) {
        String sql = "select top 1 fid from t_xt_synchtime order by fsynchtime desc";
        IRowSet rs = null;
        String lastSyncId = BOSUuid.create((String)"F4AF4F04").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && StringUtils.isEmpty((String)(lastSyncId = rs.getString("fid")))) {
                sql = "insert into t_xt_synchtime (fid,fsynchtime) values('" + lastSyncId + "', '" + new Date() + "')";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return lastSyncId;
    }
}

