/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.IPrivacySolution;
import com.kingdee.bos.openapi.PrivacySolutionFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.xtsync.xtutil.JSONUtil;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.PrivacyFieldBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivacyProtectUtil {
    private static final Logger logger = LoggerFactory.getLogger(PrivacyProtectUtil.class);
    private static final String SENSITIVE_FIELD_FCELL = "fcell";
    private static final String SENSITIVE_FIELD_FEMAIL = "femail";
    private static final String SENSITIVE_FIELD_FOLDPHONE = "foldphone";
    private static final String SENSITIVE_FIELD_FNEWPHONE = "fnewphone";
    private static volatile String PRIVACY_FIELDS_STATUS_XT = "encoded";
    private static volatile String PRIVACY_FIELDS_STATUS_WX = "encoded";
    private static volatile String PRIVACY_FIELDS_STATUS_DD = "encoded";
    private static volatile String PRIVACY_FIELDS_STATUS_WL = "encoded";
    private static volatile List<PrivacyFieldBean> privacyFieldListForXT = new ArrayList<PrivacyFieldBean>();
    private static volatile List<PrivacyFieldBean> privacyFieldListForWX = new ArrayList<PrivacyFieldBean>();
    private static volatile List<PrivacyFieldBean> privacyFieldListForDD = new ArrayList<PrivacyFieldBean>();
    private static volatile List<PrivacyFieldBean> privacyFieldListForWL = new ArrayList<PrivacyFieldBean>();
    private static final String[] privacy_fields_all_xt = new String[]{"T_PM_EASXTUSERMAP;fcell;femail", "T_XT_SYNCRELATIONSLOG;fcell", "T_XT_CELLUPDATERECORDS;fnewphone;foldphone", "T_XT_USER;fcell;femail", "T_XT_SYNCPARTLOG;fcell", "T_XT_SYNCORGLEADERLOG;fcell", "T_XT_SYNCPERSONLOG;fcell;femail", "T_PM_USER;FnCell;FbackupEMail;Fcell;Femail", "T_BD_PERSON;FnCell;Femail;Fcell;FbackupCell;FbackupEMail"};
    private static final String[] privacy_fields_all_wx = new String[]{"T_WX_USER;fcell;femail", "T_WX_SYNCPERSONLOG;fcell;femail", "T_PM_USER;FnCell;FbackupEMail;Fcell;Femail", "T_BD_PERSON;FnCell;Femail;Fcell;FbackupCell;FbackupEMail"};
    private static final String[] privacy_fields_all_dd = new String[]{"T_DD_SYNCPERSONLOG;fcell;femail", "T_PM_USER;FnCell;FbackupEMail;Fcell;Femail", "T_BD_PERSON;FnCell;Femail;Fcell;FbackupCell;FbackupEMail"};
    private static final String[] privacy_fields_all_wl = new String[]{"T_WL_USER;fcell;femail", "T_WL_SYNCPERSONLOG;Fcell;Femail", "T_PM_USER;FnCell;FbackupEMail;Fcell;Femail", "T_BD_PERSON;FnCell;Femail;Fcell;FbackupCell;FbackupEMail"};

    public static Object hideSensitiveInfo(Object result) {
        try {
            if (!PrivacyProtectUtil.isSensitiveDef()) {
                return result;
            }
            ArrayList<String> sensitiveFieldList = new ArrayList<String>();
            if (result != null && result instanceof String) {
                String resultStr = result.toString();
                if (resultStr.contains(SENSITIVE_FIELD_FCELL)) {
                    sensitiveFieldList.add(SENSITIVE_FIELD_FCELL);
                }
                if (resultStr.contains(SENSITIVE_FIELD_FEMAIL)) {
                    sensitiveFieldList.add(SENSITIVE_FIELD_FEMAIL);
                }
                if (resultStr.contains(SENSITIVE_FIELD_FOLDPHONE)) {
                    sensitiveFieldList.add(SENSITIVE_FIELD_FOLDPHONE);
                }
                if (resultStr.contains(SENSITIVE_FIELD_FNEWPHONE)) {
                    sensitiveFieldList.add(SENSITIVE_FIELD_FNEWPHONE);
                }
                if (sensitiveFieldList.size() == 0) {
                    return result;
                }
                PageResult object4Json = PrivacyProtectUtil.getResultObject(resultStr);
                List rows = object4Json.getRows();
                HashMap map = null;
                for (int i = 0; i < rows.size(); ++i) {
                    map = (HashMap)rows.get(i);
                    for (int j = 0; j < sensitiveFieldList.size(); ++j) {
                        String fieldValue;
                        String fieldName = (String)sensitiveFieldList.get(j);
                        String string = fieldValue = map.get(fieldName) == null ? null : map.get(fieldName).toString();
                        if (SENSITIVE_FIELD_FEMAIL.equalsIgnoreCase(fieldName)) {
                            map.put(fieldName, PrivacyProtectUtil.hideEmailInfo(fieldValue));
                            continue;
                        }
                        map.put(fieldName, PrivacyProtectUtil.hidePhoneInfo(fieldValue));
                    }
                }
                return JSONUtil.getJson4Object(object4Json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String hideEmailInfo(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return email;
        }
        int mid = email.lastIndexOf("@");
        int suffix = email.lastIndexOf(".");
        if (suffix < 0 || mid < 0 || suffix < mid) {
            return email;
        }
        char[] charArray = email.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (i == 0 || i == mid || i >= suffix) continue;
            charArray[i] = "*".charAt(0);
        }
        return new String(charArray);
    }

    public static String hidePhoneInfo(String newPhone) {
        if (newPhone == null || newPhone.length() == 0) {
            return "";
        }
        if (newPhone.contains("+")) {
            String[] split = newPhone.split("-", 2);
            String realPhone = split[1];
            int length = realPhone.length();
            if (length == 0) {
                return newPhone;
            }
            if (length < 3) {
                return split[0] + "-**";
            }
            return split[0] + "-" + PrivacyProtectUtil.calculateHide(realPhone);
        }
        if (newPhone.length() == 11) {
            String replaceCell = newPhone.replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2");
            return replaceCell;
        }
        return PrivacyProtectUtil.calculateHide(newPhone);
    }

    private static String calculateHide(String oldPhone) {
        int length = oldPhone.length();
        int hideLength = length % 2 == 0 ? length / 2 : length / 2 + 1;
        int start = (length - hideLength) / 2;
        int end = start + hideLength;
        String substring = oldPhone.substring(0, start);
        String substring2 = oldPhone.substring(end, length);
        StringBuilder hideChar = new StringBuilder(hideLength);
        for (int count = 0; count < hideLength; ++count) {
            hideChar.append("*");
        }
        return substring + hideChar.toString() + substring2;
    }

    private static PageResult getResultObject(String resultStr) {
        HashMap<String, Class<HashMap>> propertyClassMapping = new HashMap<String, Class<HashMap>>();
        propertyClassMapping.put("rows", HashMap.class);
        PageResult object4Json = (PageResult)JSONUtil.getObject4Json(resultStr, PageResult.class, propertyClassMapping);
        return object4Json;
    }

    public static boolean isSensitiveDef() {
        String paramValue = "false";
        try {
            paramValue = ParamControlFactory.getRemoteInstance().getParamValue(null, "PersonSensitiveDataMasking");
        }
        catch (BOSException | EASBizException e) {
            e.printStackTrace();
        }
        return "true".equalsIgnoreCase(paramValue);
    }

    public static boolean decodePrivacyFields(Context ctx, String type) throws BOSException {
        String status = PrivacyProtectUtil.getPrivacyFieldStatus(type);
        if (!"encoded".equals(status)) {
            throw new BOSException();
        }
        PrivacyProtectUtil.findNeedDencodeFields(ctx, type);
        if (PrivacyProtectUtil.privacyRealFieldList(type).size() < 1) {
            return false;
        }
        status = PrivacyProtectUtil.getPrivacyFieldStatus(type);
        if (!"encoded".equals(status)) {
            throw new BOSException();
        }
        PrivacyProtectUtil.setPrivacyFieldStatus(type, "decoding");
        IPrivacySolution privacySolution = PrivacySolutionFactory.getLocalInstance((Context)ctx);
        HashSet<String> tableNameSet = new HashSet<String>();
        for (PrivacyFieldBean privacyFieldBean : PrivacyProtectUtil.privacyRealFieldList(type)) {
            String tableName = privacyFieldBean.getTableName();
            PrivacyProtectUtil.changePrivacyFieldsStatus(tableName, "0", ctx);
            tableNameSet.add(tableName);
        }
        FilterInfo paramFilterInfo = new FilterInfo();
        paramFilterInfo.getFilterItems().add(new FilterItemInfo("tableName", tableNameSet, CompareType.INCLUDE));
        privacySolution.execute(paramFilterInfo);
        return true;
    }

    public static boolean encodePrivacyFields(Context ctx, String type) throws BOSException {
        String status = PrivacyProtectUtil.getPrivacyFieldStatus(type);
        if (!"decoded".equals(status)) {
            return false;
        }
        PrivacyProtectUtil.setPrivacyFieldStatus(type, "encoding");
        IPrivacySolution privacySolution = PrivacySolutionFactory.getLocalInstance((Context)ctx);
        HashSet<String> tableNameSet = new HashSet<String>();
        for (PrivacyFieldBean privacyFieldBean : PrivacyProtectUtil.privacyRealFieldList(type)) {
            String tableName = privacyFieldBean.getTableName();
            PrivacyProtectUtil.changePrivacyFieldsStatus(tableName, "1", ctx);
            tableNameSet.add(tableName);
        }
        FilterInfo paramFilterInfo = new FilterInfo();
        paramFilterInfo.getFilterItems().add(new FilterItemInfo("tableName", tableNameSet, CompareType.INCLUDE));
        privacySolution.execute(paramFilterInfo);
        return true;
    }

    private static void changePrivacyFieldsStatus(String tableName, String isEncode, Context ctx) throws BOSException {
        String sql = "update T_Privacy_Mapping set fisEncrypt=" + isEncode + " where FtableName = '" + tableName + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static boolean checkDncodePrivacyIsOver(Context ctx, String type) {
        for (PrivacyFieldBean privacyFieldBean : PrivacyProtectUtil.privacyRealFieldList(type)) {
            String field = privacyFieldBean.getField();
            String tableName = privacyFieldBean.getTableName();
            if (!PrivacyProtectUtil.checkIsEncodeOfField(tableName, field, ctx)) continue;
            return false;
        }
        PrivacyProtectUtil.setPrivacyFieldStatus(type, "decoded");
        return true;
    }

    public static boolean checkEncodePrivacyIsOver(Context ctx, String type) {
        for (PrivacyFieldBean privacyFieldBean : PrivacyProtectUtil.privacyRealFieldList(type)) {
            String field = privacyFieldBean.getField();
            String tableName = privacyFieldBean.getTableName();
            if (PrivacyProtectUtil.checkIsEncodeOfField(tableName, field, ctx)) continue;
            return false;
        }
        PrivacyProtectUtil.setPrivacyFieldStatus(type, "encoded");
        return true;
    }

    private static List<PrivacyFieldBean> findNeedDencodeFields(Context ctx, String type) {
        PrivacyProtectUtil.privacyRealFieldList(type).clear();
        for (int i = 0; i < PrivacyProtectUtil.getPrivacyFieldList(type).length; ++i) {
            String[] tableAndFields = PrivacyProtectUtil.getPrivacyFieldList(type)[i].split(";");
            String tableName = tableAndFields[0];
            for (int j = 1; j < tableAndFields.length; ++j) {
                String field = tableAndFields[j];
                if (!PrivacyProtectUtil.checkIsEncodeOfField(tableName, field, ctx)) continue;
                PrivacyFieldBean privacyfieldbean = new PrivacyFieldBean();
                privacyfieldbean.setField(field);
                privacyfieldbean.setTableName(tableName);
                PrivacyProtectUtil.privacyRealFieldList(type).add(privacyfieldbean);
            }
        }
        return PrivacyProtectUtil.privacyRealFieldList(type);
    }

    private static boolean checkIsEncodeOfField(String tableName, String field, Context ctx) {
        field = field + "_P";
        String sql = "select count(1) from " + tableName + " where " + field + " is not null";
        try {
            int count;
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (result != null && result.next() && (count = result.getInt(1)) > 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error(tableName + ":" + field + " not exist");
        }
        return false;
    }

    public static void setPrivacyFieldStatus(String type, String status) {
        if ("xt".equals(type)) {
            PRIVACY_FIELDS_STATUS_XT = status;
        } else if ("wx".equals(type)) {
            PRIVACY_FIELDS_STATUS_WX = status;
        } else if ("dd".equals(type)) {
            PRIVACY_FIELDS_STATUS_DD = status;
        } else if ("wl".equals(type)) {
            PRIVACY_FIELDS_STATUS_WL = status;
        }
    }

    public static String getPrivacyFieldStatus(String type) {
        if ("xt".equals(type)) {
            return PRIVACY_FIELDS_STATUS_XT;
        }
        if ("wx".equals(type)) {
            return PRIVACY_FIELDS_STATUS_WX;
        }
        if ("dd".equals(type)) {
            return PRIVACY_FIELDS_STATUS_DD;
        }
        if ("wl".equals(type)) {
            return PRIVACY_FIELDS_STATUS_WL;
        }
        return PRIVACY_FIELDS_STATUS_XT;
    }

    public static String[] getPrivacyFieldList(String type) {
        if ("xt".equals(type)) {
            return privacy_fields_all_xt;
        }
        if ("wx".equals(type)) {
            return privacy_fields_all_wx;
        }
        if ("dd".equals(type)) {
            return privacy_fields_all_dd;
        }
        if ("wl".equals(type)) {
            return privacy_fields_all_wl;
        }
        return privacy_fields_all_xt;
    }

    public static List<PrivacyFieldBean> privacyRealFieldList(String type) {
        if ("xt".equals(type)) {
            return privacyFieldListForXT;
        }
        if ("wx".equals(type)) {
            return privacyFieldListForWX;
        }
        if ("dd".equals(type)) {
            return privacyFieldListForDD;
        }
        if ("wl".equals(type)) {
            return privacyFieldListForWL;
        }
        return privacyFieldListForXT;
    }

    public static boolean getNetMutexStatus(Context ctx) {
        try {
            IMutexServiceControl iMutex = null;
            MutexParameter mutexParam = new MutexParameter();
            iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutexParam.setMutexName("sync:" + ctx.getContextID());
            mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            mutexParam.setRequestId(Uuid.fromString((String)ctx.getContextID()));
            mutexParam.setActionName("syncMutexLock");
            boolean requestMutex2 = iMutex.requestMutex2(mutexParam);
            return requestMutex2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void releaseNetMutexStatus(Context ctx) {
        try {
            IMutexServiceControl iMutex = null;
            iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            iMutex.releaseMutex(Uuid.fromString((String)ctx.getContextID()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkPrivacyBefore(Context ctx, String privacyType) throws BOSException {
        try {
            boolean requestMutex = PrivacyProtectUtil.getNetMutexStatus(ctx);
            if (!requestMutex) {
                throw new BOSException();
            }
            boolean isNeedDecode = PrivacyProtectUtil.decodePrivacyFields(ctx, privacyType);
            if (isNeedDecode) {
                int count = 0;
                while (!PrivacyProtectUtil.checkDncodePrivacyIsOver(ctx, privacyType)) {
                    TimeUnit.SECONDS.sleep(10L);
                    if (++count <= 720) continue;
                    PrivacyProtectUtil.setPrivacyFieldStatus(privacyType, "encoded");
                    throw new BOSException();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PrivacyProtectUtil.setPrivacyFieldStatus(privacyType, "encoded");
            throw new BOSException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPrivacyAfter(Context ctx, String privacyType) {
        try {
            boolean isNeedEncode = PrivacyProtectUtil.encodePrivacyFields(ctx, privacyType);
            if (isNeedEncode) {
                int count = 0;
                while (!PrivacyProtectUtil.checkEncodePrivacyIsOver(ctx, privacyType)) {
                    TimeUnit.SECONDS.sleep(10L);
                    if (++count <= 2160) continue;
                    PrivacyProtectUtil.setPrivacyFieldStatus(privacyType, "encoded");
                }
            }
        }
        catch (Exception e) {
            PrivacyProtectUtil.setPrivacyFieldStatus(privacyType, "encoded");
            e.printStackTrace();
        }
        finally {
            PrivacyProtectUtil.releaseNetMutexStatus(ctx);
        }
    }
}

