/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.property;

import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class PropertyPanel
extends KDPanel {
    private KDTable tbl = new KDTable();
    private KDPanel bar = new KDPanel();
    private KDWorkButton wbAdd = new KDWorkButton(" + ");
    private KDWorkButton wbDel = new KDWorkButton(" - ");
    private KDComboBox cbCol = new KDComboBox();
    private Column[] cols = null;

    public PropertyPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        KDPanel btnPanel = new KDPanel();
        btnPanel.setLayout((LayoutManager)new FlowLayout(2, 3, 2));
        btnPanel.add((Component)this.wbAdd);
        btnPanel.add((Component)this.wbDel);
        this.bar.setLayout((LayoutManager)new BorderLayout());
        this.bar.add((Component)new KDLabel("\u5c5e\u6027"), (Object)"West");
        this.bar.add((Component)btnPanel, (Object)"East");
        this.wbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.doAdd();
            }
        });
        this.wbDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.doDel();
            }
        });
        this.add((Component)this.bar, "North");
        this.tbl.addColumn();
        this.tbl.addColumn();
        this.tbl.addColumn().setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbCol));
        IRow row = this.tbl.addHeadRow();
        row.getCell(0).setValue((Object)"\u5c5e\u6027\u540d");
        row.getCell(1).setValue((Object)"\u5c5e\u6027\u6807\u9898");
        row.getCell(2).setValue((Object)"\u5c5e\u6027\u5b57\u6bb5");
        this.add((Component)this.tbl, "Center");
        this.setPreferredSize(new Dimension(200, 120));
    }

    private void doAdd() {
        this.wbDel.setEnabled(true);
        this.addProperty(new WizardContext.PropertyInfo());
    }

    private void doDel() {
        KDTSelectBlock b = this.tbl.getSelectManager().get();
        if (b != null) {
            for (int i = b.getEndRow(); i >= b.getBeginRow(); --i) {
                this.tbl.removeRow(i);
            }
        }
        this.wbDel.setEnabled(this.tbl.getRowCount() > 0);
    }

    private void addProperty(WizardContext.PropertyInfo pi) {
        this.wbDel.setEnabled(true);
        IRow r = this.tbl.addRow();
        r.getCell(0).setValue((Object)pi.name);
        r.getCell(1).setValue((Object)pi.caption);
        if (pi.column != null) {
            for (int i = 0; i < this.cols.length; ++i) {
                if (!pi.column.equals(this.cols[i].getName())) continue;
                r.getCell(2).setValue((Object)this.cols[i]);
                break;
            }
        }
        this.tbl.updateUI();
    }

    public void setColumn(Column[] cols) {
        this.cbCol.removeAllItems();
        this.cbCol.addItems((Object[])cols);
        this.cols = cols;
    }

    public void setProperties(List pis) {
        if (pis != null) {
            WizardContext.PropertyInfo[] pp = new WizardContext.PropertyInfo[pis.size()];
            pis.toArray(pp);
            this.setProperties(pp);
        } else {
            this.tbl.removeRows();
        }
    }

    public void setProperties(WizardContext.PropertyInfo[] pis) {
        this.tbl.removeRows();
        if (pis != null) {
            int n = pis.length;
            for (int i = 0; i < n; ++i) {
                this.addProperty(pis[i]);
            }
        }
    }

    public WizardContext.PropertyInfo[] getProperties() {
        int n = this.tbl.getRowCount();
        WizardContext.PropertyInfo[] pp = new WizardContext.PropertyInfo[n];
        for (int i = 0; i < n; ++i) {
            pp[i] = new WizardContext.PropertyInfo();
            pp[i].name = (String)this.tbl.getCell(i, 0).getValue();
            pp[i].caption = (String)this.tbl.getCell(i, 1).getValue();
            Column col = (Column)this.tbl.getCell(i, 2).getValue();
            if (col == null) continue;
            pp[i].column = col.getName();
        }
        return pp;
    }

    public boolean vertify() {
        WizardContext.PropertyInfo[] pp = this.getProperties();
        for (int i = 0; i < pp.length; ++i) {
            if (pp[i].name != null && pp[i].caption != null && pp[i].column != null) continue;
            this.tbl.getSelectManager().select(i, 0);
            this.tbl.requestFocus();
            JOptionPane.showMessageDialog((Component)((Object)this), "\u7b2c" + (i + 1) + "\u884c\u5c5e\u6027\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff01", "\u63d0\u793a", 2);
            return false;
        }
        return true;
    }
}

