/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.olapconnection.ui;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.UIContext;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectStringParser;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectionInfoWrapper;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IURLResolver;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectConstants;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectionInfo;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ui.F7Selector;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ui.ICubeModelSelectComponent;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaParser;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class OlapConnectionInfoEditUI
extends TypicalDialog
implements OlapConnectConstants {
    ICubeModelSelectComponent cubeModelSelectComponent;
    F7Selector selector;
    IURLResolver urlResolver;
    private KDComboBox cbType = new KDComboBox();
    private KDLabelContainer lblType = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"ServerType"), (JComponent)this.cbType);
    private KDTextField tfName = new KDTextField();
    private KDLabelContainer lblName = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"Name"), (JComponent)this.tfName);
    private KDTextField tfAlias = new KDTextField();
    private KDLabelContainer lblAlias = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"Alias"), (JComponent)this.tfAlias);
    private KDButton btnTest = new KDButton(ReportResource.getString(ReportResource.class, (String)"TestConnection"));
    private KDPanel pnlTest = new KDPanel();
    private OptionPanel optionPanel = new OptionPanel();
    OlapConnectionInfo info;
    String name;
    String alias;
    String connectString;

    public OlapConnectionInfoEditUI(UIContext context) {
        this.setUIContext(context);
    }

    public OlapConnectionInfoEditUI(Dialog owner, UIContext context) {
        super(owner);
        this.setUIContext(context);
        super.addControls();
    }

    public OlapConnectionInfoEditUI(Frame owner, UIContext context) {
        super(owner);
        this.setUIContext(context);
        super.addControls();
    }

    private void setUIContext(UIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "UIContext.");
        }
        Object o = context.get(UIContext.KEY_CubeModelSelectComponent);
        if (o == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "ICubeModelSelectComponent");
        }
        if (!(o instanceof ICubeModelSelectComponent)) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustImplement") + "ICubeModelSelectComponent" + ReportResource.getString(ReportResource.class, (String)"Interface"));
        }
        this.setCubeModelSelectComponent((ICubeModelSelectComponent)o);
        o = context.get(UIContext.KEY_URLResolver);
        if (o == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "IURLResolver");
        }
        if (!(o instanceof IURLResolver)) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustImplement") + "IURLResolver" + ReportResource.getString(ReportResource.class, (String)"Interface"));
        }
        this.setUrlResolver((IURLResolver)o);
    }

    private void setCubeModelSelectComponent(ICubeModelSelectComponent cubeModelSelectComponent) {
        this.cubeModelSelectComponent = cubeModelSelectComponent;
        this.optionPanel.setF7Select(cubeModelSelectComponent);
    }

    private void setUrlResolver(IURLResolver resolver) {
        this.urlResolver = resolver;
    }

    protected void todoInit() {
        this.setTitle(ReportResource.getString(ReportResource.class, (String)"ConnectionProperty"));
        this.setSize(540, 440);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.lblType.setBoundLabelLength(150);
        this.lblType.setBoundLabelUnderline(true);
        this.lblName.setBoundLabelLength(150);
        this.lblName.setBoundLabelUnderline(true);
        this.lblAlias.setBoundLabelLength(150);
        this.lblAlias.setBoundLabelUnderline(true);
        Table layout = thisCell.splitRow(7);
        this.cbType.addItem((Object)OLAPSERVERTYPE_KDOLAP);
        this.cbType.addItem((Object)OLAPSERVERTYPE_MSOLAP_XMLA);
        this.cbType.addItemListener((ItemListener)this.optionPanel);
        parent.add((Component)this.lblType, layout.cell(0));
        parent.add((Component)this.lblName, layout.cell(1));
        parent.add((Component)this.lblAlias, layout.cell(2));
        parent.add((Component)new KDSeparator(), layout.cell(3));
        parent.add((Component)((Object)this.optionPanel), layout.cell(4));
        parent.add((Component)this.pnlTest, layout.cell(6));
        layout.rowStyle(4).setPriY(1);
        this.pnlTest.setLayout((LayoutManager)new FlowLayout(2));
        this.pnlTest.add((Component)this.btnTest);
        this.btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlapConnectionInfoEditUI.this.testConnection();
            }
        });
        this.optionPanel.typeChanged();
    }

    public void setOlapConnectionInfo(OlapConnectionInfo info) {
        this.info = info;
        this.tfName.setEditable(false);
        this.tfName.setText(info.getName());
        this.tfAlias.setText(info.getAlias());
        switch (info.getType()) {
            case 0: {
                try {
                    this.cbType.setSelectedItem((Object)OLAPSERVERTYPE_KDOLAP);
                    String url = new ConnectStringParser().parse(info.getConnectString()).getUrl();
                    this.optionPanel.pbCubeModel.setValue((Object)url);
                    this.selector.setCurrentData(url);
                    break;
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
            }
        }
    }

    private void testConnection() {
        this.optionPanel.testConnection(false);
    }

    protected boolean verify() {
        this.name = this.tfName.getText().trim();
        if (this.name.length() == 0) {
            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"NameNotNull"));
            this.tfName.requestFocus();
            return false;
        }
        this.alias = this.tfAlias.getText().trim();
        if (this.alias.length() == 0) {
            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"AliasNotNull"));
            this.tfAlias.requestFocus();
            return false;
        }
        if (this.optionPanel.cache != null) {
            return true;
        }
        return this.optionPanel.testConnection(true);
    }

    public OlapConnectionInfo getResult() {
        return new OlapConnectionInfo(this.name, this.alias, this.optionPanel.currentType.getType(), this.optionPanel.getConnectString());
    }

    Object getTestedResult() {
        return this.optionPanel.cache;
    }

    class OptionPanel
    extends KDPanel
    implements ItemListener {
        CardLayout layout = new CardLayout();
        KDPanel kdolap = new KDPanel();
        KDPanel msolap_xmla = new KDPanel();
        KDPromptBox pbCubeModel = new KDPromptBox();
        KDLabelContainer lblCubeModel = new KDLabelContainer("MD" + ReportResource.getString(ReportResource.class, (String)"MultiDimensionModel"), (JComponent)this.pbCubeModel);
        KDTextField msolap_xmla_tfUrl = new KDTextField("http://");
        KDTextField msolap_xmla_tfUser = new KDTextField();
        KDPasswordField msolap_xmla_tfPassword = new KDPasswordField();
        KDLabelContainer lblUrl = new KDLabelContainer("URL", (JComponent)this.msolap_xmla_tfUrl);
        KDLabelContainer lblUser = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"user"), (JComponent)this.msolap_xmla_tfUser);
        KDLabelContainer lblPassword = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"secretcode"), (JComponent)this.msolap_xmla_tfPassword);
        OlapConnectConstants.OlapServerType currentType;
        boolean connected = false;
        Object cache;

        OptionPanel() {
            this.setBorder(new TitledBorder(ReportResource.getString(ReportResource.class, (String)"ServerOption")));
            this.setLayout(this.layout);
            this.initKdolap();
            this.initMsolap_xmla();
            this.add(OlapConnectConstants.OLAPSERVERTYPE_KDOLAP.toString(), (Component)this.kdolap);
            this.add(OlapConnectConstants.OLAPSERVERTYPE_MSOLAP_XMLA.toString(), (Component)this.msolap_xmla);
        }

        private void initKdolap() {
            this.lblCubeModel.setBoundLabelLength(150);
            this.lblCubeModel.setBoundLabelUnderline(true);
            TableLayout layout = TableLayout.splitRow((int)2);
            this.kdolap.setLayout((LayoutManager)layout);
            layout.rowStyle(1).setPriY(1);
            this.pbCubeModel.setEditable(false);
            this.kdolap.add((Component)this.lblCubeModel, (Object)layout.cell(0));
        }

        void setF7Select(ICubeModelSelectComponent cubeModelSelectComponent) {
            OlapConnectionInfoEditUI.this.selector = new F7Selector((Dialog)((Object)OlapConnectionInfoEditUI.this), cubeModelSelectComponent);
            this.pbCubeModel.setSelector((KDPromptSelector)OlapConnectionInfoEditUI.this.selector);
        }

        private void initMsolap_xmla() {
            this.lblUrl.setBoundLabelLength(150);
            this.lblUrl.setBoundLabelUnderline(true);
            this.lblUser.setBoundLabelLength(150);
            this.lblUser.setBoundLabelUnderline(true);
            this.lblPassword.setBoundLabelLength(150);
            this.lblPassword.setBoundLabelUnderline(true);
            TableLayout layout = TableLayout.splitRow((int)4);
            this.msolap_xmla.setLayout((LayoutManager)layout);
            layout.rowStyle(3).setPriY(1);
            this.msolap_xmla.add((Component)this.lblUrl, (Object)layout.cell(0));
            this.msolap_xmla.add((Component)this.lblUser, (Object)layout.cell(1));
            this.msolap_xmla.add((Component)this.lblPassword, (Object)layout.cell(2));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.typeChanged();
            }
        }

        private void typeChanged() {
            this.currentType = (OlapConnectConstants.OlapServerType)OlapConnectionInfoEditUI.this.cbType.getSelectedItem();
            String key = this.currentType.toString();
            this.layout.show((Container)((Object)this), key);
            this.connected = false;
            this.clear();
        }

        private void clear() {
            if (this.currentType == OlapConnectConstants.OLAPSERVERTYPE_KDOLAP) {
                this.pbCubeModel.setValue(null);
            } else if (this.currentType == OlapConnectConstants.OLAPSERVERTYPE_MSOLAP_XMLA) {
                this.msolap_xmla_tfUrl.setText("");
                this.msolap_xmla_tfUser.setText("");
                this.msolap_xmla_tfPassword.setText("");
            }
            this.cache = null;
        }

        private boolean testConnection(boolean verify) {
            if (this.currentType == OlapConnectConstants.OLAPSERVERTYPE_KDOLAP) {
                String r = this.pbCubeModel.getText();
                if (r == null || r.length() == 0) {
                    WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"unselect") + "MD" + ReportResource.getString(ReportResource.class, (String)"MDModel")));
                } else {
                    if (OlapConnectionInfoEditUI.this.urlResolver == null) {
                        WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"notImpl") + "IURLResolver!"));
                    }
                    try {
                        InputStream in = OlapConnectionInfoEditUI.this.urlResolver.openInputStream(r);
                        Document doc = null;
                        try {
                            doc = new SAXBuilder().build(in);
                            CubeModel cm = CubeModelUtil.loadSchema(doc);
                            this.cache = cm;
                        }
                        catch (XMLException xmle) {
                            try {
                                SchemaDef def = SchemaParser.parse(doc);
                                this.cache = def;
                            }
                            catch (Exception e) {
                                throw xmle;
                            }
                        }
                        if (!verify) {
                            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"ConSucceed"));
                        }
                        return true;
                    }
                    catch (XMLException e) {
                        if (verify) {
                            WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"ConFail") + "MD" + ReportResource.getString(ReportResource.class, (String)"MDModel")));
                        }
                        WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"SelectIllegal") + "MD" + ReportResource.getString(ReportResource.class, (String)"MDModel")));
                    }
                    catch (JDOMException e) {
                        WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"SelectIllegal") + "XML" + ReportResource.getString(ReportResource.class, (String)"File")));
                    }
                    catch (IOException e) {
                        WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"occur") + "IO" + ReportResource.getString(ReportResource.class, (String)"exception")));
                    }
                }
            } else if (this.currentType == OlapConnectConstants.OLAPSERVERTYPE_MSOLAP_XMLA) {
                // empty if block
            }
            return false;
        }

        public String getConnectString() {
            if (this.currentType == OlapConnectConstants.OLAPSERVERTYPE_KDOLAP) {
                return new ConnectionInfoWrapper(this.currentType.getType(), this.pbCubeModel.getText()).getConnectString();
            }
            return null;
        }
    }
}

