/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.bicomponent.ChartComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.DimensionProperty;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.MdxQuery;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.NonEmpty;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.ui.MdxQueryDialog;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.olap.Connection;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ChartAnalysisFrame
extends KDFrame {
    private KDTable rowTbl = new KDTable();
    private KDTable colTbl = new KDTable();
    private KDTable dataTbl = new KDTable();
    private KDChart chart = new KDChart();
    private KDButton btnBuild = new KDButton(ReportResource.getString(ReportResource.class, (String)"BuildChart"));
    private KDButton btnQuery = new KDButton(ReportResource.getString(ReportResource.class, (String)"MDXQuery"));
    private KDButton btnExport = new KDButton(ReportResource.getString(ReportResource.class, (String)"OutputExcel"));
    private ChartComponent chartComponent = null;
    private WorksheetComponent ws = null;
    private OlapModel model = null;
    private Connection connection = null;
    private String memberDefine = "";
    private String filter = null;
    private MdxQueryDialog mdxDlg = null;

    public ChartAnalysisFrame(ComponentConfig cc) {
        this.initUI(cc);
    }

    private void initUI(ComponentConfig componentConfig) {
        this.rowTbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.rowTbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.colTbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.colTbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.dataTbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.setExtendedState(6);
        this.setTitle(ReportResource.getString(ReportResource.class, (String)"ChartAnalysis"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new KDPanel(), "North");
        this.getContentPane().add((Component)new KDPanel(), "West");
        this.getContentPane().add((Component)new KDPanel(), "South");
        this.getContentPane().add((Component)new KDPanel(), "East");
        KDSplitPane topSp = new KDSplitPane(1);
        KDPanel jpLeft = new KDPanel();
        topSp.add((Component)jpLeft, (Object)"top");
        ComponentConfig cc = this.initDefaultComponentConfig();
        cc.nullPointSmooth = componentConfig.nullPointSmooth;
        this.ws = new WorksheetComponent(this.dataTbl, cc, true);
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setPriY(1);
        Table row2 = tl.cell(1).splitCol(3);
        KDPanel dataPanel = new KDPanel((LayoutManager)tl);
        KDContainer c = this.createKDContainer(ReportResource.getString(ReportResource.class, (String)"DataSheet"), this.ws.getJComponent());
        dataPanel.add((Component)c, (Object)tl.cell(0));
        dataPanel.add((Component)this.btnBuild, (Object)row2.cell(0));
        dataPanel.add((Component)this.btnExport, (Object)row2.cell(1));
        topSp.add((Component)dataPanel, (Object)"bottom");
        this.getContentPane().add((Component)topSp, "Center");
        topSp.setDividerLocation(500);
        jpLeft.setLayout((LayoutManager)new CardLayout());
        KDSplitPane sp = new KDSplitPane(0);
        jpLeft.add((Component)sp, (Object)"");
        KDSplitPane selectSP = new KDSplitPane(1);
        c = this.createKDContainer(ReportResource.getString(ReportResource.class, (String)"SelectRow"), (Component)this.rowTbl);
        this.addSwitchSelectedButton(c, this.rowTbl);
        selectSP.add((Component)c, (Object)"left");
        c = this.createKDContainer(ReportResource.getString(ReportResource.class, (String)"SelectColumn"), (Component)this.colTbl);
        this.addSwitchSelectedButton(c, this.colTbl);
        selectSP.add((Component)c, (Object)"right");
        selectSP.setDividerLocation(300);
        sp.add((Component)selectSP, (Object)"bottom");
        c = this.createKDContainer(ReportResource.getString(ReportResource.class, (String)"Chart"), (Component)this.chart);
        sp.add((Component)c, (Object)"top");
        sp.setDividerLocation(400);
        this.btnBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartAnalysisFrame.this.buildTableChart();
            }
        });
        this.btnQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartAnalysisFrame.this.query();
            }
        });
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartAnalysisFrame.this.export();
            }
        });
        this.chartComponent = new ChartComponent(this.chart, cc);
    }

    private void addSwitchSelectedButton(KDContainer c, final KDTable tbl) {
        KDWorkButton btn = new KDWorkButton(ReportResource.getString(ReportResource.class, (String)"SelectAll"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartAnalysisFrame.this.switchSelected(tbl, true);
            }
        });
        c.addButton((JButton)btn);
        btn = new KDWorkButton(ReportResource.getString(ReportResource.class, (String)"ReverseSelect"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartAnalysisFrame.this.switchSelected(tbl, false);
            }
        });
        c.addButton((JButton)btn);
    }

    private void switchSelected(KDTable tbl, boolean selectedAll) {
        int n = tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (selectedAll) {
                tbl.getCell(i, 0).setValue((Object)Boolean.TRUE);
                continue;
            }
            tbl.getCell(i, 0).setValue((Object)((Boolean)tbl.getCell(i, 0).getValue() == false ? 1 : 0));
        }
    }

    private KDContainer createKDContainer(String title, Component comp) {
        KDContainer c = new KDContainer();
        c.setTitleStyle(1);
        c.setTitle(title);
        c.setEnableActive(false);
        c.getContentPane().setLayout(new BorderLayout(0, 0));
        c.getContentPane().add(comp, "Center");
        c.setMinimumSize(new java.awt.Dimension(10, 10));
        return c;
    }

    public void setOlapModel(OlapModel model, Connection connection, String mdx, String filter) {
        this.connection = connection;
        this.model = model;
        this.filter = filter;
        try {
            this.parseDefineMember(mdx);
            this.initData(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseDefineMember(String mdx) {
        int i;
        this.memberDefine = "";
        StringBuilder token = new StringBuilder();
        char[] chs = mdx.toCharArray();
        boolean inString = false;
        int n = chs.length;
        for (i = 0; i < n; ++i) {
            char ch = chs[i];
            if (ch == '\'') {
                if (inString) {
                    inString = false;
                    token.setLength(0);
                    continue;
                }
                inString = true;
                continue;
            }
            if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                if ("select".equals(token.toString().toLowerCase(Locale.ENGLISH))) {
                    this.memberDefine = mdx.substring(0, i - "select".length());
                    break;
                }
                token.setLength(0);
                continue;
            }
            token.append(ch);
        }
        if (this.memberDefine.length() == 0 && (i = mdx.toLowerCase().indexOf("select")) > 0) {
            this.memberDefine = mdx.substring(0, i);
        }
    }

    private String getSelectMdx(KDTable tbl, boolean findProperty) throws OlapException {
        DimensionProperty[] pps;
        boolean selected = false;
        StringBuffer s = new StringBuffer("{");
        int col = tbl.getColumnCount();
        Dimension dim = null;
        int n = tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = tbl.getRow(i);
            if (!((Boolean)row.getCell(0).getValue()).booleanValue()) continue;
            if (!selected) {
                selected = true;
            }
            s.append('(');
            for (int j = 1; j < col; ++j) {
                Member m = (Member)row.getCell(j).getValue();
                if (dim == null) {
                    dim = m.getDimension();
                }
                s.append(m.getUniqueName());
                if (j == col - 1) continue;
                s.append(',');
            }
            s.append("),");
        }
        s.setLength(s.length() - 1);
        s.append('}');
        if (findProperty && selected && dim != null && (pps = OlapModelUtil.getDimensionProperties(OlapModelUtil.getLeftAxis(this.model), dim)) != null && pps.length > 0) {
            s.append("\r\n dimension properties ");
            int n2 = pps.length;
            for (int i = 0; i < n2; ++i) {
                s.append(pps[i].getDimension().getUniqueName() + ".[" + pps[i].getPropertyName() + "]");
                if (i == n2 - 1) continue;
                s.append(",");
            }
        }
        return selected ? s.toString() : null;
    }

    private void query() {
        if (this.mdxDlg == null) {
            this.mdxDlg = new MdxQueryDialog((Frame)((Object)this));
        }
        MdxQuery mdxQuery = (MdxQuery)this.model.getExtension("mdxQuery");
        this.mdxDlg.setMdx(mdxQuery.getMdxQuery());
        while (this.mdxDlg.showDialog()) {
            try {
                this.model.disableModelChangedEvent();
                mdxQuery.setMdxQuery(this.mdxDlg.getMdx());
                this.model.postModelChanged();
                break;
            }
            catch (Exception e) {
                WindowUtil.alert((Component)((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this))), (String)e.getMessage());
            }
            finally {
                this.model.enableModelChangedEvent();
            }
        }
    }

    private void export() {
        this.ws.export2Excel();
    }

    private void buildTableChart() {
        try {
            String r = this.getSelectMdx(this.rowTbl, true);
            if (r == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), ReportResource.getString(ReportResource.class, (String)"SelectRow"), ReportResource.getString(ReportResource.class, (String)"BuildChart"), 1);
                return;
            }
            String c = this.getSelectMdx(this.colTbl, false);
            if (c == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), ReportResource.getString(ReportResource.class, (String)"SelectRow"), ReportResource.getString(ReportResource.class, (String)"BuildChart"), 1);
                return;
            }
            StringBuffer s = new StringBuffer();
            s.append(this.memberDefine).append("select ").append(r).append(" on rows,\r\n").append(c).append(" on columns\r\nfrom ").append(this.connection.getDefaultCubeName());
            ChangeSlicer slicer = (ChangeSlicer)this.model.getExtension("changeSlicer");
            Member[] ms = slicer.getSlicer();
            if (ms != null && ms.length > 0) {
                s.append("\r\n where (");
                int n = ms.length;
                for (int i = 0; i < n; ++i) {
                    s.append(ms[i].getUniqueName());
                    if (i != n - 1) {
                        s.append(",");
                        continue;
                    }
                    s.append(")");
                }
            }
            OlapModel newModel = ModelFactory.makeKDOlapModel(this.connection, s.toString());
            NonEmpty nonEmpty = (NonEmpty)this.model.getExtension("nonEmpty");
            this.model = newModel;
            this.ws.getConfig().useNonEmpty = nonEmpty.isUseNonEmpty();
            this.ws.getConfig().nonEmptyForColumn = nonEmpty.isNonEmptyForColumn();
            this.ws.getConfig().nonEmptyForRow = nonEmpty.isNonEmptyForRow();
            if (this.filter != null && this.filter.trim().length() > 0) {
                ((Filter)this.model.getExtension("filter")).setCondition(this.filter);
            }
            this.ws.setModel(newModel);
            this.chartComponent.setModel(newModel);
            this.model.addModelChangeListener(new ModelChangeListener(){

                @Override
                public void modelChanged(ModelChangeEvent e) {
                    try {
                        ChartAnalysisFrame.this.initData(false);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }

                public void structureChanged(ModelChangeEvent e) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isVisible(Member[] ms) {
        return true;
    }

    private ComponentConfig initDefaultComponentConfig() {
        ComponentConfig componentConfig = ComponentConfig.getConfig();
        componentConfig.showColumnDimensionHeader = true;
        componentConfig.showRowDimensionHeader = true;
        componentConfig.showColumnHeaderInTableHeader = true;
        componentConfig.showPopupMenuForMember = true;
        return componentConfig;
    }

    private void showAxis(Axis a, KDTable tbl) {
        tbl.setRefresh(false);
        List pList = a.getPositions();
        int n = pList.size();
        tbl.removeColumns();
        Hierarchy[] hs = a.getHierarchies();
        for (int i = 0; i <= hs.length; ++i) {
            tbl.addColumn(i);
            if (i == 0) continue;
            tbl.getColumn(i).getStyleAttributes().setLocked(true);
        }
        IRow row = tbl.addHeadRow();
        row.getCell(0).setValue((Object)ReportResource.getString(ReportResource.class, (String)"Select"));
        for (int i = 0; i < hs.length; ++i) {
            row.getCell(i + 1).setValue((Object)hs[i].getCaption());
        }
        for (int i = 0; i < n; ++i) {
            Position p = (Position)pList.get(i);
            row = tbl.addRow();
            Member[] ms = p.getMembers();
            row.getCell(0).setValue((Object)Boolean.TRUE);
            for (int j = 0; j < ms.length; ++j) {
                row.getCell(j + 1).setValue((Object)ms[j]);
            }
        }
        tbl.setRefresh(true);
        tbl.reLayoutAndPaint();
    }

    private void initData(boolean firstLoad) throws Exception {
        Result result = this.model.getResult();
        Axis topAxis = OlapModelUtil.getTopAxis(result);
        Axis leftAxis = OlapModelUtil.getLeftAxis(result);
        this.showAxis(leftAxis, this.rowTbl);
        this.showAxis(topAxis, this.colTbl);
        if (firstLoad) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChartAnalysisFrame.this.buildTableChart();
                }
            });
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(KingdeeLookAndFeel.class.getName());
        ChartAnalysisFrame caf = new ChartAnalysisFrame(new ComponentConfig());
        caf.setDefaultCloseOperation(2);
        caf.setVisible(true);
    }
}

